/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db.controls;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.BevelBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.db.DBTypeDisplayRegistry;
import oracle.ide.db.ProviderOperator;
import oracle.ide.db.controls.DBObjectProviderPicker;
import oracle.ide.db.dialogs.DBEditorConfig;
import oracle.ide.db.dialogs.DBEditorFactory;
import oracle.ide.db.dialogs.DBEditorFactoryRegistry;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.util.Namespace;
import oracle.ideimpl.db.DBUIResourceHelper;
import oracle.ideimpl.db.controls.AbstractLazyCombo;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectFilter;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectLister;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectProviderID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.IdentifierBasedID;
import oracle.javatools.db.Index;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.event.DBObjectChange;
import oracle.javatools.db.event.DBObjectProviderListener;
import oracle.javatools.db.ora.DatabaseLink;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.util.DBObjectIDSet;
import oracle.javatools.db.util.DBObjectSet;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.plaf.IconicButtonUI;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.Tuple;

public final class DBObjectChooser
extends JPanel
implements ListCellRenderer {
    private static WeakReference<Database> s_lastDBRef;
    private final List<Tuple<ChangeListener, Boolean>> m_listeners = new CopyOnWriteArrayList<Tuple<ChangeListener, Boolean>>();
    private final Map<DBObjectID, List<DBObjectID>> m_contextToIDListMap = Collections.synchronizedMap(new HashMap());
    private final Map<String, DBObjectID> m_textToIDMap = Collections.synchronizedMap(new HashMap());
    private final Set<DBObjectID> m_extraIDs = Collections.synchronizedSet(new DBObjectIDSet(true));
    private final DBObjectProviderPicker.PickerConfiguration m_pickerConfig = new DBObjectProviderPicker.PickerConfiguration();
    private final DBUIResourceHelper m_helper = new DBUIResourceHelper("ComboChooserDelegate");
    private final DBObjectProviderListener m_proListener = new ProviderListener();
    private String[] m_types;
    private Table m_expandFKOwner;
    private DBObjectProvider m_destProv;
    private DBObjectProvider m_srcProv;
    private Boolean m_showIcon;
    private String m_nullText;
    private DBObjectChooser m_child;
    private DBObjectChooser m_parent;
    private DBObjectID m_contextID;
    private DBObjectID m_id;
    private Boolean m_enabled;
    private Boolean m_editable;
    private boolean m_childObjects = false;
    private boolean m_schemaObjects = false;
    private boolean m_nonSchemaSystemObjects = false;
    private boolean m_typeSupported = true;
    private boolean m_onlyReferenceIdNeeded = false;
    private boolean m_listening = true;
    private boolean m_isTextTyped = false;
    private DBObjectFilter m_filter = null;
    private CustomJComboBox m_cmb;
    private JButton m_butt;
    private ActionListener m_listener = null;
    private boolean m_subsetLoaded = false;
    private boolean m_showDBLinkButton = false;
    private DBObjectID m_databaseLinkID = null;
    private boolean m_isDatabaseLinkChooser = false;
    private JButton m_addButton;
    private JButton m_editButton;
    private boolean m_showEditButton = false;
    private boolean m_showAddButton = false;
    private NewObjectProcessor m_addObjectProcessor;
    private DBObjectCriteria<SystemObject> m_criteria;
    private DBObjectLister m_lister;
    private DBObjectCriteria<SystemObject> m_listCriteria;

    public DBObjectChooser(String ... types) {
        this((DBObjectChooser)null, types);
    }

    public DBObjectChooser(DBObjectChooser parent, String ... types) {
        this(parent, (DBObjectLister)null, (DBObjectCriteria<SystemObject>)null, types);
    }

    public DBObjectChooser(DBObjectChooser parent, DBObjectLister lister, DBObjectCriteria<SystemObject> criteria, String ... types) {
        for (String type : types) {
            Class clz = Metadata.getInstance().getObjectClass(type);
            if (Index.class == clz) {
                this.m_childObjects = true;
                continue;
            }
            if (SchemaObject.class.isAssignableFrom(clz)) {
                this.m_schemaObjects = true;
                continue;
            }
            if (ChildDBObject.class.isAssignableFrom(clz)) {
                this.m_childObjects = true;
                continue;
            }
            if (!SystemObject.class.isAssignableFrom(clz)) continue;
            this.m_nonSchemaSystemObjects = true;
        }
        if ((this.m_childObjects ? 1 : 0) + (this.m_schemaObjects ? 1 : 0) + (this.m_nonSchemaSystemObjects ? 1 : 0) != 1) {
            throw new IllegalArgumentException("Incompatible list of types");
        }
        if (lister != null || criteria != null) {
            if (lister == null || criteria == null) {
                throw new IllegalArgumentException("both lister and criteria must be null or not null");
            }
            this.m_lister = lister;
            this.m_listCriteria = criteria;
        }
        this.m_parent = parent;
        if (this.m_parent != null) {
            this.m_parent.m_child = this;
        }
        this.m_types = types;
        this.setLayout(new GridBagLayout());
    }

    public final void setShowIcon(boolean showIcon) {
        this.m_showIcon = showIcon;
    }

    public final void setNullText(String nullText) {
        this.m_nullText = nullText;
    }

    public DBObjectCriteria<SystemObject> getDBObjectCriteria() {
        return this.m_criteria;
    }

    public final void addIDToList(DBObjectID id) {
        this.m_extraIDs.add(id);
    }

    public void setShowDBLinkButton(boolean showDBLinkButton) {
        if (this.m_destProv != null) {
            throw new IllegalStateException("Must call setShowDBLinkButton() before setProvider()");
        }
        if (showDBLinkButton && (this.m_types.length != 1 || !this.m_types[0].equals("SCHEMA"))) {
            throw new IllegalStateException("DB Link button only allowed for Schema choser");
        }
        this.m_showDBLinkButton = showDBLinkButton;
    }

    public void setExpandFKInRenderer(boolean expandFKInRenderer, Table fkOwner) {
        this.m_expandFKOwner = fkOwner;
    }

    public void setShowAddButton(boolean showAddButton) {
        if (this.m_destProv != null) {
            throw new IllegalStateException("Must call setShowAddButton() before setProvider()");
        }
        this.m_showAddButton = showAddButton;
    }

    public void setAddButtonProcessor(NewObjectProcessor processor) {
        this.m_addObjectProcessor = processor;
    }

    public void setShowEditButton(boolean showEditButton) {
        if (this.m_destProv != null) {
            throw new IllegalStateException("Must call setShowEditButton() before setProvider()");
        }
        this.m_showEditButton = showEditButton;
    }

    public final void setProvider(DBObjectProvider prov) {
        if (this.m_child != null) {
            this.m_child.setProvider(prov);
        }
        this.m_destProv = prov;
        this.setSourceProvider(prov);
        if (this.m_cmb == null) {
            if (this.m_showIcon == null) {
                this.m_showIcon = this.m_types.length > 1;
            }
            this.initialiseUI();
            this.buildMaintainID();
            this.setDelegateName();
            this.setEnabled(this.isEnabled());
            if (this.m_editable != null) {
                this.m_cmb.setEditable(this.m_editable);
            }
        }
    }

    public final void enableProviderListener(boolean enable) {
        if (this.m_destProv == null) {
            throw new IllegalStateException("Cannot call enableProviderListener() before setProvider()");
        }
        if (this.m_srcProv == null) {
            return;
        }
        this.m_srcProv.removeProviderListener(this.m_proListener);
        if (enable) {
            this.m_srcProv.addProviderListener(this.m_proListener);
        }
    }

    public final void resetCaches() {
        this.m_textToIDMap.clear();
        this.m_contextToIDListMap.clear();
        if (this.m_cmb != null) {
            this.m_cmb.reset();
        }
    }

    public final void cancel() {
        if (this.m_cmb != null) {
            this.m_cmb.cancel();
        }
    }

    public final void setActive(boolean active, boolean useProviderListener, boolean resetCaches) {
        if (this.m_cmb != null) {
            if (active) {
                if (resetCaches) {
                    this.resetCaches();
                }
            } else {
                this.cancel();
            }
            if (useProviderListener) {
                this.enableProviderListener(active);
            }
        }
    }

    public final void setContextDBObjectID(DBObjectID id) {
        this.m_contextID = id;
        if (this.m_cmb != null) {
            this.contextChanged();
        }
    }

    public final DBObjectID getDBObjectID() {
        Object obj;
        DBObjectID id = this.m_id;
        if (this.m_cmb != null && this.m_cmb.isEditable() && this.m_cmb.getEditor() != null && (obj = this.m_cmb.getEditor().getItem()) instanceof String) {
            id = this.getIDFromString((String)obj);
        }
        return this.fixProvider(id);
    }

    public final void setDBObjectID(DBObjectID id) {
        this.updateID(id);
        if (this.m_cmb != null) {
            this.showID();
        }
    }

    public final DBObject getDBObject() {
        DBObject obj = null;
        DBObjectID id = this.getDBObjectID();
        if (id != null) {
            try {
                obj = id.resolveID();
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return obj;
    }

    public final void setDBObject(DBObject obj) {
        DBObjectID id = null;
        if (obj != null && (id = obj.getID()) == null) {
            id = TemporaryObjectID.createID((DBObject)obj);
        }
        this.setDBObjectID(id);
    }

    @Override
    public final void setName(String name) {
        super.setName(name);
        this.setDelegateName();
    }

    private void setDelegateName() {
        if (this.m_cmb != null) {
            this.m_cmb.setName(this.getName() + "-delegate");
        }
    }

    public String getDelegateName() {
        return this.m_cmb == null ? null : this.m_cmb.getName();
    }

    @Override
    public final void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setEnabledImpl(this.m_cmb, enabled);
        this.setEnabledImpl(this.m_butt, enabled);
        this.setEnabledImpl(this.m_addButton, enabled);
        this.enableEditButton();
    }

    private void setEnabledImpl(Component comp, boolean enabled) {
        if (comp != null) {
            comp.setEnabled(enabled);
        }
    }

    @Override
    public final boolean isEnabled() {
        if (this.m_cmb != null) {
            return this.m_cmb.isEnabled();
        }
        return this.m_enabled == null ? true : this.m_enabled;
    }

    public final void setEditable(boolean editable) {
        this.m_editable = editable;
        if (this.m_cmb != null) {
            this.m_cmb.setEditable(editable);
        }
    }

    public final boolean isEditable() {
        if (this.m_cmb != null) {
            return this.m_cmb.isEditable();
        }
        return this.m_editable == null ? false : this.m_editable;
    }

    public void setOnlyReferenceIDNeeded(boolean onlyReferenceIdNeeded) {
        this.m_onlyReferenceIdNeeded = onlyReferenceIdNeeded;
    }

    public DBObject getOrCreateDBObject() {
        DBObject obj = this.getDBObject();
        DBObjectID id = this.getDBObjectID();
        if (obj == null && id instanceof BaseObjectID && id.getType().equals("SCHEMA")) {
            obj = new Schema(((BaseObjectID)id).getName());
        }
        return obj;
    }

    public final void addChangeListener(ChangeListener listener) {
        this.addChangeListener(listener, false);
    }

    public final void addChangeListener(ChangeListener listener, boolean notifyKeyTyped) {
        if (listener != null) {
            this.removeChangeListener(listener);
            Tuple pair = new Tuple((Object)listener, (Object)notifyKeyTyped);
            this.m_listeners.add((Tuple<ChangeListener, Boolean>)pair);
        }
    }

    public final void removeChangeListener(ChangeListener listener) {
        if (listener != null) {
            for (Tuple<ChangeListener, Boolean> pair : this.m_listeners) {
                if (pair.getFirst() != listener) continue;
                this.m_listeners.remove(pair);
                break;
            }
        }
    }

    public final String[] getTypes() {
        return this.m_types;
    }

    final boolean getShowIcon() {
        return this.m_showIcon == null ? false : this.m_showIcon;
    }

    public void setFilter(DBObjectFilter filter) {
        if (this.m_filter != filter) {
            this.m_filter = filter;
            this.resetCaches();
        }
    }

    public DBObjectFilter getFilter() {
        return this.m_filter;
    }

    private DBObjectChooser getParentChooser() {
        return this.m_parent;
    }

    private DBObjectChooser getChildChooser() {
        return this.m_child;
    }

    private void updateID(DBObjectID id) {
        if (id != null && !id.equals(this.m_id, false) || id == null && this.m_id != null) {
            this.m_id = id;
            if (this.m_child != null) {
                this.m_child.setContextDBObjectID(id);
            }
            for (Tuple<ChangeListener, Boolean> pair : this.m_listeners) {
                ((ChangeListener)pair.getFirst()).chooserChanged(this, this.m_id);
            }
            this.markTextTyped(false);
        }
        this.enableEditButton();
    }

    private boolean supportsObjectType(String type) {
        boolean retval = false;
        Class clz = Metadata.getInstance().getObjectClass(type);
        if (SystemObject.class.isAssignableFrom(clz)) {
            retval = this.getProvider().supportsObjectType(type);
        }
        if (!retval && ChildDBObject.class.isAssignableFrom(clz)) {
            for (String owningType : Metadata.getInstance().getOwnerTypes(type)) {
                if (!this.supportsObjectType(owningType)) continue;
                retval = true;
                break;
            }
        }
        return retval;
    }

    private final DBObjectProvider getProvider() {
        return this.m_destProv;
    }

    private void setSourceProvider(DBObjectProvider prov) {
        this.m_srcProv = prov;
        this.resetCaches();
        if (!this.m_childObjects) {
            this.m_criteria = DBObjectCriteria.createTypeCriteria((String[])this.getTypes());
            if ("SCHEMA".equals(this.getTypes()[0]) && prov instanceof Database) {
                this.m_criteria.setUserOnly(true);
            } else {
                this.m_criteria.setUserOnly(false);
            }
        }
        if (this.getChildChooser() != null) {
            this.getChildChooser().setSourceProvider(prov);
        }
    }

    private final DBObjectProvider getSourceProvider() {
        return this.m_srcProv;
    }

    private final String getStringFromID(DBObjectID id) {
        String text = null;
        if (id != null) {
            text = DBUtil.getDBObjectName((DBObjectID)id);
            if (ModelUtil.hasLength((String)text) && this.internaliseNames() && (!"SCHEMA".equals(id.getType()) || !text.equals(this.m_destProv.getDescriptor().getPublicSchemaName()))) {
                text = this.m_destProv.getExternalName(text);
            }
            if (id instanceof BaseObjectID && ((BaseObjectID)id).getDatabaseName() != null) {
                text = text + "@" + ((BaseObjectID)id).getDatabaseName();
            }
        }
        return text == null ? "" : text;
    }

    private Collection<SystemObject> listObjects() throws DBException {
        CancelledException.checkInterrupt();
        if (this.m_lister == null) {
            return this.getSourceProvider().listObjects(this.m_criteria);
        }
        ArrayList<SystemObject> ret = new ArrayList<SystemObject>();
        for (DBObjectLister.ObjectInfo info : this.m_lister.listObjects(this.m_listCriteria)) {
            SchemaObject obj = this.getSourceProvider().getObject(info.getType(), info.getSchema(), info.getName());
            ret.add((SystemObject)obj);
        }
        return ret;
    }

    private final DBObjectID getIDFromString(String text) {
        DBObjectID id = null;
        if (text != null && text.length() > 0) {
            if (this.internaliseNames()) {
                text = this.m_destProv.getInternalName(text);
            }
            if ((this.isTextTyped() || this.m_textToIDMap.isEmpty()) && !this.m_onlyReferenceIdNeeded) {
                this.populateIDMap(this.m_contextID, false);
            }
            if ((id = this.m_textToIDMap.get(text)) == null) {
                String type = this.m_types.length == 1 ? this.m_types[0] : "UNSPECIFIED_TYPE";
                id = new ReferenceID(type, null, text, null, null);
                String schemaName = null;
                DBObjectID parentID = this.m_contextID;
                Class clz = Metadata.getInstance().getObjectClass(this.m_types[0]);
                if (clz != null && SchemaObject.class.isAssignableFrom(clz)) {
                    schemaName = this.getStringFromID(parentID);
                    parentID = null;
                }
                ((ReferenceID)id).setParent(parentID);
                ((ReferenceID)id).setSchemaName(schemaName);
                if (this.m_id instanceof ReferenceID) {
                    ((ReferenceID)id).setChildObjectNames(((ReferenceID)this.m_id).getChildObjectNames());
                }
            }
        }
        return id;
    }

    private boolean internaliseNames() {
        return !this.getTypes()[0].equals("XML SCHEMA") && !this.getTypes()[0].equals("XMLSchemaElement");
    }

    private void setTypeSupported(boolean typeSupported) {
        this.m_typeSupported = typeSupported;
        if (this.getChildChooser() != null && !typeSupported) {
            this.getChildChooser().setTypeSupported(false);
            this.getChildChooser().setEditable(true);
            this.getChildChooser().setSourceProvider(null);
        }
    }

    private boolean isTypeSupported() {
        if (this.getChildChooser() != null && !this.getChildChooser().isTypeSupported()) {
            return false;
        }
        return this.m_typeSupported;
    }

    private final void initialiseUI() {
        if (!(this.getProvider() instanceof Database)) {
            if ("TABLESPACE".equals(this.getTypes()[0])) {
                this.m_editable = true;
            }
            boolean anySupported = false;
            for (String type : this.getTypes()) {
                if (!this.supportsObjectType(type)) continue;
                anySupported = true;
                break;
            }
            this.setTypeSupported(anySupported);
        }
        if (!this.isTypeSupported()) {
            this.m_editable = true;
        }
        if (this.m_editable == null) {
            this.m_editable = false;
        }
        this.m_cmb = new CustomJComboBox();
        this.m_cmb.setEditable(this.m_editable);
        this.add((Component)this.m_cmb, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 12, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.m_cmb.setRenderer(this);
        this.m_cmb.setPrototypeDisplayValue("XXXXXXXXXXXXXXX");
        if (this.getParentChooser() == null && !this.isTypeSupported()) {
            this.m_butt = new JButton();
            this.m_butt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DBObjectChooser.this.showDBPickerDialog();
                }
            });
            this.m_butt.setIcon(OracleIcons.getIcon((String)"database.png"));
            IconicButtonUI.install((AbstractButton)this.m_butt);
            this.m_butt.setToolTipText(UIBundle.get("CHOOSER_SELECT_CONNECTION_HTML"));
            String selectConnection = this.getSelectConnectionText();
            if (ModelUtil.hasLength((String)selectConnection)) {
                this.m_butt.setMnemonic(StringUtils.getMnemonicKeyCode((String)selectConnection));
            }
            JLabel hiddenLabel = new JLabel();
            this.m_helper.resLabel(hiddenLabel, this.m_butt, selectConnection, "hiddenLabel");
            hiddenLabel.setVisible(false);
            this.add((Component)hiddenLabel, new GridBagConstraints(99, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.m_butt, new GridBagConstraints(100, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 6, 0, 0), 0, 0));
            this.m_pickerConfig.setContext(Context.newIdeContext());
            this.m_pickerConfig.setProviderTypes("db");
            this.m_pickerConfig.setShowDetails(true);
            this.m_pickerConfig.setAllowNull(true);
            Database lastDB = null;
            WeakReference<Database> lastDBRef = s_lastDBRef;
            if (lastDBRef != null) {
                lastDB = (Database)lastDBRef.get();
            }
            if (lastDB == null && this.getSourceProvider() instanceof Database) {
                lastDB = (Database)this.getSourceProvider();
            }
            this.m_pickerConfig.setDefaultProviderID(lastDB == null ? null : new DBObjectProviderID((DBObjectProvider)lastDB));
            if (lastDB != null) {
                this.setSourceProvider((DBObjectProvider)lastDB);
            }
        } else if (this.m_showDBLinkButton && this.getProvider().supportsObjectType("DATABASE LINK") && this.getParentChooser() == null) {
            this.m_butt = new JButton();
            this.m_butt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DBObjectChooser.this.showDBLinkDialog();
                }
            });
            this.m_butt.setIcon(OracleIcons.getIcon((String)"link.png"));
            IconicButtonUI.install((AbstractButton)this.m_butt);
            this.m_butt.setToolTipText(UIBundle.get("CHOOSER_SELECT_DBLINK_HTML"));
            if (ModelUtil.hasLength((String)UIBundle.get("CHOOSER_SELECT_DBLINK"))) {
                this.m_butt.setMnemonic(StringUtils.getMnemonicKeyCode((String)UIBundle.get("CHOOSER_SELECT_DBLINK")));
            }
            JLabel hiddenLabel = new JLabel();
            this.m_helper.resLabel(hiddenLabel, this.m_butt, UIBundle.get("CHOOSER_SELECT_DBLINK"), "hiddenLabel");
            hiddenLabel.setVisible(false);
            this.add((Component)hiddenLabel, new GridBagConstraints(99, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.m_butt, new GridBagConstraints(100, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 6, 0, 0), 0, 0));
        }
        if (this.m_showAddButton && this.isTypeSupported()) {
            final String type = this.m_types[0];
            this.m_addButton = new JButton();
            this.add((Component)this.m_addButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
            this.m_helper.setName(this.m_addButton, "AddButton");
            this.m_addButton.setIcon(OracleIcons.getIcon((String)"add.png"));
            this.m_addButton.setToolTipText(UIBundle.format("IDPANEL_ADD_BUTTON_TOOLTIP", DBTypeDisplayRegistry.getSingularDisplayName(type)));
            IconicButtonUI.install((AbstractButton)this.m_addButton);
            this.m_addButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DBObjectProvider pro = DBObjectChooser.this.getProvider();
                    Class clz = Metadata.getInstance().getObjectClass(type);
                    SystemObject so = (SystemObject)pro.getObjectFactory().newObject(clz);
                    if (DBObjectChooser.this.m_addObjectProcessor != null) {
                        DBObjectChooser.this.m_addObjectProcessor.initialise(so);
                    }
                    DBEditorConfig config = DBEditorConfig.newCreateConfig(pro, (DBObject)so);
                    config.setCommitToProvider(false);
                    DBEditorFactory fac = DBEditorFactoryRegistry.getCreateFactory(config);
                    boolean launch = true;
                    while (launch) {
                        launch = false;
                        fac.launchDialog(config);
                        if (config.getResult() != DBEditorConfig.Result.SUCCESS) continue;
                        ProviderOperator pop = new ProviderOperator(pro);
                        pop.createObjects(new SystemObject[]{so});
                        DBObjectChooser.this.setDBObject((DBObject)so);
                    }
                }
            });
        }
        if (this.m_showEditButton && this.isTypeSupported()) {
            this.m_editButton = new JButton();
            this.add((Component)this.m_editButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 6, 0, 0), 0, 0));
            this.m_helper.setName(this.m_editButton, "EditButton");
            this.m_editButton.setIcon(OracleIcons.getIcon((String)"edit.png"));
            IconicButtonUI.install((AbstractButton)this.m_editButton);
            this.m_editButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TemporaryObjectID tempId;
                    DBObject tempObj;
                    DBObjectID baseId = DBObjectChooser.this.getDBObjectID();
                    DBEditorConfig config = null;
                    Object id = baseId instanceof TemporaryObjectID ? ((tempObj = (tempId = (TemporaryObjectID)baseId).getOriginalObject()) != null ? tempObj.getID() : null) : baseId;
                    if (id != null && id instanceof BaseObjectID) {
                        DBEditorFactory fac;
                        try {
                            config = DBEditorConfig.newEditConfig((BaseObjectID)id, false);
                        }
                        catch (DBException dbe) {
                            DBLog.getLogger((Object)this).warning(dbe.getMessage());
                        }
                        if (config != null && (fac = DBEditorFactoryRegistry.getEditFactory(config)) != null) {
                            fac.launchDialog(config);
                        }
                    }
                }
            });
        }
    }

    private void enableEditButton() {
        if (this.m_editButton != null) {
            boolean enabled;
            String tooltip = null;
            boolean bl = enabled = this.isEnabled() && this.m_id instanceof TemporaryObjectID || this.m_id instanceof BaseObjectID && !(this.m_id instanceof ReferenceID);
            if (enabled) {
                String type = null;
                String name = null;
                if (this.m_id instanceof TemporaryObjectID) {
                    TemporaryObjectID tid = (TemporaryObjectID)this.m_id;
                    DBObject tempObj = tid.getOriginalObject();
                    if (tempObj != null) {
                        name = tempObj.getName();
                        type = tempObj.getType();
                    }
                } else {
                    BaseObjectID bid = (BaseObjectID)this.m_id;
                    type = bid.getType();
                    name = bid.getName();
                }
                tooltip = UIBundle.format("IDPANEL_EDIT_BUTTON_TOOLTIP", DBTypeDisplayRegistry.getSingularDisplayName(type), name);
            }
            this.m_editButton.setToolTipText(tooltip);
            this.m_editButton.setEnabled(enabled);
        }
    }

    private String getSelectConnectionText() {
        return UIBundle.get("CHOOSER_SELECT_CONNECTION");
    }

    private void showDBPickerDialog() {
        String name;
        DBObjectProvider pro = DBObjectProviderPicker.chooseProvider(this.m_pickerConfig, this, StringUtils.stripMnemonic((String)this.getSelectConnectionText()), null, "f1_odbchooserconn_html");
        this.resetCaches();
        if (pro instanceof Database) {
            this.setSourceProvider(pro);
            s_lastDBRef = new WeakReference<Database>((Database)pro);
        } else {
            this.setSourceProvider(this.m_destProv);
            s_lastDBRef = null;
        }
        if (this.m_nonSchemaSystemObjects) {
            try {
                this.setDBObject((DBObject)this.m_srcProv.getDefaultSchema());
            }
            catch (DBException dBException) {}
        } else if (this.m_schemaObjects && this.m_parent == null && this.m_contextID != null && (name = DBUtil.getDBObjectName((DBObjectID)this.m_contextID)) != null && "SCHEMA".equals(this.m_contextID.getType())) {
            DBObjectID newContext = null;
            try {
                Schema newSchema = this.m_srcProv.getSchema(name);
                if (newSchema != null) {
                    newContext = newSchema.getID();
                }
            }
            catch (DBException dBException) {
                // empty catch block
            }
            if (newContext == null) {
                newContext = TemporaryObjectID.createID((DBObject)new Schema(name));
            }
            this.setContextDBObjectID(newContext);
        }
    }

    private void showDBLinkDialog() {
        Schema defaultSchema;
        try {
            defaultSchema = this.m_destProv.getDefaultSchema();
        }
        catch (DBException dbe) {
            DBLog.getLogger((Object)this).warning(dbe.getMessage());
            return;
        }
        DefaultTraversablePanel panel = new DefaultTraversablePanel();
        panel.setLayout((LayoutManager)new GridBagLayout());
        JLabel label = new JLabel();
        final DBObjectChooser chooser = new DBObjectChooser("DATABASE LINK");
        chooser.m_isDatabaseLinkChooser = true;
        chooser.setNullText(UIBundle.get("CHOOSER_NO_DATABASE_LINK"));
        chooser.setProvider(this.m_destProv);
        chooser.setContextDBObjectID(defaultSchema.getID());
        chooser.setDBObjectID(this.m_databaseLinkID);
        this.m_helper.resLabel(label, chooser, UIBundle.get("CHOOSER_SELECT_DBLINK_LABEL"), "dblinkChooser");
        panel.add((Component)label, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(8, 0, 8, 0), 0, 0));
        panel.add((Component)chooser, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(8, 8, 8, 0), 0, 0));
        panel.setHelpID("f1_dbselectdblink_html");
        Namespace data = new Namespace();
        TDialogLauncher launcher = new TDialogLauncher((Component)this, UIBundle.get("CHOOSER_SELECT_DBLINK_TITLE"), (Traversable)panel, data);
        JEWTDialog dialog = launcher.initDialog();
        dialog.setContent((Component)panel);
        dialog.setResizable(true);
        dialog.setName("ChooserDBLinkDialog");
        dialog.setButtonMask(7);
        dialog.setPreferredSize(new Dimension(360, 120));
        VetoableChangeListener list = new VetoableChangeListener(){

            @Override
            public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
                if (JEWTDialog.isDialogClosingEvent((PropertyChangeEvent)evt)) {
                    DatabaseLink link = (DatabaseLink)chooser.getDBObject();
                    String linkName = link == null ? null : link.getName();
                    DBObjectChooser.this.m_databaseLinkID = link == null ? null : link.getID();
                    DBObjectChooser.this.setContextDBObjectID(DBObjectChooser.this.m_databaseLinkID);
                    if (link == null) {
                        DBObjectChooser.this.setDBObject((DBObject)defaultSchema);
                    } else if (DBObjectChooser.this.m_destProv instanceof AbstractDBObjectProvider) {
                        NameBasedID id;
                        String schemaName = ((AbstractDBObjectProvider)DBObjectChooser.this.m_destProv).getDefaultSchemaName(link);
                        if (ModelUtil.hasLength((String)schemaName)) {
                            id = new NameBasedID("SCHEMA", null, schemaName);
                            id.setDatabaseName(linkName);
                            id.setProvider(DBObjectChooser.this.m_destProv);
                        } else {
                            id = null;
                        }
                        DBObjectChooser.this.setDBObjectID((DBObjectID)id);
                    } else {
                        DBObjectChooser.this.setDBObjectID(null);
                    }
                    DBObjectChooser.this.m_criteria.setDatabaseName(linkName);
                }
            }
        };
        dialog.addVetoableChangeListener(list);
        boolean ok = launcher.showDialog();
    }

    private boolean isInContext(DBObjectID id) {
        boolean retval = true;
        if (this.m_contextID != null) {
            DBObject obj;
            DBObject contextObj;
            retval = "SCHEMA".equals(this.m_contextID.getType()) ? ModelUtil.areEqual((Object)DBUtil.getDBObjectName((DBObjectID)this.m_contextID), (Object)DBUtil.getSchemaName((DBObjectID)id)) : (id instanceof TemporaryObjectID ? (this.m_contextID instanceof TemporaryObjectID ? (contextObj = ((TemporaryObjectID)this.m_contextID).getDBObject()) == (obj = ((TemporaryObjectID)id).getDBObject()).getParent() : false) : !this.m_contextID.equals(id) && DBUtil.isSameOrChildOf((DBObjectID)id, (DBObjectID)this.m_contextID, (boolean)true));
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateIDMap(DBObjectID contextID, boolean forceFull) {
        List<DBObjectID> list = this.m_contextToIDListMap.get(contextID);
        if (list == null) {
            try {
                boolean loadsubset = !forceFull && this.subsetAvailable(contextID);
                list = this.getEntries(contextID, loadsubset);
                for (DBObjectID id : this.m_extraIDs) {
                    TemporaryObjectID tempId;
                    DBObjectID origId;
                    if (!this.isInContext(id)) continue;
                    if (id instanceof TemporaryObjectID && list.contains(origId = TemporaryObjectID.findOriginalID((TemporaryObjectID)(tempId = (TemporaryObjectID)id)))) {
                        list.remove(origId);
                    }
                    list.add(id);
                }
                if (!Thread.currentThread().isInterrupted() && !loadsubset) {
                    this.m_contextToIDListMap.put(contextID, list);
                }
            }
            catch (CancelledException loadsubset) {
            }
            catch (DBException dbe) {
                DBLog.getLogger(DBObjectChooser.class).log(Level.WARNING, UIBundle.format("CHOOSER_LOAD_ENTRIES_ERROR", dbe.getMessage()));
            }
        }
        if (!Thread.currentThread().isInterrupted()) {
            Map<String, DBObjectID> map = this.m_textToIDMap;
            synchronized (map) {
                this.m_textToIDMap.clear();
                if (list != null) {
                    for (DBObjectID id : list) {
                        String str = this.getStringFromID(id);
                        if (!ModelUtil.hasLength((String)str)) continue;
                        this.m_textToIDMap.put(str, id);
                    }
                }
            }
        }
    }

    private boolean subsetAvailable(DBObjectID contextID) {
        String schemaName;
        String[] types;
        boolean retval = false;
        DBObjectProvider pro = this.getSourceProvider();
        if (contextID != null && this.m_schemaObjects && pro instanceof Database && (types = this.getTypes()).length == 1 && "TYPE".equals(types[0]) && ModelUtil.hasLength((String)(schemaName = this.getStringFromID(contextID)))) {
            DBObjectCriteria crit = DBObjectCriteria.createCriteria((String)"TYPE", (String)schemaName, null);
            Collection objs = pro.getDescriptor().listBuiltInObjects(crit);
            retval = objs != null && !objs.isEmpty();
        }
        return retval;
    }

    private String getLoadFullListText() {
        return UIBundle.get("CHOOSER_LOAD_FULL_LIST");
    }

    private void buildMaintainID() {
        if (this.m_listener == null) {
            this.m_listener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DBObjectChooser.this.m_listening) {
                        String fullList = DBObjectChooser.this.getLoadFullListText();
                        boolean done = false;
                        if (DBObjectChooser.this.m_editable != null && DBObjectChooser.this.m_editable.booleanValue()) {
                            Object o = DBObjectChooser.this.m_cmb.getEditor().getItem();
                            if (DBObjectChooser.this.m_subsetLoaded && fullList.equals(o)) {
                                DBObjectChooser.this.m_cmb.updateComboModel(true);
                            } else if (o instanceof String) {
                                DBObjectID fromMap;
                                DBObjectID id = DBObjectChooser.this.getIDFromString((String)o);
                                if (!DBObjectChooser.this.m_cmb.isModelLoaded() && !DBObjectChooser.this.m_onlyReferenceIdNeeded) {
                                    DBObjectChooser.this.m_cmb.updateComboModel(false);
                                }
                                if (id instanceof ReferenceID && (fromMap = (DBObjectID)DBObjectChooser.this.m_textToIDMap.get(((ReferenceID)id).getName())) != null) {
                                    id = fromMap;
                                }
                                DBObjectChooser.this.setDBObjectID(id);
                                done = true;
                            }
                        } else {
                            Object o = DBObjectChooser.this.m_cmb.getSelectedItem();
                            if (DBObjectChooser.this.m_subsetLoaded && fullList.equals(o)) {
                                DBObjectChooser.this.m_cmb.updateComboModel(true);
                            } else if (o instanceof String) {
                                DBObjectID id = (DBObjectID)DBObjectChooser.this.m_textToIDMap.get(o);
                                DBObjectChooser.this.updateID(id);
                                done = true;
                            }
                        }
                        if (!done) {
                            DBObjectChooser.this.updateID(null);
                        }
                    }
                }
            };
            this.m_cmb.addActionListener(this.m_listener);
        }
    }

    private void showID() {
        DBObjectID id = this.fixProvider(this.m_id);
        String text = null;
        if (id != null) {
            String fromID = this.getStringFromID(id);
            if (ModelUtil.hasLength((String)fromID)) {
                text = fromID;
            }
        } else if (this.m_editable != null && this.m_editable.booleanValue()) {
            this.m_cmb.getEditor().setItem(text);
            return;
        }
        this.m_cmb.removeActionListener(this.m_listener);
        if (this.m_textToIDMap.containsKey(text)) {
            this.m_cmb.setSelectedItem(text);
        } else {
            int idx = -1;
            this.m_textToIDMap.clear();
            DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
            if (id != null) {
                model.addElement(text);
                this.m_textToIDMap.put(text, id);
                idx = 0;
            }
            this.m_cmb.setModel(model, false);
            this.m_cmb.setSelectedIndex(idx);
        }
        if (this.m_cmb.isEditable()) {
            this.m_cmb.getEditor().setItem(text);
        }
        this.m_cmb.addActionListener(this.m_listener);
    }

    private void contextChanged() {
        DBObjectID id = null;
        if (this.m_editable != null && this.m_editable.booleanValue()) {
            String val = (String)this.m_cmb.getEditor().getItem();
            id = this.getIDFromString(val);
        } else {
            this.m_textToIDMap.clear();
            this.m_cmb.setModel(new DefaultComboBoxModel(), false);
        }
        this.m_cmb.reset();
        this.setDBObjectID(id);
    }

    private void markTextTyped(boolean isTextTyped) {
        this.m_isTextTyped = isTextTyped;
    }

    private boolean isTextTyped() {
        return this.m_isTextTyped;
    }

    private void ensureChildContextUpToDate() {
        if (this.isTextTyped()) {
            DBObjectID mapId;
            DBObjectID id = this.getDBObjectID();
            if (id instanceof ReferenceID && (mapId = this.m_textToIDMap.get(((ReferenceID)id).getName())) != null) {
                id = mapId;
            }
            this.setDBObjectID(id);
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel label = (JLabel)this.m_cmb.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        if (value instanceof String) {
            if (this.getLoadFullListText().equals(value)) {
                label.setBorder(new BevelBorder(1));
            } else if (this.m_showDBLinkButton && ((String)value).startsWith("...@")) {
                label.setIcon(DBTypeDisplayRegistry.getNodeIcon("DATABASE LINK"));
            } else if (this.m_srcProv instanceof Database && !(this.m_destProv instanceof Database) && this.m_types[0].equals("SCHEMA")) {
                label.setIcon(OracleIcons.getIcon((String)"database.png"));
            } else if (this.getShowIcon()) {
                String type;
                String text = (String)value;
                DBObjectID id = this.m_textToIDMap.get(text);
                if (id != null && (type = id.getType()) != null) {
                    label.setIcon(DBTypeDisplayRegistry.getNodeIcon(type));
                }
            } else if (this.m_expandFKOwner != null) {
                String refKeyName;
                DBObjectID refKeyId;
                Constraint cons;
                String text = (String)value;
                DBObjectID id = this.m_textToIDMap.get(text);
                if (id == null) {
                    id = this.getDBObjectID();
                }
                if (id != null && (cons = this.m_expandFKOwner.getConstraint(text)) != null && cons instanceof FKConstraint && (refKeyId = ((FKConstraint)cons).getReferenceID()) != null && (refKeyName = DBUtil.getFullyQualifiedName((DBObjectID)refKeyId)) != null) {
                    label.setText(label.getText() + " -> " + refKeyName);
                }
            }
        }
        return label;
    }

    private List<DBObjectID> getEntries(DBObjectID contextID, boolean loadsubset) throws DBException {
        ArrayList<DBObjectID> retval;
        block17: {
            DBObject contextObject;
            DBObjectFilter filter;
            block19: {
                Object bid;
                block20: {
                    block18: {
                        retval = new ArrayList<DBObjectID>();
                        if (this.getSourceProvider() == null) break block17;
                        filter = this.getFilter();
                        if (!this.m_nonSchemaSystemObjects) break block18;
                        if (this.m_showDBLinkButton && this.m_id instanceof BaseObjectID) {
                            this.m_criteria.setDatabaseName(((BaseObjectID)this.m_id).getDatabaseName());
                        }
                        for (SystemObject sysOb : this.listObjects()) {
                            CancelledException.checkInterrupt();
                            if (sysOb == null || filter != null && !filter.accept((DBObject)sysOb)) continue;
                            DBObjectID id = sysOb.getID();
                            if (id == null) {
                                id = TemporaryObjectID.createID((DBObject)sysOb);
                            }
                            retval.add(id);
                        }
                        break block17;
                    }
                    if (!this.m_schemaObjects) break block19;
                    if (!loadsubset || !this.subsetAvailable(contextID)) break block20;
                    if (contextID == null || !"SCHEMA".equals(contextID.getType())) break block17;
                    this.m_criteria.setSchemaName(this.getStringFromID(contextID));
                    DBObjectSet sortedSet = new DBObjectSet();
                    Collection types = this.getSourceProvider().getDescriptor().listBuiltInObjects(this.m_criteria);
                    for (SystemObject dt : types) {
                        CancelledException.checkInterrupt();
                        sortedSet.add(dt);
                    }
                    for (SystemObject dt : sortedSet) {
                        retval.add(dt.getID());
                    }
                    break block17;
                }
                String dbName = null;
                String schemaName = null;
                if (contextID instanceof TemporaryObjectID) {
                    DBObject co = contextID.resolveID();
                    if (co instanceof Schema) {
                        schemaName = co.getName();
                    }
                } else if (contextID instanceof BaseObjectID && "SCHEMA".equals((bid = (BaseObjectID)contextID).getType())) {
                    dbName = bid.getDatabaseName();
                    schemaName = DBUtil.getDBObjectName((DBObjectID)bid);
                }
                this.m_criteria.setDatabaseName(dbName);
                this.m_criteria.setSchemaName(schemaName);
                for (SystemObject sysOb : this.listObjects()) {
                    CancelledException.checkInterrupt();
                    if (filter != null && !filter.accept((DBObject)sysOb)) continue;
                    DBObjectID id = sysOb.getID();
                    if (id == null) {
                        id = TemporaryObjectID.createID((DBObject)sysOb);
                    }
                    retval.add(id);
                }
                if (!this.m_isDatabaseLinkChooser) break block17;
                CancelledException.checkInterrupt();
                DBObjectProvider pro = this.getSourceProvider();
                String publicSchemaName = pro.getDescriptor().getPublicSchemaName();
                if (publicSchemaName != null) {
                    DBObjectCriteria pubLinkCrit = DBObjectCriteria.createCriteria((String)"DATABASE LINK", (String)publicSchemaName, null);
                    for (SystemObject sysOb : pro.listObjects(pubLinkCrit)) {
                        CancelledException.checkInterrupt();
                        if (filter != null && !filter.accept((DBObject)sysOb)) continue;
                        DBObjectID id = sysOb.getID();
                        if (id == null) {
                            id = TemporaryObjectID.createID((DBObject)sysOb);
                        }
                        retval.add(id);
                    }
                }
                break block17;
            }
            if (this.m_childObjects && contextID != null && (contextObject = contextID.resolveID()) != null) {
                for (String type : this.getTypes()) {
                    CancelledException.checkInterrupt();
                    for (DBObject kid : contextObject.getOwnedObjects(new String[]{type})) {
                        CancelledException.checkInterrupt();
                        if (filter != null && !filter.accept(kid)) continue;
                        retval.add(kid.getID());
                    }
                }
            }
        }
        return retval;
    }

    private DBObjectID fixProvider(DBObjectID id) {
        if (this.getProvider() != this.getSourceProvider() && (id instanceof NameBasedID || id instanceof IdentifierBasedID)) {
            BaseObjectID bid = (BaseObjectID)id;
            ReferenceID refId = new ReferenceID(bid.getType(), bid.getSchemaName(), bid.getName());
            refId.setParent(this.fixProvider(bid.getParent()));
            refId.setProvider(this.getProvider());
            return refId;
        }
        return id;
    }

    public Component getEditorComponent() {
        if (this.m_cmb != null) {
            return this.m_cmb.getEditor().getEditorComponent();
        }
        return null;
    }

    public Component getDefaultFocusComponent() {
        return this.m_cmb;
    }

    public static abstract class NewObjectProcessor {
        public abstract void initialise(SystemObject var1);
    }

    private class ProviderListener
    extends DBObjectProviderListener {
        private ProviderListener() {
        }

        private void resetCachesIfApplicable(Collection<? extends DBObject> objs) {
            for (DBObject dBObject : objs) {
                if (!Arrays.asList(DBObjectChooser.this.getTypes()).contains(dBObject.getType())) continue;
                DBObjectChooser.this.resetCaches();
                break;
            }
        }

        public void objectUpdated(DBObjectChange change) {
            if (DBObjectChooser.this.m_childObjects && change.getDBObject().getID().equals(DBObjectChooser.this.m_contextID, false)) {
                this.resetCachesIfApplicable(change.getOwnedObjectsAdded());
                this.resetCachesIfApplicable(change.getOwnedObjectsRemoved());
            } else {
                this.resetCachesIfApplicable(Collections.singletonList(change.getDBObject()));
            }
        }

        public void systemObjectsAdded(DBObjectProvider provider, Collection<? extends SystemObject> objs) {
            this.resetCachesIfApplicable(objs);
        }

        public void schemaObjectsRemoved(DBObjectProvider provider, Schema schema, Collection<? extends SchemaObject> objs) {
            this.resetCachesIfApplicable(objs);
        }

        public void schemaObjectsAdded(DBObjectProvider provider, Schema schema, Collection<? extends SchemaObject> objs) {
            this.resetCachesIfApplicable(objs);
        }

        public void systemObjectsRemoved(DBObjectProvider provider, Collection<? extends SystemObject> objs) {
            this.resetCachesIfApplicable(objs);
        }
    }

    private class CustomJComboBox
    extends AbstractLazyCombo {
        private boolean m_forceFull;

        private CustomJComboBox() {
        }

        @Override
        protected String getLoadMessage() {
            return "AbstractComboBasedChooser.updateComboModel.DONE";
        }

        @Override
        public String getNullText() {
            return DBObjectChooser.this.m_nullText;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected List<String> getModelEntries() {
            boolean loadsubset;
            ArrayList<String> retval = new ArrayList<String>();
            String curVal = DBObjectChooser.this.getStringFromID(DBObjectChooser.this.getDBObjectID());
            DBObjectID contextID = DBObjectChooser.this.m_contextID;
            DBObjectChooser.this.populateIDMap(contextID, this.m_forceFull);
            Collection list = DBObjectChooser.this.m_textToIDMap.values();
            if (list != null) {
                String nullTextToInsert = null;
                Map map = DBObjectChooser.this.m_textToIDMap;
                synchronized (map) {
                    for (DBObjectID id : list) {
                        if (id == null && nullTextToInsert == null) {
                            nullTextToInsert = this.getNullText();
                            continue;
                        }
                        String str = DBObjectChooser.this.getStringFromID(id);
                        if (!ModelUtil.hasLength((String)str)) continue;
                        retval.add(str);
                    }
                }
                Collections.sort(retval);
                if (nullTextToInsert != null) {
                    retval.add(0, nullTextToInsert);
                }
                DBObjectChooser.this.m_textToIDMap.put(curVal, DBObjectChooser.this.getDBObjectID());
            }
            boolean bl = loadsubset = !this.m_forceFull && DBObjectChooser.this.subsetAvailable(contextID);
            if (loadsubset) {
                DBObjectChooser.this.m_subsetLoaded = true;
                retval.add(DBObjectChooser.this.getLoadFullListText());
            }
            return retval;
        }

        @Override
        protected void doBeforeClearingModel() {
            DBObjectChooser.this.m_listening = false;
        }

        @Override
        protected void doAfterClearingModel() {
            DBObjectChooser.this.m_listening = true;
        }

        @Override
        protected void doBeforeLoading() {
            if (DBObjectChooser.this.m_parent != null) {
                DBObjectChooser.this.m_parent.ensureChildContextUpToDate();
            }
        }

        @Override
        public void reset() {
            super.reset();
            this.m_forceFull = false;
        }

        private void updateComboModel(boolean forceFull) {
            this.reset();
            this.m_forceFull = forceFull;
            this.loadModel();
            if (forceFull) {
                this.removeItem(DBObjectChooser.this.getLoadFullListText());
            }
        }

        @Override
        protected JTextField createEditorTextField() {
            return new CustomChooserTextField();
        }

        private class CustomChooserTextField
        extends AbstractLazyCombo.CustomJTextField {
            public CustomChooserTextField() {
                super(CustomJComboBox.this);
                this.getDocument().addDocumentListener(new DocumentListener(){

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        CustomChooserTextField.this.notifyListeners();
                    }

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        CustomChooserTextField.this.notifyListeners();
                    }

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                    }
                });
                this.addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyTyped(KeyEvent e) {
                        DBObjectChooser.this.markTextTyped(true);
                    }
                });
            }

            private void notifyListeners() {
                DBObjectID id = null;
                for (Tuple pair : DBObjectChooser.this.m_listeners) {
                    if (!((Boolean)pair.getSecond()).booleanValue()) continue;
                    if (id == null) {
                        id = DBObjectChooser.this.getIDFromString(this.getText());
                    }
                    ((ChangeListener)pair.getFirst()).chooserChanged(DBObjectChooser.this, id);
                }
            }

            @Override
            protected String getBaseName() {
                return DBObjectChooser.this.getName();
            }
        }
    }

    public static interface ChangeListener {
        public void chooserChanged(DBObjectChooser var1, DBObjectID var2);
    }
}

