/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.ideimpl.db.extension.DatabaseExtensionHook;
import oracle.ideimpl.db.resource.PropertyValueUI;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.internal.DBCore;
import oracle.javatools.db.property.DisplayNames;
import oracle.javatools.db.property.Property;
import oracle.javatools.db.resource.PropertyBundle;
import oracle.javatools.marshal.ToStringManager;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.deferred.Thunk;

public final class PropertyDisplayRegistry {
    private ExtrasPlugin m_extrasPlugin = new ExtrasPlugin();
    private Collection<Thunk<Plugin>> m_plugins = new CopyOnWriteArrayList<Thunk<Plugin>>();
    private Collection<Thunk<ResourceBundle>> m_bundles = new CopyOnWriteArrayList<Thunk<ResourceBundle>>();

    private PropertyDisplayRegistry() {
        this.registerBundle(PropertyBundle.getBundle());
        this.registerPlugin(this.m_extrasPlugin);
    }

    public static synchronized PropertyDisplayRegistry getInstance() {
        DBCore core = DBCore.getInstance();
        PropertyDisplayRegistry instance = (PropertyDisplayRegistry)core.get(PropertyDisplayRegistry.class);
        if (instance == null) {
            instance = new PropertyDisplayRegistry();
            core.put((Object)instance);
        }
        return instance;
    }

    public static final String getDisplayName(String propName) {
        return PropertyDisplayRegistry.getDisplayName(propName, null, null);
    }

    public static final String getDisplayName(String propName, DBObjectProvider pro, DBObject obj) {
        String displayName = PropertyDisplayRegistry.getDisplayNameOrNull(propName, pro, obj);
        return displayName == null ? propName : displayName;
    }

    public static final String getDisplayNameOrNull(String propName, DBObjectProvider pro, DBObject obj) {
        String displayName = null;
        if (propName != null) {
            propName = Property.getLastProperty((String)propName);
            DatabaseExtensionHook hook = DatabaseExtensionHook.getHook();
            if (hook != null) {
                displayName = hook.getExtensionPropertyDisplayName(propName, pro, obj);
            }
            if (displayName == null) {
                displayName = PropertyDisplayRegistry.getInstance().getDisplayNameFromResourceBundle(propName);
            }
            if (displayName == null) {
                displayName = PropertyDisplayRegistry.getInstance().getDisplayNameFromPlugins(propName, pro, obj);
            }
        }
        return displayName;
    }

    private String getDisplayNameFromPlugins(String propName, DBObjectProvider pro, DBObject obj) {
        for (Thunk<Plugin> pluginThunk : this.m_plugins) {
            Plugin p = (Plugin)pluginThunk.get();
            if (p == null) continue;
            try {
                String displayName = p.getDisplayName(propName, pro, obj);
                if (!ModelUtil.hasLength((String)displayName)) continue;
                return displayName;
            }
            catch (Exception e) {
                DBLog.getLogger(PropertyDisplayRegistry.class).log(DBLog.getExceptionLogLevel(), "Error calling property display plugin " + p.getClass().getName(), e);
            }
        }
        return null;
    }

    private final String getDisplayNameFromResourceBundle(String propName) {
        String displayName = null;
        for (Thunk<ResourceBundle> bundleThunk : this.m_bundles) {
            ResourceBundle b = (ResourceBundle)bundleThunk.get();
            if (b != null) {
                displayName = DisplayNames.getPropertyDisplayName((String)propName, (ResourceBundle)b);
            }
            if (!ModelUtil.hasLength(displayName)) continue;
            break;
        }
        return displayName;
    }

    private static final String getNlsStringForPropValue(String propName, Object value) {
        String stripped;
        ResourceBundle bundle;
        String key;
        String retval = null;
        if (propName != null && (retval = PropertyDisplayRegistry.lookupInBundle(propName, key = ToStringManager.converterAvailable((Object)value) ? ToStringManager.toString((Object)value) : String.valueOf(value), bundle = PropertyValueUI.getBundle())) == null && !propName.equals(stripped = Property.getLastProperty((String)propName))) {
            retval = PropertyDisplayRegistry.lookupInBundle(stripped, key, bundle);
        }
        return retval;
    }

    private static String lookupInBundle(String propName, String key, ResourceBundle bundle) {
        String retval = null;
        try {
            retval = bundle.getString(propName + "." + key);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return retval;
    }

    public static final String getPropValueDisplay(String propName, Object value) {
        String retval = PropertyDisplayRegistry.getNlsStringForPropValue(propName, value);
        if (retval == null) {
            if (value == null) {
                retval = PropertyDisplayRegistry.getNullPropValueDisplay();
            } else if (!(value instanceof Enum) && ToStringManager.converterAvailable((Object)value)) {
                retval = ToStringManager.toString((Object)value);
            } else if (PropertyDisplayRegistry.useToString(value)) {
                retval = value.toString();
            }
        }
        return retval;
    }

    private static boolean useToString(Object value) {
        boolean retval;
        try {
            retval = !Object.class.equals(value.getClass().getMethod("toString", new Class[0]).getDeclaringClass());
        }
        catch (Exception e) {
            retval = true;
        }
        return retval;
    }

    public static final String getNullPropValueDisplay() {
        return PropertyValueUI.get("DEFAULT_NULL_VALUE");
    }

    public static final boolean hasNlsStringForPropValue(String propName, Object value) {
        return PropertyDisplayRegistry.getNlsStringForPropValue(propName, value) != null;
    }

    private <T> Thunk<T> findThunk(Collection<Thunk<T>> thunks, T thunk) {
        Thunk<T> retval = null;
        for (Thunk<T> checkMe : thunks) {
            Object obj = checkMe.getIfSet();
            if (obj == null || !obj.equals(thunk)) continue;
            retval = checkMe;
            break;
        }
        return retval;
    }

    public void registerBundle(ResourceBundle bundle) {
        if (this.findThunk(this.m_bundles, bundle) == null) {
            this.registerBundle((Thunk<ResourceBundle>)Thunk.directReference((Object)bundle));
        }
    }

    public void registerBundle(Thunk<ResourceBundle> bundle) {
        this.m_bundles.add(bundle);
    }

    public boolean unregisterBundle(ResourceBundle bundle) {
        Thunk<ResourceBundle> found;
        boolean retval = false;
        if (bundle != PropertyBundle.getBundle() && (found = this.findThunk(this.m_bundles, bundle)) != null) {
            retval = this.m_bundles.remove(found);
        }
        return retval;
    }

    @Deprecated
    public void registerDisplayName(String propName, String displayName) {
        this.m_extrasPlugin.registerDisplayName(propName, displayName);
    }

    public void registerPlugin(Plugin plugin) {
        if (this.findThunk(this.m_plugins, plugin) == null) {
            this.registerPlugin((Thunk<Plugin>)Thunk.directReference((Object)plugin));
        }
    }

    public void registerPlugin(Thunk<Plugin> plugin) {
        this.m_plugins.add(plugin);
    }

    public boolean unregisterPlugin(Plugin plugin) {
        return this.m_plugins.remove(plugin);
    }

    private static class ExtrasPlugin
    extends Plugin {
        private final Map<String, String> m_extras = new HashMap<String, String>();

        private ExtrasPlugin() {
        }

        @Override
        public String getDisplayName(String name, DBObjectProvider pro, DBObject obj) {
            return this.m_extras.get(name);
        }

        public void registerDisplayName(String propName, String displayName) {
            this.m_extras.put(propName, displayName);
        }
    }

    public static abstract class Plugin {
        public abstract String getDisplayName(String var1, DBObjectProvider var2, DBObject var3);
    }
}

