/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.db;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import oracle.ide.db.DBTypeDisplayRegistryEntry;
import oracle.ide.db.DefaultDBTypeRegistry;
import oracle.ide.db.util.IconWithSmallOverlay;
import oracle.ideimpl.db.resource.UIBundle;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.plsql.PlSqlSubProgram;
import oracle.javatools.db.plsql.PlSqlTokenPattern;
import oracle.javatools.db.property.DisplayNames;
import oracle.javatools.db.token.TokenPattern;
import oracle.javatools.icons.OracleIcons;

public final class DBTypeDisplayRegistry {
    public static final String CONNECTIONS_TYPE = "Connections";
    private static List<DBTypeDisplayRegistryEntry> s_registries = new ArrayList<DBTypeDisplayRegistryEntry>();
    private static HashMap<String, Icon> s_generatedFolderIcons = new HashMap();

    private DBTypeDisplayRegistry() {
    }

    public static void addDBTypeRegistry(DBTypeDisplayRegistryEntry registry) {
        s_registries.add(0, registry);
    }

    public static Icon getFolderIcon(String type) {
        Icon retval = null;
        if (retval != null || type == null) {
            return retval;
        }
        for (DBTypeDisplayRegistryEntry reg : s_registries) {
            retval = reg.getFolderIcon(type);
            if (retval == null) continue;
            return retval;
        }
        if (DBTypeDisplayRegistry.getNodeIcon(type) != null) {
            retval = new FolderIcon(type);
            s_generatedFolderIcons.put(type, retval);
            return retval;
        }
        return null;
    }

    public static Icon getNodeIcon(String type) {
        Icon icon;
        block1: {
            DBTypeDisplayRegistryEntry reg;
            icon = null;
            if (type == null) break block1;
            Iterator<DBTypeDisplayRegistryEntry> iterator = s_registries.iterator();
            while (iterator.hasNext() && (icon = (reg = iterator.next()).getNodeIcon(type)) == null) {
            }
        }
        return icon;
    }

    public static Icon getNodeIcon(DBObject object) {
        Icon retval = null;
        if (object instanceof Constraint) {
            retval = DBTypeDisplayRegistry.getNodeIcon(((Constraint)object).getConstraintType());
        } else if (object != null) {
            String type = object.getType();
            if (object instanceof PlSqlSubProgram) {
                PlSqlSubProgram sub = (PlSqlSubProgram)object;
                if (SwingUtilities.isEventDispatchThread() && DBUtil.needsBuilding((DBObject)sub, (String)"returnTypeReference")) {
                    String source = sub.getSource();
                    String pattern = "TypeMethod".equals(type) ? "[ { NOT FINAL | <final FINAL> |     NOT OVERRIDING | <over OVERRIDING> |     <notInst  NOT INSTANTIABLE> | INSTANTIABLE }...] <methodType {MEMBER|STATIC|CONSTRUCTOR|MAP MEMBER|ORDER MEMBER}> { PROCEDURE <pname ?> <pparams [(...)]> |   FUNCTION <fname ?> <fparams [(...)]> RETURN <datatype {SELF AS RESULT|?%}> } [EXTERNAL {NAME <extname ?> | VARIABLE NAME <extvarname ?> } ][{DETERMINISTIC|PIPELINED|RESULT_CACHE}...][ {IS|AS} LANGUAGE     { JAVA NAME <javaname ?>     | C [NAME <cname ?>] LIBRARY <clibname ?.>       [AGENT IN ({^)}...) ]       [WITH <ccontext CONTEXT>]       [PARAMETERS ({^)}...) ]     } ]" : "{PROCEDURE <pname ?> <pparams [(...)]>|FUNCTION <fname ?> <fparams [(...)]> RETURN <datatype ?%>}";
                    PlSqlTokenPattern m = new PlSqlTokenPattern(pattern);
                    TokenPattern.PatternResult res = m.getResult(source);
                    type = res != null && res.getNamedMatch("fname") != null ? "FUNCTION" : "PROCEDURE";
                } else {
                    type = ((PlSqlSubProgram)object).getReturnTypeReference() == null ? "PROCEDURE" : "FUNCTION";
                }
            }
            retval = DBTypeDisplayRegistry.getNodeIcon(type);
        }
        return retval;
    }

    public static String getDisplayName(String type) {
        String name = null;
        if (type != null) {
            DBTypeDisplayRegistryEntry reg;
            Iterator<DBTypeDisplayRegistryEntry> iterator = s_registries.iterator();
            while (iterator.hasNext() && ((name = (reg = iterator.next()).getDisplayName(type)) == null || name.equals(type))) {
            }
            if (name == null || name.equals(type)) {
                name = DisplayNames.getTypePluralName((String)type);
            }
        }
        return name;
    }

    public static String getSingularDisplayName(String type) {
        String name = null;
        if (type != null) {
            DBTypeDisplayRegistryEntry reg;
            Iterator<DBTypeDisplayRegistryEntry> iterator = s_registries.iterator();
            while (iterator.hasNext() && ((name = (reg = iterator.next()).getSingularDisplayName(type)) == null || name.equals(type))) {
            }
            if (name == null || name.equals(type)) {
                name = DisplayNames.getTypeDisplayName((String)type);
            }
        }
        return name;
    }

    public static String getNewMenuItemText(String type) {
        String text = null;
        if (type != null) {
            DBTypeDisplayRegistryEntry reg;
            Iterator<DBTypeDisplayRegistryEntry> iterator = s_registries.iterator();
            while (iterator.hasNext() && (text = (reg = iterator.next()).getNewMenuItemText(type)) == null) {
            }
            if (text == null) {
                text = UIBundle.format("NEW_MENU_TEMPLATE", DBTypeDisplayRegistry.getSingularDisplayName(type));
            }
        }
        return text;
    }

    public static String getDialogTitle(String type, boolean edit, boolean error) {
        String key = edit ? (error ? "DBOBJECT_EDIT_ERR_TITLE" : "DBOBJECT_EDIT_TITLE") : (error ? "DBOBJECT_CREATE_ERR_TITLE" : "DBOBJECT_CREATE_TITLE");
        String typeDisplay = DBTypeDisplayRegistry.getSingularDisplayName(type);
        return UIBundle.format(key, typeDisplay);
    }

    static {
        DBTypeDisplayRegistry.addDBTypeRegistry(new DefaultDBTypeRegistry());
    }

    private static class FolderIcon
    extends IconWithSmallOverlay {
        public FolderIcon(String type) {
            super(OracleIcons.getIcon((String)"folder.png"), DBTypeDisplayRegistry.getNodeIcon(type));
        }
    }
}

