/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.teradata.parser;

import oracle.dbtools.migration.parser.OracleSQLConstants;

public class IdentifierHelper {
    private static final String NOTALLOWEDCHARS = " ' .@`!\"%^&*()-+=[]{};:,.<>?/~''\u00a3";
    private static final String DIGITS = "0123456789";
    private static final String EXTRAALLOWED = "_$";

    public static String createValidIdentifier(String string, String string2) {
        if (string == null || string.trim().equals("")) {
            return string;
        }
        String string3 = string;
        if (string3.trim().equals("\"\"")) {
            return string3;
        }
        if (string3.trim().startsWith("'") && string3.trim().endsWith("'")) {
            return string3;
        }
        string3 = IdentifierHelper.removeQuoteCharacters(string3);
        string3 = IdentifierHelper.leftTrimNonAlphaNumeric(string3);
        string3 = IdentifierHelper.firstCharCheck(string3, string2);
        string3 = IdentifierHelper.temporaryObjectCheck(string3);
        string3 = IdentifierHelper.removeInvalidCharacters(string3);
        string3 = IdentifierHelper.trimToSize(string3, 30);
        string3 = IdentifierHelper.modifyReservedNames(string3);
        return string3;
    }

    protected static String removeQuoteCharacters(String string) {
        if (string != null && (string.trim().startsWith("[") && string.trim().endsWith("]") || string.trim().startsWith("\"") && string.trim().endsWith("\""))) {
            string = string.trim().substring(1, string.length() - 1);
        }
        return string;
    }

    private static String leftTrimNonAlphaNumeric(String string) {
        int n = 0;
        for (char c : string.toCharArray()) {
            if (" ' .@`!\"%^&*()-+=[]{};:,.<>?/~''\u00a3_$".indexOf(c) == -1) break;
            ++n;
        }
        return string.substring(n);
    }

    private static String firstCharCheck(String string, String string2) {
        char c = string.charAt(0);
        if (" ' .@`!\"%^&*()-+=[]{};:,.<>?/~''\u00a3_$0123456789".indexOf(c) != -1) {
            string = "A" + string;
        }
        return string;
    }

    private static String temporaryObjectCheck(String string) {
        if (string.trim().startsWith("#")) {
            // empty if block
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private static String removeInvalidCharacters(String string) {
        void var6_9;
        char[] cArray = string.toCharArray();
        int n = 0;
        for (char n2 : cArray) {
            if (NOTALLOWEDCHARS.indexOf(n2) != -1) {
                cArray[n] = 95;
            }
            ++n;
        }
        n = 0;
        Object object = new StringBuffer();
        char[] cArray2 = cArray;
        int n2 = cArray2.length;
        boolean bl = false;
        while (var6_9 < n2) {
            char c = cArray2[var6_9];
            if (c == '_') {
                if (cArray.length == n + 1) {
                    ((StringBuffer)object).append(c);
                } else if (cArray.length > n + 1 && cArray[n + 1] != '_') {
                    ((StringBuffer)object).append(c);
                }
            } else {
                ((StringBuffer)object).append(c);
            }
            ++n;
            ++var6_9;
        }
        return ((StringBuffer)object).toString();
    }

    private static String trimToSize(String string, int n) {
        if (string != null && string.trim().length() > n) {
            string = string.trim().substring(0, n);
        }
        return string;
    }

    private static String modifyReservedNames(String string) {
        if (OracleSQLConstants.isSignificantWord((String)string) || OracleSQLConstants.isRservedWord((String)string)) {
            string = string + "_";
        }
        return string;
    }
}

