/*
 * Decompiled with CFR 0.152.
 */
package oracle.cloudstorage.api.stripe;

import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import oracle.cloudstorage.api.stripe.ISegmentInputStreamProcessor;
import oracle.cloudstorage.concurrent.Future;
import oracle.cloudstorage.io.Md5InputStream;

public abstract class Md5SegmentInputStreamProcessor
implements ISegmentInputStreamProcessor<String> {
    private Md5InputStream md5InputStream = null;
    private final Future<String> futureMd5 = new Future();

    protected final InputStream getMd5InputStream() {
        return this.md5InputStream;
    }

    protected abstract void process() throws Exception;

    @Override
    public void cancel() {
        this.futureMd5.cancel(true);
    }

    @Override
    public final ISegmentInputStreamProcessor.ResultProvider<String> process(InputStream segmentInputStream) throws Exception {
        this.md5InputStream = new Md5InputStream(segmentInputStream, this.futureMd5);
        this.process();
        return new ISegmentInputStreamProcessor.ResultProvider<String>(){

            @Override
            public String get() throws InterruptedException {
                try {
                    String md5 = (String)Md5SegmentInputStreamProcessor.this.futureMd5.get();
                    return md5;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }
}

