/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.buffer;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.charset.CharsetDecoder;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Segment;
import javax.swing.undo.UndoableEdit;
import oracle.javatools.buffer.ArrayLineMap;
import oracle.javatools.buffer.DigestHash;
import oracle.javatools.buffer.EOLNormalizer;
import oracle.javatools.buffer.LineMap;
import oracle.javatools.buffer.LinkedOffsetMark;
import oracle.javatools.buffer.OffsetMark;
import oracle.javatools.buffer.ReadOnlyException;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.ReadWriteLock;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.buffer.TextBufferListener;
import oracle.javatools.buffer.UndoableTextEdit;
import oracle.javatools.buffer.WriteLockRequestListener;
import oracle.javatools.util.NullArgumentException;
import oracle.javatools.util.UnexpectedExceptionError;

public abstract class ScriptRunnerAbstractTextBuffer
implements TextBuffer {
    protected static final char EOF_MARKER = '\uffff';
    protected static final char[] EMPTY_CHARS = new char[0];
    protected static String platformEOLType = "\r\n";
    private static final UndoableTextEdit START_EDIT = new UndoableTextEdit(null);
    private String bufferEOLType;
    private final CopyOnWriteArrayList<TextBufferListener> listenerList;
    private final LinkedOffsetMark marksListHead;
    protected final ReadWriteLock bufferLock;
    private boolean inChangeNotify;
    private ArrayLineMap lineMap;
    private UndoableTextEdit compoundEdit;
    private Throwable compoundEditStartTrace;
    private int nonModifiedChangeId;
    private int changeId;
    private boolean readOnlyMode;
    private boolean suppressUndo;
    private static final Logger LOG = Logger.getLogger(TextBuffer.class.getName());
    private static int globalNextId = 1001;
    private UndoState undoState;

    protected ScriptRunnerAbstractTextBuffer(ReadWriteLock readWriteLock) {
        this.bufferLock = readWriteLock;
        this.listenerList = new CopyOnWriteArrayList();
        this.marksListHead = new LinkedOffsetMark(-1, true);
        this.marksListHead.initializeHead();
        this.bufferEOLType = platformEOLType;
        this.inChangeNotify = false;
        this.lineMap = null;
        this.compoundEdit = null;
        this.readOnlyMode = false;
        this.nextChangeId();
        this.setSuppressUndo(false);
        this.clearModified();
        this.undoState = new UndoState(this);
    }

    public void setReadOnly(boolean bl) {
        this.readLock();
        try {
            this.readOnlyMode = bl;
            this.fireAttributeUpdate(2);
        }
        finally {
            this.readUnlock();
        }
    }

    public boolean isReadOnly() {
        return this.readOnlyMode;
    }

    public abstract int getLength();

    public abstract char getChar(int var1) throws IndexOutOfBoundsException;

    public char[] getChars(int n, int n2) throws IndexOutOfBoundsException {
        if (n2 < 0) {
            if (n2 == 0) {
                return EMPTY_CHARS;
            }
            throw new IndexOutOfBoundsException("length " + n2 + " < 0");
        }
        return this.getCharsImpl(n, n2);
    }

    protected abstract char[] getCharsImpl(int var1, int var2) throws IndexOutOfBoundsException;

    public String getString(int n, int n2) throws IndexOutOfBoundsException {
        return this.getStringImpl(n, n2);
    }

    protected abstract String getStringImpl(int var1, int var2) throws IndexOutOfBoundsException;

    public void getText(int n, int n2, Segment segment) throws IndexOutOfBoundsException {
        if (n2 == 0) {
            segment.array = EMPTY_CHARS;
            segment.offset = 0;
            segment.count = 0;
        } else {
            this.getTextImpl(n, n2, segment);
        }
    }

    protected abstract void getTextImpl(int var1, int var2, Segment var3) throws IndexOutOfBoundsException;

    public UndoableEdit insert(int n, char[] cArray) throws ReadOnlyException {
        try {
            EOLNormalizer eOLNormalizer = EOLNormalizer.getNormalizer((char[])cArray);
            char[] cArray2 = eOLNormalizer.normalizeData();
            return this.normalizedInsert(n, cArray2);
        }
        catch (IOException iOException) {
            throw new UnexpectedExceptionError((Throwable)iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UndoableEdit normalizedInsert(int n, char[] cArray) throws ReadOnlyException {
        if (cArray == null || cArray.length == 0) {
            return null;
        }
        if (this.inChangeNotify) {
            throw new IllegalStateException("nested mutations not allowed");
        }
        boolean bl = !this.isSuppressUndo();
        this.writeLock();
        try {
            n = this.insertImpl(n, cArray);
            boolean bl2 = this.nextChangeId();
            this.fireInsertUpdate(n, cArray, bl2);
        }
        finally {
            this.writeUnlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyInsert(int n, char[] cArray, int n2) throws ReadOnlyException {
        if (cArray == null || cArray.length == 0) {
            throw new IllegalStateException("empty data");
        }
        if (this.inChangeNotify) {
            throw new IllegalStateException("nested mutations not allowed");
        }
        if (this.compoundEdit != null) {
            throw new IllegalStateException("undo during edit not allowed", this.compoundEditStartTrace);
        }
        this.writeLock();
        try {
            this.insertImpl(n, cArray);
            boolean bl = this.setChangeId(n2);
            this.fireInsertUpdate(n, cArray, bl);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UndoableEdit append(char[] cArray) throws ReadOnlyException {
        UndoableEdit undoableEdit = null;
        this.writeLock();
        try {
            int n = this.getLength();
            undoableEdit = this.insert(n, cArray);
        }
        finally {
            this.writeUnlock();
        }
        return undoableEdit;
    }

    protected int insertImpl(int n, char[] cArray) {
        return this.insertImpl(n, cArray, 0, cArray.length);
    }

    protected abstract int insertImpl(int var1, char[] var2, int var3, int var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireInsertUpdate(int n, char[] cArray, boolean bl) {
        this.inChangeNotify = true;
        try {
            int n2 = cArray.length;
            if (this.lineMap != null) {
                this.lineMap.insertUpdate(n, n2, cArray);
            }
            int n3 = n == 0 ? 1 : n;
            for (LinkedOffsetMark linkedOffsetMark = this.marksListHead.nextMark(); linkedOffsetMark != this.marksListHead; linkedOffsetMark = linkedOffsetMark.nextMark()) {
                linkedOffsetMark.insertUpdate(n3, n2);
            }
            if (bl) {
                this.fireAttributeUpdate(5);
            }
            for (TextBufferListener textBufferListener : this.listenerList) {
                try {
                    textBufferListener.insertUpdate((TextBuffer)this, n, n2, cArray);
                }
                catch (Throwable throwable) {
                    LOG.log(Level.SEVERE, "Exception thrown by TextBufferListener " + textBufferListener + " inserting " + cArray.length + " at " + n, throwable);
                }
            }
        }
        finally {
            this.inChangeNotify = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UndoableEdit remove(int n, int n2) throws ReadOnlyException {
        if (n2 == 0) {
            return null;
        }
        if (this.inChangeNotify) {
            throw new IllegalStateException("nested mutations not allowed");
        }
        boolean bl = !this.isSuppressUndo();
        this.writeLock();
        try {
            char[] cArray = this.getChars(n, n2);
            this.removeImpl(n, n2);
            boolean bl2 = this.nextChangeId();
            this.fireRemoveUpdate(n, cArray, bl2);
        }
        finally {
            this.writeUnlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyRemove(int n, char[] cArray, int n2) throws ReadOnlyException {
        if (cArray == null || cArray.length == 0) {
            throw new IllegalStateException("empty data");
        }
        if (this.inChangeNotify) {
            throw new IllegalStateException("nested mutations not allowed");
        }
        if (this.compoundEdit != null) {
            throw new IllegalStateException("undo during edit not allowed");
        }
        this.writeLock();
        try {
            int n3 = cArray.length;
            this.removeImpl(n, n3);
            boolean bl = this.setChangeId(n2);
            this.fireRemoveUpdate(n, cArray, bl);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UndoableEdit removeToEnd(int n) throws ReadOnlyException {
        UndoableEdit undoableEdit = null;
        this.writeLock();
        try {
            int n2 = this.getLength() - n;
            undoableEdit = this.remove(n, n2);
        }
        finally {
            this.writeUnlock();
        }
        return undoableEdit;
    }

    protected abstract void removeImpl(int var1, int var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireRemoveUpdate(int n, char[] cArray, boolean bl) {
        this.inChangeNotify = true;
        try {
            int n2 = cArray.length;
            if (this.lineMap != null) {
                this.lineMap.removeUpdate(n, n2, cArray);
            }
            for (LinkedOffsetMark linkedOffsetMark = this.marksListHead.nextMark(); linkedOffsetMark != this.marksListHead; linkedOffsetMark = linkedOffsetMark.nextMark()) {
                linkedOffsetMark.removeUpdate(n, n2);
            }
            if (bl) {
                this.fireAttributeUpdate(5);
            }
            for (TextBufferListener textBufferListener : this.listenerList) {
                try {
                    textBufferListener.removeUpdate((TextBuffer)this, n, n2, cArray);
                }
                catch (Throwable throwable) {
                    LOG.log(Level.SEVERE, "Exception thrown by TextBufferListener " + textBufferListener + " removing " + cArray.length + " from " + n, throwable);
                }
            }
        }
        finally {
            this.inChangeNotify = false;
        }
    }

    public LineMap getLineMap() {
        if (this.lineMap == null) {
            this.readLock();
            try {
                this.lineMap = new ArrayLineMap((ReadTextBuffer)this);
            }
            finally {
                this.readUnlock();
            }
        }
        return this.lineMap;
    }

    public void addTextBufferListener(TextBufferListener textBufferListener) {
        this.listenerList.addIfAbsent(textBufferListener);
    }

    public void removeTextBufferListener(TextBufferListener textBufferListener) {
        this.listenerList.remove(textBufferListener);
    }

    public void readLock() {
        this.bufferLock.readLock();
    }

    public void readLockInterruptibly() throws InterruptedException {
        this.bufferLock.readLockInterruptibly();
    }

    public boolean tryReadLock() {
        return this.bufferLock.tryReadLock();
    }

    public void readUnlock() {
        this.bufferLock.readUnlock();
    }

    public int getLockStatus() {
        if (this.bufferLock.isWriteLockHeld()) {
            return 2;
        }
        if (this.bufferLock.isReadLockHeld()) {
            return 1;
        }
        return 0;
    }

    public void writeLock() throws ReadOnlyException {
        this.writeLock(true);
    }

    public void writeLock(boolean bl) throws ReadOnlyException {
        if (bl && this.isReadOnly()) {
            throw new ReadOnlyException();
        }
        this.bufferLock.writeLock();
    }

    public void writeLockInterruptibly() throws InterruptedException, ReadOnlyException {
        if (this.isReadOnly()) {
            throw new ReadOnlyException();
        }
        this.bufferLock.writeLockInterruptibly();
    }

    public boolean tryWriteLock() throws ReadOnlyException {
        if (this.isReadOnly()) {
            throw new ReadOnlyException();
        }
        return this.bufferLock.tryWriteLock();
    }

    public void writeUnlock() {
        this.bufferLock.writeUnlock();
    }

    public boolean addWriteLockRequestListener(WriteLockRequestListener writeLockRequestListener) {
        if (writeLockRequestListener == null) {
            throw new NullArgumentException("null listener");
        }
        return this.bufferLock.addWriteLockRequestListener(writeLockRequestListener);
    }

    public void removeWriteLockRequestListener(WriteLockRequestListener writeLockRequestListener) {
        if (writeLockRequestListener == null) {
            throw new NullArgumentException("null listener");
        }
        this.bufferLock.removeWriteLockRequestListener(writeLockRequestListener);
    }

    public void beginEdit() throws ReadOnlyException {
        this.writeLock();
        if (this.compoundEdit != null) {
            this.writeUnlock();
            throw new IllegalStateException("Already in compound edit");
        }
        this.compoundEditStartTrace = new Throwable("beginEdit diagnostic trace");
        this.compoundEdit = START_EDIT;
    }

    public UndoableEdit endEdit() {
        if (this.compoundEdit == null) {
            throw new IllegalStateException("Not in compound edit");
        }
        UndoableTextEdit undoableTextEdit = null;
        if (this.compoundEdit != START_EDIT) {
            undoableTextEdit = this.compoundEdit;
        }
        this.compoundEdit = null;
        this.compoundEditStartTrace = null;
        this.writeUnlock();
        return undoableTextEdit;
    }

    public boolean isModified() {
        boolean bl = this.nonModifiedChangeId != this.getChangeId();
        return bl;
    }

    public void clearModified() {
        this.clearModified(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearModified(boolean bl) {
        int n = this.getChangeId();
        boolean bl2 = n != this.nonModifiedChangeId;
        this.nonModifiedChangeId = n;
        if (bl2 && bl) {
            this.writeLock();
            try {
                this.fireAttributeUpdate(5);
            }
            finally {
                this.writeUnlock();
            }
        }
    }

    public int getChangeId() {
        return this.changeId;
    }

    private boolean setChangeId(int n) {
        boolean bl = this.isModified();
        this.changeId = n;
        return bl != this.isModified();
    }

    private static synchronized int requestNextChangeId() {
        return globalNextId++;
    }

    private boolean nextChangeId() {
        int n = ScriptRunnerAbstractTextBuffer.requestNextChangeId();
        return this.setChangeId(n);
    }

    private void setSuppressUndo(boolean bl) {
        this.suppressUndo = bl;
    }

    private boolean isSuppressUndo() {
        return this.suppressUndo;
    }

    public void read(Reader reader) throws IOException {
        EOLNormalizer eOLNormalizer = EOLNormalizer.getNormalizer((Reader)reader);
        this.read(eOLNormalizer);
    }

    public void read(FileChannel fileChannel, CharsetDecoder charsetDecoder) throws IOException {
        EOLNormalizer eOLNormalizer = EOLNormalizer.getNormalizer((FileChannel)fileChannel, (CharsetDecoder)charsetDecoder);
        this.read(eOLNormalizer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void read(EOLNormalizer eOLNormalizer) throws IOException {
        this.setReadOnly(false);
        this.writeLock();
        try {
            if (this.compoundEdit != null) {
                throw new IllegalStateException("no read() during compound edit");
            }
            this.fireAttributeUpdate(3);
            try {
                this.setSuppressUndo(true);
                this.removeToEnd(0);
                char[] cArray = eOLNormalizer.normalizeData();
                this.normalizedInsert(0, cArray);
                String string = eOLNormalizer.getEOLType();
                if (!platformEOLType.equals(string) || this.getEOLType() != string) {
                    this.setEOLType(string);
                }
                this.clearModified();
                this.setSuppressUndo(false);
            }
            finally {
                this.fireAttributeUpdate(4);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UndoableEdit insert(int n, Reader reader) throws IOException, ReadOnlyException {
        UndoableEdit undoableEdit = null;
        this.writeLock();
        try {
            EOLNormalizer eOLNormalizer = EOLNormalizer.getNormalizer((Reader)reader);
            char[] cArray = eOLNormalizer.normalizeData();
            undoableEdit = this.normalizedInsert(n, cArray);
        }
        finally {
            this.writeUnlock();
        }
        return undoableEdit;
    }

    public void write(Writer writer) throws IOException {
        this.write(writer, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Writer writer, boolean bl) throws IOException {
        if (!(writer instanceof BufferedWriter)) {
            writer = new BufferedWriter(writer);
        }
        this.readLock();
        try {
            int n;
            int n2;
            int n3;
            if (this.compoundEdit != null) {
                throw new IllegalStateException("no write() during compound edit", this.compoundEditStartTrace);
            }
            Segment segment = new Segment();
            LineMap lineMap = this.getLineMap();
            int n4 = lineMap.getLineCount() - 1;
            for (int i = 0; i < n4; ++i) {
                n3 = lineMap.getLineStartOffset(i);
                n2 = lineMap.getLineEndOffset(i) - 1;
                n = n2 - n3;
                if (n > 0) {
                    this.getText(n3, n, segment);
                    writer.write(segment.array, segment.offset, segment.count);
                }
                writer.write(this.bufferEOLType);
            }
            n3 = lineMap.getLineStartOffset(n4);
            n2 = lineMap.getLineEndOffset(n4);
            n = n2 - n3;
            if (n > 0) {
                this.getText(n3, n, segment);
                writer.write(segment.array, segment.offset, segment.count);
            }
            writer.close();
        }
        finally {
            this.readUnlock();
        }
        boolean bl2 = this.isModified();
        int n = this.getChangeId();
        if (bl && bl2) {
            this.bufferLock.writeLockFromReadLock();
            try {
                if (n == this.getChangeId()) {
                    this.clearModified(true);
                }
            }
            finally {
                this.writeUnlock();
            }
        }
    }

    public String getPlatformEOLType() {
        return platformEOLType;
    }

    public String getEOLType() {
        return this.bufferEOLType;
    }

    public void setEOLType(String string) throws ReadOnlyException {
        this.writeLock();
        try {
            this.bufferEOLType = string;
            this.fireAttributeUpdate(1);
        }
        finally {
            this.writeUnlock();
        }
    }

    private void fireAttributeUpdate(int n) {
        for (TextBufferListener textBufferListener : this.listenerList) {
            try {
                textBufferListener.attributeUpdate((TextBuffer)this, n);
            }
            catch (Throwable throwable) {
                LOG.log(Level.SEVERE, "Exception thrown by TextBufferListener " + textBufferListener + " updating attribute  " + n, throwable);
            }
        }
    }

    public OffsetMark addOffsetMark(int n) {
        return this.addOffsetMark(n, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OffsetMark addOffsetMark(int n, boolean bl) {
        LinkedOffsetMark linkedOffsetMark = null;
        this.readLock();
        try {
            linkedOffsetMark = new LinkedOffsetMark(n, bl);
            LinkedOffsetMark linkedOffsetMark2 = this.marksListHead;
            synchronized (linkedOffsetMark2) {
                linkedOffsetMark.attachBefore(this.marksListHead);
            }
        }
        finally {
            this.readUnlock();
        }
        return linkedOffsetMark;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeOffsetMark(OffsetMark offsetMark) {
        this.readLock();
        try {
            LinkedOffsetMark linkedOffsetMark = this.marksListHead;
            synchronized (linkedOffsetMark) {
                LinkedOffsetMark linkedOffsetMark2 = (LinkedOffsetMark)offsetMark;
                linkedOffsetMark2.detach();
            }
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UndoState detachUndoState() {
        this.writeLock(false);
        try {
            boolean bl = this.undoState.detachAndSaveState();
            UndoState undoState = bl ? this.undoState : null;
            this.undoState = new UndoState(this);
            UndoState undoState2 = undoState;
            return undoState2;
        }
        finally {
            this.writeUnlock();
        }
    }

    protected UndoState copyUndoState() {
        UndoState undoState = new UndoState(this);
        undoState.detachAndSaveState();
        return undoState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean attachUndoState(UndoState undoState) {
        if (undoState == null) {
            return false;
        }
        this.writeLock(false);
        try {
            boolean bl = undoState.attachAndRestoreState(this);
            if (bl) {
                this.undoState.detachAndDiscard();
                this.undoState = undoState;
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            this.writeUnlock();
        }
    }

    protected int getLineCount() {
        return this.getLineMap().getLineCount();
    }

    protected void removeFromLineMap(int n) {
        ((ArrayLineMap)this.getLineMap()).removeUpdate(0, n, null);
    }

    protected void removeLineFromLineMap(int n) {
        int n2 = ((ArrayLineMap)this.getLineMap()).getLineStartOffset(n);
        int n3 = ((ArrayLineMap)this.getLineMap()).getLineEndOffset(n);
        int n4 = n3 - n2;
        char[] cArray = new char[n4];
        ((ArrayLineMap)this.getLineMap()).removeUpdate(n2, n4, cArray);
    }

    static {
        String string = System.getProperty("line.separator");
        if (string != null && string.length() == 1) {
            char c = string.charAt(0);
            platformEOLType = c == '\r' ? "\r" : "\n";
        }
    }

    public static final class UndoState {
        private ScriptRunnerAbstractTextBuffer _textBuffer;
        private int _changeId;
        private DigestHash _digestHash;

        UndoState(ScriptRunnerAbstractTextBuffer scriptRunnerAbstractTextBuffer) {
            this._textBuffer = scriptRunnerAbstractTextBuffer;
            this._digestHash = null;
            this._changeId = -1;
        }

        ScriptRunnerAbstractTextBuffer getTextBuffer() {
            return this._textBuffer;
        }

        private void detachAndDiscard() {
            this._textBuffer = null;
            this._digestHash = null;
        }

        private boolean detachAndSaveState() {
            if (this._textBuffer == null) {
                throw new IllegalStateException("state already detached");
            }
            this._changeId = this._textBuffer.getChangeId();
            this._digestHash = DigestHash.computeDigestHash((TextBuffer)this._textBuffer);
            this._textBuffer = null;
            return this._digestHash != null;
        }

        private boolean attachAndRestoreState(ScriptRunnerAbstractTextBuffer scriptRunnerAbstractTextBuffer) {
            if (this._textBuffer != null) {
                throw new IllegalStateException("state already attached");
            }
            if (this._digestHash == null) {
                return false;
            }
            DigestHash digestHash = DigestHash.computeDigestHash((TextBuffer)scriptRunnerAbstractTextBuffer);
            if (!digestHash.equals((Object)this._digestHash)) {
                return false;
            }
            this._textBuffer = scriptRunnerAbstractTextBuffer;
            scriptRunnerAbstractTextBuffer.setChangeId(this._changeId);
            scriptRunnerAbstractTextBuffer.clearModified(false);
            this._digestHash = null;
            return true;
        }

        public String toString() {
            return "UndoState (buffer " + this._textBuffer + ", id " + this._changeId + ")";
        }
    }
}

