/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.sqlhistory;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.util.Resource;
import oracle.dbtools.util.Service;
import oracle.dbtools.util.Util;
import oracle.dbtools.worksheet.sqlhistory.SqlHistoryPanel;
import oracle.dbtools.worksheet.sqlhistory.SqlHistoryTask;
import oracle.dbtools.worksheet.sqlhistory.db.HistoryDB;
import oracle.dbtools.worksheet.sqlhistory.db.HistoryDBTableModel;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.net.URLFileSystem;

public class SqlEditorHistory {
    private static SqlEditorHistory _sqlEditorHistory = null;
    public static String OLD_HISTORY_FILE_PATH = Resource.RAPTOR_USER.getAbsolutePath() + File.separator + "SqlHistory.xml";
    public static String NEW_HISTORY_DIR_PATH = Resource.RAPTOR_USER.getAbsolutePath() + File.separator + "SqlHistory";
    public static String TYPE_SQL_HISTORY = "SQL";
    public static String TYPE_SCRIPT_HISTORY = "Script";
    private int currentSelectedRow = -1;

    public static synchronized SqlEditorHistory getInstance() {
        if (_sqlEditorHistory == null) {
            _sqlEditorHistory = new SqlEditorHistory();
            SqlEditorHistory.migrateOldHistory();
        }
        return _sqlEditorHistory;
    }

    private static void migrateOldHistory() {
        File file = new File(OLD_HISTORY_FILE_PATH);
        if (file.exists() && HistoryDB.getInstance().historySize() == 0) {
            RaptorTask<Void> raptorTask = new RaptorTask<Void>("Migrating SQL History", true, IRaptorTaskRunMode.MODAL_OPTIONAL){

                protected Void doWork() throws TaskException {
                    HistoryDB.migrateOldHistory(this);
                    return null;
                }
            };
            raptorTask.setCancellable(false);
            raptorTask.setPausable(false);
            RaptorTaskAdapter raptorTaskAdapter = new RaptorTaskAdapter(){

                public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            HistoryDBTableModel.getInstance().fireTableDataChanged();
                        }
                    });
                }
            };
            raptorTask.getDescriptor().addListener((IRaptorTaskListener)raptorTaskAdapter);
            RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
        }
    }

    static AbstractTableModel getHistoryModel() {
        return HistoryDBTableModel.getInstance();
    }

    public static int getHistorySize() {
        return HistoryDBTableModel.getInstance().getRowCount();
    }

    public static synchronized void saveSql(String string, String string2, String string3, float f) {
        if (string != null) {
            SqlHistoryTask sqlHistoryTask = new SqlHistoryTask(string, string2, string3, f);
            RaptorTaskManager.getInstance().addTask((RaptorTask)sqlHistoryTask);
        }
    }

    SqlHistoryPanel getHistoryPanel() {
        return SqlHistoryPanel.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSqlAt(int n) {
        String string = null;
        String string2 = null;
        this.currentSelectedRow = n;
        try {
            if (SqlHistoryPanel.getInstance(false) != null) {
                string = SqlHistoryPanel.getInstance().getSQLAt(n);
                string2 = SqlHistoryPanel.getInstance().getSQLTypeAt(n);
            } else {
                string = (String)HistoryDBTableModel.getInstance().getValueAt(n, 0);
                string2 = (String)HistoryDBTableModel.getInstance().getValueAt(n, 3);
            }
            URL uRL = null;
            WaitCursor waitCursor = null;
            try {
                uRL = new URL(string);
                if (URLFileSystem.canRead((URL)uRL)) {
                    waitCursor = Ide.getWaitCursor();
                    waitCursor.show();
                    string = Service.readFile((InputStream)URLFileSystem.openInputStream((URL)uRL));
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (waitCursor != null) {
                    waitCursor.hide();
                }
            }
            string = string + Util.getIdeNewLineChar();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public void setSelectedRow(int n) {
        this.currentSelectedRow = n;
    }

    public int getSelectedRow() {
        return this.currentSelectedRow;
    }
}

