/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.sqlhistory;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.JTable;
import oracle.dbtools.raptor.editors.DbEditor;
import oracle.dbtools.raptor.utils.TableSorter;
import oracle.dbtools.util.Resource;
import oracle.dbtools.util.Util;
import oracle.dbtools.worksheet.Messages;
import oracle.dbtools.worksheet.editor.Worksheet;
import oracle.dbtools.worksheet.sqlhistory.SqlEditorHistory;
import oracle.dbtools.worksheet.sqlhistory.SqlHistoryDockable;
import oracle.dbtools.worksheet.sqlhistory.SqlHistoryFilterModel;
import oracle.dbtools.worksheet.sqlhistory.SqlHistoryPanel;
import oracle.dbtools.worksheet.sqlhistory.db.HistoryDB;
import oracle.dbtools.worksheet.sqlhistory.db.HistoryDBTableModel;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.view.View;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.icons.OracleIcons;

public class SQLHistoryController
implements Controller {
    public static int APPEND_SQL_FROM_HISTORY_CMD = Ide.findOrCreateCmdID((String)"worksheet.append_sql_from_history");
    public static int REPLACE_SQL_FROM_HISTORY_CMD = Ide.findOrCreateCmdID((String)"worksheet.replace_sql_from_history");
    public static int CLEAR_SQL_FROM_HISTORY_CMD = Ide.findOrCreateCmdID((String)"Worksheet.History.Clear");
    private static IdeAction s_appendAction;
    private static IdeAction s_replaceAction;
    private static IdeAction s_clearAction;
    private static Worksheet s_editor;
    private static HistoryMouseListener _mouseListener;
    public static final int APPEND_PREVIOUS_FROM_HISTORY_ACTION_CMD_ID;
    public static final int APPEND_NEXT_FROM_HISTORY_ACTION_CMD_ID;
    public static final int REPLACE_PREVIOUS_FROM_HISTORY_ACTION_CMD_ID;
    public static final int REPLACE_NEXT_FROM_HISTORY_ACTION_CMD_ID;
    private static Object LOCK;
    private static SQLHistoryController INSTANCE;
    private static int LAST_USED_ROW;

    private SQLHistoryController() {
        if (s_appendAction == null) {
            s_appendAction = IdeAction.get((int)APPEND_SQL_FROM_HISTORY_CMD, null, (String)Messages.getString("SqlHistoryPanel.3"), null, null, null, null, (boolean)true);
            s_appendAction.putValue("SmallIcon", (Object)OracleIcons.getIcon((String)"update2.png"));
            s_appendAction.addController((Controller)this);
        }
        if (s_replaceAction == null) {
            s_replaceAction = IdeAction.get((int)REPLACE_SQL_FROM_HISTORY_CMD, null, (String)Messages.getString("SqlHistoryPanel.4"), null, null, null, null, (boolean)true);
            s_replaceAction.putValue("SmallIcon", (Object)OracleIcons.getIcon((String)"update.png"));
            s_replaceAction.addController((Controller)this);
        }
        if (s_clearAction == null) {
            s_clearAction = IdeAction.get((int)CLEAR_SQL_FROM_HISTORY_CMD, null, (String)Messages.getString("SqlHistoryPanel.5"), null, null, null, null, (boolean)true);
            s_clearAction.putValue("SmallIcon", (Object)OracleIcons.getIcon((String)"clear.png"));
            s_clearAction.addController((Controller)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SQLHistoryController getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (INSTANCE == null) {
                INSTANCE = new SQLHistoryController();
            }
        }
        return INSTANCE;
    }

    public static IdeAction getAppendAction() {
        return s_appendAction;
    }

    public static IdeAction getReplaceAction() {
        return s_replaceAction;
    }

    public static IdeAction getClearAction() {
        return s_clearAction;
    }

    protected static void setCurrentEditor() {
        Editor editor = EditorManager.getEditorManager().getCurrentEditor();
        if (editor != null && editor instanceof DbEditor) {
            if (editor instanceof Worksheet) {
                s_editor = (Worksheet)editor;
            }
        } else {
            s_editor = null;
        }
    }

    public boolean handleEvent(IdeAction ideAction, Context context) {
        JTable jTable;
        SQLHistoryController.setCurrentEditor();
        int n = ideAction.getCommandId();
        HistoryDBTableModel historyDBTableModel = HistoryDBTableModel.getInstance();
        SqlHistoryPanel sqlHistoryPanel = SqlHistoryPanel.getInstance(false) != null ? SqlHistoryPanel.getInstance(false) : null;
        int n2 = SqlEditorHistory.getInstance().getSelectedRow();
        int[] nArray = null;
        JTable jTable2 = jTable = sqlHistoryPanel != null ? sqlHistoryPanel.getTable() : null;
        n2 = jTable != null ? ((nArray = jTable.getSelectedRows()) != null && nArray.length != 0 ? nArray[nArray.length - 1] : jTable.getSelectedRow()) : LAST_USED_ROW;
        if (n == APPEND_SQL_FROM_HISTORY_CMD) {
            if (s_editor != null && nArray != null) {
                for (int n3 : nArray) {
                    s_editor.appendText(SqlEditorHistory.getInstance().getSqlAt(n3));
                }
                s_editor.getDefaultFocusComponent().requestFocusInWindow();
                historyDBTableModel.setFilter("");
            }
            return true;
        }
        if (n == REPLACE_SQL_FROM_HISTORY_CMD) {
            if (s_editor != null && nArray != null) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int n4 : nArray) {
                    stringBuffer.append(SqlEditorHistory.getInstance().getSqlAt(n4) + Util.getIdeNewLineChar());
                }
                s_editor.replaceText(stringBuffer.toString());
                s_editor.getDefaultFocusComponent().requestFocusInWindow();
                historyDBTableModel.setFilter("");
            }
            return true;
        }
        if (n == APPEND_PREVIOUS_FROM_HISTORY_ACTION_CMD_ID) {
            if (s_editor != null) {
                if (n2 - 1 >= 0) {
                    if (jTable != null) {
                        jTable.changeSelection(n2 - 1, n2 - 1, false, false);
                    }
                    String string = SqlEditorHistory.getInstance().getSqlAt(n2 - 1);
                    LAST_USED_ROW = n2 - 1;
                    s_editor.appendText(string);
                } else if (SqlEditorHistory.getHistorySize() == 1) {
                    String string = SqlEditorHistory.getInstance().getSqlAt(n2);
                    s_editor.appendText(string);
                }
            }
            return true;
        }
        if (n == APPEND_NEXT_FROM_HISTORY_ACTION_CMD_ID) {
            if (s_editor != null) {
                if (n2 + 1 < SqlEditorHistory.getHistorySize()) {
                    if (jTable != null) {
                        jTable.changeSelection(n2 + 1, 0, false, false);
                    }
                    String string = SqlEditorHistory.getInstance().getSqlAt(n2 + 1);
                    LAST_USED_ROW = n2 + 1;
                    s_editor.appendText(string);
                } else if (SqlEditorHistory.getHistorySize() == 1) {
                    String string = SqlEditorHistory.getInstance().getSqlAt(n2);
                    s_editor.appendText(string);
                }
            }
            return true;
        }
        if (n == REPLACE_PREVIOUS_FROM_HISTORY_ACTION_CMD_ID) {
            if (s_editor != null) {
                if (n2 - 1 >= 0) {
                    if (jTable != null) {
                        jTable.changeSelection(n2 - 1, 0, false, false);
                    }
                    String string = SqlEditorHistory.getInstance().getSqlAt(n2 - 1);
                    LAST_USED_ROW = n2 - 1;
                    s_editor.replaceText(string);
                } else if (SqlEditorHistory.getHistorySize() == 1) {
                    String string = SqlEditorHistory.getInstance().getSqlAt(n2);
                    s_editor.replaceText(string);
                }
            }
            return true;
        }
        if (n == REPLACE_NEXT_FROM_HISTORY_ACTION_CMD_ID) {
            if (s_editor != null) {
                if (n2 + 1 < SqlEditorHistory.getHistorySize()) {
                    if (jTable != null) {
                        jTable.changeSelection(n2 + 1, 0, false, false);
                    }
                    String string = SqlEditorHistory.getInstance().getSqlAt(n2 + 1);
                    LAST_USED_ROW = n2 + 1;
                    s_editor.replaceText(string);
                } else if (SqlEditorHistory.getHistorySize() == 1) {
                    String string = SqlEditorHistory.getInstance().getSqlAt(n2);
                    s_editor.replaceText(string);
                }
            }
            return true;
        }
        if (n == CLEAR_SQL_FROM_HISTORY_CMD) {
            int n5;
            if (!this.isHistoryInFocus(context)) {
                return false;
            }
            boolean bl = false;
            if (jTable.getSelectedRows().length == jTable.getRowCount()) {
                bl = true;
            }
            int n6 = n5 = bl ? MessageDialog.confirmOrCancel((Component)Ide.getMainWindow(), (Object)Messages.getString("SqlHistoryPanel.41"), (String)Messages.getString("SqlHistoryPanel.42")) : MessageDialog.confirmOrCancel((Component)Ide.getMainWindow(), (Object)Messages.getString("SqlHistoryPanel.43"), (String)Messages.getString("SqlHistoryPanel.44"));
            if (n5 == 1) {
                Object object;
                if (bl) {
                    jTable.selectAll();
                    nArray = jTable.getSelectedRows();
                    object = new File(Resource.RAPTOR_USER.getAbsolutePath() + File.separator + "SqlHistory.xml");
                    if (((File)object).exists()) {
                        ((File)object).delete();
                    }
                }
                object = nArray;
                TableSorter tableSorter = (TableSorter)jTable.getModel();
                SqlHistoryFilterModel sqlHistoryFilterModel = (SqlHistoryFilterModel)tableSorter.getTableModel();
                int[] nArray2 = new int[((int[])object).length];
                for (int i = 0; i < ((int[])object).length; ++i) {
                    nArray2[i] = sqlHistoryFilterModel.getRealRowIndex(jTable.convertRowIndexToModel(tableSorter.modelIndex((int)object[i])));
                }
                HistoryDB.getInstance().deleteItems(nArray2);
            }
            historyDBTableModel.fireTableDataChanged();
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        JTable jTable;
        SqlHistoryPanel sqlHistoryPanel;
        int n = ideAction.getCommandId();
        HistoryDBTableModel historyDBTableModel = HistoryDBTableModel.getInstance();
        SqlHistoryPanel sqlHistoryPanel2 = sqlHistoryPanel = SqlHistoryPanel.getInstance(false) != null ? SqlHistoryPanel.getInstance(false) : null;
        if (sqlHistoryPanel == null && historyDBTableModel.getRowCount() == 0) {
            ideAction.setEnabled(false);
            return true;
        }
        JTable jTable2 = jTable = sqlHistoryPanel != null ? sqlHistoryPanel.getTable() : null;
        int n2 = jTable != null && jTable.getSelectedRowCount() > 1 ? jTable.getSelectedRows()[0] : (jTable != null && jTable.getSelectedRowCount() == 1 ? jTable.getSelectedRow() : (LAST_USED_ROW > -1 ? LAST_USED_ROW : 0));
        if (n == APPEND_SQL_FROM_HISTORY_CMD || n == REPLACE_SQL_FROM_HISTORY_CMD) {
            ideAction.setEnabled(true);
        } else if (n == CLEAR_SQL_FROM_HISTORY_CMD) {
            if (!this.isHistoryInFocus(context)) {
                return false;
            }
            int[] nArray = jTable.getSelectedRows();
            ideAction.setEnabled(nArray.length > 0);
        } else if (n == APPEND_NEXT_FROM_HISTORY_ACTION_CMD_ID || n == REPLACE_NEXT_FROM_HISTORY_ACTION_CMD_ID) {
            boolean bl = false;
            bl = n2 < historyDBTableModel.getRowCount() - 1;
            ideAction.setEnabled(bl);
        } else if (n == APPEND_PREVIOUS_FROM_HISTORY_ACTION_CMD_ID || n == REPLACE_PREVIOUS_FROM_HISTORY_ACTION_CMD_ID) {
            boolean bl = false;
            bl = n2 > 0;
            ideAction.setEnabled(bl);
        } else {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MouseListener getMouseListener() {
        Object object = LOCK;
        synchronized (object) {
            if (_mouseListener == null) {
                _mouseListener = new HistoryMouseListener();
            }
        }
        return _mouseListener;
    }

    private boolean isHistoryInFocus(Context context) {
        View view = context.getView();
        return view != null && SqlHistoryDockable.getViewId().equals(view.toString());
    }

    static {
        APPEND_PREVIOUS_FROM_HISTORY_ACTION_CMD_ID = Ide.findOrCreateCmdID((String)"worksheet.append_previous_from_history");
        APPEND_NEXT_FROM_HISTORY_ACTION_CMD_ID = Ide.findOrCreateCmdID((String)"worksheet.append_next_from_history");
        REPLACE_PREVIOUS_FROM_HISTORY_ACTION_CMD_ID = Ide.findOrCreateCmdID((String)"worksheet.replace_previous_from_history");
        REPLACE_NEXT_FROM_HISTORY_ACTION_CMD_ID = Ide.findOrCreateCmdID((String)"worksheet.replace_next_from_history");
        LOCK = new Object();
        LAST_USED_ROW = -1;
    }

    static class HistoryMouseListener
    extends MouseAdapter {
        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            JTable jTable = (JTable)mouseEvent.getSource();
            if (jTable != null && mouseEvent.getClickCount() == 2) {
                SQLHistoryController.setCurrentEditor();
                int n = jTable.getSelectedRow();
                if (n > -1 && s_editor != null) {
                    s_editor.replaceText(SqlEditorHistory.getInstance().getSqlAt(n));
                    s_editor.getDefaultFocusComponent().requestFocusInWindow();
                }
            }
        }

        HistoryMouseListener() {
        }
    }
}

