/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.editor;

import java.awt.Color;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.connections.ConnectionListener;
import oracle.dbtools.raptor.controls.ConnectionSelectorUI;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.worksheet.editor.OpenWorksheetWizard;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.wizard.Invokable;
import oracle.ide.wizard.WizardManager;

public class WorksheetOpenController
implements Controller {
    private static WorksheetOpenController m_controller = null;
    public static final String NEW_WORKSHEET_CMD = "Worksheet.New";
    public static final String NEW_WORKSHEET_CONN_NAME = "Worksheet.New.ChoosenConnection";
    public static final int NEW_WORKSHEET_CMD_ID = Ide.findOrCreateCmdID((String)"Worksheet.New");
    private static Connections m_conns = Connections.getInstance();
    private static Runnable sUpdater;

    public boolean handleEvent(IdeAction ideAction, Context context) {
        int n = ideAction.getCommandId();
        if (n == NEW_WORKSHEET_CMD_ID) {
            WorksheetOpenController.openWorksheetWizard(null);
            return true;
        }
        if (ideAction.getValue(NEW_WORKSHEET_CONN_NAME) != null) {
            WorksheetOpenController.openWorksheetWizard((String)ideAction.getValue(NEW_WORKSHEET_CONN_NAME));
            return true;
        }
        return false;
    }

    public boolean update(IdeAction ideAction, Context context) {
        return ideAction.getCommandId() == NEW_WORKSHEET_CMD_ID;
    }

    private static Controller getInstance() {
        if (m_controller == null) {
            m_controller = new WorksheetOpenController();
        }
        return m_controller;
    }

    public static void openWorksheetWizard(final String string) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                Context context = Context.newIdeContext();
                ConnectionSelectorUI.SELECTOR_ACTIVE = true;
                if (string != null) {
                    context.setProperty("Connections.db_name", (Object)string);
                }
                WizardManager.getInstance().invokeWizard((Invokable)new OpenWorksheetWizard(), context, null, null);
                ConnectionSelectorUI.SELECTOR_ACTIVE = false;
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    public static void init() {
        IdeAction ideAction = IdeAction.get((int)NEW_WORKSHEET_CMD_ID);
        if (ideAction != null) {
            ideAction.putValue("ActionMenuActions", (Object)new IdeAction[0]);
        }
        m_conns.addConnectionListener(new ConnectionListener(){

            public void connectionAdded(ConnectionEvent connectionEvent) {
                WorksheetOpenController.updateOpenToolbarAction();
            }

            public void connectionRemoved(ConnectionEvent connectionEvent) {
                WorksheetOpenController.updateOpenToolbarAction();
            }

            public void connectionRenamed(ConnectionEvent connectionEvent) {
                WorksheetOpenController.updateOpenToolbarAction();
            }

            public void connectionModified(ConnectionEvent connectionEvent) {
                WorksheetOpenController.updateOpenToolbarAction();
            }

            public void connectionOpened(ConnectionEvent connectionEvent) {
                WorksheetOpenController.updateOpenToolbarAction();
            }

            public void connectionClosed(ConnectionEvent connectionEvent) {
                WorksheetOpenController.updateOpenToolbarAction();
            }
        });
    }

    private static synchronized void updateOpenToolbarAction() {
        if (sUpdater == null) {
            sUpdater = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    IdeAction ideAction = WorksheetOpenController.class;
                    synchronized (WorksheetOpenController.class) {
                        sUpdater = null;
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        ideAction = IdeAction.get((int)NEW_WORKSHEET_CMD_ID);
                        if (ideAction != null) {
                            ideAction.putValue("ActionMenuActions", (Object)WorksheetOpenController.getConnectionActions());
                            ideAction.setEnabled(true);
                        }
                        return;
                    }
                }
            };
            SwingUtilities.invokeLater(sUpdater);
        }
    }

    private static IdeAction[] getConnectionActions() {
        String[] stringArray = m_conns.getConnNames();
        IdeAction[] ideActionArray = new IdeAction[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            ideActionArray[i] = WorksheetOpenController.createToolbarAction(stringArray[i]);
        }
        return ideActionArray;
    }

    private static IdeAction createToolbarAction(String string) {
        String string2 = "9/" + string;
        IdeAction ideAction = IdeAction.findOrCreate((int)Ide.findOrCreateCmdID((String)string2), null, (String)string);
        ideAction.setEnabled(true);
        ideAction.addController(WorksheetOpenController.getInstance());
        Color color = Connections.getInstance().getConnectionColor(string);
        if (color != null) {
            String string3 = String.format("#%02x%02x%02x", color.getRed(), color.getGreen(), color.getBlue());
            ideAction.putValue("Name", (Object)("<html><font color=\"" + string3 + "\">" + Connections.getDisplayName((String)string)));
        } else {
            ideAction.putValue("Name", (Object)Connections.getDisplayName((String)string));
        }
        ideAction.putValue(NEW_WORKSHEET_CONN_NAME, (Object)string);
        return ideAction;
    }
}

