/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.UndoableEdit;
import oracle.dbtools.raptor.RaptorExtensionConstants;
import oracle.dbtools.raptor.controls.CustomTabbedPane;
import oracle.dbtools.raptor.controls.ITabCloseListner;
import oracle.dbtools.raptor.controls.RaptorDnDPlugin;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.controls.grid.ResultSetTable;
import oracle.dbtools.raptor.controls.query.QueryBuilderEditPanel;
import oracle.dbtools.raptor.editors.RaptorEditorPlugin;
import oracle.dbtools.raptor.editors.WorksheetEditorPluginRegistry;
import oracle.dbtools.raptor.insight.CompletionInsight;
import oracle.dbtools.raptor.phighlight.HighlightEditorPlugin;
import oracle.dbtools.raptor.phighlight.TooltipMessage;
import oracle.dbtools.raptor.phighlight.TooltipPlugin;
import oracle.dbtools.raptor.plsql.ParserEventListener;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.worksheet.StatementRunnerResultsPanel;
import oracle.dbtools.worksheet.WorksheetCallback;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.WorksheetResources;
import oracle.dbtools.worksheet.WorksheetResultPanel;
import oracle.dbtools.worksheet.commands.scriptrunner.task.RunScriptPanel;
import oracle.dbtools.worksheet.editor.ClickableScriptErrorPlugin;
import oracle.dbtools.worksheet.editor.UndoCommandWrapper;
import oracle.dbtools.worksheet.editor.Worksheet;
import oracle.dbtools.worksheet.editor.WorksheetTabbedPane;
import oracle.dbtools.worksheet.folding.WorksheetFoldingPlugin;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.EditorStatusBar;
import oracle.ide.ceditor.keymap.EditorFactory;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.ide.controls.WaitCursor;
import oracle.ide.controls.customtab.DefaultCustomTabPage;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.log.AbstractLogPage;
import oracle.ide.model.Node;
import oracle.ide.model.TextNode;
import oracle.ide.view.View;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.editor.BasicCaret;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.editor.EditorSelection;
import oracle.javatools.editor.EditorSelectionColumns;
import oracle.javatools.editor.EditorSelectionWrap;
import oracle.javatools.editor.FileOverviewMargin;
import oracle.javatools.editor.FileOverviewMark;
import oracle.javatools.editor.PopupManager;
import oracle.javatools.editor.gutter.Gutter;
import oracle.javatools.editor.gutter.GutterClickListener;
import oracle.javatools.editor.gutter.GutterColumn;
import oracle.javatools.editor.gutter.GutterColumnListener;
import oracle.javatools.editor.gutter.GutterMark;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.highlight.HighlightRegistry;
import oracle.javatools.editor.highlight.HighlightStyle;
import oracle.javatools.editor.plugins.BraceMatchingPlugin;
import oracle.javatools.editor.plugins.EditorPlugin;
import oracle.javatools.editor.plugins.LineHighlightPlugin;

public class WorksheetGUI
extends JPanel
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    protected static final Logger LOGGER = Logger.getLogger(WorksheetGUI.class.getName());
    private static final String MARK_CATEGORY = "sqlbookmark";
    private Worksheet m_worksheet;
    private Toolbar m_toolbar = new Toolbar();
    private KeyStrokeContext[] localContexts = new KeyStrokeContext[]{Ide.getKeyStrokeContextRegistry().getContext("oracle/dbtools/worksheet/editor/accelerators.xml")};
    private BasicEditorPane m_editor = EditorFactory.createIdeEditorPane((KeyStrokeContext[])this.localContexts);
    private EditorStatusBar m_statusBar = new EditorStatusBar();
    private LineGutterPlugin m_sqlGutter = new LineGutterPlugin();
    private ClickableScriptErrorPlugin m_clickableErrorPlugin;
    private FileOverviewMargin m_fileOverviewMargin = new FileOverviewMargin();
    private JSplitPane splitter = null;
    int dividerLocation = 0;
    private WorksheetTabbedPane m_tabs = new WorksheetTabbedPane();
    private JPopupMenu m_gutterCtxMenu;
    private GutterListener m_gutterListener = new GutterListener();
    final DocumentListener m_documentListener = new DocumentListener(){

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            View.updateToolbarActions((Toolbar)WorksheetGUI.this.m_toolbar);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
        }
    };
    private final PrevNextEditorController m_prevNextEditorController = new PrevNextEditorController();
    private final Controller m_prevNextTabController = new Controller(){

        public boolean handleEvent(IdeAction ideAction, Context context) {
            if (!this.isRightContext()) {
                return false;
            }
            int n = ideAction.getCommandId();
            if (70 == n) {
                if (WorksheetGUI.this.m_tabs.getSelectedIndex() > 0) {
                    WorksheetGUI.this.m_tabs.navigateBack();
                    return true;
                }
            } else if (71 == n && WorksheetGUI.this.m_tabs.getSelectedIndex() < WorksheetGUI.this.m_tabs.getNumberOfTabs() - 1) {
                WorksheetGUI.this.m_tabs.navigateForward();
                return true;
            }
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            if (!this.isRightContext()) {
                return false;
            }
            int n = ideAction.getCommandId();
            if (70 == n) {
                ideAction.setEnabled(WorksheetGUI.this.m_tabs.getSelectedIndex() > 0);
                return true;
            }
            if (71 == n) {
                ideAction.setEnabled(WorksheetGUI.this.m_tabs.getSelectedIndex() < WorksheetGUI.this.m_tabs.getNumberOfTabs() - 1);
                return true;
            }
            return false;
        }

        private boolean isRightContext() {
            boolean bl = UIUtils.containsPermanentFocusOwner((Component)((Object)WorksheetGUI.this.m_tabs));
            return bl;
        }
    };
    private final List<String> m_editSourceCommands = new ArrayList<String>(Arrays.asList("block-indent", "block-outdent", "completion-insight", "toggle-java-comments"));
    private final Controller m_editSourceController = new Controller(){

        public boolean handleEvent(IdeAction ideAction, Context context) {
            if (context.getView() == WorksheetGUI.this.m_worksheet) {
                String string = ideAction.getCommand();
                if (WorksheetGUI.this.m_editSourceCommands.contains(string)) {
                    WorksheetGUI.this.m_editor.invokeAction(string);
                    return true;
                }
                if (ideAction.toString().contains("Completion Insight")) {
                    WorksheetGUI.this.m_editor.invokeAction("completion-insight");
                    return true;
                }
            }
            return false;
        }

        public boolean update(IdeAction ideAction, Context context) {
            if (context.getView() == WorksheetGUI.this.m_worksheet) {
                String string = ideAction.getCommand();
                if (WorksheetGUI.this.m_editSourceCommands.contains(string)) {
                    ideAction.setEnabled(true);
                    return true;
                }
            }
            return false;
        }
    };
    private Component m_focusComponent;
    private Component m_helpFocusComponent;
    private TextNode m_node;
    private Handler m_handler;
    private FocusHelper m_focusHelper;
    private FocusHelper m_helpFocusHelper;
    private RaptorDnDPlugin m_dnd;
    WorksheetFoldingPlugin m_foldingPlugin;
    List<RaptorEditorPlugin> m_installedPlugins = new ArrayList<RaptorEditorPlugin>();
    private QueryBuilderEditPanel m_queryBuilderPanel;
    private CustomTabbedPane m_topPane;
    private CompletionInsight m_insight = null;
    private List<String> bindVars = new LinkedList<String>();
    private String _lastConnName;

    protected static void log(Throwable throwable) {
        String string = throwable.getMessage() + " - " + throwable.getStackTrace()[0].toString();
        LOGGER.log(Level.WARNING, string, throwable);
    }

    public WorksheetGUI(Worksheet worksheet) {
        Object object;
        RaptorEditorPlugin raptorEditorPlugin;
        EditorPlugin editorPlugin2;
        Object object2;
        Node node;
        this.m_worksheet = worksheet;
        TextBuffer textBuffer = null;
        URL uRL = null;
        Context context = worksheet.getContext();
        if (context != null) {
            node = context.getNode();
            if (node instanceof TextNode) {
                object2 = (TextNode)node;
                textBuffer = object2.acquireTextBuffer();
            }
            uRL = node.getURL();
        }
        node = textBuffer != null ? new BasicDocument("foo.plsql", textBuffer) : new BasicDocument("foo.plsql");
        this.setLayout(new BorderLayout());
        this.m_editor.setText("");
        this.m_editor.setDocument((Document)node);
        this.m_editor.putClientProperty((Object)"nb.ctrltab.popupswitcher.disable", (Object)Boolean.TRUE);
        this.m_editor.installPlugin((EditorPlugin)new LineHighlightPlugin());
        this.m_dnd = new RaptorDnDPlugin();
        this.m_dnd.setWorksheetConnection(this.m_worksheet.getConnectionName());
        this.m_editor.installPlugin((EditorPlugin)this.m_dnd);
        this.m_editor.installPlugin((EditorPlugin)this.m_statusBar);
        this.m_editor.installPlugin((EditorPlugin)this.m_sqlGutter);
        this.m_editor.installPlugin((EditorPlugin)new BraceMatchingPlugin());
        for (EditorPlugin editorPlugin2 : WorksheetEditorPluginRegistry.getPlugins((Context)context)) {
            this.m_editor.installPlugin(editorPlugin2);
            if (!(editorPlugin2 instanceof RaptorEditorPlugin)) continue;
            raptorEditorPlugin = (RaptorEditorPlugin)editorPlugin2;
            raptorEditorPlugin.setLineGutter(this.m_sqlGutter);
            raptorEditorPlugin.setNodeURL(uRL);
            this.m_installedPlugins.add(raptorEditorPlugin);
        }
        this.m_foldingPlugin = new WorksheetFoldingPlugin();
        this.m_editor.installPlugin((EditorPlugin)this.m_foldingPlugin);
        object2 = this.m_foldingPlugin.getCodeFoldingMargin();
        editorPlugin2 = new HighlightEditorPlugin(this.m_editor, this.m_worksheet.getConnectionName());
        this.m_foldingPlugin.parser.addParserEventListener((ParserEventListener)editorPlugin2);
        raptorEditorPlugin = new TooltipPlugin();
        this.m_editor.addToolTipProvider(raptorEditorPlugin.provider);
        this.m_editor.addPropertyChangeListener((PropertyChangeListener)raptorEditorPlugin);
        raptorEditorPlugin.addTooltip((TooltipMessage)editorPlugin2);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)object2, "East");
        jPanel.add((Component)this.m_sqlGutter, "Center");
        this.m_sqlGutter.addGutterClickListener((GutterClickListener)this.m_gutterListener);
        this.createContextMenu();
        this.m_editor.installPlugin((EditorPlugin)this.m_fileOverviewMargin);
        JScrollPane jScrollPane = new JScrollPane((Component)this.m_editor);
        jScrollPane.setRowHeaderView(jPanel);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel2.add((Component)this.m_fileOverviewMargin, "East");
        this.splitter = new JSplitPane(0);
        this.m_topPane = new CustomTabbedPane();
        this.m_topPane.addTab(null, WorksheetResources.getString("WORKSHEET_TAB_TITLE"), (Component)jPanel2);
        this.m_queryBuilderPanel = new QueryBuilderEditPanel((JTextComponent)this.m_editor);
        this.m_topPane.addTab(null, WorksheetResources.getString("QUERYBUILDER_TAB_TITLE"), (Component)this.m_queryBuilderPanel.getGUI());
        this.m_prevNextEditorController.init();
        this.addEditorControllers();
        this.splitter.setTopComponent((Component)this.m_topPane);
        this.splitter.setOneTouchExpandable(true);
        this.splitter.setResizeWeight(0.5);
        this.add((Component)this.splitter, "Center");
        this.m_tabs.setSplitter(this.splitter);
        this.m_editor.getDocument().addDocumentListener(this.m_documentListener);
        this.m_editor.addPropertyChangeListener("document", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                Document document;
                Document document2 = (Document)propertyChangeEvent.getOldValue();
                if (document2 != null) {
                    document2.removeDocumentListener(WorksheetGUI.this.m_documentListener);
                    if (WorksheetGUI.this.m_handler != null) {
                        document2.removeUndoableEditListener(WorksheetGUI.this.m_handler);
                    }
                }
                if ((document = (Document)propertyChangeEvent.getNewValue()) != null) {
                    document.addDocumentListener(WorksheetGUI.this.m_documentListener);
                    if (WorksheetGUI.this.m_handler != null) {
                        document.addUndoableEditListener(WorksheetGUI.this.m_handler);
                    }
                }
            }
        });
        if (this.m_editor.getCaret() instanceof BasicCaret) {
            EditorSelectionColumns editorSelectionColumns;
            object = IdeAction.get((int)81);
            boolean bl = object.getState();
            if (bl) {
                editorSelectionColumns = new EditorSelectionColumns();
                if (editorSelectionColumns.canSupportEditor(this.m_editor)) {
                    this.m_editor.putIntegerProperty("caret-editor-selection-type", 21);
                } else {
                    editorSelectionColumns = new EditorSelectionWrap();
                    this.m_editor.putIntegerProperty("caret-editor-selection-type", 20);
                    object.setState(true);
                }
            } else {
                editorSelectionColumns = new EditorSelectionWrap();
                this.m_editor.putIntegerProperty("caret-editor-selection-type", 20);
            }
            ((BasicCaret)this.m_editor.getCaret()).setEditorSelection((EditorSelection)editorSelectionColumns);
            editorSelectionColumns.install(this.m_editor);
        }
        this.m_editor.addPropertyChangeListener("editor-font", (PropertyChangeListener)this);
        object = KeyStroke.getKeyStroke("shift alt pressed F8");
        KeyStroke keyStroke = KeyStroke.getKeyStroke("shift meta pressed F8");
        this.splitter.getInputMap(1).put((KeyStroke)object, "startResize");
        this.splitter.getInputMap(1).put(keyStroke, "startResize");
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.m_handler == null) {
            this.m_handler = new Handler();
            this.m_editor.addPopupManager((PopupManager)this.m_handler);
            this.m_editor.addKeyListener((KeyListener)this.m_handler);
            Document document = this.m_editor.getDocument();
            document.addUndoableEditListener(this.m_handler);
            this.m_focusHelper = new FocusHelper();
            this.m_helpFocusHelper = new FocusHelper();
            this.m_helpFocusHelper.setIsForHelp();
        }
    }

    WorksheetTabbedPane getWorksheetTabbedPane() {
        return this.m_tabs;
    }

    private void createContextMenu() {
        if (this.m_gutterCtxMenu == null) {
            final JPopupMenu jPopupMenu = new JPopupMenu("Context Menu");
            JMenuItem jMenuItem = new JMenuItem(WorksheetResources.getString("WORKSHEET_MENU_BOOKMARKS"));
            JMenuItem jMenuItem2 = new JMenuItem(WorksheetResources.getString("WORKSHEET_MENU_LINE_NUMBERS"));
            JPopupMenu jPopupMenu2 = new JPopupMenu(WorksheetResources.getString("WORKSHEET_MENU_GUTTER"));
            jMenuItem.addActionListener(this.m_gutterListener);
            jMenuItem2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    EditorProperties editorProperties = EditorProperties.getProperties();
                    boolean bl = !editorProperties.getBooleanProperty("show-line-numbers");
                    editorProperties.putBooleanProperty("show-line-numbers", bl);
                }
            });
            jPopupMenu2.add(jMenuItem);
            jPopupMenu2.add(jMenuItem2);
            jPopupMenu.add(jPopupMenu2);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    int n = mouseEvent.getModifiers();
                    if ((n & 8) != 0 || (n & 4) != 0) {
                        jPopupMenu.show((Component)WorksheetGUI.this.m_sqlGutter, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            });
            this.m_gutterCtxMenu = jPopupMenu2;
        }
    }

    void dispose() {
        this.m_toolbar.dispose();
        this.m_toolbar.removeAll();
        if (this.m_node != null) {
            this.m_node.releaseTextBuffer();
        }
        this.m_queryBuilderPanel.dispose();
        DefaultListModel defaultListModel = this.m_topPane.getTabModel();
        while (!defaultListModel.isEmpty()) {
            this.m_topPane.removeTab((DefaultCustomTabPage)defaultListModel.getElementAt(0));
        }
        this.m_queryBuilderPanel = null;
        this.removeEditorControllers();
        this.m_worksheet = null;
        this.m_foldingPlugin.deinstall(this.m_editor);
        this.m_editor.getDocument().removeDocumentListener(this.m_documentListener);
        this.m_editor = null;
    }

    EditorStatusBar getEdtiorStatusBar() {
        return this.m_statusBar;
    }

    Component getFocusComponent() {
        return this.m_focusComponent;
    }

    Component getHelpFocusComponent() {
        return this.m_helpFocusComponent;
    }

    private Icon getIcon(String string) {
        URL uRL = this.getClass().getResource(string);
        return uRL != null ? new ImageIcon(uRL) : null;
    }

    Toolbar getToolbar() {
        return this.m_toolbar;
    }

    public void setToolbar(Toolbar toolbar) {
        this.m_toolbar = toolbar;
    }

    @Override
    public void removeNotify() {
        if (this.m_handler != null) {
            this.m_editor.removePopupManager((PopupManager)this.m_handler);
            this.m_editor.removeKeyListener((KeyListener)this.m_handler);
            this.m_editor.removeMouseListener((MouseListener)this.m_handler);
            Document document = this.m_editor.getDocument();
            document.removeUndoableEditListener(this.m_handler);
            this.m_helpFocusHelper.cleanup();
            this.m_helpFocusHelper = null;
            this.m_helpFocusComponent = null;
            this.m_focusHelper.cleanup();
            this.m_focusHelper = null;
            this.m_handler = null;
        }
        super.removeNotify();
    }

    private void tryContextMenu(MouseEvent mouseEvent) {
        Context context;
        Component component = mouseEvent.getComponent();
        component.requestFocusInWindow();
        if (mouseEvent.isPopupTrigger() && (context = this.m_worksheet.getContext(mouseEvent)) != null) {
            this.m_worksheet.getContextMenu().show(context);
        }
    }

    void updateContext(WorksheetContext worksheetContext) {
        worksheetContext.setEditor(this.m_editor);
        worksheetContext.setCallback(new Callback());
    }

    void addPanel(final WorksheetResultPanel worksheetResultPanel) {
        ITabCloseListner iTabCloseListner = new ITabCloseListner(){

            public void tabClosed() {
                if (WorksheetGUI.this.m_tabs != null && WorksheetGUI.this.m_tabs.getNumberOfTabs() <= 0) {
                    if (WorksheetGUI.this.splitter != null) {
                        WorksheetGUI.this.dividerLocation = WorksheetGUI.this.splitter.getDividerLocation();
                        WorksheetGUI.this.splitter.remove((Component)((Object)WorksheetGUI.this.m_tabs));
                    }
                    if (WorksheetGUI.this.m_helpFocusHelper != null) {
                        WorksheetGUI.this.m_helpFocusHelper.removeFocusListenerRecurse(worksheetResultPanel.getGUI());
                    }
                    if (worksheetResultPanel != null && worksheetResultPanel instanceof RunScriptPanel && WorksheetGUI.this.m_clickableErrorPlugin != null) {
                        WorksheetGUI.this.m_clickableErrorPlugin.deinstall(((RunScriptPanel)worksheetResultPanel).getTextPane());
                    }
                    WorksheetGUI.this.m_helpFocusComponent = null;
                }
            }
        };
        ArrayList<ITabCloseListner> arrayList = new ArrayList<ITabCloseListner>();
        arrayList.add(iTabCloseListner);
        if (worksheetResultPanel instanceof RunScriptPanel) {
            ((RunScriptPanel)worksheetResultPanel).getTextPane().putProperty("worksheet.topcomponent", (Object)this.m_editor);
            if (RaptorExtensionConstants.isStandAlone()) {
                this.m_clickableErrorPlugin = new ClickableScriptErrorPlugin();
                ((RunScriptPanel)worksheetResultPanel).getTextPane().installPlugin((EditorPlugin)this.m_clickableErrorPlugin);
            }
        }
        this.m_tabs.addTab(worksheetResultPanel, arrayList);
        if (this.splitter.getBottomComponent() == null) {
            this.splitter.setBottomComponent((Component)((Object)this.m_tabs));
        }
        if (this.dividerLocation != 0) {
            this.splitter.setDividerLocation(this.dividerLocation);
            this.dividerLocation = 0;
        }
        if (worksheetResultPanel != null) {
            if (worksheetResultPanel instanceof RunScriptPanel) {
                ((RunScriptPanel)worksheetResultPanel).getTextPane().addFocusListener((FocusListener)this.m_focusHelper);
            }
            if (this.m_helpFocusHelper != null) {
                this.m_helpFocusHelper.removeFocusListenerRecurse((Component)((Object)this.m_tabs));
                this.m_helpFocusHelper.addFocusListenerRecurse((Component)((Object)this.m_tabs));
            }
        }
    }

    WorksheetResultPanel getSelectedResultPanel() {
        return this.m_tabs.getSelectedResultPanel();
    }

    public void setBindVariables(List<String> list) {
        if (!this.bindVars.isEmpty()) {
            this.bindVars.clear();
        }
        this.bindVars.addAll(list);
    }

    public void invokeInsight(String string) {
        this.m_worksheet.getContext();
        if (Connections.getInstance().isOracle(string)) {
            if (this.m_insight != null) {
                this.m_editor.deinstallPlugin((EditorPlugin)this.m_insight);
            }
            this.m_insight = new CompletionInsight(string, this.m_worksheet.getParser(), this.bindVars);
            this.m_editor.installPlugin((EditorPlugin)this.m_insight);
        }
    }

    public BasicEditorPane getEditorPane() {
        return this.m_editor;
    }

    void updateWorksheetConnection(String string) {
        this.m_queryBuilderPanel.setConnection(string);
        if (string == null || !string.equals(this._lastConnName)) {
            this._lastConnName = string;
            this.m_dnd.setWorksheetConnection(string);
            for (RaptorEditorPlugin raptorEditorPlugin : this.m_installedPlugins) {
                raptorEditorPlugin.setConnection(string);
            }
        }
        for (PropertyChangeListener propertyChangeListener : this.m_editor.getPropertyChangeListeners()) {
            try {
                if (!(propertyChangeListener instanceof TooltipPlugin)) continue;
                TooltipPlugin tooltipPlugin = (TooltipPlugin)propertyChangeListener;
                this.m_editor.removePropertyChangeListener((PropertyChangeListener)tooltipPlugin);
                this.m_editor.removeToolTipProvider(tooltipPlugin.provider);
                HighlightEditorPlugin highlightEditorPlugin = new HighlightEditorPlugin(this.m_editor, this.m_worksheet.getConnectionName());
                this.m_foldingPlugin.parser.addParserEventListener((ParserEventListener)highlightEditorPlugin);
                tooltipPlugin = new TooltipPlugin();
                this.m_editor.addToolTipProvider(tooltipPlugin.provider);
                this.m_editor.addPropertyChangeListener((PropertyChangeListener)tooltipPlugin);
                tooltipPlugin.addTooltip((TooltipMessage)highlightEditorPlugin);
                highlightEditorPlugin.stateChanged(this.m_foldingPlugin.parser);
            }
            catch (Throwable throwable) {
                oracle.dbtools.util.Logger.warn(this.getClass(), (Throwable)throwable);
            }
        }
    }

    private void addEditorControllers() {
        for (String string : this.m_editSourceCommands) {
            IdeAction.find((String)string).addController(this.m_editSourceController);
        }
        IdeAction.addController((int)40, (Controller)this.m_prevNextEditorController);
        IdeAction.addController((int)41, (Controller)this.m_prevNextEditorController);
        IdeAction.addController((int)70, (Controller)this.m_prevNextTabController);
        IdeAction.addController((int)71, (Controller)this.m_prevNextTabController);
    }

    private void removeEditorControllers() {
        for (String string : this.m_editSourceCommands) {
            IdeAction.find((String)string).removeController(this.m_editSourceController);
        }
        IdeAction.removeController((int)40, (Controller)this.m_prevNextEditorController);
        IdeAction.removeController((int)41, (Controller)this.m_prevNextEditorController);
        IdeAction.removeController((int)70, (Controller)this.m_prevNextTabController);
        IdeAction.removeController((int)71, (Controller)this.m_prevNextTabController);
    }

    QueryBuilderEditPanel getQueryBuilderEditPanel() {
        return this.m_queryBuilderPanel;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        BasicCaret basicCaret;
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("editor-font") && this.m_editor.getCaret() instanceof BasicCaret && (basicCaret = (BasicCaret)this.m_editor.getCaret()).getEditorSelection() instanceof EditorSelectionColumns && !EditorSelectionColumns.isEditorFixedWidthFont((BasicEditorPane)this.m_editor)) {
            IdeAction ideAction = IdeAction.get((int)81);
            ideAction.setState(true);
        }
    }

    class PrevNextEditorController
    implements Controller {
        private List<Component> editorPaneList = new ArrayList<Component>();

        PrevNextEditorController() {
        }

        void init() {
            this.editorPaneList.add(0, (Component)WorksheetGUI.this.m_topPane);
            this.editorPaneList.add(1, (Component)((Object)WorksheetGUI.this.m_tabs));
        }

        int getCurrentIdx() {
            int n = this.getContainingEditorPaneIdx(WorksheetGUI.this.m_helpFocusComponent);
            if (n < 0) {
                n = this.getContainingEditorPaneIdx(WorksheetGUI.this.m_focusComponent);
            }
            if (n < 0) {
                n = this.getContainingEditorPaneIdx(KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner());
            }
            if (n < 1 && WorksheetGUI.this.m_topPane.getSelectedIndex() > 0) {
                n = 2;
            }
            return n;
        }

        private int getContainingEditorPaneIdx(Component component) {
            int n = -1;
            int n2 = this.editorPaneList.size();
            block0: for (int i = 0; i < n2; ++i) {
                Component component2 = this.editorPaneList.get(i);
                for (Component component3 = component; component3 != null && component3 != WorksheetGUI.this; component3 = component3.getParent()) {
                    if (component2 != component3) continue;
                    n = i;
                    break block0;
                }
            }
            return n;
        }

        public boolean handleEvent(IdeAction ideAction, Context context) {
            if (context.getView() == WorksheetGUI.this.m_worksheet) {
                int n = ideAction.getCommandId();
                if (40 == n) {
                    switch (this.getCurrentIdx()) {
                        case 0: {
                            if (this.focusOnResults()) break;
                        }
                        case 1: {
                            this.focusOnQueryBuilder();
                        }
                    }
                    return true;
                }
                if (41 == n) {
                    switch (this.getCurrentIdx()) {
                        case 2: {
                            if (this.focusOnResults()) break;
                        }
                        case 1: {
                            this.focusOnWorksheet();
                        }
                    }
                    return true;
                }
            }
            return false;
        }

        private boolean focusOnWorksheet() {
            WorksheetGUI.this.m_topPane.setSelectedIndex(0);
            WorksheetGUI.this.m_editor.requestFocusInWindow();
            return true;
        }

        private boolean focusOnResults() {
            if (WorksheetGUI.this.m_tabs.getNumberOfTabs() > 0 && WorksheetGUI.this.m_tabs.isVisible()) {
                JComponent jComponent = WorksheetGUI.this.m_tabs.getSelectedResultPanel().getGUI();
                if (jComponent instanceof RunScriptPanel) {
                    Caret caret;
                    BasicEditorPane basicEditorPane = ((RunScriptPanel)jComponent).getTextPane();
                    Caret caret2 = caret = basicEditorPane != null ? basicEditorPane.getCaret() : null;
                    if (caret != null) {
                        if (!caret.isVisible()) {
                            caret.setVisible(true);
                        }
                        basicEditorPane.ensureCaretVisible();
                    }
                    jComponent = basicEditorPane;
                } else if (jComponent instanceof StatementRunnerResultsPanel) {
                    ResultSetTable resultSetTable = ((StatementRunnerResultsPanel)jComponent).getResultSetTable();
                    if (resultSetTable != null && resultSetTable.getSelectedRow() < 0) {
                        resultSetTable.changeSelection(0, 0, false, false);
                    }
                    jComponent = resultSetTable;
                }
                ((Component)jComponent).requestFocusInWindow();
                return true;
            }
            return false;
        }

        private boolean focusOnQueryBuilder() {
            WorksheetGUI.this.m_topPane.setSelectedIndex(1);
            ((JComponent)WorksheetGUI.this.m_queryBuilderPanel.getGUI().getView()).requestFocusInWindow();
            return true;
        }

        public boolean update(IdeAction ideAction, Context context) {
            if (context.getView() == WorksheetGUI.this.m_worksheet) {
                int n = ideAction.getCommandId();
                int n2 = this.getCurrentIdx();
                if (40 == n) {
                    ideAction.setEnabled(n2 < 2);
                    return true;
                }
                if (41 == n) {
                    ideAction.setEnabled(n2 > 0);
                    return true;
                }
            }
            return false;
        }
    }

    static class MarginMark
    implements FileOverviewMark {
        private int m_from;
        private int m_to;
        private String m_tooltip;

        public MarginMark(int n, int n2, String string) {
            this.m_from = n;
            this.m_to = n2;
            this.m_tooltip = string;
        }

        public int getSelectionLength() {
            return this.m_to - this.m_from;
        }

        public int getSelectionStart() {
            return this.m_from;
        }

        public int getSeverity() {
            return 0;
        }

        public String getToolTipText(MouseEvent mouseEvent) {
            return this.m_tooltip;
        }
    }

    private class Handler
    implements PopupManager,
    KeyListener,
    MouseListener,
    UndoableEditListener {
        private Handler() {
        }

        public void hidePopup(BasicEditorPane basicEditorPane) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            View.updateToolbarActions((Toolbar)WorksheetGUI.this.m_toolbar);
            if (keyEvent.getKeyChar() == '\n' && keyEvent.isControlDown() || !keyEvent.isControlDown() || !keyEvent.isShiftDown() || Character.isDigit(keyEvent.getKeyChar())) {
                // empty if block
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Context context = WorksheetGUI.this.m_worksheet.getContext(mouseEvent);
            Object object = context.getEvent().getSource();
            if (!object.getClass().toString().equals("oracle.javatools.editor.gutter.LineGutterPlugin")) {
                WorksheetGUI.this.tryContextMenu(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            WorksheetGUI.this.tryContextMenu(mouseEvent);
        }

        public void showPopup(BasicEditorPane basicEditorPane, MouseEvent mouseEvent) {
            ContextMenu contextMenu = WorksheetGUI.this.m_worksheet.getContextMenu();
            if (contextMenu != null) {
                contextMenu.show(WorksheetGUI.this.m_worksheet.getContext(mouseEvent));
            }
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
            UndoableEdit undoableEdit = undoableEditEvent.getEdit();
            UndoCommandWrapper undoCommandWrapper = new UndoCommandWrapper(undoableEdit);
            CommandProcessor commandProcessor = CommandProcessor.getInstance();
            undoCommandWrapper.setContext(WorksheetGUI.this.m_worksheet.getContext());
            try {
                commandProcessor.invoke((Command)undoCommandWrapper);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private class GutterListener
    implements GutterClickListener,
    ActionListener,
    GutterColumnListener {
        private int m_lineNo;
        private List<GutterMark> m_marks;
        private Icon m_bkmkIcon;

        private GutterListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GutterMark gutterMark;
            String string = WorksheetResources.getString("WORKSHEET_BOOKMARKS_COLUMN");
            GutterColumn gutterColumn = WorksheetGUI.this.m_sqlGutter.lookupGutterColumn(string);
            if (gutterColumn == null) {
                gutterColumn = WorksheetGUI.this.m_sqlGutter.createGutterColumn(string, (GutterColumnListener)this);
            }
            if (this.m_marks == null) {
                this.m_marks = new ArrayList<GutterMark>();
                this.m_bkmkIcon = WorksheetGUI.this.getIcon("/oracle/dbtools/worksheet/images/bookmark.png");
            }
            boolean bl = false;
            Iterator<GutterMark> iterator = this.m_marks.iterator();
            int n = this.m_lineNo;
            while (iterator.hasNext()) {
                gutterMark = iterator.next();
                if (gutterMark.getLine() != n) continue;
                gutterMark.getGutterColumn().removeGutterMark(gutterMark);
                iterator.remove();
                bl = true;
                break;
            }
            if (!bl) {
                gutterMark = EditorProperties.getProperties();
                HighlightRegistry highlightRegistry = gutterMark.getHighlightRegistry();
                String string2 = WorksheetResources.getString("WORKSHEET_BOOKMARK_STYLE");
                HighlightStyle highlightStyle = highlightRegistry.createStyle(string2, string2, 20, Color.black, new Color(153, 255, 255));
                FileOverviewMargin.setMarkColor((String)WorksheetGUI.MARK_CATEGORY, (HighlightStyle)highlightStyle);
                this.m_marks.add(gutterColumn.addGutterMark(n, this.m_bkmkIcon, highlightStyle, 1, 1));
                MarginMark marginMark = new MarginMark(n, n, WorksheetResources.getString("WORKSHEET_BOOKMARK_MARK") + n);
                WorksheetGUI.this.m_fileOverviewMargin.addMark(WorksheetGUI.MARK_CATEGORY, n, (FileOverviewMark)marginMark);
            }
        }

        public String getMarkToolTip(GutterMark gutterMark, MouseEvent mouseEvent) {
            return null;
        }

        public void lineClicked(Gutter gutter, int n, MouseEvent mouseEvent) {
            this.m_lineNo = n;
            LineGutterPlugin lineGutterPlugin = (LineGutterPlugin)mouseEvent.getSource();
            int n2 = mouseEvent.getModifiers();
            if ((n2 & 8) != 0 || (n2 & 4) != 0) {
                WorksheetGUI.this.m_gutterCtxMenu.show((Component)lineGutterPlugin, mouseEvent.getX(), mouseEvent.getY());
            }
        }

        public void markClicked(GutterMark gutterMark, int n, MouseEvent mouseEvent) {
            gutterMark.getGutterColumn().removeGutterMark(gutterMark);
            this.m_marks.remove(gutterMark);
        }

        public void markMoved(GutterMark gutterMark, int n, int n2) {
        }

        public void markRemoved(GutterMark gutterMark, int n) {
            int n2 = this.m_marks.indexOf(gutterMark);
            if (n2 != -1) {
                this.m_marks.remove(n2);
            }
        }
    }

    private final class FocusHelper
    implements FocusListener {
        private boolean forHelp = false;

        private FocusHelper() {
            this.addFocusListenerRecurse(WorksheetGUI.this);
        }

        private void addFocusListenerRecurse(Component component) {
            if (component instanceof Container) {
                Component[] componentArray = ((Container)component).getComponents();
                for (int i = 0; i < componentArray.length; ++i) {
                    this.addFocusListenerRecurse(componentArray[i]);
                }
            }
            component.addFocusListener(this);
        }

        private void cleanup() {
            this.removeFocusListenerRecurse(WorksheetGUI.this);
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (this.forHelp) {
                WorksheetGUI.this.m_helpFocusComponent = (Component)focusEvent.getSource();
            } else {
                WorksheetGUI.this.m_focusComponent = (Component)focusEvent.getSource();
            }
        }

        private void registerFocusWithMainWindow(FocusEvent focusEvent) {
            if (WorksheetGUI.this.m_worksheet != null && WorksheetGUI.this.m_worksheet.hashCode() != Ide.getMainWindow().getLastActiveView().hashCode()) {
                Ide.getMainWindow().requestFocusInWindow();
            }
        }

        public void setIsForHelp() {
            this.forHelp = true;
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }

        private void removeFocusListenerRecurse(Component component) {
            if (component instanceof Container) {
                Component[] componentArray = ((Container)component).getComponents();
                for (int i = 0; i < componentArray.length; ++i) {
                    this.removeFocusListenerRecurse(componentArray[i]);
                }
            }
            component.removeFocusListener(this);
        }
    }

    private class Callback
    implements WorksheetCallback {
        private WaitCursor m_cursor;

        private Callback() {
        }

        @Override
        public void setEnabled(boolean bl) {
            if (bl && this.m_cursor != null) {
                this.m_cursor.hide();
                this.m_cursor = null;
            } else if (!bl && this.m_cursor == null) {
                this.m_cursor = new WaitCursor((Component)WorksheetGUI.this);
                this.m_cursor.show();
            }
        }

        @Override
        public void showResultPanel(final WorksheetResultPanel worksheetResultPanel) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    WorksheetGUI.this.addPanel(worksheetResultPanel);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }

        public void setStatusMessage(String string, Exception exception) {
            AbstractLogPage abstractLogPage = WorksheetGUI.this.m_worksheet.getLogPage();
            abstractLogPage.logQuietly((Object)(WorksheetGUI.this.m_worksheet.getTabLabel() + ": " + DateFormat.getDateTimeInstance().format(new Date(System.currentTimeMillis())) + ": " + string + System.getProperty("line.separator")));
            if (exception != null) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
                abstractLogPage.logQuietly((Object)(WorksheetGUI.this.m_worksheet.getTabLabel() + ": " + DateFormat.getDateTimeInstance().format(new Date(System.currentTimeMillis())) + ": " + exception.getMessage() + System.getProperty("line.separator")));
            }
        }

        @Override
        public void focusPanel(WorksheetResultPanel worksheetResultPanel) {
            final WorksheetTabbedPane worksheetTabbedPane = WorksheetGUI.this.getWorksheetTabbedPane();
            final int n = worksheetTabbedPane.getPanelIndex(worksheetResultPanel.getGUI());
            if (n != -1) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        worksheetTabbedPane.setSelectedIndex(n);
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                } else {
                    SwingUtilities.invokeLater(runnable);
                }
            }
        }
    }
}

