/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.owaoutput;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import oracle.dbtools.raptor.connections.ConnectionEvent;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.worksheet.Messages;
import oracle.dbtools.worksheet.commands.dbmsoutput.AbstractOutputPane;
import oracle.ide.Ide;
import oracle.ide.view.View;
import oracle.javatools.editor.BasicEditorPane;

public class OWAOutputPane
extends AbstractOutputPane {
    private static final long serialVersionUID = 1L;
    protected static final int TOGGLE_CMD_ID = Ide.createCmdID((String)"owaoutput.toggle");
    protected static final int POLL_CMD_ID = Ide.createCmdID((String)"owaoutput.poll");
    private Timer _timer = null;
    private static OWAOutputPane _owaPaneInstance = null;

    public OWAOutputPane(View view) {
        super(view);
    }

    public static AbstractOutputPane getInstance(View view) {
        if (_owaPaneInstance == null) {
            _owaPaneInstance = new OWAOutputPane(view);
        }
        return _owaPaneInstance;
    }

    public static OWAOutputPane getInstance() {
        return _owaPaneInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean enableOutput(Connection connection, boolean bl) {
        String string = "declare\n    nm  owa.vc_arr;\n    vl  owa.vc_arr;\nbegin\n    nm(1) := 'SERVER_PORT';\n    vl(1) := '80';\n    owa.init_cgi_env( 1, nm, vl );\nend;";
        Statement statement = null;
        try {
            if (connection == null) {
                this.launchConnectionChooseDialog();
                if (!this.isEnabled(connection)) {
                    boolean bl2 = false;
                    return bl2;
                }
            }
            if (connection.isClosed() && bl) {
                this.launchConnectionChooseDialog();
                if (!this.isEnabled(connection)) {
                    boolean bl3 = false;
                    return bl3;
                }
            }
            statement = connection.prepareCall(string);
            statement.execute();
        }
        catch (SQLException sQLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {}
        }
        this.start_poll(connLocal);
        this.revalidate();
        this.repaint();
        m_connEnableHash.put(this.ConnectionNameOrToString(connection), true);
        return (Boolean)m_connEnableHash.get(this.ConnectionNameOrToString(connection));
    }

    @Override
    public boolean disableOutput(Connection connection) {
        this.stop_poll(connection);
        return true;
    }

    private void stop_poll(Connection connection) {
        try {
            if (this._timer != null) {
                this._timer.cancel();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this._timer = null;
    }

    private void start_poll(Connection connection) {
        try {
            if (this._timer != null) {
                this._timer.cancel();
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this._timer = null;
        if (Connections.getInstance().isOracle(connection)) {
            this._timer = new Timer();
            this._timer.schedule((TimerTask)new Poller(connection, this.getTextPanelArea()), 0L, 3000L);
        }
    }

    @Override
    public void connectionClosed(ConnectionEvent connectionEvent) {
        this.m_tabPane.remove(connectionEvent);
        this.stop_poll(connLocal);
    }

    @Override
    public String getPaneName() {
        return Messages.getString("OWAOutputPane.35");
    }

    public static AbstractOutputPane getInstace(View view) {
        if (_owaPaneInstance == null) {
            _owaPaneInstance = new OWAOutputPane(view);
        }
        return _owaPaneInstance;
    }

    @Override
    public String getBufferSizeText() {
        return "";
    }

    @Override
    protected String getNewLabel() {
        return Messages.getString("OwaOutputPane.99");
    }

    private static class Poller
    extends TimerTask {
        private Connection localConn = null;
        private int gDB_State;
        static final int STATE_NONE = 0;
        static final int STATE_FETCHING = 1;
        static final int STATE_FINISHED = 2;
        static final int MAX_PL_LINES = 127;
        private BasicEditorPane textPanelArea;

        public Poller(Connection connection, BasicEditorPane basicEditorPane) {
            this.textPanelArea = basicEditorPane;
            this.localConn = connection;
        }

        @Override
        public void run() {
            try {
                if (this.localConn != null) {
                    this.getGeneratedStream();
                }
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            }
        }

        public void getGeneratedStream() throws SQLException {
            this.gDB_State = 0;
            while (this.gDB_State != 2) {
                try {
                    this.textPanelArea.getDocument().insertString(this.textPanelArea.getDocument().getLength(), this.getDataBlock(), null);
                }
                catch (BadLocationException badLocationException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, badLocationException.getStackTrace()[0].toString(), badLocationException);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getDataBlock() throws SQLException {
            String string;
            Statement statement = null;
            try {
                String string2 = "declare nlns number;\n buf_t varchar2(32767);\n lines htp.htbuf_arr;\nbegin\n  nlns := :1;\n  OWA.GET_PAGE(lines, nlns);\n  if (nlns < 1) then\n   buf_t := null;\n  else \n   for i in 1..nlns loop\n     buf_t:=buf_t||lines(i);\n   end loop;\n  end if;\n  :2 := buf_t; :3 := nlns;\nend;";
                int n = 127;
                statement = this.localConn.prepareCall(string2);
                statement.setInt(1, n);
                statement.registerOutParameter(2, 12);
                statement.registerOutParameter(3, -5);
                statement.execute();
                n = statement.getInt(3);
                this.gDB_State = 1;
                if (n < 127) {
                    this.gDB_State = 2;
                    if (n < 1) {
                        String string3 = "";
                        return string3;
                    }
                }
                string = statement.getString(2);
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {}
                }
            }
            return string;
        }
    }
}

