/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet.commands.autotrace;

import java.awt.Component;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.raptor.utils.NamedSwingWorker;
import oracle.dbtools.worksheet.Messages;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.dbtools.worksheet.commands.autotrace.AnalyzeAction;
import oracle.dbtools.worksheet.commands.autotrace.AutotracePanel;
import oracle.dbtools.worksheet.editor.Worksheet;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public class AutotraceAction
extends AnalyzeAction {
    private static final String UNSUFFICIENT_PRIVILEGES = Messages.getString("AutotraceAction.0");
    private Logger logger = Logger.getLogger(AutotracePanel.class.getName());
    private String GRANT_CATALOG_ROLE = null;
    private String mystat = null;
    private String sqlId = null;
    final Map<Integer, Long> snapshotBefore = new HashMap<Integer, Long>();
    Integer sid = null;
    private PreparedStatement mainStmt = null;
    private Connection auxConn = null;
    private String cursorSharing = null;
    private StatsThreadState quit = StatsThreadState.RUNNING;
    private static final Logger LOGGER = Logger.getLogger(AutotraceAction.class.getName());

    public AutotraceAction(String string, WorksheetContext worksheetContext) {
        super(Messages.getString("WorksheetTaskUI.8"), string, worksheetContext);
    }

    /*
     * Exception decompiling
     */
    protected Void doWork() throws TaskException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 74[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void myStatsInitialSnapshot() {
        try {
            PreparedStatement preparedStatement = this.conn.prepareStatement(this.mystat);
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                int n = resultSet.getInt("num") - 1;
                long l = resultSet.getLong("value");
                this.snapshotBefore.put(n, l);
                this.sid = resultSet.getInt("sid");
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            if (sQLException.getErrorCode() == 942) {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)this.GRANT_CATALOG_ROLE, (String)UNSUFFICIENT_PRIVILEGES, null);
            }
            this.logger.fine("sql=" + this.mystat);
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
            throw new RuntimeException(Messages.getString("AutotraceAction.25"));
        }
    }

    /*
     * Exception decompiling
     */
    private void gatherStatistics(Connection var1_1) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean cancel() {
        this.quit = StatsThreadState.FINISHING;
        return true;
    }

    private NamedSwingWorker runStatsThread() {
        try {
            NamedSwingWorker namedSwingWorker = new NamedSwingWorker("Background Autiotrace Statistics"){

                public Object construct() {
                    AutotraceAction.this.quit = StatsThreadState.RUNNING;
                    while (AutotraceAction.this.quit == StatsThreadState.RUNNING) {
                        try {
                            for (int i = 0; i < 600; ++i) {
                                Thread.sleep(100L);
                                if (AutotraceAction.this.quit == StatsThreadState.QUITTING) {
                                    AutotraceAction.this.auxConn = null;
                                    return null;
                                }
                                if (AutotraceAction.this.quit == StatsThreadState.FINISHING) break;
                            }
                            AutotraceAction.this.initAuxiliaryConnection();
                            if (AutotraceAction.this.quit == StatsThreadState.FINISHING) {
                                AutotraceAction.this.killAutotraceSession();
                            }
                            if (AutotraceAction.this.quit == StatsThreadState.QUITTING) continue;
                            AutotraceAction.this.gatherStatistics(AutotraceAction.this.auxConn);
                        }
                        catch (InterruptedException interruptedException) {
                            AutotraceAction.this.logger.log(Level.WARNING, "select hash_value from v$sql", interruptedException);
                        }
                        catch (SQLException sQLException) {
                            AutotraceAction.this.logger.log(Level.SEVERE, sQLException.getMessage());
                        }
                    }
                    AutotraceAction.this.auxConn = null;
                    return null;
                }
            };
            namedSwingWorker.start();
            return namedSwingWorker;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            return null;
        }
    }

    private synchronized void initAuxiliaryConnection() throws SQLException {
        if (this.auxConn != null) {
            return;
        }
        try {
            String string = Connections.getInstance().createPrivateConnection(this.ctx.getConnectionName());
            this.auxConn = Connections.getInstance().getConnection(string);
        }
        catch (Exception exception) {
            LOGGER.log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killAutotraceSession() throws SQLException, InterruptedException {
        if (this.auxConn == null) {
            return;
        }
        if (!Connections.getInstance().tryLock(this.auxConn, 500L)) {
            return;
        }
        try {
            PreparedStatement preparedStatement = this.auxConn.prepareStatement("select inst_id,sid,serial# from gv$session \n where sid = ? \n");
            preparedStatement.setInt(1, this.sid);
            ResultSet resultSet = preparedStatement.executeQuery();
            class Session {
                int instId;
                int sid;
                int serial;

                public Session(int n, int n2, int n3) {
                    this.instId = n;
                    this.sid = n2;
                    this.serial = n3;
                }
            }
            LinkedList<Session> linkedList = new LinkedList<Session>();
            while (resultSet.next()) {
                linkedList.add(new Session(resultSet.getInt("inst_id"), resultSet.getInt("sid"), resultSet.getInt("serial#")));
            }
            resultSet.close();
            preparedStatement.close();
            for (Session session : linkedList) {
                String string = "alter system kill session '" + session.sid + "," + session.serial + ",@" + session.instId + "'";
                System.out.println(string);
                DBUtil.getInstance((Connection)this.auxConn).execute(string);
            }
        }
        finally {
            Connections.getInstance().unlock(this.auxConn);
        }
    }

    protected boolean mayInterrupt() {
        return false;
    }

    public static void showAutotraceStats(String string, Worksheet worksheet) {
        WorksheetContext worksheetContext = worksheet.createWorksheetContext();
        AutotraceAction autotraceAction = new AutotraceAction(null, worksheetContext);
        autotraceAction.sqlId = string;
        AutotracePanel autotracePanel = new AutotracePanel(null, false, worksheetContext);
        autotraceAction.setAutoTracePanel(autotracePanel);
        autotraceAction.showResultPanel();
        try {
            autotraceAction.gatherStatistics(Connections.getInstance().getConnection(worksheetContext.getConnectionName()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static enum StatsThreadState {
        RUNNING,
        FINISHING,
        QUITTING;

    }
}

