/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.worksheet;

import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskDescriptor;
import oracle.dbtools.raptor.backgroundTask.internal.IRaptorTaskUIListener;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.worksheet.WorksheetContext;
import oracle.javatools.editor.BasicEditorPane;

public class WorksheetTaskUIListener
implements IRaptorTaskUIListener {
    private WorksheetContext m_ctx;
    private ISQLCommand m_cmd;

    WorksheetTaskUIListener(WorksheetContext worksheetContext, ISQLCommand iSQLCommand) {
        this.m_ctx = worksheetContext;
        this.m_cmd = iSQLCommand;
    }

    public void cancelClicked(RaptorTaskDescriptor raptorTaskDescriptor) {
    }

    public void pauseClicked(RaptorTaskDescriptor raptorTaskDescriptor) {
    }

    public void taskClicked(RaptorTaskDescriptor raptorTaskDescriptor) {
        BasicEditorPane basicEditorPane = this.m_ctx.getEditor();
        int n = basicEditorPane.getLineStartOffset(this.m_cmd.getStartLine());
        int n2 = basicEditorPane.getLineEndOffset(this.m_cmd.getEndLine());
        if (n == 0 && n2 == 0) {
            n2 = this.m_cmd.getSQLOrig().length();
        }
        if (n == n2) {
            n2 = n + this.m_cmd.getSQLOrig().length();
        }
        HighlightRunnable highlightRunnable = new HighlightRunnable(basicEditorPane, n, n2);
        SwingUtilities.invokeLater(highlightRunnable);
    }

    private static class HighlightRunnable
    implements Runnable {
        BasicEditorPane m_editor = null;
        int m_start = 0;
        int m_end = 0;

        public HighlightRunnable(BasicEditorPane basicEditorPane, int n, int n2) {
            this.m_editor = basicEditorPane;
            this.m_start = n;
            this.m_end = n2;
        }

        @Override
        public void run() {
            this.m_editor.select(0, 0);
            this.m_editor.select(this.m_start, this.m_end);
        }
    }
}

