/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.util;

import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import oracle.bali.jle.JLECanvas;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.geom.Dimension2D;
import oracle.bali.jle.geom.Point2D;
import oracle.bali.jle.geom.Rectangle2D;
import oracle.bali.jle.item.BaseContainer;
import oracle.bali.jle.tool.undo.MoveUndo;
import oracle.bali.jle.tool.undo.ResizeUndo;
import oracle.bali.jle.util.ItemUtils;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.Sort;

public class AlignmentUtils {
    private static LevelComparator _sComparator = new LevelComparator();

    private AlignmentUtils() {
    }

    public static void alignLeft(LayoutItem[] items) {
        if (items == null) {
            throw new IllegalArgumentException();
        }
        if (items.length <= 1) {
            return;
        }
        LayoutItem leftmost = null;
        double leftEdge = Double.MAX_VALUE;
        for (int i = 0; i < items.length; ++i) {
            Rectangle2D currLoc;
            double left;
            LayoutItem parent;
            LayoutItem curr = items[i];
            if (curr == null || (parent = curr.getItemParent()) == null || !((left = (currLoc = ItemUtils.itemToDeviceDouble(parent, curr.getItemBounds())).getX()) < leftEdge)) continue;
            leftEdge = left;
            leftmost = curr;
        }
        if (leftmost != null) {
            AlignmentUtils.alignLeft(items, leftmost);
        }
    }

    public static void alignLeft(LayoutItem[] items, LayoutItem target) {
        if (items == null || target == null) {
            throw new IllegalArgumentException();
        }
        LayoutItem parent = target.getItemParent();
        JLECanvas canvas = target.getCanvas();
        boolean postUndo = canvas.hasUndoableEditListeners();
        if (parent == null) {
            return;
        }
        Rectangle2D targetLoc = ItemUtils.itemToDeviceDouble(parent, target.getItemBounds());
        double leftLoc = targetLoc.getX();
        items = AlignmentUtils._sortByLevel(items);
        UndoableEdit edit = postUndo && items.length > 1 ? new CompoundEdit() : null;
        for (int i = 0; i < items.length; ++i) {
            LayoutItem curr = items[i];
            if (curr == target) continue;
            LayoutItem currParent = curr.getItemParent();
            Point2D oldLoc = curr.getItemLocation();
            Point2D newLoc = ItemUtils.deviceToItem(currParent, leftLoc, oldLoc.getY());
            curr.setItemLocation(newLoc.getX(), oldLoc.getY());
            if (edit == null) continue;
            edit = AlignmentUtils._addToMoveUndo(edit, curr, items.length > 1, newLoc.getX() - oldLoc.getX(), 0.0);
        }
        AlignmentUtils._postEditAndCleanup(postUndo, edit, items.length > 1, canvas);
    }

    public static void alignRight(LayoutItem[] items) {
        if (items == null) {
            throw new IllegalArgumentException();
        }
        if (items.length <= 1) {
            return;
        }
        LayoutItem rightmost = null;
        double rightEdge = Double.MIN_VALUE;
        for (int i = 0; i < items.length; ++i) {
            Rectangle2D currLoc;
            double right;
            LayoutItem parent;
            LayoutItem curr = items[i];
            if (curr == null || (parent = curr.getItemParent()) == null || !((right = (currLoc = ItemUtils.itemToDeviceDouble(parent, curr.getItemBounds())).getX() + currLoc.getWidth()) > rightEdge)) continue;
            rightEdge = right;
            rightmost = curr;
        }
        if (rightmost != null) {
            AlignmentUtils.alignRight(items, rightmost);
        }
    }

    public static void alignRight(LayoutItem[] items, LayoutItem target) {
        if (items == null || target == null) {
            throw new IllegalArgumentException();
        }
        LayoutItem parent = target.getItemParent();
        JLECanvas canvas = target.getCanvas();
        boolean postUndo = canvas.hasUndoableEditListeners();
        if (parent == null) {
            return;
        }
        Rectangle2D targetLoc = ItemUtils.itemToDeviceDouble(parent, target.getItemBounds());
        double rightLoc = targetLoc.getX() + targetLoc.getWidth();
        items = AlignmentUtils._sortByLevel(items);
        UndoableEdit edit = postUndo && items.length > 1 ? new CompoundEdit() : null;
        for (int i = 0; i < items.length; ++i) {
            LayoutItem curr = items[i];
            if (curr == target) continue;
            LayoutItem currParent = curr.getItemParent();
            Point2D oldLoc = curr.getItemLocation();
            Dimension2D oldDim = ItemUtils.itemToDeviceDouble(currParent, curr.getItemSize());
            Point2D newLoc = ItemUtils.deviceToItem(currParent, rightLoc - oldDim.getWidth(), 0.0);
            curr.setItemLocation(newLoc.getX(), oldLoc.getY());
            if (edit == null) continue;
            edit = AlignmentUtils._addToMoveUndo(edit, curr, items.length > 1, newLoc.getX() - oldLoc.getX(), 0.0);
        }
        AlignmentUtils._postEditAndCleanup(postUndo, edit, items.length > 1, canvas);
    }

    public static void alignHorizontalCenter(LayoutItem[] items) {
        if (items == null) {
            throw new IllegalArgumentException();
        }
        if (items.length <= 1) {
            return;
        }
        double leftEdge = Double.MAX_VALUE;
        double rightEdge = Double.MIN_VALUE;
        for (int i = 0; i < items.length; ++i) {
            double right;
            LayoutItem parent;
            LayoutItem curr = items[i];
            if (curr == null || (parent = curr.getItemParent()) == null) continue;
            Rectangle2D currLoc = ItemUtils.itemToDeviceDouble(parent, curr.getItemBounds());
            double left = currLoc.getX();
            if (left < leftEdge) {
                leftEdge = left;
            }
            if (!((right = currLoc.getX() + currLoc.getWidth()) > rightEdge)) continue;
            rightEdge = right;
        }
        AlignmentUtils.alignHorizontalCenter(items, (leftEdge + rightEdge) / 2.0);
    }

    public static void alignHorizontalCenter(LayoutItem[] items, double deviceX) {
        if (items == null) {
            throw new IllegalArgumentException();
        }
        JLECanvas canvas = items[0].getCanvas();
        boolean postUndo = canvas.hasUndoableEditListeners();
        items = AlignmentUtils._sortByLevel(items);
        UndoableEdit edit = postUndo && items.length > 1 ? new CompoundEdit() : null;
        for (int i = 0; i < items.length; ++i) {
            LayoutItem curr = items[i];
            LayoutItem currParent = curr.getItemParent();
            Rectangle2D oldBounds = curr.getItemBounds();
            Rectangle2D currDev = ItemUtils.itemToDeviceDouble(currParent, oldBounds);
            double adjustment = deviceX - (currDev.getX() + currDev.getWidth() / 2.0);
            Point2D newLoc = ItemUtils.deviceToItem(currParent, currDev.getX() + adjustment, 0.0);
            curr.setItemLocation(newLoc.getX(), oldBounds.getY());
            if (edit == null) continue;
            edit = AlignmentUtils._addToMoveUndo(edit, curr, items.length > 1, newLoc.getX() - oldBounds.getX(), 0.0);
        }
        AlignmentUtils._postEditAndCleanup(postUndo, edit, items.length > 1, canvas);
    }

    public static void alignTop(LayoutItem[] items) {
        if (items == null) {
            throw new IllegalArgumentException();
        }
        if (items.length <= 1) {
            return;
        }
        LayoutItem topmost = null;
        double topEdge = Double.MAX_VALUE;
        for (int i = 0; i < items.length; ++i) {
            Rectangle2D currLoc;
            double top;
            LayoutItem parent;
            LayoutItem curr = items[i];
            if (curr == null || (parent = curr.getItemParent()) == null || !((top = (currLoc = ItemUtils.itemToDeviceDouble(parent, curr.getItemBounds())).getY()) < topEdge)) continue;
            topEdge = top;
            topmost = curr;
        }
        if (topmost != null) {
            AlignmentUtils.alignTop(items, topmost);
        }
    }

    public static void alignTop(LayoutItem[] items, LayoutItem target) {
        if (items == null || target == null) {
            throw new IllegalArgumentException();
        }
        LayoutItem parent = target.getItemParent();
        JLECanvas canvas = target.getCanvas();
        boolean postUndo = canvas.hasUndoableEditListeners();
        if (parent == null) {
            return;
        }
        Rectangle2D targetLoc = ItemUtils.itemToDeviceDouble(parent, target.getItemBounds());
        double topLoc = targetLoc.getY();
        items = AlignmentUtils._sortByLevel(items);
        UndoableEdit edit = postUndo && items.length > 1 ? new CompoundEdit() : null;
        for (int i = 0; i < items.length; ++i) {
            LayoutItem curr = items[i];
            if (curr == target) continue;
            LayoutItem currParent = curr.getItemParent();
            Point2D oldLoc = curr.getItemLocation();
            Point2D newLoc = ItemUtils.deviceToItem(currParent, oldLoc.getX(), topLoc);
            curr.setItemLocation(oldLoc.getX(), newLoc.getY());
            if (edit == null) continue;
            edit = AlignmentUtils._addToMoveUndo(edit, curr, items.length > 1, 0.0, newLoc.getY() - oldLoc.getY());
        }
        AlignmentUtils._postEditAndCleanup(postUndo, edit, items.length > 1, canvas);
    }

    public static void alignBottom(LayoutItem[] items) {
        if (items == null) {
            throw new IllegalArgumentException();
        }
        if (items.length <= 1) {
            return;
        }
        LayoutItem bottommost = null;
        double bottomEdge = Double.MIN_VALUE;
        for (int i = 0; i < items.length; ++i) {
            Rectangle2D currLoc;
            double bottom;
            LayoutItem parent;
            LayoutItem curr = items[i];
            if (curr == null || (parent = curr.getItemParent()) == null || !((bottom = (currLoc = ItemUtils.itemToDeviceDouble(parent, curr.getItemBounds())).getY() + currLoc.getHeight()) > bottomEdge)) continue;
            bottomEdge = bottom;
            bottommost = curr;
        }
        if (bottommost != null) {
            AlignmentUtils.alignBottom(items, bottommost);
        }
    }

    public static void alignBottom(LayoutItem[] items, LayoutItem target) {
        if (items == null || target == null) {
            throw new IllegalArgumentException();
        }
        LayoutItem parent = target.getItemParent();
        JLECanvas canvas = target.getCanvas();
        boolean postUndo = canvas.hasUndoableEditListeners();
        if (parent == null) {
            return;
        }
        Rectangle2D targetLoc = ItemUtils.itemToDeviceDouble(parent, target.getItemBounds());
        double bottomLoc = targetLoc.getY() + targetLoc.getHeight();
        items = AlignmentUtils._sortByLevel(items);
        UndoableEdit edit = postUndo && items.length > 1 ? new CompoundEdit() : null;
        for (int i = 0; i < items.length; ++i) {
            LayoutItem curr = items[i];
            if (curr == target) continue;
            LayoutItem currParent = curr.getItemParent();
            Point2D oldLoc = curr.getItemLocation();
            Dimension2D oldDim = ItemUtils.itemToDeviceDouble(currParent, curr.getItemSize());
            Point2D newLoc = ItemUtils.deviceToItem(currParent, 0.0, bottomLoc - oldDim.getHeight());
            curr.setItemLocation(oldLoc.getX(), newLoc.getY());
            if (edit == null) continue;
            edit = AlignmentUtils._addToMoveUndo(edit, curr, items.length > 1, 0.0, newLoc.getY() - oldLoc.getY());
        }
        AlignmentUtils._postEditAndCleanup(postUndo, edit, items.length > 1, canvas);
    }

    public static void alignVerticalCenter(LayoutItem[] items) {
        if (items == null) {
            throw new IllegalArgumentException();
        }
        if (items.length <= 1) {
            return;
        }
        double topEdge = Double.MAX_VALUE;
        double bottomEdge = Double.MIN_VALUE;
        for (int i = 0; i < items.length; ++i) {
            double bottom;
            LayoutItem parent;
            LayoutItem curr = items[i];
            if (curr == null || (parent = curr.getItemParent()) == null) continue;
            Rectangle2D currLoc = ItemUtils.itemToDeviceDouble(parent, curr.getItemBounds());
            double top = currLoc.getY();
            if (top < topEdge) {
                topEdge = top;
            }
            if (!((bottom = currLoc.getY() + currLoc.getHeight()) > bottomEdge)) continue;
            bottomEdge = bottom;
        }
        AlignmentUtils.alignVerticalCenter(items, (topEdge + bottomEdge) / 2.0);
    }

    public static void alignVerticalCenter(LayoutItem[] items, double deviceY) {
        if (items == null) {
            throw new IllegalArgumentException();
        }
        JLECanvas canvas = items[0].getCanvas();
        boolean postUndo = canvas.hasUndoableEditListeners();
        items = AlignmentUtils._sortByLevel(items);
        UndoableEdit edit = postUndo && items.length > 1 ? new CompoundEdit() : null;
        for (int i = 0; i < items.length; ++i) {
            LayoutItem curr = items[i];
            LayoutItem currParent = curr.getItemParent();
            Rectangle2D oldBounds = curr.getItemBounds();
            Rectangle2D currDev = ItemUtils.itemToDeviceDouble(currParent, oldBounds);
            double adjustment = deviceY - (currDev.getY() + currDev.getHeight() / 2.0);
            Point2D newLoc = ItemUtils.deviceToItem(currParent, 0.0, currDev.getY() + adjustment);
            curr.setItemLocation(oldBounds.getX(), newLoc.getY());
            if (edit == null) continue;
            edit = AlignmentUtils._addToMoveUndo(edit, curr, items.length > 1, 0.0, newLoc.getY() - oldBounds.getY());
        }
        AlignmentUtils._postEditAndCleanup(postUndo, edit, items.length > 1, canvas);
    }

    public static void resizeSmallestWidth(LayoutItem[] items) {
        if (items == null) {
            throw new IllegalArgumentException();
        }
        JLECanvas canvas = items[0].getCanvas();
        boolean postUndo = canvas.hasUndoableEditListeners();
        UndoableEdit edit = postUndo && items.length > 1 ? new CompoundEdit() : null;
        double targetWidth = Double.MAX_VALUE;
        for (int i = 0; i < items.length; ++i) {
            double currWidth;
            LayoutItem currParent;
            LayoutItem curr = items[i];
            if (curr == null || (currParent = curr.getItemParent()) == null || !((currWidth = ItemUtils.itemToDeviceDouble(currParent, curr.getItemSize()).getWidth()) < targetWidth)) continue;
            targetWidth = currWidth;
        }
        edit = AlignmentUtils._resizeAndAddToEdit(edit, items, targetWidth, Double.MAX_VALUE);
        AlignmentUtils._postEditAndCleanup(postUndo, edit, items.length > 1, canvas);
    }

    public static void resizeLargestWidth(LayoutItem[] items) {
        if (items == null) {
            throw new IllegalArgumentException();
        }
        JLECanvas canvas = items[0].getCanvas();
        boolean postUndo = canvas.hasUndoableEditListeners();
        UndoableEdit edit = postUndo && items.length > 1 ? new CompoundEdit() : null;
        double targetWidth = Double.MIN_VALUE;
        for (int i = 0; i < items.length; ++i) {
            double currWidth;
            LayoutItem currParent;
            LayoutItem curr = items[i];
            if (curr == null || (currParent = curr.getItemParent()) == null || !((currWidth = ItemUtils.itemToDeviceDouble(currParent, curr.getItemSize()).getWidth()) > targetWidth)) continue;
            targetWidth = currWidth;
        }
        edit = AlignmentUtils._resizeAndAddToEdit(edit, items, targetWidth, Double.MAX_VALUE);
        AlignmentUtils._postEditAndCleanup(postUndo, edit, items.length > 1, canvas);
    }

    public static void resizeAverageWidth(LayoutItem[] items) {
        if (items == null) {
            throw new IllegalArgumentException();
        }
        JLECanvas canvas = items[0].getCanvas();
        boolean postUndo = canvas.hasUndoableEditListeners();
        UndoableEdit edit = postUndo && items.length > 1 ? new CompoundEdit() : null;
        double targetWidth = 0.0;
        int targetNum = 0;
        for (int i = 0; i < items.length; ++i) {
            LayoutItem currParent;
            LayoutItem curr = items[i];
            if (curr == null || (currParent = curr.getItemParent()) == null) continue;
            double currWidth = ItemUtils.itemToDeviceDouble(currParent, curr.getItemSize()).getWidth();
            targetWidth += currWidth;
            ++targetNum;
        }
        edit = AlignmentUtils._resizeAndAddToEdit(edit, items, targetWidth /= (double)targetNum, Double.MAX_VALUE);
        AlignmentUtils._postEditAndCleanup(postUndo, edit, items.length > 1, canvas);
    }

    public static void resizeSmallestHeight(LayoutItem[] items) {
        if (items == null) {
            throw new IllegalArgumentException();
        }
        JLECanvas canvas = items[0].getCanvas();
        boolean postUndo = canvas.hasUndoableEditListeners();
        UndoableEdit edit = postUndo && items.length > 1 ? new CompoundEdit() : null;
        double targetHeight = Double.MAX_VALUE;
        for (int i = 0; i < items.length; ++i) {
            double currHeight;
            LayoutItem currParent;
            LayoutItem curr = items[i];
            if (curr == null || (currParent = curr.getItemParent()) == null || !((currHeight = ItemUtils.itemToDeviceDouble(currParent, curr.getItemSize()).getHeight()) < targetHeight)) continue;
            targetHeight = currHeight;
        }
        edit = AlignmentUtils._resizeAndAddToEdit(edit, items, Double.MAX_VALUE, targetHeight);
        AlignmentUtils._postEditAndCleanup(postUndo, edit, items.length > 1, canvas);
    }

    public static void resizeLargestHeight(LayoutItem[] items) {
        if (items == null) {
            throw new IllegalArgumentException();
        }
        JLECanvas canvas = items[0].getCanvas();
        boolean postUndo = canvas.hasUndoableEditListeners();
        UndoableEdit edit = postUndo && items.length > 1 ? new CompoundEdit() : null;
        double targetHeight = Double.MIN_VALUE;
        for (int i = 0; i < items.length; ++i) {
            double currHeight;
            LayoutItem currParent;
            LayoutItem curr = items[i];
            if (curr == null || (currParent = curr.getItemParent()) == null || !((currHeight = ItemUtils.itemToDeviceDouble(currParent, curr.getItemSize()).getHeight()) > targetHeight)) continue;
            targetHeight = currHeight;
        }
        edit = AlignmentUtils._resizeAndAddToEdit(edit, items, Double.MAX_VALUE, targetHeight);
        AlignmentUtils._postEditAndCleanup(postUndo, edit, items.length > 1, canvas);
    }

    public static void resizeAverageHeight(LayoutItem[] items) {
        if (items == null) {
            throw new IllegalArgumentException();
        }
        JLECanvas canvas = items[0].getCanvas();
        boolean postUndo = canvas.hasUndoableEditListeners();
        UndoableEdit edit = postUndo && items.length > 1 ? new CompoundEdit() : null;
        double targetHeight = 0.0;
        int targetNum = 0;
        for (int i = 0; i < items.length; ++i) {
            LayoutItem currParent;
            LayoutItem curr = items[i];
            if (curr == null || (currParent = curr.getItemParent()) == null) continue;
            double currHeight = ItemUtils.itemToDeviceDouble(currParent, curr.getItemSize()).getHeight();
            targetHeight += currHeight;
            ++targetNum;
        }
        edit = AlignmentUtils._resizeAndAddToEdit(edit, items, Double.MAX_VALUE, targetHeight /= (double)targetNum);
        AlignmentUtils._postEditAndCleanup(postUndo, edit, items.length > 1, canvas);
    }

    public static void moveToFront(LayoutItem item) {
        if (item == null) {
            return;
        }
        LayoutItem parent = item.getItemParent();
        if (parent == null) {
            return;
        }
        parent.removeItem(item);
        parent.addItem(item, 0);
    }

    public static void moveToBack(LayoutItem item) {
        if (item == null) {
            return;
        }
        LayoutItem parent = item.getItemParent();
        if (parent == null) {
            return;
        }
        parent.removeItem(item);
        parent.addItem(item, -1);
    }

    public static void moveForward(LayoutItem item) {
        if (item == null) {
            return;
        }
        LayoutItem parent = item.getItemParent();
        if (parent == null) {
            return;
        }
        int oldIndex = ItemUtils.getItemIndex(item, parent);
        if (oldIndex <= 0) {
            return;
        }
        parent.removeItem(item);
        parent.addItem(item, oldIndex - 1);
    }

    public static void moveBackward(LayoutItem item) {
        int childCount;
        if (item == null) {
            return;
        }
        LayoutItem parent = item.getItemParent();
        if (parent == null) {
            return;
        }
        int oldIndex = ItemUtils.getItemIndex(item, parent);
        if (oldIndex >= (childCount = parent.getItemCount()) - 1) {
            return;
        }
        parent.removeItem(item);
        parent.addItem(item, oldIndex + 1);
    }

    private static UndoableEdit _addToMoveUndo(UndoableEdit edit, LayoutItem curr, boolean addToEdit, double dx, double dy) {
        MoveUndo temp = new MoveUndo(curr, dx, dy, null);
        if (addToEdit) {
            edit.addEdit(temp);
        } else {
            edit = temp;
        }
        return edit;
    }

    private static UndoableEdit _resizeAndAddToEdit(UndoableEdit edit, LayoutItem[] items, double newWidth, double newHeight) {
        boolean useNewWidth = newWidth != Double.MAX_VALUE;
        boolean useNewHeight = newHeight != Double.MAX_VALUE;
        for (int i = 0; i < items.length; ++i) {
            LayoutItem currParent;
            LayoutItem curr = items[i];
            if (curr == null || (currParent = curr.getItemParent()) == null) continue;
            Dimension2D oldSize = curr.getItemSize();
            Dimension2D newSize = ItemUtils.deviceToItem(currParent, new Dimension2D.Double(useNewWidth ? newWidth : oldSize.getWidth(), useNewHeight ? newHeight : oldSize.getHeight()));
            curr.setItemSize(useNewWidth ? newSize.getWidth() : oldSize.getWidth(), useNewHeight ? newSize.getHeight() : oldSize.getHeight());
            ResizeUndo temp = new ResizeUndo(curr, oldSize);
            if (items.length > 1) {
                edit.addEdit(temp);
                continue;
            }
            edit = temp;
        }
        return edit;
    }

    private static void _postEditAndCleanup(boolean postUndo, UndoableEdit edit, boolean endCompound, JLECanvas canvas) {
        if (postUndo) {
            if (endCompound) {
                ((CompoundEdit)edit).end();
            }
            if (edit != null) {
                canvas.processUndoableEditEvent(new UndoableEditEvent(AlignmentUtils.class, edit));
            }
        }
        canvas.repaintInterior();
    }

    private static LayoutItem[] _sortByLevel(LayoutItem[] items) {
        Object[] levels = new ItemLevel[items.length];
        int actualItems = 0;
        for (int i = 0; i < items.length; ++i) {
            ItemLevel curr;
            if (items[i] == null || (curr = new ItemLevel(items[i])).getLevel() < 0) continue;
            levels[actualItems] = curr;
            ++actualItems;
        }
        Sort.qSort((Object[])levels, (int)actualItems, (Comparator)_sComparator);
        LayoutItem[] result = new LayoutItem[actualItems];
        for (int i = 0; i < actualItems; ++i) {
            result[i] = ((ItemLevel)levels[i]).getItem();
        }
        return result;
    }

    static class ItemLevel {
        LayoutItem _item;
        int _level;

        ItemLevel(LayoutItem item) {
            this._item = item;
            BaseContainer content = item.getCanvas().getContentItem();
            int level = 0;
            while (item != content && item != null) {
                item = item.getItemParent();
                ++level;
            }
            this._level = item == null ? -1 : level;
        }

        LayoutItem getItem() {
            return this._item;
        }

        int getLevel() {
            return this._level;
        }
    }

    static class LevelComparator
    implements Comparator {
        LevelComparator() {
        }

        public int compare(Object item1, Object item2) {
            int level2;
            int level1 = ((ItemLevel)item1).getLevel();
            if (level1 < (level2 = ((ItemLevel)item2).getLevel())) {
                return -1;
            }
            if (level1 > level2) {
                return 1;
            }
            return 0;
        }
    }
}

