/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool.undo;

import java.awt.Rectangle;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.geom.Dimension2D;
import oracle.bali.jle.tool.BoundsPainter;
import oracle.bali.jle.tool.BoundsTool;
import oracle.bali.jle.tool.ControlPoint;
import oracle.bali.jle.tool.undo.LocalizedEdit;
import oracle.bali.jle.util.ItemUtils;

public class ResizeUndo
extends LocalizedEdit {
    private LayoutItem _resized;
    private double _dx;
    private double _dy;
    private ControlPoint _undoPoint;
    private ControlPoint _redoPoint;
    private BoundsTool _tool;
    private Dimension2D _size;

    public ResizeUndo(LayoutItem resized, double dx, double dy, ControlPoint point, BoundsTool tool) {
        this(resized, dx, dy, point, point, tool);
    }

    public ResizeUndo(LayoutItem resized, double dx, double dy, ControlPoint undoPoint, ControlPoint redoPoint, BoundsTool tool) {
        if (resized == null || tool == null) {
            throw new IllegalArgumentException();
        }
        this._resized = resized;
        this._dx = dx;
        this._dy = dy;
        this._undoPoint = undoPoint;
        this._redoPoint = redoPoint;
        this._tool = tool;
    }

    public ResizeUndo(LayoutItem resized, Dimension2D oldSize) {
        this._resized = resized;
        this._size = oldSize;
    }

    @Override
    public void undo() {
        super.undo();
        if (this._tool != null) {
            Rectangle oldRect = ItemUtils.parentToDevice(this._resized, this._resized.getItemBounds());
            this._tool.processResize(this._resized, -this._dx, -this._dy, this._undoPoint);
            this._repaintOldLocation(oldRect);
        } else {
            Dimension2D currSize = this._resized.getItemSize();
            this._resized.setItemSize(this._size.getWidth(), this._size.getHeight());
            this._size = currSize;
            this._resized.getCanvas().repaintInterior();
        }
    }

    @Override
    public void redo() {
        super.redo();
        if (this._tool != null) {
            Rectangle oldRect = ItemUtils.parentToDevice(this._resized, this._resized.getItemBounds());
            this._tool.processResize(this._resized, this._dx, this._dy, this._redoPoint);
            this._repaintOldLocation(oldRect);
        } else {
            Dimension2D currSize = this._resized.getItemSize();
            this._resized.setItemSize(this._size.getWidth(), this._size.getHeight());
            this._size = currSize;
            this._resized.getCanvas().repaintInterior();
        }
    }

    @Override
    public void die() {
        super.die();
        this._resized = null;
        this._undoPoint = null;
        this._redoPoint = null;
        this._tool = null;
        this._size = null;
    }

    @Override
    public String getBaseKey() {
        return "RESIZE";
    }

    public LayoutItem getResizedItem() {
        return this._resized;
    }

    private void _repaintOldLocation(Rectangle oldRect) {
        BoundsPainter painter = this._tool.getBoundsPainter();
        int xOff = painter.getControlPointWidth() / 2 + 1;
        int yOff = painter.getControlPointHeight() / 2 + 1;
        this._tool.getCanvas().repaintInterior(oldRect.x - xOff, oldRect.y - yOff, oldRect.width + xOff * 2, oldRect.height + yOff * 2);
    }
}

