/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.tool;

import java.util.EventObject;
import oracle.bali.jle.LayoutItem;

public class ClipboardToolEvent
extends EventObject {
    public static final int ITEMS_COPYING = 1;
    public static final int ITEMS_COPIED = 2;
    public static final int ITEMS_CUTTING = 3;
    public static final int ITEMS_CUT = 4;
    public static final int ITEMS_PASTING = 5;
    public static final int ITEMS_PASTED = 6;
    private LayoutItem[] _items;
    private int _id;

    public ClipboardToolEvent(Object source, int id, LayoutItem[] items) {
        super(source);
        this._id = id;
        this._items = new LayoutItem[items.length];
        System.arraycopy(items, 0, this._items, 0, items.length);
    }

    public int getId() {
        return this._id;
    }

    public LayoutItem[] getItems() {
        LayoutItem[] copy = new LayoutItem[this._items.length];
        System.arraycopy(this._items, 0, copy, 0, this._items.length);
        return copy;
    }

    @Override
    public String toString() {
        String type = null;
        switch (this._id) {
            case 1: {
                type = "ITEMS_COPYING";
                break;
            }
            case 2: {
                type = "ITEM_COPIED";
                break;
            }
            case 3: {
                type = "ITEMS_CUTTING";
                break;
            }
            case 4: {
                type = "ITEM_CUT";
                break;
            }
            case 5: {
                type = "ITEMS_PASTING";
                break;
            }
            case 6: {
                type = "ITEM_PASTED";
            }
        }
        return this.getClass().getName() + ": " + type + ", items=" + this._items;
    }
}

