/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle.item;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import oracle.bali.jle.LayoutItem;
import oracle.bali.jle.geom.Dimension2D;
import oracle.bali.jle.geom.Point2D;
import oracle.bali.jle.geom.Rectangle2D;
import oracle.bali.jle.util.ItemUtils;

public class AccessibleLayoutItem
extends AccessibleContext
implements AccessibleComponent {
    private LayoutItem _item;

    public AccessibleLayoutItem(LayoutItem item) {
        this._item = item;
    }

    public LayoutItem getItem() {
        return this._item;
    }

    @Override
    public AccessibleRole getAccessibleRole() {
        return AccessibleRole.PANEL;
    }

    @Override
    public AccessibleStateSet getAccessibleStateSet() {
        return new AccessibleStateSet();
    }

    @Override
    public int getAccessibleIndexInParent() {
        Accessible parent = this.getAccessibleParent();
        if (parent == null) {
            return -1;
        }
        AccessibleContext context = parent.getAccessibleContext();
        int count = context.getAccessibleChildrenCount();
        for (int i = 0; i < count; ++i) {
            if (context.getAccessibleChild(i) != this.getItem()) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getAccessibleChildrenCount() {
        return this.getItem().getItemCount();
    }

    @Override
    public Accessible getAccessibleChild(int i) {
        if (i < 0 || i >= this.getItem().getItemCount()) {
            return null;
        }
        LayoutItem item = this.getItem().getItem(i);
        if (item != null) {
            item.getAccessibleContext().setAccessibleParent(this.getItem());
        }
        return item;
    }

    @Override
    public Locale getLocale() throws IllegalComponentStateException {
        if (this.getItem().getCanvas() != null) {
            return this.getItem().getCanvas().getLocale();
        }
        return Locale.getDefault();
    }

    @Override
    public AccessibleComponent getAccessibleComponent() {
        return this;
    }

    @Override
    public Color getBackground() {
        return null;
    }

    @Override
    public void setBackground(Color c) {
    }

    @Override
    public Color getForeground() {
        return null;
    }

    @Override
    public void setForeground(Color c) {
    }

    @Override
    public Cursor getCursor() {
        return Cursor.getDefaultCursor();
    }

    @Override
    public void setCursor(Cursor cursor) {
    }

    @Override
    public Font getFont() {
        return null;
    }

    @Override
    public void setFont(Font f) {
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return null;
    }

    @Override
    public boolean isEnabled() {
        return this.getItem().getCanvas() == null ? false : this.getItem().getCanvas().isEnabled();
    }

    @Override
    public void setEnabled(boolean b) {
    }

    @Override
    public boolean isVisible() {
        return this.getItem().getCanvas() == null ? false : this.getItem().getCanvas().isVisible();
    }

    @Override
    public void setVisible(boolean b) {
    }

    @Override
    public boolean isShowing() {
        return this.getItem().getCanvas() == null ? false : this.getItem().getCanvas().isShowing();
    }

    @Override
    public boolean contains(Point p) {
        Rectangle bounds = this.getBounds();
        return bounds == null ? false : bounds.contains(p);
    }

    @Override
    public Point getLocationOnScreen() {
        return ItemUtils.parentToDevice(this.getItem(), this.getItem().getItemLocation());
    }

    @Override
    public Point getLocation() {
        Point2D point = this.getItem().getItemLocation();
        return new Point((int)point.getX(), (int)point.getY());
    }

    @Override
    public void setLocation(Point p) {
    }

    @Override
    public Rectangle getBounds() {
        Rectangle2D rect = this.getItem().getItemBounds();
        return rect.getBounds();
    }

    @Override
    public void setBounds(Rectangle r) {
    }

    @Override
    public Dimension getSize() {
        Dimension2D d = this.getItem().getItemSize();
        return new Dimension((int)d.getWidth(), (int)d.getHeight());
    }

    @Override
    public void setSize(Dimension d) {
    }

    @Override
    public Accessible getAccessibleAt(Point p) {
        return this.getItem().getItemAt(p.x, p.y);
    }

    @Override
    public boolean isFocusTraversable() {
        return this.getItem().isFocusTraversable();
    }

    @Override
    public void requestFocus() {
    }

    @Override
    public void addFocusListener(FocusListener l) {
    }

    @Override
    public void removeFocusListener(FocusListener l) {
    }
}

