/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.jle;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import oracle.bali.ewt.ruler.Ruler;
import oracle.bali.ewt.scrolling.EWTScrollPane;
import oracle.bali.ewt.scrolling.ScrollableComponent;

public class RulerScrollPane
extends EWTScrollPane {
    Ruler _vRuler = new Ruler(1);
    Ruler _hRuler = new Ruler(0);
    Tracker _tracker;
    VTracker _vTracker;
    HTracker _hTracker;
    VScrollbarTracker _vScrollTrack;
    HScrollbarTracker _hScrollTrack;
    private boolean _markerVisible = true;

    public RulerScrollPane(ScrollableComponent content) {
        this(content, 20, 30);
    }

    public RulerScrollPane(ScrollableComponent content, int vDisplayPolicy, int hDisplayPolicy) {
        super((Component)content, vDisplayPolicy, hDisplayPolicy);
        this.setRowHeaderView((Component)this._vRuler);
        this.setColumnHeaderView((Component)this._hRuler);
        this.setBackground(this._vRuler.getBackground());
        this._hTracker = new HTracker();
        this._hRuler.addMouseMotionListener((MouseMotionListener)this._hTracker);
        this._vTracker = new VTracker();
        this._vRuler.addMouseMotionListener((MouseMotionListener)this._vTracker);
        this._tracker = new Tracker();
        this.getViewport().getView().addMouseMotionListener(this._tracker);
        this._hScrollTrack = new HScrollbarTracker();
        this.getHorizontalScrollBar().addMouseMotionListener(this._hScrollTrack);
        this._vScrollTrack = new VScrollbarTracker();
        this.getVerticalScrollBar().addMouseMotionListener(this._vScrollTrack);
    }

    public Ruler getHorizontalRuler() {
        return this._hRuler;
    }

    public Ruler getVerticalRuler() {
        return this._vRuler;
    }

    public void setMarkerVisible(boolean visible) {
        if (visible != this._markerVisible) {
            if (!visible) {
                this._vRuler.setMarkerPosition(-1);
                this._hRuler.setMarkerPosition(-1);
                this._hRuler.removeMouseMotionListener((MouseMotionListener)this._hTracker);
                this._vRuler.removeMouseMotionListener((MouseMotionListener)this._vTracker);
                this.getViewport().getView().removeMouseMotionListener(this._tracker);
                this.getHorizontalScrollBar().removeMouseMotionListener(this._hScrollTrack);
                this.getVerticalScrollBar().removeMouseMotionListener(this._vScrollTrack);
            } else {
                this._hRuler.addMouseMotionListener((MouseMotionListener)this._hTracker);
                this._vRuler.addMouseMotionListener((MouseMotionListener)this._vTracker);
                this.getViewport().getView().addMouseMotionListener(this._tracker);
                this.getHorizontalScrollBar().removeMouseMotionListener(this._hScrollTrack);
                this.getVerticalScrollBar().removeMouseMotionListener(this._vScrollTrack);
            }
            this._markerVisible = visible;
        }
    }

    public boolean isMarkerVisible() {
        return this._markerVisible;
    }

    public boolean isHorizontalRulerVisible() {
        return this.getColumnHeader().getView() != null;
    }

    public void setHorizontalRulerVisible(boolean visible) {
        if (visible != this.isHorizontalRulerVisible()) {
            if (visible) {
                this.setColumnHeaderView((Component)this._hRuler);
                this._hRuler.addMouseMotionListener((MouseMotionListener)this._hTracker);
                this.getHorizontalScrollBar().addMouseMotionListener(this._hScrollTrack);
            } else {
                this._hRuler.removeMouseMotionListener((MouseMotionListener)this._hTracker);
                this.getHorizontalScrollBar().removeMouseMotionListener(this._hScrollTrack);
                this.setColumnHeaderView(null);
            }
            this.invalidate();
        }
    }

    public boolean isVerticalRulerVisible() {
        return this.getRowHeader().getView() != null;
    }

    public void setVerticalRulerVisible(boolean visible) {
        if (visible != this.isVerticalRulerVisible()) {
            if (visible) {
                this.setRowHeaderView((Component)this._vRuler);
                this._vRuler.addMouseMotionListener((MouseMotionListener)this._vTracker);
                this.getVerticalScrollBar().addMouseMotionListener(this._vScrollTrack);
            } else {
                this._vRuler.removeMouseMotionListener((MouseMotionListener)this._vTracker);
                this.getVerticalScrollBar().removeMouseMotionListener(this._vScrollTrack);
                this.setRowHeaderView(null);
            }
            this.invalidate();
        }
    }

    private class HTracker
    extends MouseMotionAdapter {
        private HTracker() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            RulerScrollPane.this._hRuler.freezeRepaints();
            RulerScrollPane.this._hRuler.setMarkerPosition(e.getX());
            RulerScrollPane.this._hRuler.paintImmediateInterior();
            RulerScrollPane.this._hRuler.unfreezeRepaints();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.mouseMoved(e);
        }
    }

    private class VTracker
    extends MouseMotionAdapter {
        private VTracker() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            RulerScrollPane.this._vRuler.freezeRepaints();
            RulerScrollPane.this._vRuler.setMarkerPosition(e.getY());
            RulerScrollPane.this._vRuler.paintImmediateInterior();
            RulerScrollPane.this._vRuler.unfreezeRepaints();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.mouseMoved(e);
        }
    }

    private class VScrollbarTracker
    extends MouseMotionAdapter {
        private VScrollbarTracker() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Component c = (Component)e.getSource();
            RulerScrollPane.this._vRuler.freezeRepaints();
            RulerScrollPane.this._vRuler.setMarkerPosition(e.getY() - RulerScrollPane.this._vRuler.getCanvasOrigin().y);
            RulerScrollPane.this._vRuler.paintImmediateInterior();
            RulerScrollPane.this._vRuler.unfreezeRepaints();
        }
    }

    private class HScrollbarTracker
    extends MouseMotionAdapter {
        private HScrollbarTracker() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Component c = (Component)e.getSource();
            RulerScrollPane.this._hRuler.freezeRepaints();
            RulerScrollPane.this._hRuler.setMarkerPosition(e.getX() - RulerScrollPane.this._hRuler.getCanvasOrigin().x);
            RulerScrollPane.this._hRuler.paintImmediateInterior();
            RulerScrollPane.this._hRuler.unfreezeRepaints();
        }
    }

    private class Tracker
    extends MouseMotionAdapter {
        private Tracker() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            Component c = (Component)e.getSource();
            RulerScrollPane.this._hRuler.freezeRepaints();
            RulerScrollPane.this._vRuler.freezeRepaints();
            RulerScrollPane.this._hRuler.setMarkerPosition(e.getX());
            RulerScrollPane.this._vRuler.setMarkerPosition(e.getY());
            RulerScrollPane.this._hRuler.paintImmediateInterior();
            RulerScrollPane.this._vRuler.paintImmediateInterior();
            RulerScrollPane.this._hRuler.unfreezeRepaints();
            RulerScrollPane.this._vRuler.unfreezeRepaints();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.mouseMoved(e);
        }
    }
}

