/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.thirdparty.mongodb.jdbc;

import com.mongodb.CommandResult;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;
import oracle.dbtools.thirdparty.mongodb.jdbc.Criteria;
import oracle.dbtools.thirdparty.mongodb.jdbc.MongoConnection;
import oracle.dbtools.thirdparty.mongodb.jdbc.MongoResultSet;
import oracle.dbtools.thirdparty.mongodb.jdbc.MongoResultSetEmpty;
import oracle.dbtools.thirdparty.mongodb.jdbc.NoSQL;
import oracle.dbtools.thirdparty.mongodb.jdbc.abstractdef.AMongoResultSet;
import oracle.dbtools.thirdparty.mongodb.jdbc.abstractdef.AMongoStatement;

public class MongoStatement
extends AMongoStatement {
    private MongoConnection _conn = null;
    private int _fetchSize = 10;
    private ResultSet _rs = null;

    public MongoStatement(MongoConnection mongoConnection) {
        this._conn = mongoConnection;
    }

    @Override
    public boolean execute(String string) throws SQLException {
        this._rs = this.executeQuery(string);
        return true;
    }

    @Override
    public ResultSet executeQuery(String string) throws SQLException {
        AMongoResultSet aMongoResultSet = null;
        NoSQL noSQL = new NoSQL(string);
        if (noSQL.getTask() == NoSQL.Task.GETCOLLECTIONNAMES) {
            Set set = this._conn.getMongoDB().getCollectionNames();
            aMongoResultSet = new MongoResultSet(set, noSQL.getResultSetType(), this);
        } else if (noSQL.getTask() == NoSQL.Task.FIND) {
            DBCursor dBCursor = null;
            DBCollection dBCollection = this._conn.getMongoDB().getCollection(noSQL.getCollection());
            int n = noSQL.getLimit();
            if (noSQL.hasCriteria()) {
                Criteria criteria = noSQL.getCriteria();
                dBCursor = n == -1 ? dBCollection.find(criteria.getQuery()) : dBCollection.find(criteria.getQuery()).limit(n);
            } else if (n == -1) {
                dBCursor = dBCollection.find();
            } else if (n == -2) {
                dBCursor = null;
                aMongoResultSet = new MongoResultSetEmpty();
            } else {
                dBCursor = dBCollection.find().limit(n);
            }
            if (dBCursor != null) {
                dBCursor.batchSize(this.getFetchSize());
                aMongoResultSet = new MongoResultSet(dBCursor, noSQL.getResultSetType(), this);
            }
        } else if (noSQL.getTask() == NoSQL.Task.EVAL) {
            Object object = this._conn.getMongoDB().eval(noSQL.getStmt(), new Object[0]);
            aMongoResultSet = new MongoResultSet(object, noSQL.getResultSetType(), this);
        } else if (noSQL.getTask() == NoSQL.Task.COMMAND) {
            CommandResult commandResult = this._conn.getMongoDB().command(noSQL.getStmt());
            aMongoResultSet = new MongoResultSet(commandResult, noSQL.getResultSetType(), this);
        }
        return aMongoResultSet;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this._conn;
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        this._fetchSize = n;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this._fetchSize;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this._rs;
    }

    @Override
    public void setEscapeProcessing(boolean bl) throws SQLException {
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public void cancel() throws SQLException {
    }
}

