/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.uses;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import oracle.ide.nulls.NullPrintStream;
import oracle.javatools.exports.classpath.ClassPathModel;
import oracle.javatools.exports.command.CommandException;
import oracle.javatools.exports.command.CommandLog;

public class Uses {
    private static boolean failOnUnexpectedInput = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void readUses(ClassPathModel model) throws CommandException {
        lineCount = 0;
        fileName = Uses.class.getResource("fa-used-api-messages.txt").toString();
        model.log("", CommandLog.NOTE, "loading FA uses from %s", new Object[]{fileName});
        stream = Uses.class.getResourceAsStream("fa-used-api-messages.txt");
        if (stream == null) {
            throw new CommandException("FA uses %s not read", new Object[]{fileName});
        }
        try {
            reader = new BufferedReader(new InputStreamReader(stream));
            var5_6 = null;
            try {
                reportedAdjustedTypes = new HashSet<String>();
                try {
                    MEMBER_LABELS = Arrays.asList(new String[]{"constructor", "method", "field"});
                    line = reader.readLine();
                    while (line != null) {
                        block48: {
                            block52: {
                                block50: {
                                    block51: {
                                        block49: {
                                            ++lineCount;
                                            if (line.isEmpty() || line.startsWith("#")) break block48;
                                            fields = line.split("\\s+");
                                            if (fields.length >= 2) break block49;
                                            message = String.format("unmatched message at line %d: %s", new Object[]{lineCount, line});
                                            if (Uses.failOnUnexpectedInput) {
                                                throw new IOException(message);
                                            }
                                            model.log(fileName, CommandLog.Severity.WARNING, message, new Object[0]);
                                            break block48;
                                        }
                                        label = fields[0].toLowerCase();
                                        name = fields[1];
                                        if (!"class".equals(label) && !"interface".equals(label)) break block50;
                                        if ("in".equals(fields[2])) break block51;
                                        message = String.format("unmatched message at line %d: %s", new Object[]{lineCount, line});
                                        if (Uses.failOnUnexpectedInput) {
                                            throw new IOException(message);
                                        }
                                        model.log(fileName, CommandLog.Severity.WARNING, message, new Object[0]);
                                        break block48;
                                    }
                                    packageName = fields[3];
                                    typeName = name;
                                    typeKind = label;
                                    memberName = "";
                                    ** GOTO lbl78
                                }
                                if (!"type".equals(label)) break block52;
                                label = "class";
                                typeName = name;
                                memberName = "";
                                packageName = Uses.getPackage(typeName, reportedAdjustedTypes, model, fileName);
                                typeName = typeName.substring(packageName.length() + 1);
                                typeKind = "class";
                                ** GOTO lbl78
                            }
                            if (!MEMBER_LABELS.contains(label)) {
                                message = String.format("unexpected element type %s at line %d: %s", new Object[]{label, lineCount, line});
                                if (Uses.failOnUnexpectedInput) {
                                    throw new IOException(message);
                                }
                                model.log(fileName, CommandLog.Severity.WARNING, message, new Object[0]);
                            } else if (fields.length < 3 || !"of".equals(fields[2])) {
                                message = String.format("unmatched message at line %d: %s", new Object[]{lineCount, line});
                                if (Uses.failOnUnexpectedInput) {
                                    throw new IOException(message);
                                }
                                model.log(fileName, CommandLog.Severity.WARNING, message, new Object[0]);
                            } else {
                                if (fields.length >= 7 && "in".equals(fields[5])) {
                                    packageName = fields[6];
                                    typeName = fields[4];
                                    typeKind = fields[3];
                                } else if (fields.length >= 6 && "in".equals(fields[4])) {
                                    packageName = fields[5];
                                    typeName = fields[3];
                                    typeKind = "class";
                                } else {
                                    qualifiedType = fields[3];
                                    packageName = Uses.getPackage(qualifiedType, reportedAdjustedTypes, model, fileName);
                                    typeName = qualifiedType.substring(packageName.length() + 1);
                                    typeKind = "class";
                                }
                                memberName = name;
lbl78:
                                // 3 sources

                                packag = model.getPackage(packageName);
                                if (packag != null && (type = packag.getType(typeName = Uses.erase(typeName))) != null) {
                                    packag.setHasUsedChildren(true);
                                    type.setUsed(true);
                                    var18_21 = label;
                                    var19_22 = -1;
                                    switch (var18_21.hashCode()) {
                                        case -1588406278: {
                                            if (!var18_21.equals("constructor")) break;
                                            var19_22 = 0;
                                            break;
                                        }
                                        case -1077554975: {
                                            if (!var18_21.equals("method")) break;
                                            var19_22 = 1;
                                            break;
                                        }
                                        case 97427706: {
                                            if (!var18_21.equals("field")) break;
                                            var19_22 = 2;
                                        }
                                    }
                                    switch (var19_22) {
                                        case 0: {
                                            constructor = type.getDeclaredOrInheritedMember(Uses.erase(memberName), model);
                                            if (constructor != null) {
                                                constructor.setUsed(true);
                                            } else {
                                                model.log(type, CommandLog.WARNING, "unresolved use at line %d of fa-uses.txt: %s in %s", new Object[]{lineCount, line, type.getFullName()});
                                            }
                                        }
                                        case 1: {
                                            method = type.getDeclaredOrInheritedMember(Uses.erase(memberName), model);
                                            if (method != null) {
                                                method.setUsed(true);
                                            } else {
                                                model.log(type, CommandLog.WARNING, "unresolved use at line %d of fa-uses.txt: %s in %s", new Object[]{lineCount, line, type.getFullName()});
                                            }
                                        }
                                        case 2: {
                                            field = type.getDeclaredOrInheritedMember(memberName, model);
                                            if (field != null) {
                                                field.setUsed(true);
                                                break;
                                            }
                                            model.log(type, CommandLog.WARNING, "unresolved use at line %d of fa-uses.txt: %s in %s", new Object[]{lineCount, line, type.getFullName()});
                                        }
                                    }
                                }
                            }
                        }
                        line = reader.readLine();
                    }
                }
                finally {
                    reader.close();
                }
            }
            catch (Throwable var6_9) {
                var5_6 = var6_9;
                throw var6_9;
            }
            finally {
                if (reader != null) {
                    if (var5_6 != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable var6_8) {
                            var5_6.addSuppressed(var6_8);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
        catch (IOException e) {
            throw new CommandException(e, "Uses file %s not read after line %d: %e", new Object[]{fileName, lineCount, e});
        }
    }

    private static String getPackage(String type, Set<String> reportedAdjustedTypes, ClassPathModel model, String fileName) {
        int dot = type.lastIndexOf(46);
        String packag = dot > 0 ? type.substring(0, dot) : "";
        dot = packag.lastIndexOf(46);
        if (dot > 0 && dot + 1 < packag.length() && Character.isUpperCase(packag.charAt(dot + 1))) {
            packag = packag.substring(0, dot);
            if (reportedAdjustedTypes.add(type)) {
                model.log(fileName, CommandLog.Severity.NOTE, "adjusting package for %s to %s", type, packag);
            }
        }
        return packag;
    }

    private static String erase(String signature) {
        int i = signature.indexOf(60);
        if (i < 0) {
            return signature;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(signature, 0, i);
        int depth = 1;
        ++i;
        while (i < signature.length()) {
            char c = signature.charAt(i);
            switch (c) {
                case '<': {
                    ++depth;
                    break;
                }
                case '>': {
                    if (--depth >= 0) break;
                    return signature;
                }
                default: {
                    if (depth != 0) break;
                    builder.append(c);
                }
            }
            ++i;
        }
        return depth == 0 ? builder.toString() : signature;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeUsedFiles(ClassPathModel model, Path usedConcealed, Path unusedExported, Path annotated, Path unannotated, CommandLog log) throws CommandException {
        int usedConcealedTypes = 0;
        int usedCommentedTypes = 0;
        int usedConcealedMembers = 0;
        int usedCommentedMembers = 0;
        try {
            PrintWriter usedConcealedWriter = usedConcealed != null ? Uses.getPrintWriter(usedConcealed) : new PrintWriter((OutputStream)new NullPrintStream());
            PrintWriter unusedExportedWriter = unusedExported != null ? Uses.getPrintWriter(unusedExported) : new PrintWriter((OutputStream)new NullPrintStream());
            PrintWriter annotatedWriter = annotated != null ? Uses.getPrintWriter(annotated) : new PrintWriter((OutputStream)new NullPrintStream());
            PrintWriter unannotatedWriter = unannotated != null ? Uses.getPrintWriter(unannotated) : new PrintWriter((OutputStream)new NullPrintStream());
            try {
                for (ClassPathModel.Package packag : model.getPackages()) {
                    if (!packag.hasProprietaryChildren()) continue;
                    String packageComment = packag.getAccessComment();
                    for (ClassPathModel.Type type : packag.getTypes()) {
                        if (!type.isProprietary()) continue;
                        String typeName = type.getName();
                        if (!type.isSelfOrMemberExported() == type.isUsed()) {
                            PrintWriter writer = !type.isSelfOrMemberExported() ? usedConcealedWriter : unusedExportedWriter;
                            writer.print(type.isInterface() ? "INTERFACE " : "CLASS ");
                            writer.println(type.getFullName());
                        }
                        String typeComment = type.getAccessComment();
                        ClassPathModel.Type outerType = type.getOuterType();
                        while (typeComment == null) {
                            if (outerType == null) {
                                typeComment = packageComment;
                                break;
                            }
                            typeComment = outerType.getAccessComment();
                            outerType = outerType.getOuterType();
                        }
                        if (!type.isSelfOrMemberExported() && type.isUsed()) {
                            ++usedConcealedTypes;
                            if (typeComment != null) {
                                ++usedCommentedTypes;
                            }
                            PrintWriter writer = typeComment != null ? annotatedWriter : unannotatedWriter;
                            writer.print(type.isInterface() ? "INTERFACE " : "CLASS ");
                            writer.println(type.getFullName());
                        }
                        for (ClassPathModel.Member<?> member : type.getDeclaredMembers()) {
                            String memberComment;
                            if (member.isConcealed() == member.isUsed()) {
                                PrintWriter writer = member.isConcealed() ? usedConcealedWriter : unusedExportedWriter;
                                writer.print(member.getClass().getSimpleName().toUpperCase());
                                writer.print(' ');
                                writer.println(member.getFullName());
                            }
                            if ((memberComment = member.getAccessComment()) == null) {
                                memberComment = typeComment;
                            }
                            if (!member.isConcealed() || !member.isUsed()) continue;
                            ++usedConcealedMembers;
                            if (memberComment != null) {
                                ++usedCommentedMembers;
                            }
                            PrintWriter writer = memberComment != null ? annotatedWriter : unannotatedWriter;
                            writer.print(member.getClass().getSimpleName().toUpperCase());
                            writer.print(' ');
                            writer.println(member.getFullName());
                        }
                    }
                }
            }
            finally {
                usedConcealedWriter.close();
                unusedExportedWriter.close();
                annotatedWriter.close();
                unannotatedWriter.close();
            }
        }
        catch (IOException e) {
            throw new CommandException(e, "Uses file %s or %s not created: %s", usedConcealed, unusedExported, e);
        }
        log.log(CommandLog.NOTE, "comments found for %d of %d used concealed types, %d of %d used concealed members", usedCommentedTypes, usedConcealedTypes, usedCommentedMembers, usedConcealedMembers);
        int uncommentedTypes = usedConcealedTypes - usedCommentedTypes;
        int uncommentedMembers = usedConcealedMembers - usedCommentedMembers;
        if (uncommentedTypes > 0) {
            log.log(CommandLog.WARNING, "no remediation comment found for %d (of %d) used concealed types", uncommentedTypes, usedConcealedTypes);
        }
        if (uncommentedMembers > 0) {
            log.log(CommandLog.WARNING, "no remediation comment found for %d (of %d) used concealed members", uncommentedMembers, usedConcealedMembers);
        }
    }

    private static PrintWriter getPrintWriter(Path path) throws IOException {
        return new PrintWriter(Files.newBufferedWriter(path, new OpenOption[0]));
    }
}

