/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.installation;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import oracle.javatools.exports.classpath.ClassPathRoot;
import oracle.javatools.exports.command.CommandException;
import oracle.javatools.exports.command.CommandLog;
import oracle.javatools.exports.extension.Extension;
import oracle.javatools.exports.extension.ExtensionManifestReader;
import oracle.javatools.exports.file.Paths;
import oracle.javatools.exports.library.ExportLibrary;
import oracle.javatools.exports.library.ExportLibraryReader;
import oracle.javatools.exports.library.FileExportLibrary;
import oracle.javatools.exports.specification.ExportSpecificationReader;
import oracle.javatools.exports.specification.FileExportSpecification;
import org.xml.sax.SAXException;

public class Installation {
    private final Path middlewareHome;
    private final ExtensionManifestReader manifestReader;
    private final ExportSpecificationReader<? extends FileExportSpecification, ? extends FileExportSpecification.FilePackageExportSpecification, ? extends FileExportSpecification.FileTypeExportSpecification> specificationReader;
    private final CommandLog log;
    private boolean scanned;
    private boolean resolved;
    private final Map<Path, FileExportLibrary> pathToManifestLibrary = new LinkedHashMap<Path, FileExportLibrary>();
    private final Map<Path, Extension> pathToExtension = new LinkedHashMap<Path, Extension>();
    private final Map<String, Extension> idToExtension = new LinkedHashMap<String, Extension>();
    private final Map<String, FileExportLibrary> idToLibrary = new LinkedHashMap<String, FileExportLibrary>();
    private final Map<String, FileExportLibrary> syntheticIdToLibrary = new LinkedHashMap<String, FileExportLibrary>();
    private final Map<String, FileExportLibrary> nameToLibrary = new LinkedHashMap<String, FileExportLibrary>();
    private final Map<String, String> aliasToName = new LinkedHashMap<String, String>();
    private Map<String, String> macros = new HashMap<String, String>();

    public Installation(Path middlewareHome, boolean validate, CommandLog log) throws CommandException {
        this.middlewareHome = middlewareHome;
        this.specificationReader = new ClassPathRoot.AccessPolicyReader();
        this.specificationReader.setSchemaValidating(validate);
        this.specificationReader.setDomainValidating(validate);
        ExportLibraryReader libraryReader = new ExportLibraryReader();
        libraryReader.setExportSpecificationReader(this.specificationReader);
        libraryReader.setSchemaValidating(validate);
        this.manifestReader = new ExtensionManifestReader();
        this.manifestReader.setLibraryReader(libraryReader);
        this.log = log;
        if (middlewareHome == null) {
            return;
        }
        Properties properties = new Properties();
        Path macrosDir = middlewareHome.resolve("jdeveloper/ide/macros");
        if (!Files.isDirectory(macrosDir, new LinkOption[0])) {
            return;
        }
        try {
            for (Path path : Files.newDirectoryStream(macrosDir, p -> Paths.hasSuffix(p, ".properties", ".xml"))) {
                try {
                    properties.load(Files.newInputStream(path, new OpenOption[0]));
                }
                catch (IOException e) {
                    log.error("JDeveloper macros %s file not read: %s", path, e);
                }
            }
        }
        catch (IOException e) {
            throw new CommandException("JDeveloper macro directory %s not scanned: %s", macrosDir, e);
        }
        for (Map.Entry entry : properties.entrySet()) {
            String value = (String)entry.getValue();
            if (value.indexOf(44) >= 0) continue;
            if (value.startsWith("file:")) {
                value = value.substring("file:".length());
            }
            Path file = macrosDir.resolve(value);
            Path relativePath = middlewareHome.relativize(file);
            this.macros.put((String)entry.getKey(), relativePath.toString());
        }
    }

    public Path getMiddlewareHome() {
        return this.middlewareHome;
    }

    public ExtensionManifestReader getManifestReader() {
        return this.manifestReader;
    }

    public Collection<FileExportLibrary> getLibraries() {
        this.scan();
        return this.idToLibrary.values();
    }

    public FileExportLibrary findLibrary(String id) {
        this.scan();
        FileExportLibrary library = this.idToLibrary.get(id);
        if (library == null) {
            library = this.syntheticIdToLibrary.get(id);
        }
        if (library == null) {
            library = this.nameToLibrary.get(this.aliasToName.getOrDefault(id, id));
        }
        return library;
    }

    public FileExportLibrary findManifestLibrary(Path path) {
        this.scan();
        return this.pathToManifestLibrary.get(path);
    }

    public Extension findExtension(String id) {
        this.scan();
        return this.idToExtension.get(id);
    }

    public Extension findExtension(Path path) {
        this.scan();
        return this.pathToExtension.get(path);
    }

    public Extension getExtension(Object origin, Path filePath, Path manifestPath, List<String> issues) throws CommandException {
        Extension extension = this.findExtension(filePath);
        if (extension != null) {
            return extension;
        }
        try {
            return this.loadExtension(origin, filePath, manifestPath, issues);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new CommandException(e, "extension %s not read: %s", filePath, e);
        }
    }

    public ExportLibrary getManifestLibrary(Path path, List<String> issues) throws CommandException {
        FileExportLibrary library = this.findManifestLibrary(path);
        if (library != null) {
            return library;
        }
        try {
            return this.loadLibrary(path, issues);
        }
        catch (NoSuchFileException e) {
            throw new CommandException(e, "library %s not found: %s", path, e);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new CommandException(e, "library %s not read: %s", path, e);
        }
    }

    private FileExportLibrary loadLibrary(Path libraryPath, List<String> issues) throws ParserConfigurationException, SAXException, IOException {
        FileExportLibrary library = this.manifestReader.getLibraryReader().read(libraryPath, this.macros, issues);
        this.addLibrary(library, libraryPath);
        return library;
    }

    private Extension loadExtension(Object origin, Path filePath, Path manifestPath, List<String> issues) throws IOException, ParserConfigurationException, SAXException {
        String fileName = filePath.getFileName().toString();
        int dot = fileName.lastIndexOf(46);
        String id = fileName.substring(0, dot);
        Map<String, String> extensionMacros = this.macros;
        extensionMacros = new HashMap<String, String>(extensionMacros);
        extensionMacros.put("ide.extension.install.home", id);
        ArrayList<FileExportLibrary> libraries = new ArrayList<FileExportLibrary>();
        this.manifestReader.scan(manifestPath, extensionMacros, libraries, this.aliasToName, issues);
        Extension extension = new Extension(origin, id, filePath, libraries);
        Extension idPredecessor = this.idToExtension.putIfAbsent(id, extension);
        if (idPredecessor != null) {
            if (!Files.isSameFile(extension.getFilePath(), idPredecessor.getFilePath())) {
                this.log.warning(filePath, "duplicate id \"%s\" from extensions %s and %s", id, this.path(idPredecessor), this.path(extension));
            } else {
                String originPredecessor = idPredecessor.getOrigin() instanceof Path ? Paths.relativize((Path)idPredecessor.getOrigin(), this.middlewareHome) : idPredecessor.getOrigin().toString();
                String originExtension = extension.getOrigin() instanceof Path ? Paths.relativize((Path)extension.getOrigin(), this.middlewareHome) : extension.getOrigin().toString();
                this.log.warning(filePath, "duplicate extension \"%s\" at %s from bundles.info files %s and %s", id, extension.getFilePath(), originPredecessor, originExtension);
            }
            return idPredecessor;
        }
        Extension pathPredecessor = this.pathToExtension.putIfAbsent(filePath, extension);
        if (pathPredecessor != null && pathPredecessor != extension) {
            this.log.error(filePath, "duplicate path \"%s\" from extensions %s and %s", Paths.relativize(filePath, this.middlewareHome), pathPredecessor.getId(), extension.getId());
            return pathPredecessor;
        }
        for (FileExportLibrary library : libraries) {
            this.addLibrary(library, filePath);
        }
        return extension;
    }

    private String path(Extension extension) {
        return Paths.relativize(extension.getFilePath(), this.middlewareHome);
    }

    private void addLibrary(FileExportLibrary library, Path filePath) {
        ExportLibrary pathPredecessor;
        if (this.resolved) {
            ArrayList<String> issues = new ArrayList<String>();
            library.resolveDependencies(this.specificationReader, id -> this.findLibrary((String)id), issues);
            this.log.log(this.middlewareHome, issues);
        }
        String id2 = library.getId();
        FileExportLibrary idPredecessor = this.idToLibrary.putIfAbsent(id2, library);
        String syntheticId = library.getSyntheticId();
        FileExportLibrary syntheticIdPredecessor = this.syntheticIdToLibrary.putIfAbsent(syntheticId, library);
        FileExportLibrary namePredecessor = this.nameToLibrary.putIfAbsent(library.getName(), library);
        if (idPredecessor != null && idPredecessor != library) {
            this.log.warning(filePath, "duplicate id \"%s\": library \"%s\" at %s precedes \"%s\" at %s", id2, idPredecessor.getName(), this.path(idPredecessor), library.getName(), this.path(library));
        }
        if (syntheticIdPredecessor != null && syntheticIdPredecessor != library) {
            this.log.warning(filePath, "duplicate synthetic id \"%s\": library %s (\"%s\") at %s precedes %s (\"%s\") at %s", syntheticId, syntheticIdPredecessor.getId(), syntheticIdPredecessor.getName(), this.path(syntheticIdPredecessor), library.getId(), library.getName(), this.path(library));
        }
        if (namePredecessor != null && namePredecessor != library) {
            this.log.warning(filePath, "duplicate name \"%s\": library %s at %s precedes %s at %s", library.getName(), namePredecessor.getId(), this.path(namePredecessor), library.getId(), this.path(library));
        }
        if (Paths.hasSuffix(filePath, ".library") && (pathPredecessor = (ExportLibrary)this.pathToManifestLibrary.putIfAbsent(filePath, library)) != null && pathPredecessor != library) {
            this.log.error(filePath, "duplicate path \"%\": library %s (\"%s\") precedes %s (\"%s\"", Paths.relativize(filePath, this.middlewareHome), pathPredecessor.getId(), pathPredecessor.getName(), library.getId(), library.getName());
        }
    }

    private String path(FileExportLibrary library) {
        return Paths.relativize(library.getOrigin(), this.middlewareHome);
    }

    private void scan() {
        Object containerPath;
        if (this.scanned) {
            return;
        }
        this.log.progress("Scanning installation at %s for extensions and libraries", this.middlewareHome);
        this.scanned = true;
        if (this.middlewareHome == null) {
            this.resolved = true;
            return;
        }
        Path configurationDirectory = this.middlewareHome.resolve("jdeveloper/configuration");
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(configurationDirectory, "*bundles.info");){
            for (Path bundlesInfoFile : stream) {
                BufferedReader reader = Files.newBufferedReader(bundlesInfoFile);
                Throwable throwable = null;
                try {
                    try {
                        String line = reader.readLine();
                        while (line != null) {
                            block108: {
                                String[] fields = line.split(",");
                                Path extensionPath = configurationDirectory.resolve(fields[2]).normalize();
                                try {
                                    containerPath = FileSystems.newFileSystem(extensionPath, null).getPath("/", new String[0]);
                                }
                                catch (NoSuchFileException e) {
                                    this.log.error(extensionPath, "bundle %s does not exist: %s", extensionPath, e);
                                    break block108;
                                }
                                catch (FileSystemNotFoundException e) {
                                    this.log.error(extensionPath, "file %s not a bundle: %s", extensionPath, e);
                                    break block108;
                                }
                                catch (IOException e) {
                                    this.log.error(extensionPath, "bundle %s not read: %s", extensionPath, e);
                                    break block108;
                                }
                                Path manifestPath = containerPath.resolve("META-INF/extension.xml");
                                if (Files.exists(manifestPath, new LinkOption[0])) {
                                    ArrayList<String> issues = new ArrayList<String>();
                                    try {
                                        this.loadExtension(bundlesInfoFile, extensionPath, manifestPath, issues);
                                        this.log.log(extensionPath, issues);
                                    }
                                    catch (IOException | ParserConfigurationException | SAXException e) {
                                        this.log.log(extensionPath, issues);
                                        this.log.error(extensionPath, "extension %s not scanned: %s", extensionPath, e);
                                    }
                                }
                            }
                            line = reader.readLine();
                        }
                    }
                    catch (IOException e) {
                        this.log.error(bundlesInfoFile, "bundles.info file %s not scanned: %s", bundlesInfoFile, e);
                    }
                }
                catch (Throwable e) {
                    throwable = e;
                    throw e;
                }
                finally {
                    if (reader == null) continue;
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable e) {
                            throwable.addSuppressed(e);
                        }
                        continue;
                    }
                    reader.close();
                }
            }
        }
        catch (NoSuchFileException e) {
            this.log.error(configurationDirectory, "JDeveloper configuration directory %s not present", configurationDirectory);
        }
        catch (IOException e) {
            this.log.error(configurationDirectory, "JDeveloper configuration directory %s not scanned: %s", configurationDirectory, e);
        }
        long start = System.currentTimeMillis();
        try (DirectoryStream<Path> productStream = Files.newDirectoryStream(this.middlewareHome, p -> Files.isDirectory(p, new LinkOption[0]));){
            for (Path productDirectory : productStream) {
                Path productLibraryDirectory;
                Path productLibrariesDirectory;
                Path productJDeveloperDirectory = productDirectory.resolve("plugins/jdeveloper");
                Path productConfigurationDirectory = productJDeveloperDirectory.resolve("configuration");
                if (Files.isDirectory(productConfigurationDirectory, new LinkOption[0])) {
                    try {
                        DirectoryStream<Path> stream = Files.newDirectoryStream(productConfigurationDirectory, "*bundles.info");
                        containerPath = null;
                        try {
                            for (Path bundlesInfoFile : stream) {
                                BufferedReader reader = Files.newBufferedReader(bundlesInfoFile);
                                Throwable throwable = null;
                                try {
                                    try {
                                        String line = reader.readLine();
                                        while (line != null) {
                                            block110: {
                                                Path containerPath2;
                                                String[] fields = line.split(",");
                                                Path extensionPath = productConfigurationDirectory.resolve(fields[2]).normalize();
                                                try {
                                                    containerPath2 = FileSystems.newFileSystem(extensionPath, null).getPath("/", new String[0]);
                                                }
                                                catch (NoSuchFileException e) {
                                                    this.log.error(extensionPath, "bundle %s does not exist: %s", extensionPath, e);
                                                    break block110;
                                                }
                                                catch (FileSystemNotFoundException e) {
                                                    this.log.error(extensionPath, "file %s not a bundle: %s", extensionPath, e);
                                                    break block110;
                                                }
                                                catch (IOException e) {
                                                    this.log.error(extensionPath, "bundle %s not read: %s", extensionPath, e);
                                                    break block110;
                                                }
                                                Path manifestPath = containerPath2.resolve("META-INF/extension.xml");
                                                if (Files.exists(manifestPath, new LinkOption[0])) {
                                                    ArrayList<String> issues = new ArrayList<String>();
                                                    try {
                                                        this.loadExtension(bundlesInfoFile, extensionPath, manifestPath, issues);
                                                        this.log.log(extensionPath, issues);
                                                    }
                                                    catch (IOException | ParserConfigurationException | SAXException e) {
                                                        this.log.log(extensionPath, issues);
                                                        this.log.error(extensionPath, "extension %s not scanned: %s", extensionPath, e);
                                                    }
                                                }
                                            }
                                            line = reader.readLine();
                                        }
                                    }
                                    catch (IOException e) {
                                        this.log.error(bundlesInfoFile, "bundles.info file %s not scanned: %s", bundlesInfoFile, e);
                                    }
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                finally {
                                    if (reader == null) continue;
                                    if (throwable != null) {
                                        try {
                                            reader.close();
                                        }
                                        catch (Throwable throwable3) {
                                            throwable.addSuppressed(throwable3);
                                        }
                                        continue;
                                    }
                                    reader.close();
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            containerPath = throwable;
                            throw throwable;
                        }
                        finally {
                            if (stream != null) {
                                if (containerPath != null) {
                                    try {
                                        stream.close();
                                    }
                                    catch (Throwable throwable) {
                                        ((Throwable)containerPath).addSuppressed(throwable);
                                    }
                                } else {
                                    stream.close();
                                }
                            }
                        }
                    }
                    catch (IOException e) {
                        this.log.error(productConfigurationDirectory, "middleware plugin directory %s not scanned: %s", productConfigurationDirectory, e);
                    }
                }
                if (Files.isDirectory(productLibrariesDirectory = productJDeveloperDirectory.resolve("libraries"), new LinkOption[0])) {
                    try {
                        DirectoryStream<Path> libraryStream = Files.newDirectoryStream(productLibrariesDirectory, "*.library");
                        Object object = null;
                        try {
                            for (Path libraryPath : libraryStream) {
                                try {
                                    ArrayList<String> issues = new ArrayList<String>();
                                    this.loadLibrary(libraryPath, issues);
                                    this.log.log(libraryPath, issues);
                                }
                                catch (IOException | ParserConfigurationException | SAXException e) {
                                    this.log.error(libraryPath, "library %s not read: %s", libraryPath, e);
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            object = throwable;
                            throw throwable;
                        }
                        finally {
                            if (libraryStream != null) {
                                if (object != null) {
                                    try {
                                        libraryStream.close();
                                    }
                                    catch (Throwable throwable) {
                                        ((Throwable)object).addSuppressed(throwable);
                                    }
                                } else {
                                    libraryStream.close();
                                }
                            }
                        }
                    }
                    catch (IOException e) {
                        this.log.error(productLibrariesDirectory, "middleware plugin directory %s not scanned: %s", productLibrariesDirectory, e);
                    }
                }
                if (!Files.isDirectory(productLibraryDirectory = productJDeveloperDirectory.resolve("library"), new LinkOption[0])) continue;
                this.log.warning(productLibraryDirectory, "\"library\" directory in middleware plugin directory %s ignored: possibly \"libraries\" directory was intended", productJDeveloperDirectory);
            }
        }
        catch (IOException e) {
            this.log.error(this.middlewareHome, "middleware home %s plugin directories not scanned: %s", this.middlewareHome, e);
        }
        long end = System.currentTimeMillis();
        this.log.note("time to scan installation for libraries: %dms", end - start);
        for (FileExportLibrary library : this.idToLibrary.values()) {
            ArrayList<String> issues = new ArrayList<String>();
            library.resolveDependencies(this.specificationReader, id -> this.findLibrary((String)id), issues);
            this.log.log(this.middlewareHome, issues);
        }
        this.resolved = true;
    }

    public Map<String, String> getMacros() throws CommandException {
        return this.macros;
    }
}

