/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.file;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;

public class Paths {
    private Paths() {
    }

    public static Path get(String path, String ... paths) {
        return java.nio.file.Paths.get(path, paths);
    }

    public static Path get(URI path) {
        return java.nio.file.Paths.get(path);
    }

    public static boolean isJarScheme(Path path) {
        return "jar".equals(path.getFileSystem().provider().getScheme());
    }

    public static Path getParent(Path path) {
        Path parent = path.getParent();
        if (parent == null && Paths.isJarScheme(path)) {
            parent = java.nio.file.Paths.get(path.getFileSystem().toString(), new String[0]);
        }
        return parent;
    }

    public static Path getFileName(Path path) {
        Path name = path.getFileName();
        if (name == null && Paths.isJarScheme(path)) {
            name = java.nio.file.Paths.get(path.getFileSystem().toString(), new String[0]).getFileName();
        }
        return name;
    }

    public static Path getDefaultPath(Path path) {
        if (path.getFileSystem() == FileSystems.getDefault()) {
            return path;
        }
        return java.nio.file.Paths.get(path.getFileSystem().toString(), new String[0]);
    }

    public static String getFileType(Path path) {
        String name = Paths.getFileName(path).toString();
        int dot = name.lastIndexOf(46);
        return dot >= 0 ? name.substring(dot) : "";
    }

    public static boolean hasSuffix(Path path, String ... suffixes) {
        String name = Paths.getFileName(path).toString();
        for (String suffix : suffixes) {
            if (!name.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public static URL toUrl(Path path) {
        if (Paths.isJarScheme(path)) {
            String entry = path.toString();
            if (entry.charAt(0) == '/') {
                entry = entry.substring(1);
            }
            return URLFactory.newJarURL((File)new File(path.getFileSystem().toString()), (String)entry);
        }
        return URLFactory.newFileURL((File)path.toFile());
    }

    public static String toString(Path path) {
        if (path == null) {
            return "null";
        }
        if (Paths.isJarScheme(path)) {
            String entry = path.toString();
            if (!entry.isEmpty()) {
                entry = "!" + entry;
            }
            return path.getFileSystem().toString() + entry;
        }
        return path.toString();
    }

    public static String relativize(Path path, Path basePath) {
        if (basePath == null) {
            return Paths.toString(path);
        }
        Path filePath = path;
        String entry = "";
        if (Paths.isJarScheme(path)) {
            entry = path.getNameCount() > 0 ? "!" + path : "";
            filePath = Paths.get(path.getFileSystem().toString(), new String[0]);
        }
        try {
            String relativePath = basePath.relativize(filePath) + entry;
            return relativePath;
        }
        catch (IllegalArgumentException e) {
            return Paths.toString(path);
        }
    }

    public static String relativize(URL path, Path basePath) {
        if (basePath == null) {
            return URLFileSystem.getPlatformPathName((URL)path);
        }
        URL baseUrl = URLFactory.newDirURL((String)basePath.toString());
        URL url = path;
        String entry = "";
        if (JarUtil.isJarURL((URL)url)) {
            entry = JarUtil.getJarEntry((URL)url);
            if (!entry.isEmpty()) {
                entry = '!' + entry;
            }
            url = JarUtil.getJarFileURL((URL)url);
        }
        String relativePath = URLFileSystem.toRelativeSpec((URL)url, (URL)baseUrl) + entry;
        return relativePath;
    }

    public static boolean isUpToDate(Path targetPath, long granularity, Path ... sourcePaths) {
        try {
            long limit = Files.getLastModifiedTime(targetPath, new LinkOption[0]).toMillis() + granularity;
            for (Path path : sourcePaths) {
                if (path == null || Files.getLastModifiedTime(path, new LinkOption[0]).toMillis() <= limit) continue;
                return false;
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }
}

