/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.comment;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class CommentModel
extends DefaultHandler {
    private final SAXParser parser;

    public CommentModel() throws ParserConfigurationException, SAXException {
        this(null);
    }

    public CommentModel(InputStream schema) throws ParserConfigurationException, SAXException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        if (schema != null) {
            factory.setNamespaceAware(true);
            factory.setValidating(true);
            this.parser = factory.newSAXParser();
            String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
            String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
            String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
            this.parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            this.parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaSource", schema);
        } else {
            this.parser = factory.newSAXParser();
        }
    }

    public Map<String, String> create(Path commentsPath, List<String> issues) throws SAXException, IOException {
        try (InputStream commentsStream = Files.newInputStream(commentsPath, new OpenOption[0]);){
            Map<String, String> map = this.create(commentsPath.toString(), commentsStream, issues);
            return map;
        }
    }

    public Map<String, String> create(String commentsName, InputStream commentsStream, List<String> issues) throws SAXException, IOException {
        if (commentsStream == null) {
            throw new IOException("null input stream for " + commentsName);
        }
        Collector collector = new Collector(commentsName, issues);
        this.parser.parse(commentsStream, (DefaultHandler)collector);
        return collector.getComments();
    }

    private static class Collector
    extends DefaultHandler {
        private Map<String, String> comments = new LinkedHashMap<String, String>();
        private List<String> validationIssues;
        private Locator locator;
        private String fileName;
        private int line;
        private int column;

        public Collector(String fileName, List<String> validationIssues) {
            this.validationIssues = validationIssues;
            this.fileName = fileName;
            this.column = 0;
            this.line = 0;
        }

        public Map<String, String> getComments() {
            return this.comments;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qualifiedName, Attributes attributes) throws SAXException {
            if (this.locator != null) {
                this.line = this.locator.getLineNumber();
                this.column = this.locator.getColumnNumber();
            }
            switch (qualifiedName) {
                case "lib-comments": {
                    assert (this.comments != null);
                    break;
                }
                case "comment": {
                    String predecessor;
                    String name = attributes.getValue("name");
                    String comment = attributes.getValue("comment");
                    if (name == null) {
                        throw new LocatorSAXException("name attribute required" + this.at());
                    }
                    if (comment == null) {
                        comment = "";
                    }
                    if ((predecessor = this.comments.putIfAbsent(name, comment)) == null || this.validationIssues == null) break;
                    this.validationIssues.add("Warning: duplicate comment for " + name + this.at());
                    break;
                }
                default: {
                    throw new LocatorSAXException("unexpected element name " + qualifiedName + this.at());
                }
            }
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            this.validationIssues.add("Warning: " + e.getMessage() + " (" + this.fileName + ":" + e.getLineNumber());
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            this.validationIssues.add("Error:   " + e.getMessage() + " (" + this.fileName + ":" + e.getLineNumber());
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        String at() {
            return " ( " + this.fileName + ", line " + this.line + ", column " + this.column + ')';
        }

        private static class LocatorSAXException
        extends SAXException {
            public LocatorSAXException(String message) {
                super(message);
            }

            public LocatorSAXException(Exception e) {
                super(e);
            }

            public LocatorSAXException(String message, Exception e) {
                super(message, e);
            }
        }
    }
}

