/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.ant;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.exports.ant.ExtensionResource;
import oracle.javatools.exports.ant.InstallationResource;
import oracle.javatools.exports.ant.LibraryResource;
import oracle.javatools.exports.command.ClassesSource;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;

public class LibraryList
extends Path {
    private List<ClassesSource> list;

    public LibraryList(Project project) {
        super(project);
    }

    public void addExtension(ExtensionResource library) {
        this.add((ResourceCollection)library);
    }

    public void addLibrary(LibraryResource library) {
        this.add((ResourceCollection)library);
    }

    public void addInstallation(InstallationResource installation) {
        this.add((ResourceCollection)installation);
    }

    public List<ClassesSource> asList() {
        if (this.list == null) {
            this.list = new ArrayList<ClassesSource>();
            Iterator i = this.iterator();
            while (i.hasNext()) {
                java.nio.file.Path path;
                FileResource r;
                Resource resource = (Resource)i.next();
                if (resource instanceof InstallationResource) {
                    this.list.add(new ClassesSource());
                    continue;
                }
                if (resource instanceof ExtensionResource) {
                    r = (ExtensionResource)resource;
                    path = r.getFile() != null ? r.getFile().toPath() : null;
                    this.list.add(new ClassesSource(path, r.getId(), ClassesSource.Type.EXTENSION));
                    continue;
                }
                if (resource instanceof LibraryResource) {
                    r = (LibraryResource)resource;
                    path = r.getFile() != null ? r.getFile().toPath() : null;
                    this.list.add(new ClassesSource(path, r.getId(), ClassesSource.Type.LIBRARY));
                    continue;
                }
                if (resource instanceof FileResource) {
                    r = (FileResource)resource;
                    path = r.getFile() != null ? r.getFile().toPath() : null;
                    this.list.add(new ClassesSource(path, ClassesSource.Type.UNKNOWN));
                    continue;
                }
                throw new BuildException("Resource " + resource + " is not a file resource", resource.getLocation());
            }
        }
        return this.list;
    }
}

