/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.exports.ant;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import oracle.javatools.exports.ant.ExtensionResource;
import oracle.javatools.exports.ant.InstallationResource;
import oracle.javatools.exports.ant.LibraryList;
import oracle.javatools.exports.ant.LibraryResource;
import oracle.javatools.exports.ant.PathList;
import oracle.javatools.exports.command.ClassesSource;
import oracle.javatools.exports.command.Command;
import oracle.javatools.exports.command.CommandException;
import oracle.javatools.exports.command.CommandInterface;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class ExportTask
extends Task {
    private CommandInterface.Operation operation;
    private boolean validating = true;
    private boolean uses;
    private String owner;
    private List<String> consumers = Collections.emptyList();
    private java.nio.file.Path domainFile;
    private java.nio.file.Path middlewareHome;
    private PathList classPath = new PathList(this.getProject());
    private LibraryList libraries = new LibraryList(this.getProject());
    private boolean failOnClassPathError = true;
    private LibraryList dependencies = new LibraryList(this.getProject());
    private PathList baselines = new PathList(this.getProject());
    private PathList bootClassPath = new PathList(this.getProject());
    private java.nio.file.Path outputDirectory;
    private EnumSet<CommandInterface.Output> output;
    private EnumSet<CommandInterface.Output> noOutput;
    private String libraryName;
    private String libraryId;
    private String libraryDescription;
    private java.nio.file.Path addedFile;
    private java.nio.file.Path baselineFile;
    private java.nio.file.Path commentsFile;
    private java.nio.file.Path concealedFile;
    private java.nio.file.Path exportedFile;
    private java.nio.file.Path exportsFile;
    private java.nio.file.Path issuesFile;
    private java.nio.file.Path librariesFile;
    private java.nio.file.Path libraryFile;
    private java.nio.file.Path problemsFile;
    private java.nio.file.Path removedFile;
    private java.nio.file.Path unusedExportedFile;
    private java.nio.file.Path usedCommentedFile;
    private java.nio.file.Path usedConcealedFile;
    private java.nio.file.Path usedUncommentedFile;

    public void setValidate(boolean validate) {
        this.validating = validate;
    }

    public void setUses(boolean uses) {
        this.uses = uses;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setConsumers(String names) {
        this.consumers = new ArrayList<String>();
        for (String consumer : names.split(",")) {
            this.consumers.add(consumer.trim());
        }
        Collections.sort(this.consumers);
    }

    public void setDomainFile(File file) {
        this.domainFile = file.toPath();
    }

    public void setMiddlewareHome(File directory) {
        this.middlewareHome = directory.toPath();
    }

    public Path createClassPath() {
        return this.classPath;
    }

    public void setClassPathRef(Reference reference) {
        this.createClassPath().setRefid(reference);
    }

    public Path createAnnotatedClassPath() {
        return this.classPath;
    }

    public void setAnnotatedClassPathRef(Reference reference) {
        this.createClassPath().setRefid(reference);
    }

    public LibraryList createLibraries() {
        return this.libraries;
    }

    public void setLibrariesRef(Reference reference) {
        this.createLibraries().setRefid(reference);
    }

    public void setFailOnClassPathError(boolean failOnClassPathError) {
        this.failOnClassPathError = failOnClassPathError;
    }

    public void addInstallation(InstallationResource installation) {
        this.createLibraries().addInstallation(installation);
    }

    public void addExtension(ExtensionResource library) {
        this.createLibraries().addExtension(library);
    }

    public void addLibrary(LibraryResource library) {
        this.createLibraries().addLibrary(library);
    }

    public Path createBaselines() {
        return this.baselines;
    }

    public void setBaselinesRef(Reference reference) {
        this.createBaselines().setRefid(reference);
    }

    public void setDependencies(Path classpath) {
        this.createDependencies().add(classpath);
    }

    public LibraryList createDependencies() {
        return this.dependencies;
    }

    public void setDependenciesRef(Reference reference) {
        this.createDependencies().setRefid(reference);
    }

    public void setBootClasspath(Path classpath) {
        this.createBootClasspath().append(classpath);
    }

    public void setBootClassPathRef(Reference reference) {
        this.createBootClasspath().setRefid(reference);
    }

    public Path createBootClasspath() {
        return this.bootClassPath;
    }

    public void setOutputDir(File outputDirectory) {
        this.outputDirectory = outputDirectory.toPath();
    }

    public void setOutput(String text) {
        if (this.noOutput != null) {
            throw new BuildException("output attribute conflicts with nooutput attribute");
        }
        this.setOutput(text, true);
    }

    public void setNoOutput(String text) {
        if (this.noOutput != null) {
            throw new BuildException("nooutput attribute conflicts with output attribute");
        }
        this.setOutput(text, true);
    }

    private void setOutput(String text, boolean negated) {
        CommandInterface.Output[] enumerals = CommandInterface.Output.values();
        ArrayList<String> names = new ArrayList<String>(enumerals.length);
        for (CommandInterface.Output type : enumerals) {
            names.add(type.getTypeName());
        }
        EnumSet<CommandInterface.Output> types = EnumSet.noneOf(CommandInterface.Output.class);
        for (String name : text.split(",")) {
            name = name.trim().toLowerCase();
            int index = names.indexOf(name = name.replaceAll("-", ""));
            if (index < 0) {
                throw new BuildException("Invalid output type \"" + name + "\" not one of " + names);
            }
            types.add(enumerals[index]);
        }
        if (negated) {
            this.noOutput = types;
        } else {
            this.output = types;
        }
    }

    public void setLibraryName(String libraryName) {
        this.libraryName = libraryName;
    }

    public void setLibraryId(String libraryId) {
        this.libraryId = libraryId;
    }

    public void setLibraryDescription(String libraryDescription) {
        this.libraryDescription = libraryDescription;
    }

    public void setAddedFile(java.nio.file.Path file) {
        this.addedFile = file;
    }

    public void setBaselineFile(java.nio.file.Path file) {
        this.baselineFile = file;
    }

    public void setCommentsFile(File file) {
        this.commentsFile = file.toPath();
    }

    public void setConcealedFile(File file) {
        this.concealedFile = file.toPath();
    }

    public void setConcealedSignaturesFile(File file) {
        this.concealedFile = file.toPath();
    }

    public void setExportedFile(File file) {
        this.exportedFile = file.toPath();
    }

    public void setExportsFile(File file) {
        this.exportsFile = file.toPath();
    }

    public void setExportedSignaturesFile(File file) {
        this.exportedFile = file.toPath();
    }

    public void setIssuesFile(File file) {
        this.issuesFile = file.toPath();
    }

    public void setLibrariesFile(File file) {
        this.librariesFile = file.toPath();
    }

    public void setLibraryFile(File file) {
        this.libraryFile = file.toPath();
    }

    public void setProblemsFile(File file) {
        this.problemsFile = file.toPath();
    }

    public void setProblemTypesFile(File file) {
        this.problemsFile = file.toPath();
    }

    public void setRemovedFile(File file) {
        this.removedFile = file.toPath();
    }

    public void setUnusedExportedFile(File file) {
        this.unusedExportedFile = file.toPath();
    }

    public void setUnusedExportedSignaturesFile(File file) {
        this.unusedExportedFile = file.toPath();
    }

    public void setUsedCommentedFile(File file) {
        this.usedCommentedFile = file.toPath();
    }

    public void setUsedConcealedAnnotatedFile(File file) {
        this.usedCommentedFile = file.toPath();
    }

    public void setUsedConcealedFile(File file) {
        this.usedConcealedFile = file.toPath();
    }

    public void setUsedConcealedSignaturesFile(File file) {
        this.usedConcealedFile = file.toPath();
    }

    public void setUsedUncommentedFile(File file) {
        this.usedUncommentedFile = file.toPath();
    }

    public void setUsedConcealedUnannotatedFile(File file) {
        this.usedUncommentedFile = file.toPath();
    }

    public void execute() {
        this.operation = this.getTaskName().contains("generate") ? CommandInterface.Operation.GENERATE : (this.getTaskName().contains("analyze") ? CommandInterface.Operation.ANALYZE : (this.getTaskName().contains("analyse") ? CommandInterface.Operation.ANALYZE : (this.getTaskName().contains("merge") ? CommandInterface.Operation.MERGE : (this.getTaskName().contains("capture") ? CommandInterface.Operation.CAPTURE : (this.getTaskName().contains("compare") ? CommandInterface.Operation.COMPARE : CommandInterface.Operation.ANALYZE)))));
        UserInterface ui = new UserInterface();
        EnumSet<CommandInterface.Output> defaultOutput = this.operation.getDefaults();
        if (this.uses) {
            if (this.operation.getAllowed().contains((Object)CommandInterface.Output.USED_CONCEALED)) {
                defaultOutput.addAll(EnumSet.of(CommandInterface.Output.UNUSED_EXPORTED, CommandInterface.Output.USED_CONCEALED, CommandInterface.Output.USED_COMMENTED, CommandInterface.Output.USED_UNCOMMENTED));
            } else {
                throw new BuildException("<" + this.getTaskName() + "> prohibits the uses attribute");
            }
        }
        switch (ui.getOperation()) {
            case GENERATE: {
                if (!ui.getClassPath().isEmpty()) break;
                throw new BuildException("<generate> task requires classpth attribute or element");
            }
            case ANALYZE: 
            case MERGE: 
            case CAPTURE: {
                if (ui.getClassPath().isEmpty()) break;
                throw new BuildException("<" + ui.getOperation().toString().toLowerCase() + "> task does not allow classpath attribute or element");
            }
            case COMPARE: {
                if (this.baselines.asList().size() == 2) break;
                throw new BuildException("<baselines> must supply exactly two baseline files");
            }
        }
        boolean outputDirectoryNeeded = false;
        for (CommandInterface.Output type : (CommandInterface.Output[])CommandInterface.Output.class.getEnumConstants()) {
            try {
                Field field = ((Object)((Object)this)).getClass().getDeclaredField(type.getPropertyName());
                field.setAccessible(true);
                Object value = field.get((Object)this);
                if (value != null && this.noOutput != null && this.noOutput.contains((Object)type)) {
                    throw new BuildException("no" + type.getTypeName() + " output conflicts with " + type.getPropertyName() + " attribute value");
                }
                if (value != null || !(this.output != null ? this.output.contains((Object)type) : defaultOutput.contains((Object)type)) || this.noOutput != null && this.noOutput.contains((Object)type)) continue;
                outputDirectoryNeeded = true;
                if (this.outputDirectory == null) {
                    throw new BuildException("outputdir attribute required to create default path for " + type.getTypeName());
                }
                field.set((Object)this, this.outputDirectory.resolve(type.getFileName()));
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new BuildException("Field " + type.getPropertyName() + " for output type \"" + type.getTypeName() + "\" not introspected: " + e, (Throwable)e);
            }
        }
        if (!outputDirectoryNeeded) {
            this.outputDirectory = null;
        }
        try {
            Command.execute(ui);
        }
        catch (CommandException e) {
            throw new BuildException(e.getMessage(), (Throwable)e);
        }
    }

    private class UserInterface
    implements CommandInterface {
        private UserInterface() {
        }

        @Override
        public CommandInterface.Operation getOperation() {
            return ExportTask.this.operation;
        }

        @Override
        public boolean isValidating() {
            return ExportTask.this.validating;
        }

        @Override
        public String getOwner() {
            return ExportTask.this.owner;
        }

        @Override
        public List<String> getConsumers() {
            return ExportTask.this.consumers;
        }

        @Override
        public java.nio.file.Path getDomainFile() {
            return ExportTask.this.domainFile;
        }

        @Override
        public List<java.nio.file.Path> getClassPath() {
            return ExportTask.this.classPath.asList();
        }

        @Override
        public boolean isFailOnClassPathError() {
            return ExportTask.this.failOnClassPathError;
        }

        @Override
        public List<ClassesSource> getLibraries() {
            return ExportTask.this.libraries.asList();
        }

        @Override
        public java.nio.file.Path getMiddlewareHome() {
            return ExportTask.this.middlewareHome;
        }

        @Override
        public List<ClassesSource> getDependencies() {
            return ExportTask.this.dependencies.asList();
        }

        @Override
        public java.nio.file.Path getBaseline0() {
            List<java.nio.file.Path> paths = ExportTask.this.baselines.asList();
            return paths.size() > 0 ? paths.get(0) : null;
        }

        @Override
        public java.nio.file.Path getBaseline1() {
            List<java.nio.file.Path> paths = ExportTask.this.baselines.asList();
            return paths.size() > 1 ? paths.get(1) : null;
        }

        @Override
        public List<java.nio.file.Path> getBootClassPath() {
            return ExportTask.this.bootClassPath.asList();
        }

        @Override
        public String getLibraryName() {
            return ExportTask.this.libraryName;
        }

        @Override
        public String getLibraryId() {
            return ExportTask.this.libraryId;
        }

        @Override
        public String getLibraryDescription() {
            return ExportTask.this.libraryDescription;
        }

        @Override
        public java.nio.file.Path getOutputDirectory() {
            return ExportTask.this.outputDirectory;
        }

        @Override
        public java.nio.file.Path getAddedFile() {
            return ExportTask.this.addedFile;
        }

        @Override
        public java.nio.file.Path getBaselineFile() {
            return ExportTask.this.baselineFile;
        }

        @Override
        public java.nio.file.Path getCommentsFile() {
            return ExportTask.this.commentsFile;
        }

        @Override
        public java.nio.file.Path getConcealedFile() {
            return ExportTask.this.concealedFile;
        }

        @Override
        public java.nio.file.Path getExportedFile() {
            return ExportTask.this.exportedFile;
        }

        @Override
        public java.nio.file.Path getExportsFile() {
            return ExportTask.this.exportsFile;
        }

        @Override
        public java.nio.file.Path getIssuesFile() {
            return ExportTask.this.issuesFile;
        }

        @Override
        public java.nio.file.Path getLibraryFile() {
            return ExportTask.this.libraryFile;
        }

        @Override
        public java.nio.file.Path getLibrariesFile() {
            return ExportTask.this.librariesFile;
        }

        @Override
        public java.nio.file.Path getProblemsFile() {
            return ExportTask.this.problemsFile;
        }

        @Override
        public java.nio.file.Path getRemovedFile() {
            return ExportTask.this.removedFile;
        }

        @Override
        public java.nio.file.Path getUnusedExportedFile() {
            return ExportTask.this.unusedExportedFile;
        }

        @Override
        public java.nio.file.Path getUsedCommentedFile() {
            return ExportTask.this.usedCommentedFile;
        }

        @Override
        public java.nio.file.Path getUsedConcealedFile() {
            return ExportTask.this.usedConcealedFile;
        }

        @Override
        public java.nio.file.Path getUsedUncommentedFile() {
            return ExportTask.this.usedUncommentedFile;
        }

        @Override
        public void error(String message, Object ... arguments) {
            ExportTask.this.getProject().log(String.format(message, arguments), 0);
        }

        @Override
        public void warning(String message, Object ... arguments) {
            ExportTask.this.getProject().log(String.format(message, arguments), 1);
        }

        @Override
        public void note(String message, Object ... arguments) {
            ExportTask.this.getProject().log(String.format(message, arguments), 2);
        }

        @Override
        public void coarse(String message, Object ... arguments) {
            ExportTask.this.getProject().log(String.format(message, arguments), 3);
        }

        @Override
        public void fine(String message, Object ... arguments) {
            ExportTask.this.getProject().log(String.format(message, arguments), 4);
        }

        @Override
        public String parameter(String name) {
            return "<" + name + "> element";
        }

        @Override
        public String option(String name) {
            return name + " attribute";
        }

        @Override
        public String output(CommandInterface.Output output) {
            return "\"" + output.getTypeName() + "\" in output attribute, or " + output.getTypeName() + "file attribute";
        }

        @Override
        public String libraryOrExtension(String libraryId, String extensionId) {
            return "<library id=\"" + libraryId + "\"/> or <extension id=\"" + extensionId + "\">";
        }
    }
}

