/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.autorest.ui.JEditorPaneScrollPaneWrapper;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.model.RestModule;
import oracle.dbtools.rest.model.RestResourceHandler;
import oracle.dbtools.rest.model.RestTemplate;
import oracle.dbtools.rest.utils.RestUtils;
import oracle.javatools.icons.OracleIcons;

public class RestSummaryTabPanel
extends JPanel {
    private BorderLayout borderLayout1 = new BorderLayout();
    private JTabbedPane summaryTabbedPane = new JTabbedPane();
    private JScrollPane summaryScrollPane = new JScrollPane();
    private JTree summaryTree = new JTree();
    private JEditorPaneScrollPaneWrapper sqlEditorPane = null;

    public RestSummaryTabPanel(RestModule restModule, RestTemplate restTemplate, RestResourceHandler restResourceHandler, JEditorPaneScrollPaneWrapper jEditorPaneScrollPaneWrapper) {
        this.sqlEditorPane = jEditorPaneScrollPaneWrapper;
        this.buildSummaryTree(restModule, restTemplate, restResourceHandler);
        this.setUpTabs();
    }

    private void setUpTabs() {
        this.setLayout(this.borderLayout1);
        this.setName("RestSchemaSummaryPanel");
        this.summaryTabbedPane.setName("summaryTabbedPane");
        this.summaryScrollPane.setName("summaryScrollPane");
        this.summaryTree.setName("summaryTree");
        this.sqlEditorPane.setName("sqlEditorPane");
        this.summaryTree.setCellRenderer(new NodeRenderer());
        this.summaryScrollPane.getViewport().add(this.summaryTree);
        this.summaryTabbedPane.addTab(RestArb.getString("WIZ_TAB_SUMMARY"), this.summaryScrollPane);
        this.summaryTabbedPane.addTab(RestArb.getString("WIZ_TAB_SQL"), this.sqlEditorPane);
        this.add((Component)this.summaryTabbedPane, "Center");
    }

    public void setSqlEditorCode(String string) {
        if (!this.sqlEditorPane.isEditable()) {
            this.sqlEditorPane.setEditable(true);
            this.sqlEditorPane.setText(string);
            this.sqlEditorPane.setEditable(false);
        } else {
            this.sqlEditorPane.setText(string);
        }
    }

    public void buildSummaryTree(RestModule restModule, RestTemplate restTemplate, RestResourceHandler restResourceHandler) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        DefaultMutableTreeNode defaultMutableTreeNode2;
        this.summaryTree.removeAll();
        DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(RestArb.getString("WIZ_SUMMARY_ROOT"));
        DefaultMutableTreeNode defaultMutableTreeNode4 = this.getModuleSummaryNode(restModule);
        if (defaultMutableTreeNode4 != null) {
            defaultMutableTreeNode3.add(defaultMutableTreeNode4);
        }
        if ((defaultMutableTreeNode2 = this.getTemplateSummaryNode(restTemplate)) != null) {
            defaultMutableTreeNode3.add(defaultMutableTreeNode2);
        }
        if ((defaultMutableTreeNode = this.getHandlerSummaryNode(restResourceHandler)) != null) {
            defaultMutableTreeNode3.add(defaultMutableTreeNode);
        }
        this.summaryTree.setModel(new DefaultTreeModel(defaultMutableTreeNode3));
        if (defaultMutableTreeNode4 != null) {
            this.summaryTree.expandPath(new TreePath(defaultMutableTreeNode4.getPath()));
        }
        if (defaultMutableTreeNode2 != null) {
            this.summaryTree.expandPath(new TreePath(defaultMutableTreeNode2.getPath()));
        }
        if (defaultMutableTreeNode != null) {
            this.summaryTree.expandPath(new TreePath(defaultMutableTreeNode.getPath()));
        }
    }

    private DefaultMutableTreeNode getModuleSummaryNode(RestModule restModule) {
        if (restModule == null) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(RestArb.getString("LABEL_MODULE"));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(StringUtils.stripMnemonic((String)RestArb.getString("MODULE_NAME")), restModule.getName())));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(StringUtils.stripMnemonic((String)RestArb.getString("URI_PATTERN")), restModule.getURIPrefix())));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.getLabel(StringUtils.stripMnemonic((String)RestArb.getString("PUBLISH")), restModule.isPublished())));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(StringUtils.stripMnemonic((String)RestArb.getString("PAGINATION_SIZE")), Long.toString(restModule.getPaginationSize()))));
        List list = restModule.getOrigins();
        if (list != null && !list.isEmpty()) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(RestArb.getString("ORIGINS_ALLOWED"));
            for (String string : restModule.getOrigins()) {
                defaultMutableTreeNode2.add(new DefaultMutableTreeNode(this.getLabel(string)));
            }
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        } else {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(RestArb.getString("WIZ_ORIGINS_NONE")));
        }
        return defaultMutableTreeNode;
    }

    private DefaultMutableTreeNode getTemplateSummaryNode(RestTemplate restTemplate) {
        if (restTemplate == null) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(RestArb.getString("LABEL_TEMPLATE"));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(StringUtils.stripMnemonic((String)RestArb.getString("URI_PREFIX")), restTemplate.getURIPattern())));
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(StringUtils.stripMnemonic((String)RestArb.getString("PRIORITY")), Long.toString(restTemplate.getPriority()))));
        if (restTemplate.getEntityTag() == RestTemplate.ENTITY_TAG_TYPE.QUERY) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(this.format(StringUtils.stripMnemonic((String)RestArb.getString("ENTITY_TAG")), restTemplate.getEntityTag().getNLS()));
            defaultMutableTreeNode2.add(new DefaultMutableTreeNode(this.getLabel(restTemplate.getEntityTagQuery())));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        } else {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(StringUtils.stripMnemonic((String)RestArb.getString("ENTITY_TAG")), restTemplate.getEntityTag().getNLS())));
        }
        return defaultMutableTreeNode;
    }

    private DefaultMutableTreeNode getHandlerSummaryNode(RestResourceHandler restResourceHandler) {
        if (restResourceHandler == null) {
            return null;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(RestArb.getString("LABEL_RESOURCE_HANDLER"));
        switch (restResourceHandler.getMethodType()) {
            case GET: {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(RestArb.getString("METHOD"), RestArb.getString("GET_NODE"))));
                break;
            }
            case POST: {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(RestArb.getString("METHOD"), RestArb.getString("POST_NODE"))));
                break;
            }
            case PUT: {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(RestArb.getString("METHOD"), RestArb.getString("PUT_NODE"))));
                break;
            }
            case DELETE: {
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(RestArb.getString("METHOD"), RestArb.getString("DELETE_NODE"))));
            }
        }
        if (RestUtils.isAPEXRestfulServices()) {
            defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.getLabel(StringUtils.stripMnemonic((String)RestArb.getString("SECURE_ACCESS")), restResourceHandler.isSecuredAccess())));
        }
        defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(StringUtils.stripMnemonic((String)RestArb.getString("SOURCE_TYPE")), restResourceHandler.getSourceType().getNLS())));
        switch (restResourceHandler.getMethodType()) {
            case GET: {
                String string = null;
                string = restResourceHandler.getSourceType() == RestResourceHandler.SOURCE_TYPE.MEDIA_RESOURCE ? RestArb.getString("FORMAT_BINARY") : restResourceHandler.getFormatType().getNLS();
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(StringUtils.stripMnemonic((String)RestArb.getString("DATA_FORMAT")), string)));
                if (restResourceHandler.getSourceType() == null || restResourceHandler.getSourceType() == RestResourceHandler.SOURCE_TYPE.QUERY_ONE_ROW) break;
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.format(StringUtils.stripMnemonic((String)RestArb.getString("PAGINATION_SIZE")), Long.toString(restResourceHandler.getPaginationSize()))));
                break;
            }
            case POST: 
            case PUT: {
                List list = restResourceHandler.getMimeTypes();
                if (list == null || list.isEmpty()) break;
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(RestArb.getString("MIME_TYPES"));
                for (String string : list) {
                    defaultMutableTreeNode2.add(new DefaultMutableTreeNode(this.getLabel(string)));
                }
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                break;
            }
        }
        return defaultMutableTreeNode;
    }

    public JLabel getLabel(String string, boolean bl) {
        JLabel jLabel = new JLabel();
        jLabel.setText(string);
        if (bl) {
            jLabel.setIcon(OracleIcons.getIcon((String)"check.png"));
        } else {
            jLabel.setIcon(OracleIcons.getIcon((String)"delete.png"));
        }
        return jLabel;
    }

    public JLabel getLabel(String string) {
        JLabel jLabel = new JLabel();
        String string2 = string != null ? string : "";
        jLabel.setText(string2);
        return jLabel;
    }

    private String format(String string, String string2) {
        return string + " " + string2;
    }

    public class NodeRenderer
    extends DefaultTreeCellRenderer {
        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (object2 instanceof String) {
                jLabel.setText((String)object2);
                if (bl3) {
                    jLabel.setIcon(OracleIcons.getIcon((String)"attribute.png"));
                }
                return jLabel;
            }
            return (Component)object2;
        }
    }
}

