/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.utils;

import java.awt.Component;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.navigator.db.model.DBChildInstance;
import oracle.dbtools.raptor.navigator.db.model.DBFolderInstance;
import oracle.dbtools.raptor.navigator.db.model.DBObjectInstance;
import oracle.dbtools.raptor.navigator.impl.ObjectFolder;
import oracle.dbtools.raptor.navigator.model.NavigatorTreeNode;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.export.RestExport;
import oracle.dbtools.rest.model.RestModule;
import oracle.dbtools.rest.model.RestPrivilege;
import oracle.dbtools.rest.model.RestSchema;
import oracle.dbtools.rest.ui.RestExportDialog;
import oracle.dbtools.rest.utils.RestLoadData;
import oracle.dbtools.rest.utils.RestUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ProductInformation;
import oracle.ide.Version;
import oracle.ide.db.model.SqlNode;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.javatools.dialogs.MessageDialog;

public class RestExportDefinitions {
    private static final int MAX_AUTO_OPEN_SIZE = 500000;
    private boolean _includeEnableSchema;
    private boolean _includePrivileges;
    private boolean _includeModules;
    private String _fullCode;
    private String _fileName;
    private String _encoding;
    private String _objectType;
    private String _objectName;
    private String _schemaName;
    private String _ordsSchemaVer;
    private int _dbVer = 12;

    public static void exportREST(Context context, RestSchema restSchema) {
        new RestExportDefinitions().export(context, restSchema);
    }

    private void export(Context context, RestSchema restSchema) {
        DBObject dBObject = (DBObject)context.getProperty("ObjectAction.DBOBJECT");
        if (dBObject != null && !RestUtils.emptyValue(dBObject.getObjectType())) {
            this._objectType = dBObject.getObjectType();
            this._objectName = dBObject.getObjectName();
            String string = dBObject.getDBVersion();
            if (!RestUtils.nullOrEmpty(string) && string.startsWith("11")) {
                this._dbVer = 11;
            }
            if (restSchema != null) {
                this._schemaName = restSchema.getSchemaName();
                this._ordsSchemaVer = restSchema.getOrdsSchemaVersion();
            }
            if (this.showExportDialog(this._objectType, this._objectName)) {
                switch (this._objectType) {
                    case "REST_MODULE_FOLDER": {
                        this.exportAllModules(context, restSchema);
                        break;
                    }
                    case "REST_MODULE": {
                        this.exportModule(context, restSchema);
                        break;
                    }
                    case "REST_PRIVILEGE_FOLDER": {
                        this.exportAllPrivileges(context, restSchema);
                        break;
                    }
                    case "REST_PRIVILEGE": {
                        this.exportPrivilege(context, restSchema);
                        break;
                    }
                    case "REST_ROLE_FOLDER": {
                        this.exportAllRoles(context, restSchema);
                        break;
                    }
                    case "REST_ROLE": {
                        this.exportRole(context, restSchema);
                        break;
                    }
                }
            }
        } else {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Cannot get the object type from DBObject.");
        }
    }

    private void exportAllModules(Context context, RestSchema restSchema) {
        List<RestModule> list;
        NavigatorTreeNode navigatorTreeNode = RestUtils.findTreeNode(context);
        if (navigatorTreeNode != null && navigatorTreeNode.getElement() instanceof ObjectFolder && (list = this.getModuleList(navigatorTreeNode, null)) != null && !list.isEmpty()) {
            NavigatorTreeNode navigatorTreeNode2;
            List<Object> list2 = new ArrayList();
            ArrayList<RestPrivilege> arrayList = new ArrayList<RestPrivilege>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            if (this._includePrivileges && (navigatorTreeNode2 = (NavigatorTreeNode)navigatorTreeNode.getParent()) != null) {
                for (RestModule restModule : list) {
                    List<RestPrivilege> list3 = this.getModulePrivileges(navigatorTreeNode2, restModule.getName());
                    if (list3 == null || list3.isEmpty()) continue;
                    for (RestPrivilege restPrivilege : list3) {
                        if (arrayList2.contains(restPrivilege.getName())) continue;
                        arrayList.add(restPrivilege);
                        arrayList2.add(restPrivilege.getName());
                    }
                }
                list2 = this.exportPrivilegeRoles(navigatorTreeNode2, arrayList);
            }
            navigatorTreeNode2 = new RestExport(ProductInformation.getProductInformation().getName(), Version.VER_FULL, this._schemaName, this._ordsSchemaVer, this._dbVer);
            this._fullCode = navigatorTreeNode2.exportModulesRolesPrivileges((RestSchema)(this._includeEnableSchema ? restSchema : null), list, list2, arrayList);
            if (this.saveFile() && this.isOpenScriptInEditor()) {
                this.showScriptInEditor();
            }
        }
    }

    private void exportModule(Context context, RestSchema restSchema) {
        RestModule restModule = RestLoadData.createRestModuleTemplateHandler(context);
        if (restModule != null) {
            NavigatorTreeNode navigatorTreeNode;
            NavigatorTreeNode navigatorTreeNode2;
            ArrayList<RestModule> arrayList = new ArrayList<RestModule>();
            arrayList.add(restModule);
            List<Object> list = new ArrayList();
            List<Object> list2 = new ArrayList();
            if (this._includePrivileges && (navigatorTreeNode2 = RestUtils.findTreeNode(context)) != null && (navigatorTreeNode = (NavigatorTreeNode)navigatorTreeNode2.getParent().getParent()) != null && (list2 = this.getModulePrivileges(navigatorTreeNode, restModule.getName())) != null && list2.size() > 0) {
                list = this.exportPrivilegeRoles(navigatorTreeNode, list2);
                this.filterProtectedModules(list2, restModule.getName());
            }
            navigatorTreeNode2 = new RestExport(ProductInformation.getProductInformation().getName(), Version.VER_FULL, this._schemaName, this._ordsSchemaVer, this._dbVer);
            this._fullCode = navigatorTreeNode2.exportModulesRolesPrivileges((RestSchema)(this._includeEnableSchema ? restSchema : null), arrayList, list, list2);
            if (this.saveFile() && this.isOpenScriptInEditor()) {
                this.showScriptInEditor();
            }
        }
    }

    private void exportAllRoles(Context context, RestSchema restSchema) {
        NavigatorTreeNode navigatorTreeNode = RestUtils.findTreeNode(context);
        if (navigatorTreeNode != null && navigatorTreeNode.getElement() instanceof ObjectFolder) {
            List<String> list;
            boolean bl = navigatorTreeNode.getChildCount() > 0;
            List<String> list2 = list = bl ? RestUtils.getChildrenNames(navigatorTreeNode) : RestUtils.getChildrenNames((ObjectFolder)navigatorTreeNode.getElement());
            if (list != null && !list.isEmpty()) {
                RestExport restExport = new RestExport(ProductInformation.getProductInformation().getName(), Version.VER_FULL, this._schemaName, this._ordsSchemaVer, this._dbVer);
                this._fullCode = restExport.exportModulesRolesPrivileges((RestSchema)(this._includeEnableSchema ? restSchema : null), null, list, null);
                if (this.saveFile() && this.isOpenScriptInEditor()) {
                    this.showScriptInEditor();
                }
            }
        }
    }

    private void exportRole(Context context, RestSchema restSchema) {
        ArrayList<String> arrayList = new ArrayList<String>();
        NavigatorTreeNode navigatorTreeNode = RestUtils.findTreeNode(context);
        if (navigatorTreeNode != null) {
            arrayList.add(navigatorTreeNode.getElement().getShortLabel());
            RestExport restExport = new RestExport(ProductInformation.getProductInformation().getName(), Version.VER_FULL, this._schemaName, this._ordsSchemaVer, this._dbVer);
            this._fullCode = restExport.exportModulesRolesPrivileges((RestSchema)(this._includeEnableSchema ? restSchema : null), null, arrayList, null);
            if (this.saveFile() && this.isOpenScriptInEditor()) {
                this.showScriptInEditor();
            }
        }
    }

    private List<RestPrivilege> getModulePrivileges(NavigatorTreeNode navigatorTreeNode, String string) {
        List<RestPrivilege> list = null;
        Enumeration enumeration = navigatorTreeNode.children();
        while (enumeration.hasMoreElements()) {
            ObjectFolder objectFolder;
            NavigatorTreeNode navigatorTreeNode2 = (NavigatorTreeNode)enumeration.nextElement();
            if (!(navigatorTreeNode2.getElement() instanceof ObjectFolder) || !(objectFolder = (ObjectFolder)navigatorTreeNode2.getElement()).getObjectType().equals("REST_PRIVILEGE")) continue;
            boolean bl = navigatorTreeNode2.getChildCount() > 0;
            list = bl ? this.getPrivileges(navigatorTreeNode2, string) : this.loadPrivileges(objectFolder, string);
            break;
        }
        return list;
    }

    private List<RestPrivilege> getPrivileges(NavigatorTreeNode navigatorTreeNode, String string) {
        boolean bl = !RestUtils.nullOrEmpty(string);
        ArrayList<RestPrivilege> arrayList = new ArrayList<RestPrivilege>();
        if (navigatorTreeNode != null) {
            Enumeration enumeration = navigatorTreeNode.children();
            while (enumeration.hasMoreElements()) {
                DBObject dBObject;
                NavigatorTreeNode navigatorTreeNode2 = (NavigatorTreeNode)enumeration.nextElement();
                Element element = navigatorTreeNode2.getElement();
                if (element == null || (dBObject = new DBObject(element)) == null) continue;
                RestPrivilege restPrivilege = null;
                if (bl) {
                    List<String> list;
                    String string2;
                    Map map = dBObject.getDictionary();
                    if (map == null) {
                        return null;
                    }
                    Set set = map.keySet();
                    if (set != null && set.contains("SELECTED_MODULE_NAMES") && !RestUtils.nullOrEmpty(string2 = (String)map.get("SELECTED_MODULE_NAMES")) && (list = RestLoadData.parseValues(string2)).contains(string)) {
                        restPrivilege = RestLoadData.createRestPrivilege(dBObject);
                    }
                } else {
                    restPrivilege = RestLoadData.createRestPrivilege(dBObject);
                }
                if (restPrivilege == null) continue;
                arrayList.add(restPrivilege);
            }
        }
        return arrayList;
    }

    private List<RestPrivilege> loadPrivileges(ObjectFolder objectFolder, String string) {
        boolean bl = !RestUtils.nullOrEmpty(string);
        ArrayList<RestPrivilege> arrayList = new ArrayList<RestPrivilege>();
        try {
            DBFolderInstance dBFolderInstance = objectFolder.getFolderInstance();
            List list = dBFolderInstance.listChildren();
            for (DBChildInstance dBChildInstance : list) {
                RestPrivilege restPrivilege = null;
                if (bl) {
                    List<String> list2;
                    String string2;
                    Set set = dBChildInstance.getPropertyKeys();
                    if (set != null && set.contains("SELECTED_MODULE_NAMES") && !RestUtils.nullOrEmpty(string2 = (String)dBChildInstance.getProperty("SELECTED_MODULE_NAMES")) && (list2 = RestLoadData.parseValues(string2)).contains(string)) {
                        restPrivilege = RestLoadData.createRestPrivilege(dBChildInstance);
                    }
                } else {
                    restPrivilege = RestLoadData.createRestPrivilege(dBChildInstance);
                }
                if (restPrivilege == null) continue;
                arrayList.add(restPrivilege);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getLocalizedMessage(), exception);
        }
        return arrayList;
    }

    private void filterProtectedModules(List<RestPrivilege> list, String string) {
        if (list != null && !list.isEmpty()) {
            ArrayList<String> arrayList = null;
            for (RestPrivilege restPrivilege : list) {
                List list2 = restPrivilege.getModules();
                if (list2 == null || !list2.contains(string) || list2.size() <= 1) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                    arrayList.add(string);
                }
                restPrivilege.setModules(arrayList);
            }
        }
    }

    private List<String> getRoles(NavigatorTreeNode navigatorTreeNode) {
        List<String> list = null;
        Enumeration enumeration = navigatorTreeNode.children();
        while (enumeration.hasMoreElements()) {
            ObjectFolder objectFolder;
            NavigatorTreeNode navigatorTreeNode2 = (NavigatorTreeNode)enumeration.nextElement();
            if (!(navigatorTreeNode2.getElement() instanceof ObjectFolder) || (objectFolder = (ObjectFolder)navigatorTreeNode2.getElement()) == null || !objectFolder.getObjectType().equals("REST_ROLE")) continue;
            boolean bl = navigatorTreeNode2.getChildCount() > 0;
            list = bl ? RestUtils.getChildrenNames(navigatorTreeNode2) : RestUtils.getChildrenNames(objectFolder);
            break;
        }
        return list;
    }

    private void exportAllPrivileges(Context context, RestSchema restSchema) {
        List<RestPrivilege> list;
        NavigatorTreeNode navigatorTreeNode = RestUtils.findTreeNode(context);
        if (navigatorTreeNode != null && navigatorTreeNode.getElement() instanceof ObjectFolder && (list = this.getPrivilegeList(navigatorTreeNode, null)) != null && !list.isEmpty()) {
            NavigatorTreeNode navigatorTreeNode2;
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            ArrayList<String> arrayList3 = new ArrayList<String>();
            if (this._includeModules && (navigatorTreeNode2 = (NavigatorTreeNode)navigatorTreeNode.getParent()) != null) {
                for (RestPrivilege restPrivilege : list) {
                    List<String> list2;
                    if (restPrivilege.getModules() != null && !restPrivilege.getModules().isEmpty() && (list2 = this.getProtectedModules(navigatorTreeNode2, restPrivilege)) != null && !list2.isEmpty()) {
                        for (String string : list2) {
                            if (arrayList3.contains(string.getName())) continue;
                            arrayList2.add(string);
                            arrayList3.add(string.getName());
                        }
                    }
                    list2 = this.exportPrivilegeRoles(navigatorTreeNode2, restPrivilege);
                    for (String string : list2) {
                        if (arrayList.contains(string)) continue;
                        arrayList.add(string);
                    }
                }
            }
            navigatorTreeNode2 = new RestExport(ProductInformation.getProductInformation().getName(), Version.VER_FULL, this._schemaName, this._ordsSchemaVer, this._dbVer);
            this._fullCode = navigatorTreeNode2.exportModulesRolesPrivileges((RestSchema)(this._includeEnableSchema ? restSchema : null), arrayList2, arrayList, list);
            if (this.saveFile() && this.isOpenScriptInEditor()) {
                this.showScriptInEditor();
            }
        }
    }

    private void exportPrivilege(Context context, RestSchema restSchema) {
        DBObject dBObject = (DBObject)context.getProperty("ObjectAction.DBOBJECT");
        RestPrivilege restPrivilege = RestLoadData.createRestPrivilege(dBObject);
        if (restPrivilege != null) {
            NavigatorTreeNode navigatorTreeNode;
            ArrayList<RestPrivilege> arrayList = new ArrayList<RestPrivilege>();
            arrayList.add(restPrivilege);
            List<Object> list = new ArrayList();
            List<Object> list2 = new ArrayList();
            NavigatorTreeNode navigatorTreeNode2 = RestUtils.findTreeNode(context);
            if (navigatorTreeNode2 != null && (navigatorTreeNode = (NavigatorTreeNode)navigatorTreeNode2.getParent().getParent()) != null) {
                if (this._includeModules && restPrivilege.getModules() != null && !restPrivilege.getModules().isEmpty()) {
                    list = this.getProtectedModules(navigatorTreeNode, restPrivilege);
                }
                list2 = this.exportPrivilegeRoles(navigatorTreeNode, restPrivilege);
            }
            navigatorTreeNode = new RestExport(ProductInformation.getProductInformation().getName(), Version.VER_FULL, this._schemaName, this._ordsSchemaVer, this._dbVer);
            this._fullCode = navigatorTreeNode.exportModulesRolesPrivileges((RestSchema)(this._includeEnableSchema ? restSchema : null), list, list2, arrayList);
            if (this.saveFile() && this.isOpenScriptInEditor()) {
                this.showScriptInEditor();
            }
        }
    }

    private List<RestPrivilege> getPrivilegeList(NavigatorTreeNode navigatorTreeNode, String string) {
        List<Object> list = new ArrayList();
        if (navigatorTreeNode.getChildCount() > 0) {
            list = this.getPrivileges(navigatorTreeNode, string);
        } else {
            ObjectFolder objectFolder = (ObjectFolder)navigatorTreeNode.getElement();
            list = this.loadPrivileges(objectFolder, string);
        }
        return list;
    }

    private List<RestModule> getProtectedModules(NavigatorTreeNode navigatorTreeNode, RestPrivilege restPrivilege) {
        List list = restPrivilege.getModules();
        List<RestModule> list2 = new ArrayList<RestModule>();
        Enumeration enumeration = navigatorTreeNode.children();
        while (enumeration.hasMoreElements()) {
            ObjectFolder objectFolder;
            NavigatorTreeNode navigatorTreeNode2 = (NavigatorTreeNode)enumeration.nextElement();
            if (!(navigatorTreeNode2.getElement() instanceof ObjectFolder) || (objectFolder = (ObjectFolder)navigatorTreeNode2.getElement()) == null || !objectFolder.getObjectType().equals("REST_MODULE")) continue;
            list2 = this.getModuleList(navigatorTreeNode2, list);
            break;
        }
        return list2;
    }

    private List<RestModule> getModuleList(NavigatorTreeNode navigatorTreeNode, List<String> list) {
        List<Object> list2 = new ArrayList();
        if (navigatorTreeNode.getChildCount() > 0) {
            list2 = this.getModules(navigatorTreeNode, list);
        } else {
            ObjectFolder objectFolder = (ObjectFolder)navigatorTreeNode.getElement();
            list2 = this.loadModules(objectFolder, list);
        }
        return list2;
    }

    private List<RestModule> loadModules(ObjectFolder objectFolder, List<String> list) {
        ArrayList<RestModule> arrayList = new ArrayList<RestModule>();
        boolean bl = list != null && !list.isEmpty();
        try {
            DBFolderInstance dBFolderInstance = objectFolder.getFolderInstance();
            List list2 = dBFolderInstance.listChildren();
            for (DBChildInstance dBChildInstance : list2) {
                RestModule restModule;
                String string = (String)dBChildInstance.getProperty("NAME");
                if (string == null) continue;
                DBObjectInstance dBObjectInstance = null;
                if (bl) {
                    if (list.contains(string)) {
                        dBObjectInstance = (DBObjectInstance)dBChildInstance;
                    }
                } else {
                    dBObjectInstance = (DBObjectInstance)dBChildInstance;
                }
                if (dBObjectInstance == null || (restModule = RestLoadData.createRestModuleTemplatesHandlers(dBObjectInstance)) == null) continue;
                arrayList.add(restModule);
            }
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getLocalizedMessage(), exception);
        }
        return arrayList;
    }

    private List<RestModule> getModules(NavigatorTreeNode navigatorTreeNode, List<String> list) {
        boolean bl;
        ArrayList<RestModule> arrayList = new ArrayList<RestModule>();
        boolean bl2 = bl = list != null && !list.isEmpty();
        if (navigatorTreeNode != null) {
            Enumeration enumeration = navigatorTreeNode.children();
            while (enumeration.hasMoreElements()) {
                String string;
                DBObject dBObject;
                NavigatorTreeNode navigatorTreeNode2 = (NavigatorTreeNode)enumeration.nextElement();
                Element element = navigatorTreeNode2.getElement();
                if (element == null || (dBObject = new DBObject(element)) == null) continue;
                Map map = dBObject.getDictionary();
                if (map == null) {
                    return null;
                }
                Set set = map.keySet();
                if (set == null || !set.contains("MODULE_NAME") || RestUtils.nullOrEmpty(string = (String)map.get("MODULE_NAME"))) continue;
                RestModule restModule = null;
                if (bl) {
                    if (list.contains(string)) {
                        restModule = RestLoadData.createRestModuleTemplatesHandlers(dBObject);
                    }
                } else {
                    restModule = RestLoadData.createRestModuleTemplatesHandlers(dBObject);
                }
                if (restModule == null) continue;
                arrayList.add(restModule);
            }
        }
        return arrayList;
    }

    private List<String> exportPrivilegeRoles(NavigatorTreeNode navigatorTreeNode, RestPrivilege restPrivilege) {
        ArrayList<RestPrivilege> arrayList = new ArrayList<RestPrivilege>();
        arrayList.add(restPrivilege);
        return this.exportPrivilegeRoles(navigatorTreeNode, arrayList);
    }

    private List<String> exportPrivilegeRoles(NavigatorTreeNode navigatorTreeNode, List<RestPrivilege> list) {
        List<String> list2;
        if (navigatorTreeNode != null && list != null && !list.isEmpty() && (list2 = this.getRoles(navigatorTreeNode)) != null && !list2.isEmpty()) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (RestPrivilege restPrivilege : list) {
                List list3 = restPrivilege.getRoles();
                if (list3 == null || list3.isEmpty()) continue;
                for (String string : list3) {
                    if (!list2.contains(string) || arrayList.contains(string)) continue;
                    arrayList.add(string);
                }
            }
            return arrayList;
        }
        return null;
    }

    private boolean showExportDialog(String string, String string2) {
        RestExportDialog restExportDialog = new RestExportDialog(string, string2);
        if (restExportDialog.runDialog()) {
            this._includeEnableSchema = restExportDialog.includeEnableSchema();
            if (string.equals("REST_MODULE") || string.equals("REST_MODULE_FOLDER")) {
                this._includePrivileges = restExportDialog.includePrivileges();
            } else if (string.equals("REST_PRIVILEGE") || string.equals("REST_PRIVILEGE_FOLDER")) {
                this._includeModules = restExportDialog.includeModules();
            }
            this._fileName = restExportDialog.getFileName();
            this._encoding = restExportDialog.getEncoding();
            return true;
        }
        return false;
    }

    private String getFullCode() {
        return this._fullCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveFile() {
        if (RestUtils.nullOrEmpty(this._encoding)) {
            this._encoding = "UTF-8";
        }
        boolean bl = true;
        OutputStreamWriter outputStreamWriter = null;
        try {
            outputStreamWriter = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(new File(this._fileName))), this._encoding);
            outputStreamWriter.write(this.getFullCode());
            outputStreamWriter.flush();
        }
        catch (Exception exception) {
            bl = false;
        }
        finally {
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {}
            }
        }
        return bl;
    }

    private void showScriptInEditor() {
        final File file = new File(this._fileName);
        URL uRL = null;
        try {
            uRL = file.toURI().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, malformedURLException.getLocalizedMessage(), malformedURLException);
            return;
        }
        final SqlNode sqlNode = new SqlNode(uRL);
        final String string = sqlNode.getShortLabel();
        sqlNode.setSaveEncoding(this._encoding);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Object object;
                if (file.length() > 500000L) {
                    String string3 = RestArb.format("EXPORT_TITLE", RestUtils.getNLSObjectType(RestExportDefinitions.this._objectType));
                    String string2 = RestArb.format("EXCEEDS_AUTO_OPEN_SIZE", RestExportDefinitions.this._fileName);
                    MessageDialog.information((Component)Ide.getMainWindow(), (Object)string2, (String)string3, null);
                    return;
                }
                List list = EditorManager.getEditorManager().getAllEditors();
                Iterator iterator = list.iterator();
                Editor editor = null;
                while (iterator.hasNext()) {
                    editor = (Editor)iterator.next();
                    object = editor.getTabLabel();
                    if (!RestExportDefinitions.this._fileName.equals(object) && !RestExportDefinitions.this._fileName.equals(((String)object).replace('*', ' ').trim()) && !string.equals(object) && !string.equals(((String)object).replace('*', ' ').trim())) continue;
                    EditorManager.getEditorManager().closeEditors(Arrays.asList(editor));
                    break;
                }
                object = Context.newIdeContext((Node)sqlNode);
                OpenEditorOptions openEditorOptions = new OpenEditorOptions((Context)object);
                openEditorOptions.setFlags(1);
                EditorManager.getEditorManager().openEditor(openEditorOptions);
            }
        });
    }

    private boolean isOpenScriptInEditor() {
        return DBConfig.getInstance().getBoolean("EXPORT_OPEN_TGT");
    }
}

