/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.ui;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.model.RestModule;
import oracle.dbtools.rest.utils.RestUtils;
import oracle.ide.util.ResourceUtils;

public class RestRenameModulePanel
extends JPanel {
    private List<String> _existingNames;
    private List<String> _uriPrefixes;
    private JTextField _oldName;
    private JTextField _name;
    private JTextField _oldUriPrefix;
    private JTextField _uriPrefix;
    private JLabel _modURIExample;
    private RestModule _module;
    private List<String> _errMsg;
    private String _schema;

    public RestRenameModulePanel(RestModule restModule) {
        this(restModule, null);
    }

    public RestRenameModulePanel(RestModule restModule, String string) {
        this._module = restModule;
        if (string != null) {
            this._schema = string.toLowerCase();
        }
        this.createPanel();
    }

    private void initializeComponents() {
        this._oldName = new JTextField();
        this._name = new JTextField();
        this._oldUriPrefix = new JTextField();
        this._uriPrefix = new JTextField();
        this._modURIExample = new JLabel();
        Font font = this._modURIExample.getFont();
        this._modURIExample.setFont(font.deriveFont(font.getStyle() | 1, font.getSize()));
        if (this._module != null) {
            this._oldName.setText(this._module.getName());
            this._name.setText(this._module.getName());
            this._oldUriPrefix.setText(this._module.getURIPrefix());
            this._uriPrefix.setText(this._module.getURIPrefix());
            String string = this._uriPrefix.getText();
            if (!RestUtils.emptyValue(string) && !string.startsWith("/")) {
                string = "/" + string;
            }
            this._modURIExample.setText(string);
        }
        this._name.requestFocusInWindow();
    }

    private void createPanel() {
        this.initializeComponents();
        this.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        JLabel jLabel5 = new JLabel(RestArb.getString("URI_EXAMPLE_LABEL"));
        JLabel jLabel6 = new JLabel();
        ResourceUtils.resLabel((JLabel)jLabel, (Component)this._oldName, (String)RestArb.getString("MODULE_NAME"));
        ResourceUtils.resLabel((JLabel)jLabel2, (Component)this._name, (String)RestArb.getString("RENAME_NEW_NAME"));
        ResourceUtils.resLabel((JLabel)jLabel3, (Component)this._oldUriPrefix, (String)RestArb.getString("URI_PREFIX"));
        ResourceUtils.resLabel((JLabel)jLabel4, (Component)this._uriPrefix, (String)RestArb.getString("RENAME_NEW_URI_PREFIX"));
        URI uRI = RestUtils.getBaseURI();
        String string = "";
        if (uRI != null) {
            string = uRI.toString();
            string = string.substring(0, string.length() - 1);
        } else {
            string = this._schema != null ? RestArb.format("HTTP_EXAMPLE_HOST_PORT2", this._schema) : RestArb.getString("HTTP_EXAMPLE_HOST_PORT");
        }
        ResourceUtils.resLabel((JLabel)jLabel6, (Component)this._modURIExample, (String)string);
        int n = 0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 0, 0, 6), 0, 0));
        jPanel.add((Component)this._oldName, new GridBagConstraints(1, n, 1, 1, 1.0, 0.5, 23, 2, new Insets(8, 0, 0, 8), 0, 0));
        jPanel.add((Component)jLabel2, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 0, 0, 6), 0, 0));
        jPanel.add((Component)this._name, new GridBagConstraints(1, n, 1, 1, 1.0, 0.5, 23, 2, new Insets(8, 0, 0, 8), 0, 0));
        n = 0;
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)jLabel3, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 8, 8, 6), 0, 0));
        jPanel2.add((Component)this._oldUriPrefix, new GridBagConstraints(1, n, 2, 1, 0.5, 1.0, 23, 2, new Insets(8, 0, 8, 8), 0, 0));
        jPanel2.add((Component)jLabel4, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, new Insets(8, 8, 8, 6), 0, 0));
        jPanel2.add((Component)this._uriPrefix, new GridBagConstraints(1, n, 2, 1, 0.5, 1.0, 23, 2, new Insets(8, 0, 8, 8), 0, 0));
        jPanel2.add((Component)jLabel5, new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, new Insets(4, 8, 8, 6), 0, 0));
        jPanel2.add((Component)jLabel6, new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 21, 0, new Insets(4, 0, 8, 0), 0, 0));
        jPanel2.add((Component)this._modURIExample, new GridBagConstraints(2, n, 1, 1, 0.5, 1.0, 23, 2, new Insets(4, 0, 8, 8), 0, 0));
        LayoutControl.GBC.addVSpring((JPanel)jPanel2, (int)(++n));
        UIUtils.makeTitledBorder((JComponent)jPanel2, (String)RestArb.getString("URI_TITLE"));
        this._oldName.setEnabled(false);
        this._oldUriPrefix.setEnabled(false);
        n = 0;
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.add((Component)jPanel, new GridBagConstraints(0, n, 2, 1, 1.0, 0.5, 23, 2, new Insets(8, 8, 8, 8), 0, 0));
        jPanel3.add((Component)jPanel2, new GridBagConstraints(0, ++n, 2, 1, 1.0, 0.5, 23, 2, new Insets(8, 8, 8, 8), 0, 0));
        n = 0;
        this.add((Component)jPanel3, new GridBagConstraints(0, ++n, 1, 1, 1.0, 0.1, 23, 2, new Insets(0, 0, 0, 0), 0, 0));
        LayoutControl.GBC.addVSpring((JPanel)this, (int)(++n));
        this.addListeners();
    }

    public void addListeners() {
        if (this._uriPrefix != null && this._uriPrefix.getKeyListeners().length == 0) {
            this._uriPrefix.addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent keyEvent) {
                }

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                }

                @Override
                public void keyReleased(KeyEvent keyEvent) {
                    String string = RestRenameModulePanel.this._uriPrefix.getText();
                    if (string != null && !string.isEmpty() && !string.startsWith("/")) {
                        string = "/" + string;
                    }
                    RestRenameModulePanel.this._modURIExample.setText(string);
                }
            });
        }
    }

    public void removeListeners() {
        if (this._uriPrefix != null) {
            KeyListener[] keyListenerArray;
            for (KeyListener keyListener : keyListenerArray = this._uriPrefix.getKeyListeners()) {
                this._uriPrefix.removeKeyListener(keyListener);
            }
        }
    }

    public boolean validInfo() {
        if (this._errMsg == null) {
            this._errMsg = new ArrayList<String>();
        } else {
            this._errMsg.clear();
        }
        boolean bl = false;
        boolean bl2 = false;
        String string = this._name.getText();
        String string2 = this._uriPrefix.getText();
        if (RestUtils.emptyValue(string)) {
            this.setErrorMessage(RestArb.format("VALUE_REQUIRED", RestArb.getString("LABEL_MODULE_NAME")));
        } else if (this.isExistModuleName(string)) {
            this.setErrorMessage(RestArb.format("VALUE_ALREADY_EXIST", RestArb.getString("LABEL_MODULE_NAME")));
        }
        if (RestUtils.emptyValue(string2)) {
            this.setErrorMessage(RestArb.format("VALUE_REQUIRED", RestArb.getString("LABEL_URI_PREFIX")));
        } else if (this.isExistUriPrefix(string2)) {
            this.setErrorMessage(RestArb.format("VALUE_ALREADY_EXIST", RestArb.getString("LABEL_URI_PREFIX")));
        }
        if (this._errMsg.size() > 0) {
            bl = true;
        }
        try {
            new URI(string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            this.setErrorMessage(RestArb.format("URI_SYNTAX_ERROR", RestArb.getString("LABEL_URI_PREFIX")));
            bl2 = true;
        }
        if (this._errMsg.size() > 0) {
            if (bl) {
                this._name.requestFocusInWindow();
            } else if (bl2) {
                this._uriPrefix.requestFocusInWindow();
            }
        }
        return this._errMsg.size() == 0;
    }

    public RestModule getValues() {
        RestModule restModule = new RestModule();
        String string = this._name.getText() != null ? this._name.getText().trim() : "";
        restModule.setName(string);
        String string2 = this._uriPrefix.getText() != null ? this._uriPrefix.getText().trim() : "";
        restModule.setURIPrefix(string2);
        return restModule;
    }

    public String getErrorMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this._errMsg) {
            stringBuffer.append(string).append("\n");
        }
        return stringBuffer.toString();
    }

    private void setErrorMessage(String string) {
        if (this._errMsg == null) {
            this._errMsg = new ArrayList<String>();
        }
        this._errMsg.add(string);
    }

    public void setExistingNames(List<String> list) {
        this._existingNames = list;
    }

    public boolean isExistModuleName(String string) {
        if (this._existingNames == null || this._existingNames.isEmpty()) {
            return false;
        }
        return this._existingNames.contains(string);
    }

    public void setExistingUriPrefixes(List<String> list) {
        this._uriPrefixes = list;
    }

    public boolean isExistUriPrefix(String string) {
        if (this._uriPrefixes == null || this._uriPrefixes.isEmpty()) {
            return false;
        }
        return this._uriPrefixes.contains(string);
    }

    public boolean valuesChanged() {
        if (this._module != null) {
            if (RestUtils.valuesDifferent(this._module.getName(), this._name.getText())) {
                return true;
            }
            if (RestUtils.valuesDifferent(this._module.getURIPrefix(), this._uriPrefix.getText())) {
                return true;
            }
        }
        return false;
    }
}

