/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.ui;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.utils.RestUtils;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.WildcardURLFilter;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.dialogs.MessageDialog;

public class RestExportPanel
extends JPanel {
    static final URLFilter SQL_FILTER = new WildcardURLFilter(RestArb.getString("EXPORT_SQL_FILTER_MASK"), URLFileSystem.isLocalFileSystemCaseSensitive(), RestArb.getString("EXPORT_SQL_FILTER_NAME"));
    private static final String EXP_FILE_NAME = "export.sql";
    private JCheckBox _exportEnableSchemaCB = new JCheckBox();
    private JCheckBox _exportPrivilegesCB = new JCheckBox();
    private JCheckBox _exportModulesCB = new JCheckBox();
    URLFileChooser.URLFileChooserPanel chooserPanel = URLFileChooser.createURLFileChooserPanel((int)1, null, (boolean)true, (boolean)true);
    private String _name;
    private List<String> _errMsg;
    private String _restType;

    public RestExportPanel(String string, String string2) {
        this._restType = string;
        this._name = string2;
        this.createPanel();
    }

    private void initializeComponents() {
    }

    private void createPanel() {
        this.initializeComponents();
        this.setLayout(new GridBagLayout());
        ResourceUtils.resButton((AbstractButton)this._exportEnableSchemaCB, (String)RestArb.getString("EXPORT_ENABLE_SCHEMA"));
        JTextPane jTextPane = new JTextPane();
        jTextPane.setText(this.getDescription());
        jTextPane.setEditable(false);
        jTextPane.setOpaque(false);
        jTextPane.setRequestFocusEnabled(false);
        jTextPane.setFocusable(false);
        this._exportEnableSchemaCB.setSelected(true);
        int n = 0;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.add((Component)this._exportEnableSchemaCB, LayoutControl.GBC.gbc((int)0, (int)n, (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE));
        if (this._restType.equals("REST_MODULE") || this._restType.equals("REST_MODULE_FOLDER")) {
            this._exportPrivilegesCB.setSelected(true);
            ResourceUtils.resButton((AbstractButton)this._exportPrivilegesCB, (String)RestArb.getString("EXPORT_PRIVILEGES2"));
            jPanel.add((Component)this._exportPrivilegesCB, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE));
        } else if (this._restType.equals("REST_PRIVILEGE") || this._restType.equals("REST_PRIVILEGE_FOLDER")) {
            this._exportModulesCB.setSelected(true);
            ResourceUtils.resButton((AbstractButton)this._exportModulesCB, (String)RestArb.getString("EXPORT_MODULES"));
            jPanel.add((Component)this._exportModulesCB, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)2, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.NONE));
        } else {
            LayoutControl.GBC.addHSpring((JPanel)jPanel, (int)1);
        }
        UIUtils.makeTitledBorder((JComponent)jPanel, (String)RestArb.getString("EXPORT_TITLE_BORDER"));
        JTextPane jTextPane2 = new JTextPane();
        jTextPane2.setEditable(false);
        jTextPane2.setOpaque(false);
        jTextPane2.setRequestFocusEnabled(false);
        jTextPane2.setFocusable(false);
        jTextPane2.setText(RestArb.getString("EXPORT_FILE_DESCRIP"));
        this.chooserPanel.clearChooseableURLFilters();
        this.chooserPanel.addChooseableURLFilter(SQL_FILTER);
        this.chooserPanel.setSelectedFile(this.getDefaultExportFile());
        this.chooserPanel.showEncodings(true);
        n = 0;
        int n2 = 0;
        JPanel jPanel2 = LayoutControl.GBC.createPanel();
        jPanel2.add((Component)jTextPane2, LayoutControl.GBC.gbc((int)n2, (int)n, (int)3, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X));
        jPanel2.add((Component)this.chooserPanel, LayoutControl.GBC.gbc((int)n2, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_LABEL2CONTROL_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        n = 0;
        this.add((Component)jTextPane, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.add((Component)jPanel, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        this.add((Component)jPanel2, LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.SECTION_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.X));
        LayoutControl.GBC.addVSpring((JPanel)this, (int)(++n));
        this.addListeners();
    }

    private String getDescription() {
        switch (this._restType) {
            case "REST_MODULE_FOLDER": {
                return RestArb.format("EXPORT_ALL_DESCRIP", RestArb.getString("LABEL_LC_modules"));
            }
            case "REST_MODULE": {
                return RestArb.format("EXPORT_MODULE_DESCRIP", this._name);
            }
            case "REST_PRIVILEGE_FOLDER": {
                return RestArb.format("EXPORT_ALL_DESCRIP", RestArb.getString("LABEL_LC_privileges"));
            }
            case "REST_PRIVILEGE": {
                return RestArb.format("EXPORT_PRIVILEGE_DESCRIP", this._name);
            }
            case "REST_ROLE_FOLDER": {
                return RestArb.format("EXPORT_ALL_DESCRIP", RestArb.getString("LABEL_LC_roles"));
            }
            case "REST_ROLE": {
                return RestArb.format("EXPORT_ROLE_DESCRIP", this._name);
            }
        }
        return "";
    }

    private File getFile() {
        return this.chooserPanel.getSelectedFile();
    }

    public void addListeners() {
    }

    public void removeListeners() {
    }

    public boolean validInfo() {
        if (this._errMsg == null) {
            this._errMsg = new ArrayList<String>();
        } else {
            this._errMsg.clear();
        }
        boolean bl = false;
        if (RestUtils.emptyValue(this.getFileName())) {
            this.setErrorMessage(RestArb.format("VALUE_REQUIRED", RestArb.getString("LABEL_FILE_NAME")));
        } else {
            bl = this.verifyFile(this.getFile());
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean verifyFile(File file) {
        if (file != null) {
            if (file.isDirectory()) {
                this.setErrorMessage(RestArb.format("ERR_FOLDER_MISSING_FILENAME", file.getAbsolutePath()));
                return false;
            }
            boolean bl = false;
            if (file.exists()) {
                bl = MessageDialog.confirm((Component)this, (Object)RestArb.format("CONFIRM_OVERWRITE", file.getAbsolutePath()), (String)RestArb.getString("CONFIRM_OVERWRITE_TITLE"), null);
                if (!bl) return false;
                if (file.delete()) return this.verifyCanCreate(file);
                this.setErrorMessage(RestArb.format("ERR_CANNOT_DELETE_FILE", file.getAbsolutePath()));
                return false;
            }
            File file2 = file.getParentFile();
            if (file2.exists()) return this.verifyCanCreate(file);
            bl = MessageDialog.confirm((Component)this, (Object)RestArb.format("CONFIRM_CREATE_DIR", file2.getAbsolutePath()), (String)RestArb.getString("CONFIRM_CREATE_DIR_TITLE"), null);
            if (!bl) return false;
            try {
                if (file2.mkdirs()) return this.verifyCanCreate(file);
                this.setErrorMessage(RestArb.format("ERR_CANNOT_CREATE_DIR", file.getAbsolutePath(), ""));
                return false;
            }
            catch (Exception exception) {
                String string = RestArb.format("REASON", exception.getLocalizedMessage());
                this.setErrorMessage(RestArb.format("ERR_CANNOT_CREATE_DIR", file.getAbsolutePath(), string));
                return false;
            }
        }
        this.setErrorMessage(RestArb.format("VALUE_REQUIRED", RestArb.getString("LABEL_FILE_NAME")));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean verifyCanCreate(File file) {
        FileOutputStream fileOutputStream = null;
        try {
            file.createNewFile();
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(1);
            fileOutputStream.close();
            file.delete();
        }
        catch (Exception exception) {
            String string = RestArb.format("REASON", exception.getLocalizedMessage());
            this.setErrorMessage(RestArb.format("ERR_CANNOT_CREATE_FILE", file.getAbsolutePath(), string));
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    public String getValues() {
        return null;
    }

    public boolean isExportEnableSchema() {
        return this._exportEnableSchemaCB.isSelected();
    }

    public boolean isExportPrivileges() {
        return this._exportPrivilegesCB.isSelected();
    }

    public boolean isExportModules() {
        return this._exportModulesCB.isSelected();
    }

    public String getFileName() {
        return this.chooserPanel.getText();
    }

    public String getEncoding() {
        return this.chooserPanel.getEncoding();
    }

    public String getErrorMessage() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this._errMsg != null) {
            for (String string : this._errMsg) {
                stringBuffer.append(string).append("\n");
            }
        }
        return stringBuffer.toString();
    }

    public boolean hasErrors() {
        return this._errMsg != null && this._errMsg.size() > 0;
    }

    private void setErrorMessage(String string) {
        if (this._errMsg == null) {
            this._errMsg = new ArrayList<String>();
        }
        this._errMsg.add(string);
    }

    private File getDefaultExportFile() {
        String string = DBConfig.getInstance().getString("EXPORTDIR");
        if (string == null || string.isEmpty()) {
            string = System.getProperty("user.home");
        }
        return new File(string, EXP_FILE_NAME);
    }
}

