/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.patterns;

import java.io.IOException;
import java.io.Reader;
import oracle.dbtools.rest.patterns.ParserBase;
import oracle.dbtools.rest.patterns.PathToken;

class GlobParser
extends ParserBase {
    public GlobParser(Reader reader) {
        super(reader);
    }

    @Override
    protected PathToken next() {
        PathToken.Type type = this.previousType();
        PathToken pathToken = null;
        try {
            pathToken = type == null || PathToken.Type.SEPARATOR == type ? this.literalOrGlob() : (PathToken.Type.GLOB == type ? this.eos() : this.separator());
            if (pathToken != null) {
                this.previous(pathToken);
            }
            return pathToken;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private PathToken literalOrGlob() throws IOException {
        int n = this.r.read();
        if (n == -1) {
            return null;
        }
        char c = (char)n;
        if ('*' == c) {
            return PathToken.glob();
        }
        this.r.unread(n);
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        while (!bl) {
            n = this.r.read();
            if (n == -1) {
                bl = true;
                continue;
            }
            c = (char)n;
            if ('/' == c) {
                bl = true;
                this.r.unread(n);
                continue;
            }
            this.addLiteral(stringBuilder, c);
        }
        return PathToken.literal(stringBuilder.toString());
    }
}

