/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rest.install;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.dbtools.common.config.file.ConfigurationFiles;
import oracle.dbtools.common.install.InstallConstants;
import oracle.dbtools.raptor.utils.XMLHelper;
import oracle.dbtools.rest.RestArb;
import oracle.dbtools.rest.install.RestInstallConstants;
import oracle.dbtools.rest.utils.RestUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InstallUtils {
    private static final Logger logger = Logger.getLogger(InstallUtils.class.getName());
    private static final String CONTEXT_PARAM = "context-param";
    private static final String PARAM_NAME = "param-name";
    private static final String PARAM_VALUE = "param-value";
    private static final String VERSION = "version";
    private static final String APEX_CONFIG_XML = "apex-config.xml";
    private static final String DEFAULTS_XML = "apex-config.xml";

    public static String getLogFolder(File file) throws Exception {
        String string = file.getParent() + File.separator + "logs" + File.separator;
        if (InstallUtils.canWriteFolder(string)) {
            return string;
        }
        string = System.getProperty("user.home");
        if (InstallUtils.canWriteFolder(string)) {
            return string;
        }
        throw new Exception(RestArb.format("ERRORWRITELOGFILE", string));
    }

    public static boolean canWriteFolder(String string) {
        File file;
        return !InstallUtils.nullOrEmpty(string) && (file = new File(string)).isDirectory() && file.canWrite();
    }

    public static Map<String, String> getWEBXMLParams(File file) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ZipFile zipFile = null;
        InputStream inputStream = null;
        try {
            zipFile = new ZipFile(file);
            ZipEntry zipEntry = zipFile.getEntry("WEB-INF/web.xml");
            if (zipEntry == null) {
                throw new IllegalStateException(RestArb.format("ERROR_FILE_NOT_FOUND", "WEB-INF/web.xml"));
            }
            inputStream = zipFile.getInputStream(zipEntry);
            try {
                Document document = InstallUtils.parse(inputStream);
                NodeList nodeList = document.getElementsByTagName(CONTEXT_PARAM);
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    Node node = nodeList.item(i);
                    if (!node.getNodeName().equals(CONTEXT_PARAM)) continue;
                    Node node2 = XMLHelper.getChildNode((Node)node, (String)PARAM_NAME);
                    Node node3 = XMLHelper.getChildNode((Node)node, (String)PARAM_VALUE);
                    String string = node2.getTextContent();
                    String string2 = node3.getTextContent();
                    if (string.equals("config.dir")) {
                        hashMap.put("config.dir", string2);
                        continue;
                    }
                    if (!string.equals(VERSION)) continue;
                    hashMap.put("product.version", string2);
                }
            }
            catch (Exception exception) {
                logger.warning(exception.getStackTrace()[0].toString());
            }
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (Exception exception) {}
            }
        }
        return hashMap;
    }

    public static Document parse(InputStream inputStream) throws IOException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            InstallUtils.setFeature(documentBuilderFactory, "http://javax.xml.XMLConstants/feature/secure-processing", true);
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            return document;
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new IOException(exception);
        }
    }

    private static void setFeature(DocumentBuilderFactory documentBuilderFactory, String string, boolean bl) {
        try {
            documentBuilderFactory.setFeature(string, bl);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            logger.fine("setFeature(), feature: " + string + "\n" + parserConfigurationException.getStackTrace()[0].toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getInstallParamsFromFile(File file) throws IOException {
        String string;
        File file2;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (file != null && file.exists() && (file2 = new File(string = file.getParentFile().getPath() + InstallConstants.INSTALL_PARAMS_XML)).exists() && file2.canRead()) {
            Properties properties = new Properties();
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file2);
                properties.load(fileInputStream);
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (Exception exception) {}
                }
            }
            if (properties != null) {
                Enumeration<?> enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    Object obj = enumeration.nextElement();
                    String string2 = obj.toString();
                    String string3 = properties.getProperty(string2);
                    if (InstallUtils.nullOrEmpty(string3)) continue;
                    hashMap.put(string2, string3);
                }
            }
            hashMap.put("file.parameter", string);
            InstallUtils.excludeInstallParameters(hashMap);
        }
        return hashMap;
    }

    private static void excludeInstallParameters(Map<String, String> map) {
        if (map != null) {
            map.remove("pdb.open.readwrite");
            map.remove("pdb.open.asneeded");
        }
    }

    private static boolean isMigrateV1(File file) {
        File file2 = new File(file, "apex-config.xml");
        return file2.exists();
    }

    private static File getConfigDirContext(File file) {
        File file2 = new File(file, "apex");
        if (file2.exists() && file2.isDirectory()) {
            return file2;
        }
        file2 = new File(file, "ords");
        return file2;
    }

    public static RestInstallConstants.InstallType getInstallType(File file) throws Exception {
        File file2 = InstallUtils.getConfigDirContext(file);
        boolean bl = file2.exists();
        if (bl) {
            if (ConfigurationFiles.isConfigured((File)file2)) {
                if (ConfigurationFiles.isMigrateV2((File)file2)) {
                    return RestInstallConstants.InstallType.MIGRATE_V2;
                }
                return RestInstallConstants.InstallType.VERIFY_SCHEMA;
            }
            if (InstallUtils.isMigrateV1(file2)) {
                return RestInstallConstants.InstallType.MIGRATE_V1;
            }
            return RestInstallConstants.InstallType.REQUIRES_CONFIG;
        }
        return RestInstallConstants.InstallType.REQUIRES_CONFIG;
    }

    public static boolean isDefaultConfigFileExist(File file) throws Exception {
        File file2;
        File file3 = InstallUtils.getConfigDirContext(file);
        return file3.exists() && (file2 = new File(file3, "apex-config.xml")).exists() && file2.isFile();
    }

    public static boolean nullOrEmpty(String string) {
        return RestUtils.nullOrEmpty(string);
    }

    public static boolean nullOrEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }
}

