/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.plugin.db2ISeriesv6;

import java.sql.Connection;
import java.text.MessageFormat;
import java.util.Properties;
import oracle.dbtools.metadata.persistence.MdIndexe;
import oracle.dbtools.migration.capture.CaptureContext;
import oracle.dbtools.migration.workbench.core.MigrationStorer;
import oracle.dbtools.migration.workbench.plugin.DB2OnlineCapturer;
import oracle.dbtools.raptor.utils.Connections;

public final class DB2IOnlineCapturer
extends DB2OnlineCapturer {
    private static final String GET_SCHEMA_QUERY = " SELECT SCHEMA_NAME, SCHEMA_OWNER, SCHEMA_CREATOR, SCHEMA_TEXT  FROM QSYS2.SYSSCHEMAS   WHERE SCHEMA_OWNER <> ''QSYS'' AND SCHEMA_CREATOR <> ''*IBM''   AND SCHEMA_OWNER <> '''' AND UPPER(SCHEMA_NAME) = UPPER(''{0}'') ";
    private static final String GET_TABLE_QUERY = "select TABLE_NAME from QSYS2.SYSTABLES WHERE  TABLE_SCHEMA = ''{0}'' and SYSTEM_TABLE = ''N'' and TABLE_TYPE = ''T''";
    private static final String GET_SYNONYM_QUERY = "select TABLE_NAME TABNAME, BASE_TABLE_SCHEMA BASE_TABSCHEMA, BASE_TABLE_NAME BASE_TABNAME  from QSYS2.SYSTABLES where TABLE_SCHEMA = '${schema}' and TABLE_TYPE = 'A'";
    private static final String GET_COLUMN_QUERY = "select COLUMN_NAME COLNAME, DATA_TYPE TYPENAME, LENGTH,  NUMERIC_SCALE SCALE, IS_NULLABLE NULLS, COLUMN_DEFAULT DEFAULT from QSYS2.SYSCOLUMNS  WHERE TABLE_SCHEMA = ''{0}'' AND TABLE_NAME =''{1}''  ORDER BY ORDINAL_POSITION";
    private static final String GET_VIEW_QUERY = "select TABLE_NAME VIEWNAME, VIEW_DEFINITION TEXT, VIEW_OWNER OWNER,   CASE IS_UPDATABLE WHEN ''Y'' THEN ''N''  WHEN ''N'' THEN ''Y''  ELSE ''N''  END  READONLY from QSYS2.SYSVIEWS WHERE TABLE_SCHEMA=''{0}''";
    private static final String GET_INDEXES_QUERY = "select INDEX_NAME INDNAME , IS_SPANNING_INDEX INDEXTYPE, IS_UNIQUE UNIQUERULE from QSYS2.SYSINDEXES WHERE TABLE_SCHEMA = ''{0}'' AND TABLE_NAME=''{1}'' ";
    private static final String GET_INDEX_DETAILS_QUERY = "select B.COLUMN_NAME COLNAME, B.COLUMN_POSITION COLSEQ from  QSYS2.SYSINDEXES A, QSYS2.SYSKEYS B WHERE A.INDEX_SCHEMA=''{0}'' AND A.INDEX_NAME=''{1}'' AND  B.INDEX_SCHEMA = A.INDEX_SCHEMA AND B.INDEX_NAME = A.INDEX_NAME";
    private static final String GET_TRIGGERS_QUERY = "select TRIGGER_NAME TRIGNAME, EVENT_OBJECT_SCHEMA TABSCHEMA, EVENT_OBJECT_TABLE TABNAME,    case EVENT_MANIPULATION when ''DELETE'' THEN ''D'' when ''DELETE'' THEN ''D'' when ''INSERT'' THEN ''I'' when ''UPDATE'' THEN ''U'' when ''READ'' THEN ''R'' ELSE ''I'' END TRIGEVENT, ACTION_STATEMENT TEXT,  LONG_COMMENT REMARKS from QSYS2.SYSTRIGGERS where EVENT_OBJECT_SCHEMA=''{0}'' AND EVENT_OBJECT_TABLE=''{1}''";
    private static final String GET_PROCEDURES_QUERY = "select ROUTINE_NAME NAME,  ROUTINE_TYPE ROUTINETYPE, ROUTINE_DEFINITION TEXT, ROUTINE_CREATED CREATE_TIME, LONG_COMMENT REMARKS from QSYS2.SYSROUTINES where ROUTINE_SCHEMA = ''{0}''";
    private String GET_PK_CONSTRAINTS_QUERY = "SELECT X.CONSTRAINT_NAME CONSTNAME, X.TYPE, X.TABLE_SCHEMA TABSCHEMA, X.TABLE_NAME TABNAME, Z.COLUMN_NAME COLNAME, Z.ORDINAL_POSITION COLSEQ, '''' REMARKS from  (select CONSTRAINT_NAME, TYPE, TABLE_SCHEMA, TABLE_NAME, REMARKS from QSYS2.SYSCST  where (type = ''PRIMARY KEY'' OR type = ''UNIQUE'') AND TABLE_SCHEMA=''{0}'' AND  TABLE_NAME=''{1}'' ) X  JOIN  (select COLUMN_NAME,  ORDINAL_POSITION, CONSTRAINT_NAME, TABLE_SCHEMA, TABLE_NAME from QSYS2.SYSKEYCST WHERE  TABLE_SCHEMA=''{0}'' AND  TABLE_NAME=''{1}'') Z  on  (X.CONSTRAINT_NAME = Z.CONSTRAINT_NAME and X.TABLE_SCHEMA = Z.TABLE_SCHEMA and X.TABLE_NAME = Z.TABLE_NAME) ORDER BY X.CONSTRAINT_NAME";
    private String GET_FK_CONSTRAINTS_QUERY = "select X.CONSTRAINT_NAME CONSTNAME, X.CONSTRAINT_TYPE TYPE, X.TABLE_NAME TABNAME, X.TABLE_SCHEMA TABSCHEMA, X.COLUMN_NAME COLNAME,  X.LONG_COMMENT REMARKS, X.ORDINAL_POSITION COLSEQ,  Y.TABLE_NAME REFTABNAME, Y.TABLE_SCHEMA REFTABSCHEMA, Y.COLUMN_NAME REFCOLNAME  from   (select A.CONSTRAINT_NAME, A.CONSTRAINT_SCHEMA, A.CONSTRAINT_TYPE, A.LONG_COMMENT, B.TABLE_NAME, B.TABLE_SCHEMA, B.COLUMN_NAME, B.ORDINAL_POSITION from QSYS2.SYSCST A, QSYS2.SYSKEYCST B  where A.CONSTRAINT_SCHEMA = ''{0}'' and A.CONSTRAINT_TYPE = ''FOREIGN KEY'' and A.TABLE_NAME=''{1}'' AND   A.CONSTRAINT_NAME = B.CONSTRAINT_NAME and A.CONSTRAINT_SCHEMA = B.CONSTRAINT_SCHEMA) X  join  (select A.CONSTRAINT_NAME, A.CONSTRAINT_SCHEMA, UNIQUE_CONSTRAINT_SCHEMA, UNIQUE_CONSTRAINT_NAME, TABLE_NAME, TABLE_SCHEMA, COLUMN_NAME from QSYS2.SYSREFCST A, QSYS2.SYSKEYCST B  where A.constraint_schema = ''{0}''  AND A.UNIQUE_CONSTRAINT_NAME = B.CONSTRAINT_NAME and A.UNIQUE_CONSTRAINT_SCHEMA = B.CONSTRAINT_SCHEMA) Y  on (X.CONSTRAINT_NAME = Y.CONSTRAINT_NAME AND X.CONSTRAINT_SCHEMA = Y.CONSTRAINT_SCHEMA)";

    public DB2IOnlineCapturer(MigrationStorer migrationStorer, Connection connection) {
        super(migrationStorer, connection);
    }

    @Override
    protected String getSchemaQuery() {
        String string = Connections.getInstance().getConnectionName(this.getConnection());
        Properties properties = Connections.getInstance().getConnectionInfo(string);
        String string2 = properties.getProperty("user");
        String string3 = MessageFormat.format(GET_SCHEMA_QUERY, string2);
        return string3;
    }

    @Override
    protected String getTableQuery(CaptureContext captureContext) {
        String string = captureContext.applyToSQLString("${schema}");
        String string2 = MessageFormat.format(GET_TABLE_QUERY, string);
        return string2;
    }

    @Override
    protected StringBuffer getViewQuery(CaptureContext captureContext) {
        String string = captureContext.applyToSQLString("${schema}");
        String string2 = MessageFormat.format(GET_VIEW_QUERY, string);
        StringBuffer stringBuffer = new StringBuffer(string2);
        return stringBuffer;
    }

    @Override
    protected StringBuffer getColumnQuery(CaptureContext captureContext) {
        String string = captureContext.applyToSQLString("${schema}");
        String string2 = (String)captureContext.getContextVariable("TABLE");
        String string3 = MessageFormat.format(GET_COLUMN_QUERY, string, string2);
        StringBuffer stringBuffer = new StringBuffer(string3);
        return stringBuffer;
    }

    @Override
    protected String getSynonymQuery() {
        return GET_SYNONYM_QUERY;
    }

    @Override
    protected StringBuffer getIndexQuery(CaptureContext captureContext) {
        String string = captureContext.applyToSQLString("${schema}");
        String string2 = captureContext.applyToSQLString("${table}");
        String string3 = MessageFormat.format(GET_INDEXES_QUERY, string, string2);
        StringBuffer stringBuffer = new StringBuffer(string3);
        return stringBuffer;
    }

    @Override
    protected String getIndexDetailsQuery(MdIndexe mdIndexe, CaptureContext captureContext) {
        String string = captureContext.applyToSQLString("${schema}");
        String string2 = MessageFormat.format(GET_INDEX_DETAILS_QUERY, string, mdIndexe.getIndexName());
        return string2;
    }

    protected StringBuffer getTriggerQuery(CaptureContext captureContext) {
        String string = captureContext.applyToSQLString("${schema}");
        String string2 = captureContext.applyToSQLString("${table}");
        String string3 = MessageFormat.format(GET_TRIGGERS_QUERY, string, string2);
        StringBuffer stringBuffer = new StringBuffer(string3);
        return stringBuffer;
    }

    @Override
    protected StringBuffer getStoredPgmQuery(CaptureContext captureContext) {
        String string = captureContext.applyToSQLString("${schema}");
        String string2 = MessageFormat.format(GET_PROCEDURES_QUERY, string);
        StringBuffer stringBuffer = new StringBuffer(string2);
        return stringBuffer;
    }

    @Override
    protected StringBuffer getPKConstrQuery(CaptureContext captureContext) {
        String string = captureContext.applyToSQLString("${schema}");
        String string2 = captureContext.applyToSQLString("${table}");
        String string3 = MessageFormat.format(this.GET_PK_CONSTRAINTS_QUERY, string, string2);
        StringBuffer stringBuffer = new StringBuffer(string3);
        return stringBuffer;
    }

    @Override
    protected String getFKConstrQuery(CaptureContext captureContext) {
        String string = captureContext.applyToSQLString("${schema}");
        String string2 = captureContext.applyToSQLString("${table}");
        StringBuffer stringBuffer = new StringBuffer(this.GET_FK_CONSTRAINTS_QUERY);
        String string3 = MessageFormat.format(stringBuffer.toString(), string, string2);
        return string3;
    }
}

