/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.offline;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import oracle.dbtools.metadata.persistence.PersistenceException;
import oracle.dbtools.migration.workbench.offline.MultiStream;
import oracle.dbtools.migration.workbench.offline.XMLHandler;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class DB2FileReader {
    private String m_directory;
    private InputStream m_bFileInputStream;
    private String m_inputFile;
    private String m_encoding;

    public DB2FileReader(String string, String string2) {
        this.m_directory = string;
        this.m_encoding = string2;
    }

    public void setFileToRead(String string) {
        this.closeStreams();
        this.m_inputFile = string;
        this.m_bFileInputStream = null;
    }

    private void initializeReader(boolean bl) {
        File file = new File(this.m_directory + "/" + this.m_inputFile);
        if (file.canRead()) {
            try {
                this.m_bFileInputStream = bl ? new BufferedInputStream(new MultiStream(new FileInputStream(file))) : new BufferedInputStream(new FileInputStream(file));
            }
            catch (FileNotFoundException fileNotFoundException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, fileNotFoundException.getStackTrace()[0].toString(), fileNotFoundException);
                this.closeStreams();
            }
        }
    }

    public void closeStreams() {
        if (this.m_bFileInputStream != null) {
            try {
                this.m_bFileInputStream.close();
                this.m_inputFile = null;
                this.m_bFileInputStream = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void main(String[] stringArray) {
        DB2FileReader dB2FileReader = new DB2FileReader("migrations/db2v9.5/src//oracle/dbtools/migration/workbench/db2v9/resources", null);
        try {
            dB2FileReader.setFileToRead("triggers.dat");
            dB2FileReader.doParse(new XMLHandler(10){
                int count = 0;

                @Override
                public void rowCompleted() throws PersistenceException {
                }
            });
        }
        finally {
            dB2FileReader.closeStreams();
        }
    }

    public void doParse(DefaultHandler defaultHandler) {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            if (this.m_bFileInputStream == null) {
                this.initializeReader(true);
            }
            sAXParser.parse(this.getInputSource(), defaultHandler);
        }
        catch (Throwable throwable) {
            Logger.getLogger(DB2FileReader.class.getName()).log(Level.WARNING, throwable.getStackTrace()[0].toString(), throwable);
            this.closeStreams();
        }
    }

    public String findLine(BufferedReader bufferedReader, String string) {
        String string2 = null;
        try {
            while ((string2 = bufferedReader.readLine()) != null) {
                if (!string2.trim().startsWith(string)) continue;
                return string2;
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        return null;
    }

    public String lastLine(BufferedReader bufferedReader) {
        String string = null;
        String string2 = null;
        try {
            while ((string2 = bufferedReader.readLine()) != null) {
                int n = string2.indexOf("=");
                if (n < 0) continue;
                string = string2.substring(n + 1).trim();
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
        }
        return string;
    }

    public BufferedReader getLineReader() {
        if (this.m_bFileInputStream == null) {
            this.initializeReader(false);
        }
        return new BufferedReader(new InputStreamReader(this.m_bFileInputStream));
    }

    private InputSource getInputSource() {
        try {
            InputSource inputSource = new InputSource(new BufferedReader(new InputStreamReader(this.m_bFileInputStream, this.m_encoding)));
            return inputSource;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, unsupportedEncodingException.getStackTrace()[0].toString(), unsupportedEncodingException);
            this.closeStreams();
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            this.closeStreams();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream getInputStream() {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        char[] cArray = new char[1024];
        try {
            int n;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.m_bFileInputStream, this.m_encoding));
            while ((n = bufferedReader.read(cArray)) != -1) {
                ((Writer)charArrayWriter).write(cArray, 0, n);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, unsupportedEncodingException.getStackTrace()[0].toString(), unsupportedEncodingException);
            this.closeStreams();
        }
        catch (IOException iOException) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
            this.closeStreams();
        }
        finally {
            try {
                this.m_bFileInputStream.close();
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, iOException.getStackTrace()[0].toString(), iOException);
                this.closeStreams();
            }
        }
        return new ByteArrayInputStream(((Object)charArrayWriter).toString().getBytes());
    }
}

