/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.views.tables;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.controls.DBConnectionComboBox;
import oracle.dbtools.raptor.ui.table.ListReorderableTableModel;
import oracle.dbtools.raptor.ui.table.ListReorderableTableWithTitleBar;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.spatial.SpatialArb;
import oracle.dbtools.spatial.mapviewer.MapViewer;
import oracle.dbtools.spatial.mapviewer.components.MapViewerHelper;
import oracle.dbtools.spatial.tools.ISpatialTool;
import oracle.dbtools.spatial.tools.SpatialAddGeomQuery;
import oracle.dbtools.spatial.tools.SpatialToolRegistry;
import oracle.dbtools.spatial.views.SpatialUtil;
import oracle.dbtools.spatial.views.SpatialViewController;
import oracle.dbtools.spatial.views.tables.QueryObject;
import oracle.dbtools.spatial.views.tables.SpatialReorderableTableModel;
import oracle.dbtools.spatial.views.tables.SpatialTabPanel;
import oracle.ide.Context;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.Toolbar;
import oracle.javatools.db.DBException;
import oracle.javatools.ui.table.ReorderableTableWithTitleBar;
import oracle.javatools.ui.table.TableToolbar;

public class SpatialListReorderableTableWithTitleBar<T>
extends ListReorderableTableWithTitleBar<T> {
    private static final long serialVersionUID = 1L;
    private SpatialReorderableTableModel _model;
    private SpatialTabPanel _tabPanel;
    private String _tabLabel;
    Toolbar geomToolbar;
    SpatialDBConnectionCombobox databaseSelector;
    private String currentlySelectedConnection;
    private boolean raptorTaskResult;
    private MapViewer mapView;
    private JLabel sridLabel;

    public SpatialListReorderableTableWithTitleBar(ListReorderableTableModel<T> listReorderableTableModel, MapViewer mapViewer, String string) {
        super(listReorderableTableModel);
        this._model = (SpatialReorderableTableModel)listReorderableTableModel;
        this.mapView = mapViewer;
        this._tabLabel = string;
        this._tabPanel.setTabLabel(this._tabLabel);
    }

    public void initTablePanel() {
        super.initTablePanel();
        this.sridLabel = new JLabel(SpatialArb.getString("NoActiveSRID"));
        TableToolbar tableToolbar = this.getReorderableTableWithTitleBar().getTableToolbar();
        ArrayList<Component> arrayList = new ArrayList<Component>();
        tableToolbar.removeAll();
        tableToolbar.setAddVisible(true);
        this.databaseSelector = new SpatialDBConnectionCombobox();
        this.databaseSelector.getJComboBox().setSelectedIndex(-1);
        JComboBox jComboBox = this.databaseSelector.getJComboBox();
        jComboBox.setName("Spatial connection combobox");
        arrayList.add(this.sridLabel);
        arrayList.add(jComboBox);
        this.geomToolbar = new Toolbar();
        SpatialViewController.getInstance().installGeometryToolbar(this.geomToolbar, arrayList);
        tableToolbar.add((Component)this.geomToolbar);
        ((SpatialReorderableTableModel)super.getListTableModel()).setToolbar(tableToolbar);
        ReorderableTableWithTitleBar reorderableTableWithTitleBar = this.getReorderableTableWithTitleBar();
        this._tabPanel = new SpatialTabPanel(reorderableTableWithTitleBar);
    }

    public void setConnectionAndInsertQuery(QueryObject queryObject, String string) {
        String string2 = this.getCurrentConnectionName();
        if (string2 != null && string2.length() > 0 && string2.equals(string)) {
            try {
                Connection connection = Connections.getInstance().getConnection(string2);
                String[] stringArray = MapViewerHelper.getColumnNames(queryObject.getQueryText(), connection);
                queryObject.setCandidateColumns(stringArray);
                this.getModel().addRow(queryObject);
                if (this.getModel().getTableSRID() != -10) {
                    this.sridLabel.setText(SpatialArb.getString("ActiveSRID") + Integer.toString(this.getModel().getTableSRID()));
                } else {
                    this.setDefaultLabel();
                }
                this.getModel().setEditable(true);
                SpatialUtil.getPanel().getSelectedMapViewer().refreshMapView();
                SpatialViewController.getInstance().toggleToolbar();
            }
            catch (DBException dBException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, dBException.getStackTrace()[0].toString(), dBException);
            }
            catch (Exception exception) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
    }

    public void setTabPageConnection(String string) {
        this.databaseSelector.setCurrentConnection(string);
    }

    public void setConnectionAndReturnToTool(String string, ISpatialTool iSpatialTool) {
        this.setConnectionAndReturnToATool(string, iSpatialTool);
    }

    public void setConnectionAndReturnToATool(String string, ISpatialTool iSpatialTool) {
        if (string != null && string.length() > 0 && iSpatialTool != null) {
            this.databaseSelector.addConnection(string);
            try {
                if (MapViewerHelper.isConnectionValid(Connections.getInstance().getConnection(string))) {
                    IdeAction ideAction = SpatialToolRegistry.getTool(iSpatialTool.getType()).getAction();
                    SpatialAddGeomQuery spatialAddGeomQuery = (SpatialAddGeomQuery)SpatialToolRegistry.getTool(iSpatialTool.getType());
                    spatialAddGeomQuery.handleEvent(ideAction, Context.newIdeContext());
                }
            }
            catch (DBException dBException) {
                dBException.printStackTrace();
                return;
            }
        }
    }

    public SpatialTabPanel getTabPanel() {
        return this._tabPanel;
    }

    public SpatialReorderableTableModel getModel() {
        return this._model;
    }

    public String getTabLabel() {
        return this._tabLabel;
    }

    public void setTabLabel(String string) {
        this._tabPanel.setTabLabel(string);
    }

    public synchronized boolean isConnectionSet() {
        try {
            Connection connection = MapViewerHelper.getCurrentTabCnx();
            return MapViewerHelper.isConnectionValid(connection) && this.raptorTaskResult;
        }
        catch (Exception exception) {
            this.raptorTaskResult = false;
            return false;
        }
    }

    public String getCurrentConnectionName() {
        return this.databaseSelector.getCurrentConnectionName();
    }

    public boolean setGridPreferredConnection(String string) {
        if (string != null && string.length() > 0) {
            try {
                Connection connection = Connections.getInstance().getConnection(string);
                this.getTabPageMapViewer().setMapViewerConnection(connection);
            }
            catch (DBException dBException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, dBException.getStackTrace()[0].toString(), dBException);
                this.disconnect();
                return false;
            }
        }
        return true;
    }

    public DBConnectionComboBox getCombobox() {
        return this.databaseSelector;
    }

    public void disconnect() {
        this.getModel().setEditable(false);
        this.databaseSelector.disconnect();
    }

    public MapViewer getTabPageMapViewer() {
        return this.mapView;
    }

    public JLabel getSridLabel() {
        return this.sridLabel;
    }

    public void setDefaultLabel() {
        this.sridLabel.setText(SpatialArb.getString("NoActiveSRID"));
    }

    class SpatialDBConnectionCombobox
    extends DBConnectionComboBox {
        public SpatialDBConnectionCombobox() {
            this.getJComboBox().addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    int n = itemEvent.getStateChange();
                    if (n == 1) {
                        String string = (String)itemEvent.getItem();
                        SpatialListReorderableTableWithTitleBar.this.currentlySelectedConnection = string;
                        if (SpatialListReorderableTableWithTitleBar.this.currentlySelectedConnection != null && SpatialListReorderableTableWithTitleBar.this.currentlySelectedConnection.length() > 0) {
                            SpatialListReorderableTableWithTitleBar.this.getModel().setEditable(false);
                            SpatialListReorderableTableWithTitleBar.this.raptorTaskResult = SpatialListReorderableTableWithTitleBar.this.setGridPreferredConnection(SpatialListReorderableTableWithTitleBar.this.currentlySelectedConnection);
                            if (SpatialListReorderableTableWithTitleBar.this.raptorTaskResult) {
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        SpatialListReorderableTableWithTitleBar.this.getModel().setEditable(true);
                                        SpatialListReorderableTableWithTitleBar.this.getModel().removeAll();
                                        SpatialListReorderableTableWithTitleBar.this.getModel().toggleActiveConnectionHistory(SpatialListReorderableTableWithTitleBar.this.currentlySelectedConnection);
                                        SpatialListReorderableTableWithTitleBar.this.getTabPageMapViewer().getMapViewerContoller().removeAllLayers();
                                        SpatialListReorderableTableWithTitleBar.this.getModel().setTableSRID(-10);
                                        SpatialListReorderableTableWithTitleBar.this.getModel().replaceHistoryTask(SpatialListReorderableTableWithTitleBar.this.currentlySelectedConnection);
                                        if (SpatialListReorderableTableWithTitleBar.this.getModel().getTableSRID() != -10) {
                                            SpatialListReorderableTableWithTitleBar.this.sridLabel.setText(SpatialArb.getString("ActiveSRID") + Integer.toString(SpatialListReorderableTableWithTitleBar.this.getModel().getTableSRID()));
                                        } else {
                                            SpatialListReorderableTableWithTitleBar.this.setDefaultLabel();
                                        }
                                    }
                                });
                            }
                            SpatialViewController.getInstance().toggleToolbar();
                        }
                    }
                }
            });
        }

        public void addConnection(String string) {
            if (Connections.getInstance().isOracle(string)) {
                SpatialListReorderableTableWithTitleBar.this.currentlySelectedConnection = string;
                super.addConnection(string);
                this.setCurrentConnection(string);
            }
        }

        private void disconnect() {
            this.setCurrentConnection(null);
        }
    }
}

