/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.mapviewer.model;

import java.awt.Dimension;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.spatial.mapviewer.components.MapViewerHelper;
import oracle.dbtools.spatial.views.tables.QueryObject;
import oracle.dbtools.spatial.views.tables.SpatialReorderableTableModel;
import oracle.maps.tools.configurable.FeatureSelectionConfigurable;

public class RenderingPanelModel {
    public static final int TYPE_POINT = 0;
    public static final int TYPE_LINE = 1;
    public static final int TYPE_AREA = 2;
    private SpatialReorderableTableModel tableModel;
    private final Dimension DEFAULT_DIMENSION = new Dimension(500, 400);
    private final double[] INIT_DATA_WINDOW = new double[]{0.0, 0.0, 10.0, 10.0};
    private Connection modelConn;
    private FeatureSelectionConfigurable configurationLayer;

    public RenderingPanelModel(SpatialReorderableTableModel spatialReorderableTableModel) {
        this.tableModel = spatialReorderableTableModel;
    }

    public void setConnection(Connection connection) {
        this.modelConn = connection;
    }

    public Connection getConnection() {
        return this.modelConn;
    }

    public SpatialReorderableTableModel getTableModel() {
        return this.tableModel;
    }

    public double[] getInitialDataWindow() {
        return this.INIT_DATA_WINDOW;
    }

    public Dimension getInitialDimension() {
        return this.DEFAULT_DIMENSION;
    }

    public void setLayerStyle(Properties properties, QueryObject queryObject) {
        String string = "unknown";
        int n = Integer.parseInt(properties.getProperty("sublayer_type"));
        String string2 = "color_cyan_black_255";
        String string3 = "";
        switch (n) {
            case 0: {
                string2 = queryObject.getMarkerStyleString();
                string = "point";
                break;
            }
            case 1: {
                string2 = queryObject.getLineStyleString();
                string = "line";
                break;
            }
            default: {
                string2 = queryObject.getAreaStyleString();
                string = "area";
            }
        }
        string3 = queryObject.getLabelStyleString();
        properties.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.renderStyle", string2);
        properties.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.labelStyle", string3);
        properties.setProperty("oracle.maps.tools.configurable.FeatureSelectionConfigurable.mouseoverFeatureColor", queryObject.getHoverAreaStyleString());
    }

    public Properties getLayerProperties(QueryObject queryObject, int n) {
        Properties properties = new Properties();
        properties.setProperty("query", queryObject.getQueryText());
        properties.setProperty("layeridx", Integer.toString(queryObject.getLayerNumber()));
        properties.setProperty("geomcolumnidx", "0");
        properties.setProperty("true", Boolean.toString(queryObject.isPreselected()));
        properties.setProperty("geomcolumnname", queryObject.getGeomColName());
        properties.setProperty("tablesrid", Integer.toString(queryObject.getSRID()));
        properties.setProperty("layermbr_xmin", Double.toString(queryObject.getMBR()[0]));
        properties.setProperty("layermbr_ymin", Double.toString(queryObject.getMBR()[1]));
        properties.setProperty("layermbr_xmax", Double.toString(queryObject.getMBR()[2]));
        properties.setProperty("layermbr_ymax", Double.toString(queryObject.getMBR()[3]));
        switch (n) {
            case 0: {
                properties.setProperty("sublayer_type", Integer.toString(0));
                break;
            }
            case 1: {
                properties.setProperty("sublayer_type", Integer.toString(1));
                break;
            }
            case 2: {
                properties.setProperty("sublayer_type", Integer.toString(2));
            }
        }
        this.setLayerStyle(properties, queryObject);
        return properties;
    }

    public int getTranslatedLayerIndex(int n, int n2) {
        int n3 = 3 * n;
        switch (n2) {
            case 0: {
                return n3 + 3;
            }
            case 1: {
                return n3 + 2;
            }
            case 2: {
                return n3 + 1;
            }
        }
        return -1;
    }

    public boolean checkGeometryValidity(Struct struct) {
        boolean bl = false;
        try {
            bl = MapViewerHelper.isGeometryValid(struct, this.getConnection());
        }
        catch (SQLException sQLException) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, sQLException.getStackTrace()[0].toString(), sQLException);
            sQLException.printStackTrace();
            return false;
        }
        catch (Exception exception) {
            Logger.getLogger(this.getClass().getName()).log(Level.INFO, exception.getStackTrace()[0].toString(), exception);
            exception.printStackTrace();
        }
        return bl;
    }
}

