/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.mapviewer.controller;

import java.awt.Component;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.spatial.SpatialArb;
import oracle.dbtools.spatial.mapviewer.components.MapViewerHelper;
import oracle.dbtools.spatial.mapviewer.model.MainCanvasDataSource;
import oracle.dbtools.spatial.mapviewer.model.RenderingPanelModel;
import oracle.dbtools.spatial.mapviewer.view.RenderingPanelView;
import oracle.dbtools.spatial.views.SpatialUtil;
import oracle.dbtools.spatial.views.SpatialViewController;
import oracle.dbtools.spatial.views.tables.QueryObject;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;
import oracle.maps.core.Layer;
import oracle.spatial.edit.layer.GeometrySetLayer;
import oracle.spatial.geometry.JGeometry;

public class RenderingPanelController {
    RenderingPanelModel panelModel;
    RenderingPanelView panelView;
    QueryObject origData;
    String proposedQuery;
    int selectedRow;
    private QueryObject queryObj;

    public RenderingPanelController(RenderingPanelModel renderingPanelModel, RenderingPanelView renderingPanelView) {
        this.panelModel = renderingPanelModel;
        this.panelView = renderingPanelView;
    }

    public void addLayerToCanvas(QueryObject queryObject, int n) {
        if (--n < 0) {
            return;
        }
        int n2 = this.panelModel.getTranslatedLayerIndex(n, 0);
        int n3 = this.panelModel.getTranslatedLayerIndex(n, 1);
        int n4 = this.panelModel.getTranslatedLayerIndex(n, 2);
        Properties properties = this.panelModel.getLayerProperties(queryObject, 0);
        Properties properties2 = this.panelModel.getLayerProperties(queryObject, 1);
        Properties properties3 = this.panelModel.getLayerProperties(queryObject, 2);
        this.panelView.addGeometrySetLayer(properties3, n4, queryObject.getAreaKeys(), queryObject.getAreaMap(), queryObject.getSelectedLabelColumnData());
        this.panelView.addGeometrySetLayer(properties2, n3, queryObject.getCurveKeys(), queryObject.getCurveMap(), queryObject.getSelectedLabelColumnData());
        this.panelView.addGeometrySetLayer(properties, n2, queryObject.getPointKeys(), queryObject.getPointMap(), queryObject.getSelectedLabelColumnData());
        this.panelView.setLastLayerSelectable();
    }

    public void moveLayer(int n, int n2) {
        this.panelView.moveLayer(n, n2);
    }

    public void refreshLayers() {
        this.panelView.refreshLayers();
    }

    public void removeLayer(int n) {
        this.panelView.removeLayer(n);
    }

    public void removeAllLayers() {
        this.panelView.removeAllLayers();
    }

    public void clearAllSelections() {
        int n = this.panelView.getCanvas().getLayerManager().size();
        for (int i = 0; i < n; ++i) {
            try {
                GeometrySetLayer geometrySetLayer = (GeometrySetLayer)this.panelView.getCanvas().getLayerManager().getLayerByPosition(Integer.valueOf(i));
                if (geometrySetLayer == null) continue;
                geometrySetLayer.clearSelection();
                continue;
            }
            catch (ClassCastException classCastException) {
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.panelView.clearSelectedObjKey();
    }

    public void updateLayer(int n, QueryObject queryObject) {
        boolean bl = queryObject.isPreselected();
        int n2 = this.panelModel.getTranslatedLayerIndex(n, 0);
        int n3 = this.panelModel.getTranslatedLayerIndex(n, 1);
        int n4 = this.panelModel.getTranslatedLayerIndex(n, 2);
        GeometrySetLayer geometrySetLayer = (GeometrySetLayer)this.panelView.getCanvas().getLayerManager().get(n2);
        MainCanvasDataSource mainCanvasDataSource = (MainCanvasDataSource)geometrySetLayer.getDataSource();
        mainCanvasDataSource.getConnectionProperties().setProperty("true", Boolean.toString(bl));
        GeometrySetLayer geometrySetLayer2 = (GeometrySetLayer)this.panelView.getCanvas().getLayerManager().get(n3);
        MainCanvasDataSource mainCanvasDataSource2 = (MainCanvasDataSource)geometrySetLayer2.getDataSource();
        mainCanvasDataSource2.getConnectionProperties().setProperty("true", Boolean.toString(bl));
        GeometrySetLayer geometrySetLayer3 = (GeometrySetLayer)this.panelView.getCanvas().getLayerManager().get(n4);
        MainCanvasDataSource mainCanvasDataSource3 = (MainCanvasDataSource)geometrySetLayer3.getDataSource();
        mainCanvasDataSource3.getConnectionProperties().setProperty("true", Boolean.toString(bl));
        String string = mainCanvasDataSource.getConnectionProperties().getProperty("query");
        this.proposedQuery = queryObject.getQueryText();
        boolean bl2 = queryObject.isLabelChanged();
        if (string.equals(this.proposedQuery) && !bl2) {
            HashMap<String, String> hashMap = queryObject.getSelectedLabelColumnData();
            mainCanvasDataSource.setLabelMap(hashMap);
            mainCanvasDataSource2.setLabelMap(hashMap);
            mainCanvasDataSource3.setLabelMap(hashMap);
            this.panelModel.setLayerStyle(mainCanvasDataSource.getConnectionProperties(), queryObject);
            this.panelModel.setLayerStyle(mainCanvasDataSource2.getConnectionProperties(), queryObject);
            this.panelModel.setLayerStyle(mainCanvasDataSource3.getConnectionProperties(), queryObject);
            geometrySetLayer.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.renderStyle", mainCanvasDataSource.getConnectionProperties().getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.renderStyle"));
            geometrySetLayer.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.labelStyle", mainCanvasDataSource.getConnectionProperties().getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.labelStyle"));
            geometrySetLayer2.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.renderStyle", mainCanvasDataSource2.getConnectionProperties().getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.renderStyle"));
            geometrySetLayer2.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.labelStyle", mainCanvasDataSource2.getConnectionProperties().getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.labelStyle"));
            geometrySetLayer3.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.renderStyle", mainCanvasDataSource3.getConnectionProperties().getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.renderStyle"));
            geometrySetLayer3.setProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.labelStyle", mainCanvasDataSource3.getConnectionProperties().getProperty("oracle.spatial.edit.layer.AbstractDataSetLayer.labelStyle"));
            this.panelView.updateLayer((Layer)geometrySetLayer, mainCanvasDataSource.getConnectionProperties());
            this.panelView.updateLayer((Layer)geometrySetLayer2, mainCanvasDataSource2.getConnectionProperties());
            this.panelView.updateLayer((Layer)geometrySetLayer3, mainCanvasDataSource3.getConnectionProperties());
            this.clearAllSelections();
        } else {
            Vector vector = new Vector();
            this.selectedRow = n;
            this.origData = queryObject;
            try {
                if (!bl2) {
                    String string2 = "";
                } else {
                    String string3 = queryObject.getAnnotatedColumn();
                    queryObject.setLabelChanged(false);
                }
                this.replaceTask();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private QueryObject buildQueryObject() {
        QueryObject queryObject = null;
        queryObject = new QueryObject(this.origData.getQueryTitle(), this.proposedQuery, this.origData.getAnnotatedColumn(), this.origData.getLabelColor(), this.origData.getMarkerColor(), this.origData.getMarkerFillColor(), this.origData.getMarkerSize(), this.origData.getMarkerType(), this.origData.getCurvesColor(), this.origData.getCurveLineWidth(), this.origData.getAreaBorderColor(), this.origData.getAreaFillColor(), this.origData.getCandidateAnnotation(), this.origData.getCnx());
        queryObject.setTabIdentifier(this.panelModel.getTableModel().getIdentifier().toString());
        queryObject.setNewlyCreated();
        queryObject.setPreselected(this.origData.isPreselected());
        queryObject.setConnectionSourceName(this.origData.getConnectionSourceName());
        return queryObject;
    }

    private void insertObjectInTable(QueryObject queryObject) {
        Vector<Object> vector = new Vector();
        this.removeLayer(this.selectedRow);
        if (this.panelModel.getTableModel().getRowList().contains(this.origData)) {
            this.panelModel.getTableModel().removeRow(this.selectedRow);
            this.panelModel.getTableModel().addRowAt(queryObject, this.selectedRow);
        }
        try {
            vector = MapViewerHelper.getQuerySRIDS(this.proposedQuery, this.origData.getCnx());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (vector.size() > 0) {
            this.panelModel.getTableModel().setTableSRID(((Integer[])vector.get(0))[0]);
            SpatialUtil.getPanel().getTabPageByTabId(this.panelModel.getTableModel().getIdentifier().toString()).getSridLabel().setText(SpatialArb.getString("ActiveSRID") + ((Integer[])vector.get(0))[0]);
        } else {
            this.panelModel.getTableModel().setTableSRID(-10);
            SpatialUtil.getPanel().getTabPageByTabId(this.panelModel.getTableModel().getIdentifier().toString()).setDefaultLabel();
        }
    }

    private void replaceTask() {
        RaptorTask<Object> raptorTask = new RaptorTask<Object>("Updating mapquery", true, IRaptorTaskRunMode.IDE_STATUSBAR){

            protected Object doWork() {
                RenderingPanelController.this.queryObj = RenderingPanelController.this.buildQueryObject();
                return null;
            }
        };
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SpatialViewController.getInstance().toggleToolbar();
                    }
                });
            }

            public void taskCancelled(RaptorTaskEvent raptorTaskEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SpatialViewController.getInstance().toggleToolbar();
                    }
                });
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        RenderingPanelController.this.insertObjectInTable(RenderingPanelController.this.queryObj);
                        SpatialViewController.getInstance().toggleToolbar();
                        SpatialUtil.getPanel().setAllTabsCloseable(true);
                    }
                });
            }
        });
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    public void highLiteGeometries(Struct[] structArray, boolean bl) throws SQLException {
        int n = this.panelView.getCanvas().getLayerManager().size();
        JGeometry[] jGeometryArray = new JGeometry[1];
        boolean bl2 = false;
        try {
            jGeometryArray[0] = JGeometry.loadJS((Struct)structArray[0]);
        }
        catch (SQLException sQLException) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)sQLException.getMessage(), (String)SpatialArb.getString("IdentifyGeometry"), null);
            return;
        }
        if (!MapViewerHelper.isConnectionValid(this.panelModel.getConnection())) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)SpatialArb.getString("SpatialError13500"), (String)"", null);
            return;
        }
        if (!this.panelModel.checkGeometryValidity(structArray[0])) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)SpatialArb.getString("InvalidGeometryError"), (String)SpatialArb.getString("IdentifyGeometry"), null);
            return;
        }
        block5: for (int i = 0; i < n; ++i) {
            try {
                GeometrySetLayer geometrySetLayer = (GeometrySetLayer)this.panelView.getCanvas().getLayerManager().get(i);
                if (geometrySetLayer == null || structArray == null) continue;
                HashMap hashMap = (HashMap)((MainCanvasDataSource)geometrySetLayer.getDataSource()).getMap();
                ArrayList arrayList = new ArrayList(hashMap.keySet());
                for (int j = 0; j < arrayList.size(); ++j) {
                    Object v = hashMap.get(arrayList.get(j));
                    if (!(v instanceof JGeometry) || !v.equals(jGeometryArray[0])) continue;
                    geometrySetLayer.setHighliteGeometries(jGeometryArray);
                    bl2 = true;
                    continue block5;
                }
                continue;
            }
            catch (ClassCastException classCastException) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, classCastException.getStackTrace()[0].toString(), classCastException);
                continue;
            }
            catch (Exception exception) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, exception.getStackTrace()[0].toString(), exception);
            }
        }
        this.panelModel.getTableModel().saveHiliteGeoms(jGeometryArray);
        if (!bl2 && bl) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)SpatialArb.getString("GeometryNotFound"), (String)SpatialArb.getString("IdentifyGeometry"), null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearHighLiteGeometries() {
        int n = this.panelView.getCanvas().getLayerManager().size();
        for (int i = 0; i < n; ++i) {
            try {
                GeometrySetLayer geometrySetLayer = (GeometrySetLayer)this.panelView.getCanvas().getLayerManager().getLayerByPosition(Integer.valueOf(i));
                if (geometrySetLayer == null) continue;
                geometrySetLayer.setHighliteGeometries(new JGeometry[0]);
                continue;
            }
            catch (ClassCastException classCastException) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, classCastException.getStackTrace()[0].toString(), classCastException);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
            finally {
                this.panelModel.getTableModel().saveHiliteGeoms(new JGeometry[0]);
            }
        }
    }
}

