/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.dialogs.newquery.model;

import java.awt.Color;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.table.TableModel;
import oracle.dbtools.spatial.SpatialArb;
import oracle.dbtools.spatial.mapviewer.model.SpatialComboBoxLoader;
import oracle.dbtools.spatial.views.tables.SpatialReorderableTableModel;
import oracle.ide.help.HelpInfo;
import oracle.javatools.editor.BasicDocument;
import oracle.javatools.editor.gutter.LineGutterPlugin;
import oracle.javatools.editor.plugins.LineHighlightPlugin;

public class NewQueryModel {
    private BasicDocument basicDoc;
    private Connection mapConnection;
    private TableModel mapsTableModel;
    public static final Color DEFAULT_AREA_FILL_COLOR = Color.yellow;
    public static final Color DEFAULT_AREA_BORDER_COLOR = Color.gray;
    public static final Color DEFAULT_LINE_COLOR = Color.black;
    public static final Color DEFAULT_MARKER_COLOR = Color.black;
    public static final Color DEFAULT_MARKER_FILL_COLOR = Color.red;
    public static final int DEFAULT_LINE_WIDTH = 1;
    public static final int DEFAULT_MARKER_SIZE = 8;
    public static final int DEFAULT_MARKER_STYLE = 0;
    public static final int MARKER_STYLE_CIRCLE = 0;
    public static final int MARKER_STYLE_STAR = 1;
    public static final int MARKER_STYLE_RECT = 2;
    public static final int MARKER_STYLE_ARROW = 3;
    private Color area_fill_color = DEFAULT_AREA_FILL_COLOR;
    private Color area_border_color = DEFAULT_AREA_BORDER_COLOR;
    private Color marker_border = DEFAULT_MARKER_COLOR;
    private Color marker_fill = DEFAULT_MARKER_FILL_COLOR;
    private Color line_color = DEFAULT_LINE_COLOR;
    private Color labelColor = DEFAULT_LINE_COLOR;
    private int line_width;
    private int marker_size;
    private String queryTitle;
    private String queryText;
    private int markerStyle;
    private String labelColumn;
    private Map<String, Integer> markerNames;
    private String[] markerKeys;
    private SpatialComboBoxLoader comboLoader;
    private HelpInfo helpInfo;
    private LineHighlightPlugin m_sqlHighlite;
    private LineGutterPlugin m_sqlGutter;
    private int currentTableSRID = -10;

    public NewQueryModel(Connection connection, TableModel tableModel) {
        this.mapConnection = connection;
        this.mapsTableModel = tableModel;
        this.comboLoader = new SpatialComboBoxLoader(this.mapConnection);
        this.initModel();
    }

    private void initModel() {
        this.basicDoc = new BasicDocument("foo.plsql");
        this.helpInfo = new HelpInfo("f1_mapquery_html");
        this.m_sqlGutter = new LineGutterPlugin();
        this.m_sqlHighlite = new LineHighlightPlugin();
        this.setLabelColumn("");
        this.setMarkerStyle(0);
        this.setQueryText("");
        this.setQueryTitle("");
        this.setMarker_size(8);
        this.setLine_width(1);
        this.currentTableSRID = ((SpatialReorderableTableModel)((Object)this.mapsTableModel)).getTableSRID();
        this.initMap();
    }

    public HelpInfo getHelpInfo() {
        return this.helpInfo;
    }

    public BasicDocument getDocument() {
        return this.basicDoc;
    }

    private void initMap() {
        String[] stringArray = new String[]{SpatialArb.getString("Circle"), SpatialArb.getString("Star"), SpatialArb.getString("Rect"), SpatialArb.getString("Arrow")};
        this.markerKeys = stringArray;
        this.markerNames = new HashMap<String, Integer>();
        this.markerNames.put(this.markerKeys[0], 0);
        this.markerNames.put(this.markerKeys[1], 1);
        this.markerNames.put(this.markerKeys[2], 2);
        this.markerNames.put(this.markerKeys[3], 3);
    }

    public void setMapConnection(Connection connection) {
        this.mapConnection = connection;
    }

    public Connection getMapConnection() {
        return this.mapConnection;
    }

    public void setQueryTitle(String string) {
        this.queryTitle = string;
    }

    public String getQueryTitle() {
        return this.queryTitle;
    }

    public void setQueryText(String string) {
        this.queryText = string;
    }

    public String getQueryText() {
        return this.queryText;
    }

    public void setLabelColumn(String string) {
        this.labelColumn = string;
    }

    public String getLabelColumn() {
        return this.labelColumn;
    }

    public void setArea_fill_color(Color color) {
        this.area_fill_color = color;
    }

    public Color getArea_fill_color() {
        return this.area_fill_color;
    }

    public void setArea_border_color(Color color) {
        this.area_border_color = color;
    }

    public Color getArea_border_color() {
        return this.area_border_color;
    }

    public void setLine_color(Color color) {
        this.line_color = color;
    }

    public Color getLine_color() {
        return this.line_color;
    }

    public void setLine_width(int n) {
        this.line_width = n;
    }

    public int getLine_width() {
        return this.line_width;
    }

    public void setMarker_size(int n) {
        this.marker_size = n;
    }

    public int getMarker_size() {
        return this.marker_size;
    }

    public void setMarkerStyle(String string) {
        int n = this.markerNames.get(string);
        this.setMarkerStyle(n);
    }

    private void setMarkerStyle(int n) {
        this.markerStyle = n;
    }

    public int getMarkerStyle() {
        return this.markerStyle;
    }

    public void setMarkerFillColor(Color color) {
        this.marker_fill = color;
    }

    public Color getMarkerFillColor() {
        return this.marker_fill;
    }

    public Color getMarker_color() {
        return this.marker_border;
    }

    public String[] getMarkerItems() {
        return this.markerKeys;
    }

    public void setMarkerBorder(Color color) {
        this.marker_border = color;
    }

    public TableModel getMapsTableModel() {
        return this.mapsTableModel;
    }

    public SpatialComboBoxLoader getComboLoader() {
        return this.comboLoader;
    }

    public LineHighlightPlugin getHighLightPlugin() {
        return this.m_sqlHighlite;
    }

    public LineGutterPlugin getLineGutterPlugin() {
        return this.m_sqlGutter;
    }

    public void setLabelColor(Color color) {
        this.labelColor = color;
    }

    public Color getLabelColor() {
        return this.labelColor;
    }

    public void setCurrentTableSRID(int n) {
        this.currentTableSRID = n;
    }

    public int getCurrentTableSRID() {
        return this.currentTableSRID;
    }
}

