/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.dialogs.metadata.model;

import java.util.Vector;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.spatial.dialogs.metadata.model.ProcessSQL;
import oracle.dbtools.spatial.dialogs.metadata.model.SpatialDimension;

public class SpatialMetadataModel {
    private String tableName;
    private String spatialIndex;
    private String spatialRefID = "";
    private Vector spatialcols = null;
    private Vector<SpatialDimension> dimList = new Vector();
    private DBObject dbObject;
    private ProcessSQL processSql = new ProcessSQL();
    private String spatialcol = null;
    private boolean isColumnSelected;

    public void setDBObject(DBObject dBObject) {
        this.dbObject = dBObject;
    }

    public void setIsColumnSelected(boolean bl) {
        this.isColumnSelected = bl;
    }

    public boolean getIsColumnSelected() {
        return this.isColumnSelected;
    }

    public void setCurrrentColumn(String string) {
        this.spatialcol = string;
    }

    public String getCurrentColumn() {
        return this.spatialcol;
    }

    public Vector getDimensionList() {
        return this.dimList;
    }

    public int getDimensionSize() {
        return this.dimList.size();
    }

    public void removeDimension(int n) {
        this.dimList.remove(n);
    }

    public void addDimension(SpatialDimension spatialDimension) {
        this.dimList.add(spatialDimension);
    }

    public boolean isSingleColumnSpatial() {
        for (int i = 0; i < this.getSpatialColumnSize(); ++i) {
            String string = this.getCurrentColumn();
            if (!this.getSpatialColumn(i).equals(string)) continue;
            return true;
        }
        return false;
    }

    public void setInitialModelData() {
        Vector vector = null;
        String string = "";
        String string2 = "";
        this.dimList.clear();
        this.spatialcols = null;
        this.setTableName(this.dbObject.getObjectName());
        Vector vector2 = this.processSql.getSpatialColumns(this.dbObject);
        this.setSpatialColumns(vector2);
        if (!this.isColumnSelected) {
            this.spatialcol = this.getFirstColumn();
        }
        if (this.spatialcol != null) {
            string = this.processSql.getSpatialSRID(this.dbObject, this.spatialcol);
            string2 = this.processSql.getSpatialIndex(this.dbObject, this.spatialcol);
        }
        this.setSpatialRefID(string);
        this.setSpatialIndex(string2);
        if (this.spatialcol != null) {
            vector = this.processSql.getSpatialDimensions(this.dbObject, this.spatialcol);
            for (int i = 0; i < vector.size(); ++i) {
                this.addDimension((SpatialDimension)vector.elementAt(i));
            }
        }
    }

    public void applyModelData() {
        this.processSql.deleteSpatialMetadata(this.dbObject, this.spatialcol);
        this.processSql.insertSpatialMetadata(this.dbObject, this.spatialcol, this.dimList, this.spatialRefID);
    }

    public void setModelDataForColumn(String string) {
        Vector vector = null;
        this.dimList.clear();
        this.spatialcol = string;
        String string2 = this.processSql.getSpatialSRID(this.dbObject, this.spatialcol);
        this.setSpatialRefID(string2);
        String string3 = this.processSql.getSpatialIndex(this.dbObject, this.spatialcol);
        this.setSpatialIndex(string3);
        if (string != null) {
            vector = this.processSql.getSpatialDimensions(this.dbObject, string);
        }
        for (int i = 0; i < vector.size(); ++i) {
            this.addDimension((SpatialDimension)vector.elementAt(i));
        }
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public String getSpatialIndex() {
        return this.spatialIndex;
    }

    public void setSpatialIndex(String string) {
        this.spatialIndex = string;
    }

    public String getSpatialRefID() {
        return this.spatialRefID.toString();
    }

    public void setSpatialRefID(String string) {
        this.spatialRefID = string == null ? "" : string;
    }

    public String getFirstColumn() {
        return this.getSpatialColumn(0);
    }

    public Vector getSpatialColumns() {
        return this.spatialcols;
    }

    public String getSpatialColumn(int n) {
        if (this.spatialcols.size() > n) {
            return (String)this.spatialcols.elementAt(n);
        }
        return null;
    }

    public int getSpatialColumnSize() {
        return this.spatialcols.size();
    }

    public void setSpatialColumns(Vector vector) {
        this.spatialcols = vector;
    }
}

