/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.spatial.actions.updatemetadata;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.dbtools.raptor.controls.UIUtils;
import oracle.dbtools.raptor.dialogs.actions.AbstractMenuAction;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.spatial.SpatialArb;
import oracle.dbtools.spatial.dialogs.metadata.controller.SpatialMetadataController;
import oracle.dbtools.spatial.dialogs.metadata.model.SpatialMetadataModel;
import oracle.dbtools.spatial.dialogs.metadata.view.SpatialMetadataView;
import oracle.ide.help.HelpSystem;

public class AddMetadata
extends AbstractMenuAction {
    private JEWTDialog dlg;
    private static SpatialMetadataModel model = null;
    private static SpatialMetadataView view = null;
    private static SpatialMetadataController controller = null;
    private boolean columnSelected = false;
    private DBObject dbObject;

    public void launch() {
        this.dbObject = this.getDBObject();
        String string = this.dbObject.getObjectType();
        String string2 = this.dbObject.getChildName();
        if (model == null) {
            model = new SpatialMetadataModel();
            view = new SpatialMetadataView(model);
            view.createMainPanel();
            controller = new SpatialMetadataController(model, view);
        }
        model.setDBObject(this.dbObject);
        if (this.columnSelected) {
            model.setCurrrentColumn(string2);
            model.setIsColumnSelected(true);
        } else {
            model.setIsColumnSelected(false);
        }
        controller.removeListeners();
        JPanel jPanel = view.getMainPanel();
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_spatialmetadata_html");
        this.dlg = UIUtils.createPanelDialog((JPanel)jPanel, (String)SpatialArb.getString("MaintainSpatialMetadata"), null, (boolean)true);
        controller.populateSpatialModel(this.dlg);
        this.dlg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = model.getFirstColumn();
                if (string == null) {
                    AddMetadata.this.dlg.dispose();
                    return;
                }
                if (model.getIsColumnSelected() && !model.isSingleColumnSpatial()) {
                    AddMetadata.this.dlg.dispose();
                    return;
                }
                boolean bl = view.checkInput();
                if (bl) {
                    controller.applyModelData();
                    AddMetadata.this.dlg.dispose();
                }
            }
        });
        this.dlg.runDialog();
    }

    public void setArgs(String string) {
        if (string != null && string.indexOf("COLUMN") >= 0) {
            this.columnSelected = true;
        }
    }
}

