/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.workbench.sybase12;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import oracle.dbtools.migration.capture.offline.OfflineCaptureException;
import oracle.dbtools.migration.workbench.plugin.sybaseofflinecapture.GenerateDSMLFormattedFiles;
import oracle.dbtools.migration.workbench.plugin.sybaseofflinecapture.MetadataFileParser;
import oracle.dbtools.migration.workbench.plugin.sybaseofflinecapture.ObjectStatusList;
import oracle.dbtools.migration.workbench.plugin.sybaseofflinecapture.OracleDatatypeIdentifiers;
import oracle.dbtools.migration.workbench.sybase12.Sybase12AbstractCapturer;

public class Sybase12DoOfflineCaptureLoad
implements OracleDatatypeIdentifiers {
    private HashMap<File, ArrayList<File>> _dbXMLMetadataList = new HashMap();
    private HashMap<File, ObjectStatusList> m_dSMLMap = null;
    private String _currentTableName = null;
    private int _currentDbId = 0;
    public String currValue = "";
    private HashMap<String, String[]> m_tableTypes = new HashMap();
    private Connection m_conn = null;
    private static String m_encoding = null;

    public Sybase12DoOfflineCaptureLoad(Connection connection) {
        this.m_conn = connection;
        this.populateTableTypes();
    }

    public void convertBcpDumpToXML(HashMap<File, ObjectStatusList> hashMap) throws OfflineCaptureException {
        this.m_dSMLMap = hashMap;
        Statement statement = null;
        Connection connection = null;
        try {
            connection = this.m_conn;
            statement = connection.createStatement();
            GenerateDSMLFormattedFiles generateDSMLFormattedFiles = new GenerateDSMLFormattedFiles(this.m_dSMLMap, Sybase12DoOfflineCaptureLoad.getEncoding());
            this._dbXMLMetadataList = generateDSMLFormattedFiles.getDSMLFormattedFilesTable();
        }
        catch (SQLException sQLException) {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw new OfflineCaptureException((Exception)sQLException);
        }
        catch (Exception exception) {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw new OfflineCaptureException(exception);
        }
    }

    public void loadSourceModel(HashMap<File, ObjectStatusList> hashMap) throws OfflineCaptureException {
        this.m_dSMLMap = hashMap;
        Statement statement = null;
        Connection connection = null;
        try {
            connection = this.m_conn;
            statement = connection.createStatement();
            GenerateDSMLFormattedFiles generateDSMLFormattedFiles = new GenerateDSMLFormattedFiles(this.m_dSMLMap, Sybase12DoOfflineCaptureLoad.getEncoding());
            this._dbXMLMetadataList = generateDSMLFormattedFiles.getDSMLFormattedFilesTable();
            File file = this.getDbFile("MASTER");
            if (file == null) {
                throw new OfflineCaptureException(new Exception());
            }
            this._currentDbId = 1;
            this.populateSourceModel(connection, file, 1);
            for (File file2 : this._dbXMLMetadataList.keySet()) {
                int n;
                if (file2.getName().equalsIgnoreCase("MASTER")) continue;
                this._currentDbId = n = this.getDbId(connection, file2.getName());
                Sybase12AbstractCapturer.OfflineDbId = n;
                if (n == 0) continue;
                this.populateSourceModel(connection, file2, n);
            }
            this.sourceModelIndexCreate(connection);
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw new OfflineCaptureException((Exception)sQLException);
        }
        catch (Exception exception) {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            throw new OfflineCaptureException(exception);
        }
    }

    public File getDbFile(String string) {
        File file = null;
        for (File file2 : this.m_dSMLMap.keySet()) {
            String string2 = file2.getName();
            if (!string2.equalsIgnoreCase(string)) continue;
            file = file2;
            break;
        }
        return file;
    }

    public int getDbId(Connection connection, String string) throws OfflineCaptureException {
        Statement statement = null;
        ResultSet resultSet = null;
        int n = 0;
        try {
            statement = connection.createStatement();
            String string2 = " SELECT DBID FROM SYB12_SYSDATABASES  WHERE UPPER(NAME) = '" + string.toUpperCase() + "' ";
            resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            return n;
        }
        catch (SQLException sQLException) {
            throw new OfflineCaptureException((Exception)sQLException);
        }
    }

    public void populateSourceModel(Connection connection, File file, int n) throws OfflineCaptureException {
        try {
            ArrayList<File> arrayList = this._dbXMLMetadataList.get(file);
            Iterator<File> iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                File file2;
                File file3 = file2 = iterator.next();
                this._currentTableName = GenerateDSMLFormattedFiles.getUnqualifiedName(file3.getName());
                this._currentTableName = this.getCorrectName(this._currentTableName);
                String[] stringArray = this.getFieldTypes(this._currentTableName);
                if (stringArray == null) continue;
                MetadataFileParser metadataFileParser = new MetadataFileParser(this._currentDbId, Sybase12DoOfflineCaptureLoad.fileToURL(file3), this._currentTableName);
                metadataFileParser.createPrepardStatement(connection, stringArray);
                int n2 = metadataFileParser.loadData();
            }
        }
        catch (Exception exception) {
            throw new OfflineCaptureException(exception);
        }
    }

    private String getCorrectName(String string) {
        if (string.startsWith("SYB12")) {
            return string;
        }
        if (string.startsWith("SYB15")) {
            return "SYB12_" + string.split("_")[1];
        }
        return string;
    }

    private String[] getFieldTypes(String string) {
        String[] stringArray = null;
        for (String string2 : this.m_tableTypes.keySet()) {
            if (!string.equalsIgnoreCase(string2)) continue;
            stringArray = this.m_tableTypes.get(string2.toUpperCase());
            break;
        }
        return stringArray;
    }

    private void populateTableTypes() {
        String[] stringArray = new String[]{"3", "1", "3", "3", "3", "3", "3", "1", "1", "3", "3", "3", "3", "3", "3", "1", "3", "3"};
        this.m_tableTypes.put("SYB12_SYSDATABASES", stringArray);
        String[] stringArray2 = new String[]{"3", "3", "3", "3", "1", "1"};
        this.m_tableTypes.put("SYB12_SYSUSERS", stringArray2);
        String[] stringArray3 = new String[]{"3", "1", "3", "3", "1", "3", "3", "3", "3", "3", "1", "1", "3", "3", "3", "3", "3", "3", "3", "3", "6", "1"};
        this.m_tableTypes.put("SYB12_SYSOBJECTS", stringArray3);
        String[] stringArray4 = new String[]{"3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "3", "1", "1", "3", "3", "3", "1", "3", "3", "3", "3", "3"};
        this.m_tableTypes.put("SYB12_SYSCOLUMNS", stringArray4);
        String[] stringArray5 = new String[]{"3", "3", "3", "3", "3", "3", "3", "3", "3", "1", "1", "3", "3", "3", "3", "3", "3", "3"};
        this.m_tableTypes.put("SYB12_SYSTYPES", stringArray5);
        String[] stringArray6 = new String[]{"3", "3", "3", "3", "3", "3", "1", "3", "3"};
        this.m_tableTypes.put("SYB12_SYSCOMMENTS", stringArray6);
        String[] stringArray7 = new String[]{"3", "3", "1", "1", "1"};
        this.m_tableTypes.put("SYB12_SYSINDEXES", stringArray7);
        String[] stringArray8 = new String[]{"3", "3", "1", "1"};
        this.m_tableTypes.put("SYB12_SYSCONSTRAINTS", stringArray8);
    }

    private static URL fileToURL(File file) {
        String string = file.getAbsolutePath();
        String string2 = System.getProperty("file.separator");
        if (string2 != null && string2.length() == 1) {
            string = string.replace(string2.charAt(0), '/');
        }
        if (string.length() > 0 && string.charAt(0) != '/') {
            string = '/' + string;
        }
        try {
            return new URL("file", null, string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new Error("Unexpected MalformedURLException");
        }
    }

    public void sourceModelIndexCreate(Connection connection) throws OfflineCaptureException {
        Statement statement = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            arrayList.add("CREATE INDEX SYSOBJECTS_IDX1 ON SYB12_SYSOBJECTS(ID)");
            arrayList.add("CREATE INDEX SYSCOMMENTS_IDX1 ON SYB12_SYSCOMMENTS(ID)");
            statement = connection.createStatement();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                String string;
                String string2 = string = (String)iterator.next();
                try {
                    statement.execute(string2);
                }
                catch (SQLException sQLException) {}
            }
            statement.close();
            arrayList.clear();
        }
        catch (SQLException sQLException) {
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
        }
    }

    public static void setEncoding(String string) {
        m_encoding = string;
    }

    public static String getEncoding() {
        return m_encoding;
    }
}

