/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.animation.timing.interpolation;

import java.lang.reflect.Method;
import org.jdesktop.animation.timing.interpolation.KeyValues;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class KeyValuesInt
extends KeyValues<Integer> {
    public KeyValuesInt(int ... values) {
        super(values);
        for (int value : values) {
            this.values.add(value);
        }
    }

    @Override
    public Class<?> getType() {
        return Integer.TYPE;
    }

    @Override
    public void setValue(Object object, Method method, int i0, int i1, float fraction) {
        int value;
        if (i0 == i1) {
            value = (Integer)this.values.get(i0);
        } else {
            int v0 = (Integer)this.values.get(i0);
            int v1 = (Integer)this.values.get(i1);
            value = (int)((float)v0 + (float)(v1 - v0) * fraction + 0.5f);
        }
        try {
            method.invoke(object, value);
        }
        catch (Exception e) {
            System.out.println("Problem invoking method in KVInt.setValue:" + e);
        }
    }

    @Override
    public void setValue(Object object, Method method, int index) {
        try {
            method.invoke(object, this.values.get(index));
        }
        catch (Exception e) {
            System.out.println("Problem invoking method in KVInt.setValue:" + e);
        }
    }
}

