/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.tests;

import com.adbs.ast.AstToken;
import com.adbs.ast.AstTokenIdentifier;
import com.adbs.ast.BaseSQLContext;
import com.adbs.ast.MetadataContainer;
import com.adbs.ast.MetadataField;
import com.adbs.ast.MetadataObject;
import com.adbs.ast.MetadataTable;
import com.adbs.ast.SQLQualifiedName;
import com.adbs.querybuilder.PlainTextSQLBuilder;
import com.adbs.querybuilder.QueryBuilder;
import com.adbs.querybuilder.SQLUpdatedEvent;
import com.adbs.querybuilder.SQLUpdatedEventListener;
import com.adbs.syntax.BaseSyntaxProvider;
import com.adbs.syntax.OracleServerVersion;
import com.adbs.syntax.OracleSyntaxProvider;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;

public class Main {
    public static void main(String[] args) {
        new Main();
    }

    public Main() {
        JFrame guiFrame = new JFrame();
        final PlainTextSQLBuilder plainTextSQLBuilder = new PlainTextSQLBuilder();
        guiFrame.setDefaultCloseOperation(3);
        guiFrame.setTitle("Example GUI");
        guiFrame.setSize(300, 250);
        guiFrame.setLocationRelativeTo(null);
        final QueryBuilder queryBuilder = new QueryBuilder();
        queryBuilder.setOfflineMode(true);
        queryBuilder.setUseAltNames(true);
        plainTextSQLBuilder.setQueryBuilder(queryBuilder);
        plainTextSQLBuilder.setUseAltNames(true);
        OracleSyntaxProvider sp = new OracleSyntaxProvider();
        sp.setServerVersion(OracleServerVersion.Oracle9);
        queryBuilder.setSyntaxProvider((BaseSyntaxProvider)sp);
        this.initMetadata(queryBuilder);
        final JTextArea textSql = new JTextArea();
        queryBuilder.addSQLUpdatedEventListener(new SQLUpdatedEventListener(){

            public void sqlUpdatedEventOccurred(SQLUpdatedEvent sqlUpdatedEvent) {
                textSql.setText(plainTextSQLBuilder.getSQL());
            }
        });
        textSql.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                queryBuilder.setSQL(textSql.getText());
            }
        });
        JSplitPane splitPane = new JSplitPane(0, (Component)queryBuilder, textSql);
        splitPane.setResizeWeight(0.75);
        guiFrame.add((Component)splitPane, "Center");
        queryBuilder.setSQL("Select * From hr.md_transaction t inner join hr.md_book b on t.id=b.id");
        guiFrame.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMetadata(QueryBuilder qb) {
        BaseSQLContext sqlContext = qb.getSQLContext();
        MetadataContainer container = qb.getMetadataContainer();
        AstTokenIdentifier schema = new AstTokenIdentifier(sqlContext, "hr", false);
        try {
            MetadataField field;
            MetadataField field2;
            AstTokenIdentifier ast;
            SQLQualifiedName field_name;
            MetadataTable table;
            container.setDefaultSchemaNamesStr("zz");
            AstTokenIdentifier table_name = new AstTokenIdentifier(sqlContext, "MD_Book", false);
            try {
                table = container.addTable(schema, table_name, false, null);
                table.getName().setCaseSensitive(true);
                table.getSchema().setCaseSensitive(true);
                table.setAltName("MD_book2");
                table.setAltNameCaseSensitive(true);
                field_name = new SQLQualifiedName(sqlContext);
                try {
                    ast = new AstTokenIdentifier(sqlContext, "id", false);
                    ast.setCaseSensitive(true);
                    field_name.addName((AstToken)ast);
                    field2 = table.getFields().add();
                    field2.setName(field_name);
                    field2.setAltName("Id");
                    field2.setFieldTypeName("NUMBER");
                }
                finally {
                    field_name.dispose();
                }
                field_name = new SQLQualifiedName(sqlContext);
                field_name.addName((AstToken)new AstTokenIdentifier(sqlContext, "title", false));
                field = table.getFields().add();
                field.setName(field_name);
                field.setFieldTypeName("VARCHAR2");
                field.setSize(50);
            }
            finally {
                table_name.dispose();
            }
            MetadataObject mo = container.findObjectByAltName("\"MD_book2\"");
            MetadataObject mo2 = container.findObjectByFullName("MD_book");
            mo2 = container.findObjectByFullName("hr.\"MD_book\"");
            mo2 = container.findObjectByFullName("hr.MD_book");
            mo2 = container.findObjectByFullName("\"hr\".\"MD_book\"");
            MetadataObject mo3 = container.findObjectByFullName("MD_book");
            table_name = new AstTokenIdentifier(sqlContext, "MD_Transaction", false);
            try {
                table = container.addTable(schema, table_name, false, null);
                field_name = new SQLQualifiedName(sqlContext);
                try {
                    ast = new AstTokenIdentifier(sqlContext, "ID", false);
                    ast.setCaseSensitive(true);
                    field_name.addName((AstToken)ast);
                    field2 = table.getFields().add();
                    field2.setName(field_name);
                    field2.setFieldTypeName("NUMBER");
                }
                finally {
                    field_name.dispose();
                }
                field_name = new SQLQualifiedName(sqlContext);
                field_name.addName((AstToken)new AstTokenIdentifier(sqlContext, "trans_date", false));
                field = table.getFields().add();
                field.setName(field_name);
                field.setFieldTypeName("DATE");
            }
            finally {
                table_name.dispose();
            }
        }
        finally {
            schema.dispose();
        }
    }
}

