/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.string;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.crest.model.metadata.XMLToObjectTransformer;

public class StringUtilities {
    public static final String EMPTY_STRING = "";
    public static final String NEWLINE = System.getProperty("line.separator");

    private StringUtilities() {
    }

    public static String replace(String text, String oldPart, String newPart) {
        StringBuffer buffer = new StringBuffer();
        StringUtilities.replace(text, oldPart, newPart, buffer);
        return buffer.toString();
    }

    public static void replace(String text, String oldPart, String newPart, StringBuffer buffer) {
        int pos = 0;
        int oldpos = 0;
        while (pos >= 0) {
            pos = text.indexOf(oldPart, oldpos);
            if (pos == -1) {
                buffer.append(text.substring(oldpos));
                continue;
            }
            buffer.append(text.substring(oldpos, pos));
            buffer.append(newPart);
            oldpos = pos + oldPart.length();
        }
    }

    public static String labeledComment(String label, String comment) {
        return new StringBuffer().append(StringUtilities.labeledStart(label)).append(comment).append(StringUtilities.labeledEnd()).toString();
    }

    public static String labeledStart(String label) {
        return new StringBuffer().append('[').append(label).append(": ").toString();
    }

    public static String labeledEnd() {
        return "]";
    }

    public static String removeAllBetween(String text, String start, String end) {
        StringBuffer buffer = new StringBuffer();
        int posStart = 0;
        int posEnd = 0;
        int posCopy = 0;
        int endLength = end.length();
        do {
            posStart = text.indexOf(start, posEnd);
            posEnd = text.indexOf(end, posStart);
            if (posStart >= 0 && posStart < posEnd) {
                buffer.append(text.substring(posCopy, posStart));
                posCopy = posEnd + endLength;
                continue;
            }
            buffer.append(text.substring(posCopy, text.length()));
        } while (posStart >= 0);
        return buffer.toString();
    }

    public static boolean isEmpty(String text) {
        return text == null || text.trim().equals(EMPTY_STRING);
    }

    public static boolean isNotEmpty(String text) {
        return !StringUtilities.isEmpty(text);
    }

    public static String decodeAttributeValue(String encoded) {
        return StringUtilities.decodeAttributeValue(encoded, XMLToObjectTransformer.XMLEntityExpanded);
    }

    public static String decodeAttributeValue(String encoded, boolean entityExpanded) {
        if (encoded == null || EMPTY_STRING.equalsIgnoreCase(encoded)) {
            return encoded;
        }
        String string = encoded;
        if (!entityExpanded && string.indexOf(38) >= 0) {
            string = StringUtilities.replace(string, "&apos;", "'");
            string = StringUtilities.replace(string, "&quot;", "\"");
            string = StringUtilities.replace(string, "&lt;", "<");
            string = StringUtilities.replace(string, "&gt;", ">");
            string = StringUtilities.replace(string, "&amp;", "&");
        }
        if (string.indexOf("<br>") >= 0) {
            string = StringUtilities.replace(string, "<br>", "\r\n");
        }
        if (string.indexOf("<br/>") >= 0) {
            string = StringUtilities.replace(string, "<br/>", "\n");
        }
        if (string.indexOf("</br>") >= 0) {
            string = StringUtilities.replace(string, "</br>", "\r");
        }
        return string;
    }

    public static String encodeAttributeValue(String unencoded) {
        if (unencoded == null || EMPTY_STRING.equalsIgnoreCase(unencoded)) {
            return unencoded;
        }
        String string = StringUtilities.clearInvalidXMLCharacters(unencoded);
        if (string.indexOf("&quot;") >= 0) {
            string = StringUtilities.replace(string, "&quot;", "&amp;quot;");
        }
        if (string.indexOf("&lt;") >= 0) {
            string = StringUtilities.replace(string, "&lt;", "&amp;lt;");
        }
        if (string.indexOf("&gt;") >= 0) {
            string = StringUtilities.replace(string, "&gt;", "&amp;gt;");
        }
        if (string.indexOf(38) >= 0) {
            string = StringUtilities.replace(string, "&", "&amp;");
        }
        if (string.indexOf(34) >= 0) {
            string = StringUtilities.replace(string, "\"", "&quot;");
        }
        if (string.indexOf(39) >= 0) {
            string = StringUtilities.replace(string, "'", "&apos;");
        }
        if (string.indexOf(60) >= 0) {
            string = StringUtilities.replace(string, "<", "&lt;");
        }
        if (string.indexOf(62) >= 0) {
            string = StringUtilities.replace(string, ">", "&gt;");
        }
        if (string.indexOf("\r\n") >= 0) {
            string = StringUtilities.replace(string, "\r\n", "&lt;br&gt;");
        }
        if (string.indexOf(10) >= 0) {
            string = StringUtilities.replace(string, "\n", "&lt;br/&gt;");
        }
        if (string.indexOf("\r") >= 0) {
            string = StringUtilities.replace(string, "\r", "&lt;/br&gt;");
        }
        return string;
    }

    public static String clearInvalidXMLCharacters(String string) {
        StringBuffer out = new StringBuffer();
        if (string == null || EMPTY_STRING.equals(string)) {
            return EMPTY_STRING;
        }
        for (int i = 0; i < string.length(); ++i) {
            char current = string.charAt(i);
            if (!(current == '\t' || current == '\n' || current == '\r' || current >= ' ' && current <= '\ud7ff' || current >= '\ue000' && current <= '\ufffd') && (current < '\u10000' || current > '\u10ffff')) continue;
            out.append(current);
        }
        return out.toString();
    }

    public static int lastIndexOf(String string, String expr) {
        String upstring = string.toUpperCase(Locale.ROOT);
        int index = upstring.lastIndexOf(expr.toUpperCase(Locale.ROOT));
        if (index > -1 && string.length() != upstring.length()) {
            Pattern pattern = Pattern.compile(expr, 66);
            return StringUtilities.lastIndexOf(string, pattern);
        }
        return index;
    }

    public static int lastIndexOf(String string, Pattern pattern) {
        Matcher matcher = pattern.matcher(string);
        int res = -1;
        while (matcher.find()) {
            res = matcher.start();
        }
        return res;
    }

    public static int indexOf(String string, String expr) {
        String upstring = string.toUpperCase(Locale.ROOT);
        int index = upstring.indexOf(expr.toUpperCase(Locale.ROOT));
        if (index > -1 && string.length() != upstring.length()) {
            Pattern pattern = Pattern.compile(expr, 66);
            return StringUtilities.indexOf(string, pattern);
        }
        return index;
    }

    public static int indexOf(String string, String expr, int fromIndex) {
        String upstring = string.toUpperCase(Locale.ROOT);
        int index = upstring.indexOf(expr.toUpperCase(Locale.ROOT), fromIndex);
        if (index > -1 && string.length() != upstring.length()) {
            Pattern pattern = Pattern.compile(expr, 66);
            int patternIndex = StringUtilities.indexOf(string.substring(fromIndex), pattern);
            if (patternIndex > -1) {
                return fromIndex + patternIndex;
            }
            return -1;
        }
        return index;
    }

    public static int indexOf(String string, Pattern pattern) {
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return matcher.start();
        }
        return -1;
    }

    public static String ltrim(String s) {
        int i;
        for (i = 0; i < s.length() && Character.isWhitespace(s.charAt(i)); ++i) {
        }
        return s.substring(i);
    }

    public static String rtrim(String s) {
        int i;
        for (i = s.length() - 1; i > 0 && Character.isWhitespace(s.charAt(i)); --i) {
        }
        return s.substring(0, i + 1);
    }

    public static String encodeAttributeValueJSON(String string) {
        if (string == null || EMPTY_STRING.equalsIgnoreCase(string)) {
            return string;
        }
        char c = '\u0000';
        int len = string.length();
        StringBuilder sb = new StringBuilder(len + 4);
        block9: for (int i = 0; i < len; ++i) {
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u" + t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }
}

