/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.propertymap.wrapperpool;

import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.crest.util.propertymap.PropertyMapWrapper;
import oracle.dbtools.crest.util.propertymap.wrapperpool.PMWPool;
import oracle.dbtools.crest.util.propertymap.wrapperpool.PMWPooled;

public class PMWPoolMap {
    private Map pmwPools = new HashMap();
    private static PMWPoolMap instance = null;

    private PMWPoolMap() {
    }

    static PMWPoolMap createInstanceForTestingOnly() {
        return new PMWPoolMap();
    }

    public static PMWPoolMap getInstance() {
        if (instance == null) {
            instance = new PMWPoolMap();
        }
        return instance;
    }

    public static void clearInstance() {
        instance = null;
    }

    public PropertyMapWrapper getInstance(Class wrappeeClass, Object wrappee) {
        return this.getInstance(wrappeeClass, Object.class, wrappee);
    }

    public PropertyMapWrapper getInstance(Class wrappeeClass, Class baseClass, Object wrappee) {
        return this.getPool(wrappeeClass, baseClass).getInstance(wrappee);
    }

    public void releaseInstance(PropertyMapWrapper wrapper) {
        if (wrapper instanceof PMWPooled) {
            PMWPooled pmwPooled = (PMWPooled)wrapper;
            this.getPool(pmwPooled.getWrappeeClass(), Object.class).releaseInstance(pmwPooled);
        }
    }

    private PMWPool getPool(Class wrappeeClass, Class baseClass) {
        if (!this.pmwPools.containsKey(wrappeeClass)) {
            this.createPool(wrappeeClass, baseClass);
        }
        return (PMWPool)this.pmwPools.get(wrappeeClass);
    }

    public PMWPool createPool(Class wrappeeClass, Class baseClass) {
        PMWPool pool = new PMWPool(baseClass, wrappeeClass);
        this.pmwPools.put(wrappeeClass, pool);
        return pool;
    }

    public void clearPMWPoolMap() {
        this.pmwPools.clear();
    }

    Map getPmwPools() {
        return this.pmwPools;
    }
}

