/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.propertymap.wrapperpool;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import oracle.dbtools.crest.util.propertymap.PropertyMapWrapper;
import oracle.dbtools.crest.util.propertymap.PropertyTranslator;
import oracle.dbtools.crest.util.propertymap.wrapperpool.PMWPooled;

public class PMWPool {
    private Class baseClass = Object.class;
    private Class wrappeeClass = Object.class;
    private Stack free = new Stack();
    private Set used = new HashSet();
    private int keepInstances = 10;
    private PropertyTranslator[] translators = new PropertyTranslator[0];
    private PropertyMapWrapper prototype = null;

    public PMWPool(Class baseClass, Class wrappeeClass) {
        this.baseClass = baseClass;
        this.wrappeeClass = wrappeeClass;
    }

    private PropertyMapWrapper createInstance() {
        PropertyMapWrapper instance = null;
        if (this.prototype == null) {
            this.prototype = new PMWPooled(this);
            this.prototype.setTranslators(this.translators);
            this.prototype.setBaseClass(this.baseClass);
            this.prototype.setWrappeeClass(this.wrappeeClass);
        }
        instance = this.prototype.makeClone();
        return instance;
    }

    public PropertyMapWrapper getInstance(Object wrappee) {
        PropertyMapWrapper instance = null;
        instance = this.free.isEmpty() ? this.createInstance() : (PropertyMapWrapper)this.free.pop();
        this.used.add(instance);
        instance.setWrappee(wrappee);
        return instance;
    }

    public void releaseInstance(PropertyMapWrapper instance) {
        instance.setWrappee(null);
        this.used.remove(instance);
        if (this.free.size() < this.keepInstances) {
            this.free.push(instance);
        } else if (instance instanceof PMWPooled) {
            ((PMWPooled)instance).setPool(null);
        }
    }

    public int getKeepInstances() {
        return this.keepInstances;
    }

    public void setKeepInstances(int number) {
        this.keepInstances = number;
    }

    public int getUsedInstanceCount() {
        return this.used.size();
    }

    public int getFreeInstanceCount() {
        return this.free.size();
    }

    public void setTranslators(PropertyTranslator[] translators) {
        this.translators = translators;
    }
}

