/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.gui.swing;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.View;

public class SelectedTabbedPaneUI
extends BasicTabbedPaneUI {
    private static final Color whiteColor = Color.white;
    private static final Color lightBlue = new Color(61, 149, 255, 50);
    private static final Color lightWhite = new Color(200, 200, 200, 50);
    private static final Color selectedColor = new Color(0, 84, 227);

    @Override
    protected void paintTabBackground(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        if (isSelected) {
            GradientPaint gradient = this.tabPane.isEnabledAt(tabIndex) ? new GradientPaint(x, y, selectedColor, x + w - 2, y, lightBlue) : new GradientPaint(x, y, this.shadow, x + w / 2, y, lightWhite);
            Graphics2D g2 = (Graphics2D)g;
            g2.setPaint(gradient);
            if (tabPlacement == 1) {
                g2.fillRect(x + 2, y + 2, w - 2, h - 2);
            } else {
                g2.fillRect(x + 2, y, w - 2, h - 1);
            }
        }
    }

    @Override
    protected void paintFocusIndicator(Graphics g, int tabPlacement, Rectangle[] rects, int tabIndex, Rectangle iconRect, Rectangle textRect, boolean isSelected) {
    }

    @Override
    protected void paintTabBorder(Graphics g, int tabPlacement, int tabIndex, int x, int y, int w, int h, boolean isSelected) {
        if (tabPlacement == 1) {
            g.setColor(this.shadow);
            g.drawLine(x, y + 2, x, y + h - 2);
            g.drawLine(x + 1, y + 1, x + 1, y + 1);
            g.drawLine(x + 2, y, x + w - 2, y);
            g.drawLine(x + w, y + 2, x + w, y + h - 2);
            g.drawLine(x + w - 1, y + 1, x + w - 1, y + 1);
            if (isSelected) {
                g.setColor(this.lightHighlight);
                g.drawLine(x + 1, y + 2, x + 1, y + h - 1);
                g.drawLine(x + 3, y + 1, x + w - 2, y + 1);
                g.drawLine(x + w - 1, y + 2, x + w - 1, y + h - 1);
            }
        } else if (tabPlacement == 3) {
            g.setColor(this.shadow);
            g.drawLine(x, y + 1, x, y + h - 2);
            g.drawLine(x + 2, y + h, x + 1, y - 1 + h);
            g.drawLine(x + 2, y + h, x + w - 3, y + h);
            g.drawLine(x + w, y + h - 2, x + w, y + 1);
            g.drawLine(x + w - 2, y + h, x + w - 1, y - 1 + h);
            if (isSelected) {
                g.setColor(this.lightHighlight);
                g.drawLine(x + 1, y, x + 1, y + h - 2);
                g.drawLine(x + 2, y - 1 + h, x + w - 2, y - 1 + h);
                g.drawLine(x + w - 1, y - 2 + h, x + w - 1, y);
            }
        } else {
            super.paintTabBorder(g, tabPlacement, tabIndex, x, y, w, h, isSelected);
        }
    }

    @Override
    protected void paintText(Graphics g, int tabPlacement, Font font, FontMetrics metrics, int tabIndex, String title, Rectangle textRect, boolean isSelected) {
        g.setFont(font);
        View v = this.getTextViewForTab(tabIndex);
        if (v != null) {
            v.paint(g, textRect);
        } else {
            int mnemIndex = this.tabPane.getDisplayedMnemonicIndexAt(tabIndex);
            if (this.tabPane.isEnabled() && this.tabPane.isEnabledAt(tabIndex)) {
                int p = 0;
                if (isSelected) {
                    g.setColor(whiteColor);
                    if (tabPlacement == 3) {
                        p = 2;
                    } else if (tabPlacement == 1) {
                        p = -2;
                    }
                } else {
                    g.setColor(this.tabPane.getForegroundAt(tabIndex));
                }
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent() - p);
            } else {
                g.setColor(this.tabPane.getBackgroundAt(tabIndex).brighter());
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x, textRect.y + metrics.getAscent());
                g.setColor(this.tabPane.getBackgroundAt(tabIndex).darker());
                BasicGraphicsUtils.drawStringUnderlineCharAt(g, title, mnemIndex, textRect.x - 1, textRect.y + metrics.getAscent() - 1);
            }
        }
    }
}

