/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.gui.swing;

import java.awt.Dialog;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.options.Settings;

public class MultilineCellEditor
extends JDialog {
    private final String KEY_ESCAPE = "ESCAPE";
    private JTextArea textArea;
    private boolean cancel = false;
    private Action escapeAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            MultilineCellEditor.this.cancel = true;
            MultilineCellEditor.this.close();
        }
    };

    public MultilineCellEditor(Dialog owner, final int row, final int col, final JTable table) {
        super(owner);
        this.setUndecorated(true);
        this.addWindowFocusListener(new WindowAdapter(){

            @Override
            public void windowLostFocus(WindowEvent arg0) {
                if (!MultilineCellEditor.this.cancel) {
                    table.setValueAt(MultilineCellEditor.this.textArea.getText(), row, col);
                    MultilineCellEditor.this.close();
                }
            }
        });
        String text = (String)table.getValueAt(row, col);
        Point p = table.getLocationOnScreen();
        Rectangle rec = table.getCellRect(row, col, true);
        this.textArea = new JTextArea(text);
        Border border = BorderFactory.createLineBorder(table.getSelectionBackground());
        this.textArea.setBorder(border);
        this.textArea.selectAll();
        JScrollPane sp = new JScrollPane(this.textArea);
        this.getContentPane().add(sp);
        Settings.DialogSettings ds = ApplicationView.getInstance().getSettings().getDialogSettings(this.getClass().getName());
        if (ds == null) {
            this.setBounds(p.x + rec.x, p.y + rec.y, rec.width, 60);
        } else {
            int w = Math.max(rec.width, ds.rec.width);
            int h = Math.max(60, ds.rec.height);
            this.setBounds(p.x + rec.x, p.y + rec.y, w, h);
        }
        int condition = 1;
        JComponent c = (JComponent)this.getContentPane();
        c.getInputMap(condition).put(KeyStroke.getKeyStroke("ESCAPE"), "ESCAPE");
        c.getActionMap().put("ESCAPE", this.escapeAction);
    }

    private void close() {
        Rectangle rectangle = new Rectangle(this.getLocation(), this.getSize());
        ApplicationView.getInstance().getSettings().setDialogSettings(this.getClass().getName(), rectangle);
        this.dispose();
    }
}

