/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.gui.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;

public class MoveUpDownListJTable {
    private JTable jtable;
    private List objects;
    private ListSelectionModel selectionModel;
    private JScrollBar sb;

    public MoveUpDownListJTable(List objects, JTable jtable) {
        this.objects = objects;
        this.jtable = jtable;
        this.selectionModel = jtable.getSelectionModel();
        if (jtable.getParent() != null && jtable.getParent().getParent() instanceof JScrollPane) {
            this.sb = ((JScrollPane)jtable.getParent().getParent()).getVerticalScrollBar();
        }
    }

    private boolean moveToIndex(Object object, int index) {
        if (this.objects.contains(object) && this.objects.size() > index && index >= 0) {
            this.objects.remove(object);
            this.objects.add(index, object);
            return true;
        }
        return false;
    }

    private void setSelection(ListSelectionModel selModel, int[] selection) {
        selModel.clearSelection();
        if (selection.length > 0) {
            for (int i = selection.length - 1; i > -1; --i) {
                selModel.addSelectionInterval(selection[i], selection[i]);
            }
        }
    }

    public class MoveDownAction
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            int objectNumber;
            int[] selection;
            int icol = MoveUpDownListJTable.this.jtable.getEditingColumn();
            int irow = MoveUpDownListJTable.this.jtable.getEditingRow();
            if (icol > -1 && irow > -1) {
                MoveUpDownListJTable.this.jtable.getCellEditor(irow, icol).stopCellEditing();
            }
            if ((selection = MoveUpDownListJTable.this.jtable.getSelectedRows()).length > 0 && (objectNumber = selection[selection.length - 1]) < MoveUpDownListJTable.this.objects.size() - 1) {
                int curvalue;
                for (int i = selection.length - 1; i > -1; --i) {
                    objectNumber = selection[i];
                    Object obj = MoveUpDownListJTable.this.objects.get(objectNumber);
                    MoveUpDownListJTable.this.moveToIndex(obj, objectNumber + 1);
                    selection[i] = objectNumber + 1;
                }
                MoveUpDownListJTable.this.setSelection(MoveUpDownListJTable.this.selectionModel, selection);
                objectNumber = selection[selection.length - 1];
                if (MoveUpDownListJTable.this.sb != null && MoveUpDownListJTable.this.objects.size() > 0 && (curvalue = MoveUpDownListJTable.this.sb.getValue()) < MoveUpDownListJTable.this.sb.getMaximum()) {
                    int value = curvalue + MoveUpDownListJTable.this.sb.getMaximum() / MoveUpDownListJTable.this.objects.size();
                    if (value == curvalue) {
                        ++value;
                    }
                    MoveUpDownListJTable.this.sb.setValue(Math.min(value, MoveUpDownListJTable.this.sb.getMaximum()));
                }
                MoveUpDownListJTable.this.jtable.updateUI();
            }
        }
    }

    public class MoveUpAction
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            int objectNumber;
            int[] selection;
            int icol = MoveUpDownListJTable.this.jtable.getEditingColumn();
            int irow = MoveUpDownListJTable.this.jtable.getEditingRow();
            if (icol > -1 && irow > -1) {
                MoveUpDownListJTable.this.jtable.getCellEditor(irow, icol).stopCellEditing();
            }
            if ((selection = MoveUpDownListJTable.this.jtable.getSelectedRows()).length > 0 && (objectNumber = selection[0]) > 0) {
                for (int i = 0; i < selection.length; ++i) {
                    objectNumber = selection[i];
                    Object obj = MoveUpDownListJTable.this.objects.get(objectNumber);
                    MoveUpDownListJTable.this.moveToIndex(obj, objectNumber - 1);
                    selection[i] = objectNumber - 1;
                }
                MoveUpDownListJTable.this.setSelection(MoveUpDownListJTable.this.selectionModel, selection);
                objectNumber = selection[0];
                if (MoveUpDownListJTable.this.sb != null && MoveUpDownListJTable.this.objects.size() > 0) {
                    int value = objectNumber * MoveUpDownListJTable.this.sb.getMaximum() / MoveUpDownListJTable.this.objects.size();
                    if (value < MoveUpDownListJTable.this.sb.getMinimum()) {
                        value = MoveUpDownListJTable.this.sb.getMinimum();
                    }
                    MoveUpDownListJTable.this.sb.setValue(value);
                }
                MoveUpDownListJTable.this.jtable.updateUI();
            }
        }
    }
}

