/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.gui.swing;

import java.awt.Toolkit;
import java.util.regex.Pattern;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class JNumericField
extends JTextField {
    private Pattern wholeNumberPattern;

    public JNumericField() {
        this.setDocument(new NumericDocument());
    }

    public JNumericField(int length, int columns) {
        this();
        this.wholeNumberPattern = Pattern.compile("^?[0-9]{0," + length + "}");
        this.setColumns(columns);
    }

    class NumericDocument
    extends PlainDocument {
        NumericDocument() {
        }

        @Override
        public void insertString(int offset, String string, AttributeSet attributes) throws BadLocationException {
            if (string != null) {
                String newValue;
                int length = this.getLength();
                if (length == 0) {
                    newValue = string;
                } else {
                    String currentContent = this.getText(0, length);
                    StringBuffer currentBuffer = new StringBuffer(currentContent);
                    currentBuffer.insert(offset, string);
                    newValue = currentBuffer.toString();
                }
                if (length == 0 && ("-".equals(string) || "+".equals(string))) {
                    super.insertString(offset, string, attributes);
                } else {
                    try {
                        if (this.validateValue(newValue)) {
                            super.insertString(offset, string, attributes);
                        } else {
                            Toolkit.getDefaultToolkit().beep();
                        }
                    }
                    catch (NumberFormatException exception) {
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
            }
        }

        public boolean validateValue(String value) throws NumberFormatException {
            return JNumericField.this.wholeNumberPattern != null && JNumericField.this.wholeNumberPattern.matcher(value).matches();
        }
    }
}

