/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util.connection;

import com.jcraft.jsch.UserInfo;
import java.awt.Component;
import java.util.concurrent.Callable;
import javax.swing.JPasswordField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import oracle.dbtools.raptor.explorer.dt.dialog.ConnectionDialogArb;
import oracle.dbtools.util.Logger;
import oracle.ide.Ide;
import oracle.ide.dialogs.SimpleInputDialog;
import oracle.javatools.dialogs.MessageDialog;

public class RaptorUserInfo
implements UserInfo {
    private String mPassphrase;
    private String mPassword;

    private static String getAuthorization(final String message) {
        Worker<String> worker = new Worker<String>(){

            @Override
            public void run() {
                InputDialog dlg = new InputDialog();
                String result = dlg.show(ConnectionDialogArb.getString((String)"SSH_AUTHORIZATION_REQUIRED_TITLE"), message, null) ? dlg.getInputValue() : null;
                this.setResult(result);
            }
        };
        String result = null;
        try {
            result = (String)worker.call();
        }
        catch (Exception ex) {
            Logger.severe(RaptorUserInfo.class, (Throwable)ex);
        }
        return result;
    }

    public String getPassphrase() {
        return this.mPassphrase;
    }

    public String getPassword() {
        return this.mPassword;
    }

    public boolean promptPassword(String message) {
        this.mPassword = RaptorUserInfo.getAuthorization(message);
        return this.mPassword != null;
    }

    public boolean promptPassphrase(String message) {
        this.mPassphrase = RaptorUserInfo.getAuthorization(message);
        return this.mPassphrase != null;
    }

    public boolean promptYesNo(final String message) {
        Worker<Boolean> worker = new Worker<Boolean>(){

            @Override
            public void run() {
                this.setResult(MessageDialog.confirm((Component)Ide.getMainWindow(), (Object)message, (String)ConnectionDialogArb.getString((String)"SSH_AUTHORIZATION_TITLE"), null));
            }
        };
        boolean result = false;
        try {
            result = (Boolean)worker.call();
        }
        catch (Exception ex) {
            Logger.severe(RaptorUserInfo.class, (Throwable)ex);
        }
        return result;
    }

    public void showMessage(final String message) {
        Worker<Void> worker = new Worker<Void>(){

            @Override
            public void run() {
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)message, (String)ConnectionDialogArb.getString((String)"SSH_AUTHORIZATION_TITLE"), null);
            }
        };
        try {
            worker.call();
        }
        catch (Exception ex) {
            Logger.severe(RaptorUserInfo.class, (Throwable)ex);
        }
    }

    private static abstract class Worker<V>
    implements Callable<V>,
    Runnable {
        private volatile V result;

        private Worker() {
        }

        protected void setResult(V result) {
            this.result = result;
        }

        @Override
        public V call() throws Exception {
            if (SwingUtilities.isEventDispatchThread()) {
                this.run();
            } else {
                SwingUtilities.invokeAndWait(this);
            }
            return this.result;
        }
    }

    private static class InputDialog
    extends SimpleInputDialog {
        InputDialog() {
            super((Component)Ide.getMainWindow());
        }

        protected JTextComponent createInputComponent() {
            return new JPasswordField(15);
        }
    }
}

